/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Hours;
import org.joda.time.LocalDate;
import org.joda.time.Minutes;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.Weeks;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Days
extends BaseSingleFieldPeriod {
    public static final Days FIVE;
    public static final Days FOUR;
    public static final Days MAX_VALUE;
    public static final Days MIN_VALUE;
    public static final Days ONE;
    private static final PeriodFormatter PARSER;
    public static final Days SEVEN;
    public static final Days SIX;
    public static final Days THREE;
    public static final Days TWO;
    public static final Days ZERO;
    private static final long serialVersionUID = 87525275727380865L;

    static {
        ZERO = new Days(0);
        ONE = new Days(1);
        TWO = new Days(2);
        THREE = new Days(3);
        FOUR = new Days(4);
        FIVE = new Days(5);
        SIX = new Days(6);
        SEVEN = new Days(7);
        MAX_VALUE = new Days(Integer.MAX_VALUE);
        MIN_VALUE = new Days(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.days());
    }

    private Days(int n2) {
        super(n2);
    }

    public static Days days(int n2) {
        switch (n2) {
            default: {
                return new Days(n2);
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: 
        }
        return MIN_VALUE;
    }

    public static Days daysBetween(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        return Days.days(BaseSingleFieldPeriod.between(readableInstant, readableInstant2, DurationFieldType.days()));
    }

    public static Days daysBetween(ReadablePartial readablePartial, ReadablePartial readablePartial2) {
        if (readablePartial instanceof LocalDate && readablePartial2 instanceof LocalDate) {
            return Days.days(DateTimeUtils.getChronology(readablePartial.getChronology()).days().getDifference(((LocalDate)readablePartial2).getLocalMillis(), ((LocalDate)readablePartial).getLocalMillis()));
        }
        return Days.days(BaseSingleFieldPeriod.between(readablePartial, readablePartial2, ZERO));
    }

    public static Days daysIn(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            return ZERO;
        }
        return Days.days(BaseSingleFieldPeriod.between(readableInterval.getStart(), readableInterval.getEnd(), DurationFieldType.days()));
    }

    @FromString
    public static Days parseDays(String string2) {
        if (string2 == null) {
            return ZERO;
        }
        return Days.days(PARSER.parsePeriod(string2).getDays());
    }

    private Object readResolve() {
        return Days.days(this.getValue());
    }

    public static Days standardDaysIn(ReadablePeriod readablePeriod) {
        return Days.days(BaseSingleFieldPeriod.standardPeriodIn(readablePeriod, 86400000L));
    }

    public Days dividedBy(int n2) {
        if (n2 == 1) {
            return this;
        }
        return Days.days(this.getValue() / n2);
    }

    public int getDays() {
        return this.getValue();
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.days();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.days();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isGreaterThan(Days days) {
        if (days == null) {
            if (this.getValue() > 0) return true;
            return false;
        }
        if (this.getValue() <= days.getValue()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isLessThan(Days days) {
        if (days == null) {
            if (this.getValue() < 0) return true;
            return false;
        }
        if (this.getValue() >= days.getValue()) return false;
        return true;
    }

    public Days minus(int n2) {
        return this.plus(FieldUtils.safeNegate(n2));
    }

    public Days minus(Days days) {
        if (days == null) {
            return this;
        }
        return this.minus(days.getValue());
    }

    public Days multipliedBy(int n2) {
        return Days.days(FieldUtils.safeMultiply(this.getValue(), n2));
    }

    public Days negated() {
        return Days.days(FieldUtils.safeNegate(this.getValue()));
    }

    public Days plus(int n2) {
        if (n2 == 0) {
            return this;
        }
        return Days.days(FieldUtils.safeAdd(this.getValue(), n2));
    }

    public Days plus(Days days) {
        if (days == null) {
            return this;
        }
        return this.plus(days.getValue());
    }

    public Duration toStandardDuration() {
        return new Duration(86400000L * (long)this.getValue());
    }

    public Hours toStandardHours() {
        return Hours.hours(FieldUtils.safeMultiply(this.getValue(), 24));
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), 1440));
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 86400));
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 7);
    }

    @Override
    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "D";
    }
}

