/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.IllegalInstantException;
import org.joda.time.JodaTimePermission;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.BaseChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.FormatUtils;
import org.joda.time.tz.DefaultNameProvider;
import org.joda.time.tz.FixedDateTimeZone;
import org.joda.time.tz.NameProvider;
import org.joda.time.tz.Provider;
import org.joda.time.tz.UTCProvider;
import org.joda.time.tz.ZoneInfoProvider;

public abstract class DateTimeZone
implements Serializable {
    private static final int MAX_MILLIS = 86399999;
    public static final DateTimeZone UTC = new FixedDateTimeZone("UTC", "UTC", 0, 0);
    private static Set<String> cAvailableIDs;
    private static volatile DateTimeZone cDefault;
    private static NameProvider cNameProvider;
    private static DateTimeFormatter cOffsetFormatter;
    private static Provider cProvider;
    private static Map<String, String> cZoneIdConversion;
    private static Map<String, SoftReference<DateTimeZone>> iFixedOffsetCache;
    private static final long serialVersionUID = 5546345482340108586L;
    private final String iID;

    static {
        DateTimeZone.setProvider0(null);
        DateTimeZone.setNameProvider0(null);
    }

    protected DateTimeZone(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DateTimeZone fixedOffsetZone(String string2, int n2) {
        synchronized (DateTimeZone.class) {
            DateTimeZone dateTimeZone;
            Reference reference;
            if (n2 == 0) {
                return UTC;
            }
            if (iFixedOffsetCache == null) {
                iFixedOffsetCache = new HashMap<String, SoftReference<DateTimeZone>>();
            }
            if ((reference = (Reference)iFixedOffsetCache.get(string2)) != null) {
                dateTimeZone = (DateTimeZone)reference.get();
                if (dateTimeZone != null) return dateTimeZone;
            }
            dateTimeZone = new FixedDateTimeZone(string2, null, n2, n2);
            iFixedOffsetCache.put(string2, new SoftReference<DateTimeZone>(dateTimeZone));
            return dateTimeZone;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FromString
    public static DateTimeZone forID(String string2) {
        int n2;
        if (string2 == null) {
            return DateTimeZone.getDefault();
        }
        if (string2.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = cProvider.getZone(string2);
        if (dateTimeZone != null) return dateTimeZone;
        if (!string2.startsWith("+")) {
            if (!string2.startsWith("-")) throw new IllegalArgumentException("The datetime zone id '" + string2 + "' is not recognised");
        }
        if ((long)(n2 = DateTimeZone.parseOffset(string2)) != 0L) return DateTimeZone.fixedOffsetZone(DateTimeZone.printOffset(n2), n2);
        return UTC;
    }

    public static DateTimeZone forOffsetHours(int n2) throws IllegalArgumentException {
        return DateTimeZone.forOffsetHoursMinutes(n2, 0);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DateTimeZone forOffsetHoursMinutes(int var0, int var1_1) throws IllegalArgumentException {
        if (var0 == 0 && var1_1 == 0) {
            return DateTimeZone.UTC;
        }
        if (var0 < -23 || var0 > 23) {
            throw new IllegalArgumentException("Hours out of range: " + var0);
        }
        if (var1_1 < -59 || var1_1 > 59) {
            throw new IllegalArgumentException("Minutes out of range: " + var1_1);
        }
        if (var0 > 0 && var1_1 < 0) {
            throw new IllegalArgumentException("Positive hours must not have negative minutes: " + var1_1);
        }
        var2_2 = var0 * 60;
        if (var2_2 < 0) {
            try {
                var3_3 = var2_2 - Math.abs(var1_1);
lbl13:
                // 2 sources

                while (true) {
                    var5_4 = FieldUtils.safeMultiply(var3_3, 60000);
                    return DateTimeZone.forOffsetMillis(var5_4);
                }
            }
            catch (ArithmeticException var4_5) {
                throw new IllegalArgumentException("Offset is too large");
            }
        }
        var3_3 = var2_2 + var1_1;
        ** while (true)
    }

    public static DateTimeZone forOffsetMillis(int n2) {
        if (n2 < -86399999 || n2 > 86399999) {
            throw new IllegalArgumentException("Millis out of range: " + n2);
        }
        return DateTimeZone.fixedOffsetZone(DateTimeZone.printOffset(n2), n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DateTimeZone forTimeZone(TimeZone timeZone) {
        int n2;
        if (timeZone == null) {
            return DateTimeZone.getDefault();
        }
        String string2 = timeZone.getID();
        if (string2.equals("UTC")) {
            return UTC;
        }
        String string3 = DateTimeZone.getConvertedId(string2);
        DateTimeZone dateTimeZone = null;
        if (string3 != null) {
            dateTimeZone = cProvider.getZone(string3);
        }
        if (dateTimeZone == null) {
            dateTimeZone = cProvider.getZone(string2);
        }
        if (dateTimeZone != null) return dateTimeZone;
        if (string3 != null) throw new IllegalArgumentException("The datetime zone id '" + string2 + "' is not recognised");
        String string4 = timeZone.getID();
        if (!string4.startsWith("GMT+")) {
            if (!string4.startsWith("GMT-")) throw new IllegalArgumentException("The datetime zone id '" + string2 + "' is not recognised");
        }
        if ((long)(n2 = DateTimeZone.parseOffset(string4.substring(3))) != 0L) return DateTimeZone.fixedOffsetZone(DateTimeZone.printOffset(n2), n2);
        return UTC;
    }

    public static Set<String> getAvailableIDs() {
        return cAvailableIDs;
    }

    private static String getConvertedId(String string2) {
        synchronized (DateTimeZone.class) {
            Map<String, String> map = cZoneIdConversion;
            if (map == null) {
                map = new HashMap<String, String>();
                map.put("GMT", "UTC");
                map.put("WET", "WET");
                map.put("CET", "CET");
                map.put("MET", "CET");
                map.put("ECT", "CET");
                map.put("EET", "EET");
                map.put("MIT", "Pacific/Apia");
                map.put("HST", "Pacific/Honolulu");
                map.put("AST", "America/Anchorage");
                map.put("PST", "America/Los_Angeles");
                map.put("MST", "America/Denver");
                map.put("PNT", "America/Phoenix");
                map.put("CST", "America/Chicago");
                map.put("EST", "America/New_York");
                map.put("IET", "America/Indiana/Indianapolis");
                map.put("PRT", "America/Puerto_Rico");
                map.put("CNT", "America/St_Johns");
                map.put("AGT", "America/Argentina/Buenos_Aires");
                map.put("BET", "America/Sao_Paulo");
                map.put("ART", "Africa/Cairo");
                map.put("CAT", "Africa/Harare");
                map.put("EAT", "Africa/Addis_Ababa");
                map.put("NET", "Asia/Yerevan");
                map.put("PLT", "Asia/Karachi");
                map.put("IST", "Asia/Kolkata");
                map.put("BST", "Asia/Dhaka");
                map.put("VST", "Asia/Ho_Chi_Minh");
                map.put("CTT", "Asia/Shanghai");
                map.put("JST", "Asia/Tokyo");
                map.put("ACT", "Australia/Darwin");
                map.put("AET", "Australia/Sydney");
                map.put("SST", "Pacific/Guadalcanal");
                map.put("NST", "Pacific/Auckland");
                cZoneIdConversion = map;
            }
            String string3 = map.get(string2);
            return string3;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DateTimeZone getDefault() {
        DateTimeZone dateTimeZone = cDefault;
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        synchronized (DateTimeZone.class) {
            DateTimeZone dateTimeZone2 = cDefault;
            if (dateTimeZone2 == null) {
                block12: {
                    block11: {
                        dateTimeZone2 = null;
                        try {
                            String string2 = System.getProperty("user.timezone");
                            dateTimeZone2 = null;
                            if (string2 != null) {
                                DateTimeZone dateTimeZone3;
                                dateTimeZone2 = dateTimeZone3 = DateTimeZone.forID(string2);
                            }
                            break block11;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            break block12;
                        }
                        catch (RuntimeException runtimeException) {
                            dateTimeZone2 = null;
                        }
                    }
                    if (dateTimeZone2 == null) {
                        DateTimeZone dateTimeZone4;
                        dateTimeZone2 = dateTimeZone4 = DateTimeZone.forTimeZone(TimeZone.getDefault());
                    }
                }
                if (dateTimeZone2 == null) {
                    dateTimeZone2 = UTC;
                }
                cDefault = dateTimeZone2;
            }
            return dateTimeZone2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static NameProvider getDefaultNameProvider() {
        block7: {
            var2 = System.getProperty("org.joda.time.DateTimeZone.NameProvider");
            if (var2 == null) break block7;
            try {
                var1_1 = (NameProvider)Class.forName(var2).newInstance();
            }
            catch (Exception var3_2) {
                var4_3 = Thread.currentThread();
                var4_3.getThreadGroup().uncaughtException(var4_3, var3_2);
            }
lbl6:
            // 3 sources

            while (true) {
                if (var1_1 == null) {
                    var1_1 = new DefaultNameProvider();
                }
                return var1_1;
            }
        }
        var1_1 = null;
        ** GOTO lbl6
        {
            catch (SecurityException var0_4) {
                var1_1 = null;
                ** continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Provider getDefaultProvider() {
        block13: {
            block12: {
                var5 = System.getProperty("org.joda.time.DateTimeZone.Provider");
                if (var5 == null) break block12;
                try {
                    var6_1 = (Provider)Class.forName(var5).newInstance();
                }
                catch (Exception var7_4) {
                    var8_5 = Thread.currentThread();
                    var8_5.getThreadGroup().uncaughtException(var8_5, var7_4);
                }
lbl6:
                // 2 sources

                while (true) {
                    var1_2 = var6_1;
lbl8:
                    // 2 sources

                    while (true) {
                        if (var1_2 == null) {
                            var2_3 = new ZoneInfoProvider("org/joda/time/tz/data");
lbl12:
                            // 2 sources

                            while (true) {
                                if (var2_3 == null) {
                                    var2_3 = new UTCProvider();
                                }
                                return var2_3;
                            }
                        }
                        break block13;
                        break;
                    }
                    break;
                }
            }
            var6_1 = null;
            ** while (true)
            catch (Exception var3_6) {
                var4_7 = Thread.currentThread();
                var4_7.getThreadGroup().uncaughtException(var4_7, var3_6);
            }
        }
        var2_3 = var1_2;
        ** while (true)
        {
            catch (SecurityException var0_8) {
                var1_2 = null;
                ** continue;
            }
        }
    }

    public static NameProvider getNameProvider() {
        return cNameProvider;
    }

    public static Provider getProvider() {
        return cProvider;
    }

    private static DateTimeFormatter offsetFormatter() {
        synchronized (DateTimeZone.class) {
            if (cOffsetFormatter == null) {
                cOffsetFormatter = new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter();
            }
            DateTimeFormatter dateTimeFormatter = cOffsetFormatter;
            return dateTimeFormatter;
        }
    }

    private static int parseOffset(String string2) {
        BaseChronology baseChronology = new BaseChronology(){
            private static final long serialVersionUID = -3128740902654445468L;

            @Override
            public DateTimeZone getZone() {
                return null;
            }

            @Override
            public String toString() {
                return this.getClass().getName();
            }

            @Override
            public Chronology withUTC() {
                return this;
            }

            @Override
            public Chronology withZone(DateTimeZone dateTimeZone) {
                return this;
            }
        };
        return -((int)DateTimeZone.offsetFormatter().withChronology(baseChronology).parseMillis(string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String printOffset(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 >= 0) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
            n2 = -n2;
        }
        int n3 = n2 / 3600000;
        FormatUtils.appendPaddedInteger(stringBuffer, n3, 2);
        int n4 = n2 - n3 * 3600000;
        int n5 = n4 / 60000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n5, 2);
        int n6 = n4 - n5 * 60000;
        if (n6 == 0) {
            return stringBuffer.toString();
        }
        int n7 = n6 / 1000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n7, 2);
        int n8 = n6 - n7 * 1000;
        if (n8 == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append('.');
        FormatUtils.appendPaddedInteger(stringBuffer, n8, 3);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setDefault(DateTimeZone dateTimeZone) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setDefault"));
        }
        if (dateTimeZone == null) {
            throw new IllegalArgumentException("The datetime zone must not be null");
        }
        synchronized (DateTimeZone.class) {
            cDefault = dateTimeZone;
            return;
        }
    }

    public static void setNameProvider(NameProvider nameProvider) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setNameProvider"));
        }
        DateTimeZone.setNameProvider0(nameProvider);
    }

    private static void setNameProvider0(NameProvider nameProvider) {
        if (nameProvider == null) {
            nameProvider = DateTimeZone.getDefaultNameProvider();
        }
        cNameProvider = nameProvider;
    }

    public static void setProvider(Provider provider) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setProvider"));
        }
        DateTimeZone.setProvider0(provider);
    }

    private static void setProvider0(Provider provider) {
        Set<String> set;
        if (provider == null) {
            provider = DateTimeZone.getDefaultProvider();
        }
        if ((set = provider.getAvailableIDs()) == null || set.size() == 0) {
            throw new IllegalArgumentException("The provider doesn't have any available ids");
        }
        if (!set.contains("UTC")) {
            throw new IllegalArgumentException("The provider doesn't support UTC");
        }
        if (!UTC.equals(provider.getZone("UTC"))) {
            throw new IllegalArgumentException("Invalid UTC zone provided");
        }
        cProvider = provider;
        cAvailableIDs = set;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long adjustOffset(long l2, boolean bl2) {
        long l3;
        long l4 = l2 - 10800000L;
        long l5 = 10800000L + l2;
        long l6 = this.getOffset(l4);
        if (l6 <= (l3 = (long)this.getOffset(l5))) return l2;
        long l7 = l6 - l3;
        long l8 = this.nextTransition(l4);
        long l9 = l8 - l7;
        long l10 = l8 + l7;
        if (l2 < l9 || l2 >= l10) return l2;
        if (l2 - l9 >= l7) {
            if (bl2) return l2;
            return l2 - l7;
        }
        if (bl2) return l2 + l7;
        return l2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public long convertLocalToUTC(long var1_1, boolean var3_2) {
        var4_3 = 0x7FFFFFFFFFFFFFFFL;
        var6_4 = this.getOffset(var1_1);
        if (var6_4 == (var7_5 = this.getOffset(var1_1 - (long)var6_4)) || !var3_2 && var6_4 >= 0) ** GOTO lbl-1000
        var11_6 = this.nextTransition(var1_1 - (long)var6_4);
        if (var11_6 == var1_1 - (long)var6_4) {
            var11_6 = var4_3;
        }
        if ((var13_7 = this.nextTransition(var1_1 - (long)var7_5)) != var1_1 - (long)var7_5) {
            var4_3 = var13_7;
        }
        if (var11_6 != var4_3) {
            if (var3_2) {
                throw new IllegalInstantException(var1_1, this.getID());
            }
            var8_8 = var6_4;
        } else lbl-1000:
        // 2 sources

        {
            var8_8 = var7_5;
        }
        if ((var1_1 ^ (var9_9 = var1_1 - (long)var8_8)) < 0L && (var1_1 ^ (long)var8_8) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return var9_9;
    }

    public long convertLocalToUTC(long l2, boolean bl2, long l3) {
        int n2 = this.getOffset(l3);
        long l4 = l2 - (long)n2;
        if (this.getOffset(l4) == n2) {
            return l4;
        }
        return this.convertLocalToUTC(l2, bl2);
    }

    public long convertUTCToLocal(long l2) {
        int n2 = this.getOffset(l2);
        long l3 = l2 + (long)n2;
        if ((l2 ^ l3) < 0L && (l2 ^ (long)n2) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return l3;
    }

    public abstract boolean equals(Object var1);

    @ToString
    public final String getID() {
        return this.iID;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long getMillisKeepLocal(DateTimeZone dateTimeZone, long l2) {
        DateTimeZone dateTimeZone2 = dateTimeZone == null ? DateTimeZone.getDefault() : dateTimeZone;
        if (dateTimeZone2 == this) {
            return l2;
        }
        return dateTimeZone2.convertLocalToUTC(this.convertUTCToLocal(l2), false, l2);
    }

    public final String getName(long l2) {
        return this.getName(l2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getName(long l2, Locale locale) {
        String string2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string2 = this.getNameKey(l2)) == null) {
            return this.iID;
        }
        String string3 = cNameProvider.getName(locale, this.iID, string2);
        if (string3 != null) return string3;
        return DateTimeZone.printOffset(this.getOffset(l2));
    }

    public abstract String getNameKey(long var1);

    public abstract int getOffset(long var1);

    public final int getOffset(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.getOffset(DateTimeUtils.currentTimeMillis());
        }
        return this.getOffset(readableInstant.getMillis());
    }

    public int getOffsetFromLocal(long l2) {
        int n2;
        int n3;
        long l3;
        long l4;
        int n4;
        int n5 = this.getOffset(l2);
        if (n5 != (n4 = this.getOffset(l4 = l2 - (long)n5))) {
            if (n5 - n4 < 0 && this.nextTransition(l4) != this.nextTransition(l2 - (long)n4)) {
                return n5;
            }
        } else if (n5 >= 0 && (l3 = this.previousTransition(l4)) < l4 && l4 - l3 <= (long)(n3 = (n2 = this.getOffset(l3)) - n5)) {
            return n2;
        }
        return n4;
    }

    public final String getShortName(long l2) {
        return this.getShortName(l2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getShortName(long l2, Locale locale) {
        String string2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string2 = this.getNameKey(l2)) == null) {
            return this.iID;
        }
        String string3 = cNameProvider.getShortName(locale, this.iID, string2);
        if (string3 != null) return string3;
        return DateTimeZone.printOffset(this.getOffset(l2));
    }

    public abstract int getStandardOffset(long var1);

    public int hashCode() {
        return 57 + this.getID().hashCode();
    }

    public abstract boolean isFixed();

    public boolean isLocalDateTimeGap(LocalDateTime localDateTime) {
        if (this.isFixed()) {
            return false;
        }
        try {
            localDateTime.toDateTime(this);
            return false;
        }
        catch (IllegalInstantException illegalInstantException) {
            return true;
        }
    }

    public boolean isStandardOffset(long l2) {
        return this.getOffset(l2) == this.getStandardOffset(l2);
    }

    public abstract long nextTransition(long var1);

    public abstract long previousTransition(long var1);

    public String toString() {
        return this.getID();
    }

    public TimeZone toTimeZone() {
        return TimeZone.getTimeZone(this.iID);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Stub(this.iID);
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6471952376487863581L;
        private transient String iID;

        Stub(String string2) {
            this.iID = string2;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            this.iID = objectInputStream.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return DateTimeZone.forID(this.iID);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeUTF(this.iID);
        }
    }
}

