/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.text.DateFormatSymbols;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.JodaTimePermission;
import org.joda.time.PeriodType;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;

public class DateTimeUtils {
    private static final SystemMillisProvider SYSTEM_MILLIS_PROVIDER = new SystemMillisProvider();
    private static volatile MillisProvider cMillisProvider = SYSTEM_MILLIS_PROVIDER;
    private static volatile Map<String, DateTimeZone> cZoneNames;

    static {
        LinkedHashMap<String, DateTimeZone> linkedHashMap = new LinkedHashMap<String, DateTimeZone>();
        linkedHashMap.put("UT", DateTimeZone.UTC);
        linkedHashMap.put("UTC", DateTimeZone.UTC);
        linkedHashMap.put("GMT", DateTimeZone.UTC);
        DateTimeUtils.put(linkedHashMap, "EST", "America/New_York");
        DateTimeUtils.put(linkedHashMap, "EDT", "America/New_York");
        DateTimeUtils.put(linkedHashMap, "CST", "America/Chicago");
        DateTimeUtils.put(linkedHashMap, "CDT", "America/Chicago");
        DateTimeUtils.put(linkedHashMap, "MST", "America/Denver");
        DateTimeUtils.put(linkedHashMap, "MDT", "America/Denver");
        DateTimeUtils.put(linkedHashMap, "PST", "America/Los_Angeles");
        DateTimeUtils.put(linkedHashMap, "PDT", "America/Los_Angeles");
        cZoneNames = Collections.unmodifiableMap(linkedHashMap);
    }

    protected DateTimeUtils() {
    }

    private static void checkPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("CurrentTime.setProvider"));
        }
    }

    public static final long currentTimeMillis() {
        return cMillisProvider.getMillis();
    }

    public static final long fromJulianDay(double d2) {
        return (long)(8.64E7 * (d2 - 2440587.5));
    }

    public static final Chronology getChronology(Chronology chronology) {
        if (chronology == null) {
            chronology = ISOChronology.getInstance();
        }
        return chronology;
    }

    public static final DateFormatSymbols getDateFormatSymbols(Locale locale) {
        try {
            DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)DateFormatSymbols.class.getMethod("getInstance", Locale.class).invoke(null, locale);
            return dateFormatSymbols;
        }
        catch (Exception exception) {
            return new DateFormatSymbols(locale);
        }
    }

    public static final Map<String, DateTimeZone> getDefaultTimeZoneNames() {
        return cZoneNames;
    }

    public static final long getDurationMillis(ReadableDuration readableDuration) {
        if (readableDuration == null) {
            return 0L;
        }
        return readableDuration.getMillis();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final Chronology getInstantChronology(ReadableInstant readableInstant) {
        void var1_2;
        if (readableInstant == null) {
            ISOChronology iSOChronology = ISOChronology.getInstance();
            return var1_2;
        } else {
            Chronology chronology = readableInstant.getChronology();
            if (chronology != null) return var1_2;
            return ISOChronology.getInstance();
        }
    }

    public static final long getInstantMillis(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return DateTimeUtils.currentTimeMillis();
        }
        return readableInstant.getMillis();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final Chronology getIntervalChronology(ReadableInstant readableInstant, ReadableInstant readableInstant2) {
        Chronology chronology;
        if (readableInstant != null) {
            chronology = readableInstant.getChronology();
        } else {
            chronology = null;
            if (readableInstant2 != null) {
                chronology = readableInstant2.getChronology();
            }
        }
        if (chronology != null) return chronology;
        return ISOChronology.getInstance();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final Chronology getIntervalChronology(ReadableInterval readableInterval) {
        void var1_2;
        if (readableInterval == null) {
            ISOChronology iSOChronology = ISOChronology.getInstance();
            return var1_2;
        } else {
            Chronology chronology = readableInterval.getChronology();
            if (chronology != null) return var1_2;
            return ISOChronology.getInstance();
        }
    }

    public static final PeriodType getPeriodType(PeriodType periodType) {
        if (periodType == null) {
            periodType = PeriodType.standard();
        }
        return periodType;
    }

    public static final ReadableInterval getReadableInterval(ReadableInterval readableInterval) {
        if (readableInterval == null) {
            long l2 = DateTimeUtils.currentTimeMillis();
            readableInterval = new Interval(l2, l2);
        }
        return readableInterval;
    }

    public static final DateTimeZone getZone(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        return dateTimeZone;
    }

    public static final boolean isContiguous(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            throw new IllegalArgumentException("Partial must not be null");
        }
        DurationFieldType durationFieldType = null;
        for (int i2 = 0; i2 < readablePartial.size(); ++i2) {
            DateTimeField dateTimeField = readablePartial.getField(i2);
            if (i2 > 0 && dateTimeField.getRangeDurationField().getType() != durationFieldType) {
                return false;
            }
            durationFieldType = dateTimeField.getDurationField().getType();
        }
        return true;
    }

    private static void put(Map<String, DateTimeZone> map, String string2, String string3) {
        try {
            map.put(string2, DateTimeZone.forID(string3));
            return;
        }
        catch (RuntimeException runtimeException) {
            return;
        }
    }

    public static final void setCurrentMillisFixed(long l2) throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = new FixedMillisProvider(l2);
    }

    public static final void setCurrentMillisOffset(long l2) throws SecurityException {
        DateTimeUtils.checkPermission();
        if (l2 == 0L) {
            cMillisProvider = SYSTEM_MILLIS_PROVIDER;
            return;
        }
        cMillisProvider = new OffsetMillisProvider(l2);
    }

    public static final void setCurrentMillisProvider(MillisProvider millisProvider) throws SecurityException {
        if (millisProvider == null) {
            throw new IllegalArgumentException("The MillisProvider must not be null");
        }
        DateTimeUtils.checkPermission();
        cMillisProvider = millisProvider;
    }

    public static final void setCurrentMillisSystem() throws SecurityException {
        DateTimeUtils.checkPermission();
        cMillisProvider = SYSTEM_MILLIS_PROVIDER;
    }

    public static final void setDefaultTimeZoneNames(Map<String, DateTimeZone> map) {
        cZoneNames = Collections.unmodifiableMap(new HashMap<String, DateTimeZone>(map));
    }

    public static final double toJulianDay(long l2) {
        return 2440587.5 + (double)l2 / 8.64E7;
    }

    public static final long toJulianDayNumber(long l2) {
        return (long)Math.floor(0.5 + DateTimeUtils.toJulianDay(l2));
    }

    static class FixedMillisProvider
    implements MillisProvider {
        private final long iMillis;

        FixedMillisProvider(long l2) {
            this.iMillis = l2;
        }

        @Override
        public long getMillis() {
            return this.iMillis;
        }
    }

    public static interface MillisProvider {
        public long getMillis();
    }

    static class OffsetMillisProvider
    implements MillisProvider {
        private final long iMillis;

        OffsetMillisProvider(long l2) {
            this.iMillis = l2;
        }

        @Override
        public long getMillis() {
            return System.currentTimeMillis() + this.iMillis;
        }
    }

    static class SystemMillisProvider
    implements MillisProvider {
        SystemMillisProvider() {
        }

        @Override
        public long getMillis() {
            return System.currentTimeMillis();
        }
    }
}

