/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Comparator;
import org.joda.time.Chronology;
import org.joda.time.DateTimeFieldType;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.InstantConverter;

public class DateTimeComparator
implements Comparator<Object>,
Serializable {
    private static final DateTimeComparator ALL_INSTANCE = new DateTimeComparator(null, null);
    private static final DateTimeComparator DATE_INSTANCE = new DateTimeComparator(DateTimeFieldType.dayOfYear(), null);
    private static final DateTimeComparator TIME_INSTANCE = new DateTimeComparator(null, DateTimeFieldType.dayOfYear());
    private static final long serialVersionUID = -6097339773320178364L;
    private final DateTimeFieldType iLowerLimit;
    private final DateTimeFieldType iUpperLimit;

    protected DateTimeComparator(DateTimeFieldType dateTimeFieldType, DateTimeFieldType dateTimeFieldType2) {
        this.iLowerLimit = dateTimeFieldType;
        this.iUpperLimit = dateTimeFieldType2;
    }

    public static DateTimeComparator getDateOnlyInstance() {
        return DATE_INSTANCE;
    }

    public static DateTimeComparator getInstance() {
        return ALL_INSTANCE;
    }

    public static DateTimeComparator getInstance(DateTimeFieldType dateTimeFieldType) {
        return DateTimeComparator.getInstance(dateTimeFieldType, null);
    }

    public static DateTimeComparator getInstance(DateTimeFieldType dateTimeFieldType, DateTimeFieldType dateTimeFieldType2) {
        if (dateTimeFieldType == null && dateTimeFieldType2 == null) {
            return ALL_INSTANCE;
        }
        if (dateTimeFieldType == DateTimeFieldType.dayOfYear() && dateTimeFieldType2 == null) {
            return DATE_INSTANCE;
        }
        if (dateTimeFieldType == null && dateTimeFieldType2 == DateTimeFieldType.dayOfYear()) {
            return TIME_INSTANCE;
        }
        return new DateTimeComparator(dateTimeFieldType, dateTimeFieldType2);
    }

    public static DateTimeComparator getTimeOnlyInstance() {
        return TIME_INSTANCE;
    }

    private Object readResolve() {
        return DateTimeComparator.getInstance(this.iLowerLimit, this.iUpperLimit);
    }

    @Override
    public int compare(Object object, Object object2) {
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(object);
        Chronology chronology = instantConverter.getChronology(object, (Chronology)null);
        long l2 = instantConverter.getInstantMillis(object, chronology);
        InstantConverter instantConverter2 = ConverterManager.getInstance().getInstantConverter(object2);
        Chronology chronology2 = instantConverter2.getChronology(object2, (Chronology)null);
        long l3 = instantConverter2.getInstantMillis(object2, chronology2);
        if (this.iLowerLimit != null) {
            l2 = this.iLowerLimit.getField(chronology).roundFloor(l2);
            l3 = this.iLowerLimit.getField(chronology2).roundFloor(l3);
        }
        if (this.iUpperLimit != null) {
            l2 = this.iUpperLimit.getField(chronology).remainder(l2);
            l3 = this.iUpperLimit.getField(chronology2).remainder(l3);
        }
        if (l2 < l3) {
            return -1;
        }
        if (l2 > l3) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl2;
        block2: {
            block4: {
                DateTimeComparator dateTimeComparator;
                block3: {
                    boolean bl3 = object instanceof DateTimeComparator;
                    bl2 = false;
                    if (!bl3) break block2;
                    dateTimeComparator = (DateTimeComparator)object;
                    if (this.iLowerLimit == dateTimeComparator.getLowerLimit()) break block3;
                    DateTimeFieldType dateTimeFieldType = this.iLowerLimit;
                    bl2 = false;
                    if (dateTimeFieldType == null) break block2;
                    boolean bl4 = this.iLowerLimit.equals(dateTimeComparator.getLowerLimit());
                    bl2 = false;
                    if (!bl4) break block2;
                }
                if (this.iUpperLimit == dateTimeComparator.getUpperLimit()) break block4;
                DateTimeFieldType dateTimeFieldType = this.iUpperLimit;
                bl2 = false;
                if (dateTimeFieldType == null) break block2;
                boolean bl5 = this.iUpperLimit.equals(dateTimeComparator.getUpperLimit());
                bl2 = false;
                if (!bl5) break block2;
            }
            bl2 = true;
        }
        return bl2;
    }

    public DateTimeFieldType getLowerLimit() {
        return this.iLowerLimit;
    }

    public DateTimeFieldType getUpperLimit() {
        return this.iUpperLimit;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n2 = this.iLowerLimit == null ? 0 : this.iLowerLimit.hashCode();
        DateTimeFieldType dateTimeFieldType = this.iUpperLimit;
        int n3 = 0;
        if (dateTimeFieldType == null) {
            return n2 + n3 * 123;
        }
        n3 = this.iUpperLimit.hashCode();
        return n2 + n3 * 123;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        String string2;
        if (this.iLowerLimit == this.iUpperLimit) {
            String string3;
            StringBuilder stringBuilder = new StringBuilder().append("DateTimeComparator[");
            if (this.iLowerLimit == null) {
                string3 = "";
                return stringBuilder.append(string3).append("]").toString();
            }
            string3 = this.iLowerLimit.getName();
            return stringBuilder.append(string3).append("]").toString();
        }
        StringBuilder stringBuilder = new StringBuilder().append("DateTimeComparator[");
        String string4 = this.iLowerLimit == null ? "" : this.iLowerLimit.getName();
        StringBuilder stringBuilder2 = stringBuilder.append(string4).append("-");
        if (this.iUpperLimit == null) {
            string2 = "";
            return stringBuilder2.append(string2).append("]").toString();
        }
        string2 = this.iUpperLimit.getName();
        return stringBuilder2.append(string2).append("]").toString();
    }
}

