/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalInstantException;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.TimeOfDay;
import org.joda.time.YearMonthDay;
import org.joda.time.base.BaseDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateTime
extends BaseDateTime
implements ReadableDateTime,
Serializable {
    private static final long serialVersionUID = -5171125899451703815L;

    public DateTime() {
    }

    public DateTime(int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5, n6, 0, 0);
    }

    public DateTime(int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n2, n3, n4, n5, n6, n7, 0);
    }

    public DateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n2, n3, n4, n5, n6, n7, n8);
    }

    public DateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8, Chronology chronology) {
        super(n2, n3, n4, n5, n6, n7, n8, chronology);
    }

    public DateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8, DateTimeZone dateTimeZone) {
        super(n2, n3, n4, n5, n6, n7, n8, dateTimeZone);
    }

    public DateTime(int n2, int n3, int n4, int n5, int n6, int n7, Chronology chronology) {
        super(n2, n3, n4, n5, n6, n7, 0, chronology);
    }

    public DateTime(int n2, int n3, int n4, int n5, int n6, int n7, DateTimeZone dateTimeZone) {
        super(n2, n3, n4, n5, n6, n7, 0, dateTimeZone);
    }

    public DateTime(int n2, int n3, int n4, int n5, int n6, Chronology chronology) {
        super(n2, n3, n4, n5, n6, 0, 0, chronology);
    }

    public DateTime(int n2, int n3, int n4, int n5, int n6, DateTimeZone dateTimeZone) {
        super(n2, n3, n4, n5, n6, 0, 0, dateTimeZone);
    }

    public DateTime(long l2) {
        super(l2);
    }

    public DateTime(long l2, Chronology chronology) {
        super(l2, chronology);
    }

    public DateTime(long l2, DateTimeZone dateTimeZone) {
        super(l2, dateTimeZone);
    }

    public DateTime(Object object) {
        super(object, (Chronology)null);
    }

    public DateTime(Object object, Chronology chronology) {
        super(object, DateTimeUtils.getChronology(chronology));
    }

    public DateTime(Object object, DateTimeZone dateTimeZone) {
        super(object, dateTimeZone);
    }

    public DateTime(Chronology chronology) {
        super(chronology);
    }

    public DateTime(DateTimeZone dateTimeZone) {
        super(dateTimeZone);
    }

    public static DateTime now() {
        return new DateTime();
    }

    public static DateTime now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new DateTime(chronology);
    }

    public static DateTime now(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new DateTime(dateTimeZone);
    }

    @FromString
    public static DateTime parse(String string2) {
        return DateTime.parse(string2, ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    }

    public static DateTime parse(String string2, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseDateTime(string2);
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public Property hourOfDay() {
        return new Property(this, this.getChronology().hourOfDay());
    }

    public Property millisOfDay() {
        return new Property(this, this.getChronology().millisOfDay());
    }

    public Property millisOfSecond() {
        return new Property(this, this.getChronology().millisOfSecond());
    }

    public DateTime minus(long l2) {
        return this.withDurationAdded(l2, -1);
    }

    public DateTime minus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, -1);
    }

    public DateTime minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public DateTime minusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().days().subtract(this.getMillis(), n2));
    }

    public DateTime minusHours(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().hours().subtract(this.getMillis(), n2));
    }

    public DateTime minusMillis(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().millis().subtract(this.getMillis(), n2));
    }

    public DateTime minusMinutes(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().minutes().subtract(this.getMillis(), n2));
    }

    public DateTime minusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().months().subtract(this.getMillis(), n2));
    }

    public DateTime minusSeconds(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().seconds().subtract(this.getMillis(), n2));
    }

    public DateTime minusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().weeks().subtract(this.getMillis(), n2));
    }

    public DateTime minusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().years().subtract(this.getMillis(), n2));
    }

    public Property minuteOfDay() {
        return new Property(this, this.getChronology().minuteOfDay());
    }

    public Property minuteOfHour() {
        return new Property(this, this.getChronology().minuteOfHour());
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public DateTime plus(long l2) {
        return this.withDurationAdded(l2, 1);
    }

    public DateTime plus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, 1);
    }

    public DateTime plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public DateTime plusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().days().add(this.getMillis(), n2));
    }

    public DateTime plusHours(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().hours().add(this.getMillis(), n2));
    }

    public DateTime plusMillis(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().millis().add(this.getMillis(), n2));
    }

    public DateTime plusMinutes(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().minutes().add(this.getMillis(), n2));
    }

    public DateTime plusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().months().add(this.getMillis(), n2));
    }

    public DateTime plusSeconds(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().seconds().add(this.getMillis(), n2));
    }

    public DateTime plusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().weeks().add(this.getMillis(), n2));
    }

    public DateTime plusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().years().add(this.getMillis(), n2));
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField dateTimeField = dateTimeFieldType.getField(this.getChronology());
        if (!dateTimeField.isSupported()) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return new Property(this, dateTimeField);
    }

    public Property secondOfDay() {
        return new Property(this, this.getChronology().secondOfDay());
    }

    public Property secondOfMinute() {
        return new Property(this, this.getChronology().secondOfMinute());
    }

    @Deprecated
    public DateMidnight toDateMidnight() {
        return new DateMidnight(this.getMillis(), this.getChronology());
    }

    @Override
    public DateTime toDateTime() {
        return this;
    }

    @Override
    public DateTime toDateTime(Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology);
        if (this.getChronology() == chronology2) {
            return this;
        }
        return super.toDateTime(chronology2);
    }

    @Override
    public DateTime toDateTime(DateTimeZone dateTimeZone) {
        DateTimeZone dateTimeZone2 = DateTimeUtils.getZone(dateTimeZone);
        if (this.getZone() == dateTimeZone2) {
            return this;
        }
        return super.toDateTime(dateTimeZone2);
    }

    @Override
    public DateTime toDateTimeISO() {
        if (this.getChronology() == ISOChronology.getInstance()) {
            return this;
        }
        return super.toDateTimeISO();
    }

    public LocalDate toLocalDate() {
        return new LocalDate(this.getMillis(), this.getChronology());
    }

    public LocalDateTime toLocalDateTime() {
        return new LocalDateTime(this.getMillis(), this.getChronology());
    }

    public LocalTime toLocalTime() {
        return new LocalTime(this.getMillis(), this.getChronology());
    }

    @Deprecated
    public TimeOfDay toTimeOfDay() {
        return new TimeOfDay(this.getMillis(), this.getChronology());
    }

    @Deprecated
    public YearMonthDay toYearMonthDay() {
        return new YearMonthDay(this.getMillis(), this.getChronology());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public DateTime withCenturyOfEra(int n2) {
        return this.withMillis(this.getChronology().centuryOfEra().set(this.getMillis(), n2));
    }

    public DateTime withChronology(Chronology chronology) {
        Chronology chronology2 = DateTimeUtils.getChronology(chronology);
        if (chronology2 == this.getChronology()) {
            return this;
        }
        return new DateTime(this.getMillis(), chronology2);
    }

    public DateTime withDate(int n2, int n3, int n4) {
        Chronology chronology = this.getChronology();
        long l2 = this.getMillis();
        long l3 = chronology.year().set(l2, n2);
        long l4 = chronology.monthOfYear().set(l3, n3);
        return this.withMillis(chronology.dayOfMonth().set(l4, n4));
    }

    public DateTime withDayOfMonth(int n2) {
        return this.withMillis(this.getChronology().dayOfMonth().set(this.getMillis(), n2));
    }

    public DateTime withDayOfWeek(int n2) {
        return this.withMillis(this.getChronology().dayOfWeek().set(this.getMillis(), n2));
    }

    public DateTime withDayOfYear(int n2) {
        return this.withMillis(this.getChronology().dayOfYear().set(this.getMillis(), n2));
    }

    public DateTime withDurationAdded(long l2, int n2) {
        if (l2 == 0L || n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().add(this.getMillis(), l2, n2));
    }

    public DateTime withDurationAdded(ReadableDuration readableDuration, int n2) {
        if (readableDuration == null || n2 == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n2);
    }

    public DateTime withEarlierOffsetAtOverlap() {
        return this.withMillis(this.getZone().adjustOffset(this.getMillis(), false));
    }

    public DateTime withEra(int n2) {
        return this.withMillis(this.getChronology().era().set(this.getMillis(), n2));
    }

    public DateTime withField(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        return this.withMillis(dateTimeFieldType.getField(this.getChronology()).set(this.getMillis(), n2));
    }

    public DateTime withFieldAdded(DurationFieldType durationFieldType, int n2) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(durationFieldType.getField(this.getChronology()).add(this.getMillis(), n2));
    }

    public DateTime withFields(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            return this;
        }
        return this.withMillis(this.getChronology().set(readablePartial, this.getMillis()));
    }

    public DateTime withHourOfDay(int n2) {
        return this.withMillis(this.getChronology().hourOfDay().set(this.getMillis(), n2));
    }

    public DateTime withLaterOffsetAtOverlap() {
        return this.withMillis(this.getZone().adjustOffset(this.getMillis(), true));
    }

    public DateTime withMillis(long l2) {
        if (l2 == this.getMillis()) {
            return this;
        }
        return new DateTime(l2, this.getChronology());
    }

    public DateTime withMillisOfDay(int n2) {
        return this.withMillis(this.getChronology().millisOfDay().set(this.getMillis(), n2));
    }

    public DateTime withMillisOfSecond(int n2) {
        return this.withMillis(this.getChronology().millisOfSecond().set(this.getMillis(), n2));
    }

    public DateTime withMinuteOfHour(int n2) {
        return this.withMillis(this.getChronology().minuteOfHour().set(this.getMillis(), n2));
    }

    public DateTime withMonthOfYear(int n2) {
        return this.withMillis(this.getChronology().monthOfYear().set(this.getMillis(), n2));
    }

    public DateTime withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().add(readablePeriod, this.getMillis(), n2));
    }

    public DateTime withSecondOfMinute(int n2) {
        return this.withMillis(this.getChronology().secondOfMinute().set(this.getMillis(), n2));
    }

    public DateTime withTime(int n2, int n3, int n4, int n5) {
        Chronology chronology = this.getChronology();
        long l2 = this.getMillis();
        long l3 = chronology.hourOfDay().set(l2, n2);
        long l4 = chronology.minuteOfHour().set(l3, n3);
        long l5 = chronology.secondOfMinute().set(l4, n4);
        return this.withMillis(chronology.millisOfSecond().set(l5, n5));
    }

    public DateTime withTimeAtStartOfDay() {
        return this.toLocalDate().toDateTimeAtStartOfDay(this.getZone());
    }

    public DateTime withWeekOfWeekyear(int n2) {
        return this.withMillis(this.getChronology().weekOfWeekyear().set(this.getMillis(), n2));
    }

    public DateTime withWeekyear(int n2) {
        return this.withMillis(this.getChronology().weekyear().set(this.getMillis(), n2));
    }

    public DateTime withYear(int n2) {
        return this.withMillis(this.getChronology().year().set(this.getMillis(), n2));
    }

    public DateTime withYearOfCentury(int n2) {
        return this.withMillis(this.getChronology().yearOfCentury().set(this.getMillis(), n2));
    }

    public DateTime withYearOfEra(int n2) {
        return this.withMillis(this.getChronology().yearOfEra().set(this.getMillis(), n2));
    }

    public DateTime withZone(DateTimeZone dateTimeZone) {
        return this.withChronology(this.getChronology().withZone(dateTimeZone));
    }

    public DateTime withZoneRetainFields(DateTimeZone dateTimeZone) {
        DateTimeZone dateTimeZone2;
        DateTimeZone dateTimeZone3 = DateTimeUtils.getZone(dateTimeZone);
        if (dateTimeZone3 == (dateTimeZone2 = DateTimeUtils.getZone(this.getZone()))) {
            return this;
        }
        return new DateTime(dateTimeZone2.getMillisKeepLocal(dateTimeZone3, this.getMillis()), this.getChronology().withZone(dateTimeZone3));
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -6983323811635733510L;
        private DateTimeField iField;
        private DateTime iInstant;

        Property(DateTime dateTime, DateTimeField dateTimeField) {
            this.iInstant = dateTime;
            this.iField = dateTimeField;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.iInstant = (DateTime)objectInputStream.readObject();
            this.iField = ((DateTimeFieldType)objectInputStream.readObject()).getField(this.iInstant.getChronology());
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.iInstant);
            objectOutputStream.writeObject(this.iField.getType());
        }

        public DateTime addToCopy(int n2) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), n2));
        }

        public DateTime addToCopy(long l2) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), l2));
        }

        public DateTime addWrapFieldToCopy(int n2) {
            return this.iInstant.withMillis(this.iField.addWrapField(this.iInstant.getMillis(), n2));
        }

        @Override
        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public DateTime getDateTime() {
            return this.iInstant;
        }

        @Override
        public DateTimeField getField() {
            return this.iField;
        }

        @Override
        protected long getMillis() {
            return this.iInstant.getMillis();
        }

        public DateTime roundCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundCeiling(this.iInstant.getMillis()));
        }

        public DateTime roundFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundFloor(this.iInstant.getMillis()));
        }

        public DateTime roundHalfCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfCeiling(this.iInstant.getMillis()));
        }

        public DateTime roundHalfEvenCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfEven(this.iInstant.getMillis()));
        }

        public DateTime roundHalfFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfFloor(this.iInstant.getMillis()));
        }

        public DateTime setCopy(int n2) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), n2));
        }

        public DateTime setCopy(String string2) {
            return this.setCopy(string2, null);
        }

        public DateTime setCopy(String string2, Locale locale) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), string2, locale));
        }

        public DateTime withMaximumValue() {
            try {
                DateTime dateTime = this.setCopy(this.getMaximumValue());
                return dateTime;
            }
            catch (RuntimeException runtimeException) {
                if (IllegalInstantException.isIllegalInstant(runtimeException)) {
                    return new DateTime(this.getChronology().getZone().previousTransition(86400000L + this.getMillis()), this.getChronology());
                }
                throw runtimeException;
            }
        }

        public DateTime withMinimumValue() {
            try {
                DateTime dateTime = this.setCopy(this.getMinimumValue());
                return dateTime;
            }
            catch (RuntimeException runtimeException) {
                if (IllegalInstantException.isIllegalInstant(runtimeException)) {
                    return new DateTime(this.getChronology().getZone().nextTransition(this.getMillis() - 86400000L), this.getChronology());
                }
                throw runtimeException;
            }
        }
    }
}

