/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.joda.convert.FromString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.YearMonthDay;
import org.joda.time.base.BaseDateTime;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Deprecated
public final class DateMidnight
extends BaseDateTime
implements ReadableDateTime,
Serializable {
    private static final long serialVersionUID = 156371964018738L;

    public DateMidnight() {
    }

    public DateMidnight(int n2, int n3, int n4) {
        super(n2, n3, n4, 0, 0, 0, 0);
    }

    public DateMidnight(int n2, int n3, int n4, Chronology chronology) {
        super(n2, n3, n4, 0, 0, 0, 0, chronology);
    }

    public DateMidnight(int n2, int n3, int n4, DateTimeZone dateTimeZone) {
        super(n2, n3, n4, 0, 0, 0, 0, dateTimeZone);
    }

    public DateMidnight(long l2) {
        super(l2);
    }

    public DateMidnight(long l2, Chronology chronology) {
        super(l2, chronology);
    }

    public DateMidnight(long l2, DateTimeZone dateTimeZone) {
        super(l2, dateTimeZone);
    }

    public DateMidnight(Object object) {
        super(object, (Chronology)null);
    }

    public DateMidnight(Object object, Chronology chronology) {
        super(object, DateTimeUtils.getChronology(chronology));
    }

    public DateMidnight(Object object, DateTimeZone dateTimeZone) {
        super(object, dateTimeZone);
    }

    public DateMidnight(Chronology chronology) {
        super(chronology);
    }

    public DateMidnight(DateTimeZone dateTimeZone) {
        super(dateTimeZone);
    }

    public static DateMidnight now() {
        return new DateMidnight();
    }

    public static DateMidnight now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new DateMidnight(chronology);
    }

    public static DateMidnight now(DateTimeZone dateTimeZone) {
        if (dateTimeZone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new DateMidnight(dateTimeZone);
    }

    @FromString
    public static DateMidnight parse(String string2) {
        return DateMidnight.parse(string2, ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    }

    public static DateMidnight parse(String string2, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseDateTime(string2).toDateMidnight();
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    @Override
    protected long checkInstant(long l2, Chronology chronology) {
        return chronology.dayOfMonth().roundFloor(l2);
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public DateMidnight minus(long l2) {
        return this.withDurationAdded(l2, -1);
    }

    public DateMidnight minus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, -1);
    }

    public DateMidnight minus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, -1);
    }

    public DateMidnight minusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().days().subtract(this.getMillis(), n2));
    }

    public DateMidnight minusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().months().subtract(this.getMillis(), n2));
    }

    public DateMidnight minusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().weeks().subtract(this.getMillis(), n2));
    }

    public DateMidnight minusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().years().subtract(this.getMillis(), n2));
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public DateMidnight plus(long l2) {
        return this.withDurationAdded(l2, 1);
    }

    public DateMidnight plus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, 1);
    }

    public DateMidnight plus(ReadablePeriod readablePeriod) {
        return this.withPeriodAdded(readablePeriod, 1);
    }

    public DateMidnight plusDays(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().days().add(this.getMillis(), n2));
    }

    public DateMidnight plusMonths(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().months().add(this.getMillis(), n2));
    }

    public DateMidnight plusWeeks(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().weeks().add(this.getMillis(), n2));
    }

    public DateMidnight plusYears(int n2) {
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().years().add(this.getMillis(), n2));
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField dateTimeField = dateTimeFieldType.getField(this.getChronology());
        if (!dateTimeField.isSupported()) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return new Property(this, dateTimeField);
    }

    public Interval toInterval() {
        Chronology chronology = this.getChronology();
        long l2 = this.getMillis();
        return new Interval(l2, DurationFieldType.days().getField(chronology).add(l2, 1), chronology);
    }

    public LocalDate toLocalDate() {
        return new LocalDate(this.getMillis(), this.getChronology());
    }

    @Deprecated
    public YearMonthDay toYearMonthDay() {
        return new YearMonthDay(this.getMillis(), this.getChronology());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public DateMidnight withCenturyOfEra(int n2) {
        return this.withMillis(this.getChronology().centuryOfEra().set(this.getMillis(), n2));
    }

    public DateMidnight withChronology(Chronology chronology) {
        if (chronology == this.getChronology()) {
            return this;
        }
        return new DateMidnight(this.getMillis(), chronology);
    }

    public DateMidnight withDayOfMonth(int n2) {
        return this.withMillis(this.getChronology().dayOfMonth().set(this.getMillis(), n2));
    }

    public DateMidnight withDayOfWeek(int n2) {
        return this.withMillis(this.getChronology().dayOfWeek().set(this.getMillis(), n2));
    }

    public DateMidnight withDayOfYear(int n2) {
        return this.withMillis(this.getChronology().dayOfYear().set(this.getMillis(), n2));
    }

    public DateMidnight withDurationAdded(long l2, int n2) {
        if (l2 == 0L || n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().add(this.getMillis(), l2, n2));
    }

    public DateMidnight withDurationAdded(ReadableDuration readableDuration, int n2) {
        if (readableDuration == null || n2 == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n2);
    }

    public DateMidnight withEra(int n2) {
        return this.withMillis(this.getChronology().era().set(this.getMillis(), n2));
    }

    public DateMidnight withField(DateTimeFieldType dateTimeFieldType, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        return this.withMillis(dateTimeFieldType.getField(this.getChronology()).set(this.getMillis(), n2));
    }

    public DateMidnight withFieldAdded(DurationFieldType durationFieldType, int n2) {
        if (durationFieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (n2 == 0) {
            return this;
        }
        return this.withMillis(durationFieldType.getField(this.getChronology()).add(this.getMillis(), n2));
    }

    public DateMidnight withFields(ReadablePartial readablePartial) {
        if (readablePartial == null) {
            return this;
        }
        return this.withMillis(this.getChronology().set(readablePartial, this.getMillis()));
    }

    public DateMidnight withMillis(long l2) {
        Chronology chronology = this.getChronology();
        long l3 = this.checkInstant(l2, chronology);
        if (l3 == this.getMillis()) {
            return this;
        }
        return new DateMidnight(l3, chronology);
    }

    public DateMidnight withMonthOfYear(int n2) {
        return this.withMillis(this.getChronology().monthOfYear().set(this.getMillis(), n2));
    }

    public DateMidnight withPeriodAdded(ReadablePeriod readablePeriod, int n2) {
        if (readablePeriod == null || n2 == 0) {
            return this;
        }
        return this.withMillis(this.getChronology().add(readablePeriod, this.getMillis(), n2));
    }

    public DateMidnight withWeekOfWeekyear(int n2) {
        return this.withMillis(this.getChronology().weekOfWeekyear().set(this.getMillis(), n2));
    }

    public DateMidnight withWeekyear(int n2) {
        return this.withMillis(this.getChronology().weekyear().set(this.getMillis(), n2));
    }

    public DateMidnight withYear(int n2) {
        return this.withMillis(this.getChronology().year().set(this.getMillis(), n2));
    }

    public DateMidnight withYearOfCentury(int n2) {
        return this.withMillis(this.getChronology().yearOfCentury().set(this.getMillis(), n2));
    }

    public DateMidnight withYearOfEra(int n2) {
        return this.withMillis(this.getChronology().yearOfEra().set(this.getMillis(), n2));
    }

    public DateMidnight withZoneRetainFields(DateTimeZone dateTimeZone) {
        DateTimeZone dateTimeZone2;
        DateTimeZone dateTimeZone3 = DateTimeUtils.getZone(dateTimeZone);
        if (dateTimeZone3 == (dateTimeZone2 = DateTimeUtils.getZone(this.getZone()))) {
            return this;
        }
        return new DateMidnight(dateTimeZone2.getMillisKeepLocal(dateTimeZone3, this.getMillis()), this.getChronology().withZone(dateTimeZone3));
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = 257629620L;
        private DateTimeField iField;
        private DateMidnight iInstant;

        Property(DateMidnight dateMidnight, DateTimeField dateTimeField) {
            this.iInstant = dateMidnight;
            this.iField = dateTimeField;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.iInstant = (DateMidnight)objectInputStream.readObject();
            this.iField = ((DateTimeFieldType)objectInputStream.readObject()).getField(this.iInstant.getChronology());
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.iInstant);
            objectOutputStream.writeObject(this.iField.getType());
        }

        public DateMidnight addToCopy(int n2) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), n2));
        }

        public DateMidnight addToCopy(long l2) {
            return this.iInstant.withMillis(this.iField.add(this.iInstant.getMillis(), l2));
        }

        public DateMidnight addWrapFieldToCopy(int n2) {
            return this.iInstant.withMillis(this.iField.addWrapField(this.iInstant.getMillis(), n2));
        }

        @Override
        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public DateMidnight getDateMidnight() {
            return this.iInstant;
        }

        @Override
        public DateTimeField getField() {
            return this.iField;
        }

        @Override
        protected long getMillis() {
            return this.iInstant.getMillis();
        }

        public DateMidnight roundCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundCeiling(this.iInstant.getMillis()));
        }

        public DateMidnight roundFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundFloor(this.iInstant.getMillis()));
        }

        public DateMidnight roundHalfCeilingCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfCeiling(this.iInstant.getMillis()));
        }

        public DateMidnight roundHalfEvenCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfEven(this.iInstant.getMillis()));
        }

        public DateMidnight roundHalfFloorCopy() {
            return this.iInstant.withMillis(this.iField.roundHalfFloor(this.iInstant.getMillis()));
        }

        public DateMidnight setCopy(int n2) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), n2));
        }

        public DateMidnight setCopy(String string2) {
            return this.setCopy(string2, null);
        }

        public DateMidnight setCopy(String string2, Locale locale) {
            return this.iInstant.withMillis(this.iField.set(this.iInstant.getMillis(), string2, locale));
        }

        public DateMidnight withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public DateMidnight withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }
    }
}

