/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.Serializable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class Triple<L, M, R>
implements Comparable<Triple<L, M, R>>,
Serializable {
    private static final long serialVersionUID = 1L;

    public static <L, M, R> Triple<L, M, R> of(L l2, M m2, R r2) {
        return new ImmutableTriple<L, M, R>(l2, m2, r2);
    }

    @Override
    public int compareTo(Triple<L, M, R> triple) {
        return new CompareToBuilder().append(this.getLeft(), triple.getLeft()).append(this.getMiddle(), triple.getMiddle()).append(this.getRight(), triple.getRight()).toComparison();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof Triple)) {
                    return false;
                }
                Triple triple = (Triple)object;
                if (!ObjectUtils.equals(this.getLeft(), triple.getLeft()) || !ObjectUtils.equals(this.getMiddle(), triple.getMiddle()) || !ObjectUtils.equals(this.getRight(), triple.getRight())) break block5;
            }
            return true;
        }
        return false;
    }

    public abstract L getLeft();

    public abstract M getMiddle();

    public abstract R getRight();

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n2 = this.getLeft() == null ? 0 : this.getLeft().hashCode();
        int n3 = this.getMiddle() == null ? 0 : this.getMiddle().hashCode();
        int n4 = n2 ^ n3;
        R r2 = this.getRight();
        int n5 = 0;
        if (r2 == null) {
            return n4 ^ n5;
        }
        n5 = this.getRight().hashCode();
        return n4 ^ n5;
    }

    public String toString() {
        return "" + '(' + this.getLeft() + ',' + this.getMiddle() + ',' + this.getRight() + ')';
    }

    public String toString(String string2) {
        Object[] objectArray = new Object[]{this.getLeft(), this.getMiddle(), this.getRight()};
        return String.format(string2, objectArray);
    }
}

