/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class Pair<L, R>
implements Map.Entry<L, R>,
Comparable<Pair<L, R>>,
Serializable {
    private static final long serialVersionUID = 4954918890077093841L;

    public static <L, R> Pair<L, R> of(L l2, R r2) {
        return new ImmutablePair<L, R>(l2, r2);
    }

    @Override
    public int compareTo(Pair<L, R> pair) {
        return new CompareToBuilder().append(this.getLeft(), pair.getLeft()).append(this.getRight(), pair.getRight()).toComparison();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                if (!ObjectUtils.equals(this.getKey(), entry.getKey()) || !ObjectUtils.equals(this.getValue(), entry.getValue())) break block5;
            }
            return true;
        }
        return false;
    }

    @Override
    public final L getKey() {
        return this.getLeft();
    }

    public abstract L getLeft();

    public abstract R getRight();

    @Override
    public R getValue() {
        return this.getRight();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int hashCode() {
        int n2 = this.getKey() == null ? 0 : this.getKey().hashCode();
        R r2 = this.getValue();
        int n3 = 0;
        if (r2 == null) {
            return n2 ^ n3;
        }
        n3 = this.getValue().hashCode();
        return n2 ^ n3;
    }

    public String toString() {
        return "" + '(' + this.getLeft() + ',' + this.getRight() + ')';
    }

    public String toString(String string2) {
        Object[] objectArray = new Object[]{this.getLeft(), this.getRight()};
        return String.format(string2, objectArray);
    }
}

