/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import org.apache.commons.lang3.time.DurationFormatUtils;

public class StopWatch {
    private static final long NANO_2_MILLIS = 1000000L;
    private State runningState = State.UNSTARTED;
    private SplitState splitState = SplitState.UNSPLIT;
    private long startTime;
    private long startTimeMillis;
    private long stopTime;

    public long getNanoTime() {
        if (this.runningState == State.STOPPED || this.runningState == State.SUSPENDED) {
            return this.stopTime - this.startTime;
        }
        if (this.runningState == State.UNSTARTED) {
            return 0L;
        }
        if (this.runningState == State.RUNNING) {
            return System.nanoTime() - this.startTime;
        }
        throw new RuntimeException("Illegal running state has occurred.");
    }

    public long getSplitNanoTime() {
        if (this.splitState != SplitState.SPLIT) {
            throw new IllegalStateException("Stopwatch must be split to get the split time. ");
        }
        return this.stopTime - this.startTime;
    }

    public long getSplitTime() {
        return this.getSplitNanoTime() / 1000000L;
    }

    public long getStartTime() {
        if (this.runningState == State.UNSTARTED) {
            throw new IllegalStateException("Stopwatch has not been started");
        }
        return this.startTimeMillis;
    }

    public long getTime() {
        return this.getNanoTime() / 1000000L;
    }

    public boolean isStarted() {
        return this.runningState.isStarted();
    }

    public boolean isStopped() {
        return this.runningState.isStopped();
    }

    public boolean isSuspended() {
        return this.runningState.isSuspended();
    }

    public void reset() {
        this.runningState = State.UNSTARTED;
        this.splitState = SplitState.UNSPLIT;
    }

    public void resume() {
        if (this.runningState != State.SUSPENDED) {
            throw new IllegalStateException("Stopwatch must be suspended to resume. ");
        }
        this.startTime += System.nanoTime() - this.stopTime;
        this.runningState = State.RUNNING;
    }

    public void split() {
        if (this.runningState != State.RUNNING) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        this.stopTime = System.nanoTime();
        this.splitState = SplitState.SPLIT;
    }

    public void start() {
        if (this.runningState == State.STOPPED) {
            throw new IllegalStateException("Stopwatch must be reset before being restarted. ");
        }
        if (this.runningState != State.UNSTARTED) {
            throw new IllegalStateException("Stopwatch already started. ");
        }
        this.startTime = System.nanoTime();
        this.startTimeMillis = System.currentTimeMillis();
        this.runningState = State.RUNNING;
    }

    public void stop() {
        if (this.runningState != State.RUNNING && this.runningState != State.SUSPENDED) {
            throw new IllegalStateException("Stopwatch is not running. ");
        }
        if (this.runningState == State.RUNNING) {
            this.stopTime = System.nanoTime();
        }
        this.runningState = State.STOPPED;
    }

    public void suspend() {
        if (this.runningState != State.RUNNING) {
            throw new IllegalStateException("Stopwatch must be running to suspend. ");
        }
        this.stopTime = System.nanoTime();
        this.runningState = State.SUSPENDED;
    }

    public String toSplitString() {
        return DurationFormatUtils.formatDurationHMS(this.getSplitTime());
    }

    public String toString() {
        return DurationFormatUtils.formatDurationHMS(this.getTime());
    }

    public void unsplit() {
        if (this.splitState != SplitState.SPLIT) {
            throw new IllegalStateException("Stopwatch has not been split. ");
        }
        this.splitState = SplitState.UNSPLIT;
    }

    private static final class SplitState
    extends Enum<SplitState> {
        private static final /* synthetic */ SplitState[] $VALUES;
        public static final /* enum */ SplitState SPLIT = new SplitState();
        public static final /* enum */ SplitState UNSPLIT = new SplitState();

        static {
            SplitState[] splitStateArray = new SplitState[]{SPLIT, UNSPLIT};
            $VALUES = splitStateArray;
        }

        public static SplitState valueOf(String string2) {
            return Enum.valueOf(SplitState.class, string2);
        }

        public static SplitState[] values() {
            return (SplitState[])$VALUES.clone();
        }
    }

    private static abstract class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State RUNNING;
        public static final /* enum */ State STOPPED;
        public static final /* enum */ State SUSPENDED;
        public static final /* enum */ State UNSTARTED;

        static {
            UNSTARTED = new State(){

                @Override
                boolean isStarted() {
                    return false;
                }

                @Override
                boolean isStopped() {
                    return true;
                }

                @Override
                boolean isSuspended() {
                    return false;
                }
            };
            RUNNING = new State(){

                @Override
                boolean isStarted() {
                    return true;
                }

                @Override
                boolean isStopped() {
                    return false;
                }

                @Override
                boolean isSuspended() {
                    return false;
                }
            };
            STOPPED = new State(){

                @Override
                boolean isStarted() {
                    return false;
                }

                @Override
                boolean isStopped() {
                    return true;
                }

                @Override
                boolean isSuspended() {
                    return false;
                }
            };
            SUSPENDED = new State(){

                @Override
                boolean isStarted() {
                    return true;
                }

                @Override
                boolean isStopped() {
                    return false;
                }

                @Override
                boolean isSuspended() {
                    return true;
                }
            };
            State[] stateArray = new State[]{UNSTARTED, RUNNING, STOPPED, SUSPENDED};
            $VALUES = stateArray;
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        abstract boolean isStarted();

        abstract boolean isStopped();

        abstract boolean isSuspended();
    }
}

