/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class FormatCache<F extends Format> {
    static final int NONE = -1;
    private static final ConcurrentMap<MultipartKey, String> cDateTimeInstanceCache = new ConcurrentHashMap<MultipartKey, String>(7);
    private final ConcurrentMap<MultipartKey, F> cInstanceCache = new ConcurrentHashMap<MultipartKey, F>(7);

    FormatCache() {
    }

    private F getDateTimeInstance(Integer n2, Integer n3, TimeZone timeZone, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return this.getInstance(FormatCache.getPatternForStyle(n2, n3, locale), timeZone, locale);
    }

    /*
     * Unable to fully structure code
     */
    static String getPatternForStyle(Integer var0, Integer var1_1, Locale var2_2) {
        block5: {
            var3_3 = new MultipartKey(new Object[]{var0, var1_1, var2_2});
            var4_4 = (String)FormatCache.cDateTimeInstanceCache.get(var3_3);
            if (var4_4 != null) break block5;
            if (var0 == null) {
                var6_5 = DateFormat.getTimeInstance(var1_1, var2_2);
lbl7:
                // 3 sources

                while ((var7_6 = FormatCache.cDateTimeInstanceCache.putIfAbsent(var3_3, var4_4 = ((SimpleDateFormat)var6_5).toPattern())) != null) {
                    return var7_6;
                }
            }
            if (var1_1 != null) ** GOTO lbl14
            try {
                var6_5 = DateFormat.getDateInstance(var0, var2_2);
                ** GOTO lbl7
lbl14:
                // 1 sources

                var6_5 = var8_7 = DateFormat.getDateTimeInstance(var0, var1_1, var2_2);
                ** GOTO lbl7
            }
            catch (ClassCastException var5_8) {
                throw new IllegalArgumentException("No date time pattern for locale: " + var2_2);
            }
        }
        return var4_4;
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    F getDateInstance(int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n2, null, timeZone, locale);
    }

    F getDateTimeInstance(int n2, int n3, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n2, (Integer)n3, timeZone, locale);
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    public F getInstance(String string2, TimeZone timeZone, Locale locale) {
        Format format;
        MultipartKey multipartKey;
        Format format2;
        if (string2 == null) {
            throw new NullPointerException("pattern must not be null");
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((format2 = (Format)this.cInstanceCache.get(multipartKey = new MultipartKey(string2, timeZone, locale))) == null && (format = this.cInstanceCache.putIfAbsent(multipartKey, format2 = this.createInstance(string2, timeZone, locale))) != null) {
            format2 = format;
        }
        return (F)format2;
    }

    F getTimeInstance(int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance(null, (Integer)n2, timeZone, locale);
    }

    private static class MultipartKey {
        private int hashCode;
        private final Object[] keys;

        public MultipartKey(Object ... objectArray) {
            this.keys = objectArray;
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.keys, ((MultipartKey)object).keys);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n2 = 0;
                for (Object object : this.keys) {
                    if (object == null) continue;
                    n2 = n2 * 7 + object.hashCode();
                }
                this.hashCode = n2;
            }
            return this.hashCode;
        }
    }
}

