/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DatePrinter;

public class FastDatePrinter
implements DatePrinter,
Serializable {
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private static ConcurrentMap<TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<TimeZoneDisplayKey, String>(7);
    private static final long serialVersionUID = 1L;
    private final Locale mLocale;
    private transient int mMaxLengthEstimate;
    private final String mPattern;
    private transient Rule[] mRules;
    private final TimeZone mTimeZone;

    protected FastDatePrinter(String string2, TimeZone timeZone, Locale locale) {
        this.mPattern = string2;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private String applyRulesToString(Calendar calendar) {
        return this.applyRules(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    static String getTimeZoneDisplay(TimeZone timeZone, boolean bl2, int n2, Locale locale) {
        String string2;
        TimeZoneDisplayKey timeZoneDisplayKey = new TimeZoneDisplayKey(timeZone, bl2, n2, locale);
        String string3 = (String)cTimeZoneDisplayCache.get(timeZoneDisplayKey);
        if (string3 == null && (string2 = cTimeZoneDisplayCache.putIfAbsent(timeZoneDisplayKey, string3 = timeZone.getDisplayName(bl2, n2, locale))) != null) {
            string3 = string2;
        }
        return string3;
    }

    private void init() {
        List<Rule> list = this.parsePattern();
        this.mRules = list.toArray(new Rule[list.size()]);
        int n2 = 0;
        int n3 = this.mRules.length;
        while (--n3 >= 0) {
            n2 += this.mRules[n3].estimateLength();
        }
        this.mMaxLengthEstimate = n2;
    }

    private GregorianCalendar newCalendar() {
        return new GregorianCalendar(this.mTimeZone, this.mLocale);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        Rule[] ruleArray = this.mRules;
        int n2 = ruleArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ruleArray[i2].appendTo(stringBuffer, calendar);
        }
        return stringBuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof FastDatePrinter)) break block2;
                FastDatePrinter fastDatePrinter = (FastDatePrinter)object;
                if (this.mPattern.equals(fastDatePrinter.mPattern) && this.mTimeZone.equals(fastDatePrinter.mTimeZone) && this.mLocale.equals(fastDatePrinter.mLocale)) break block3;
            }
            return false;
        }
        return true;
    }

    @Override
    public String format(long l2) {
        GregorianCalendar gregorianCalendar = this.newCalendar();
        gregorianCalendar.setTimeInMillis(l2);
        return this.applyRulesToString(gregorianCalendar);
    }

    @Override
    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    @Override
    public String format(Date date) {
        GregorianCalendar gregorianCalendar = this.newCalendar();
        gregorianCalendar.setTime(date);
        return this.applyRulesToString(gregorianCalendar);
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer) {
        return this.format(new Date(l2), stringBuffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string2;
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((Long)object, stringBuffer);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unknown class: ");
        if (object == null) {
            string2 = "<null>";
            throw new IllegalArgumentException(stringBuilder.append(string2).toString());
        }
        string2 = object.getClass().getName();
        throw new IllegalArgumentException(stringBuilder.append(string2).toString());
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.applyRules(calendar, stringBuffer);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        GregorianCalendar gregorianCalendar = this.newCalendar();
        gregorianCalendar.setTime(date);
        return this.applyRules(gregorianCalendar, stringBuffer);
    }

    @Override
    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    @Override
    public String getPattern() {
        return this.mPattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    public int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected List<Rule> parsePattern() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.mLocale);
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        String[] stringArray = dateFormatSymbols.getEras();
        String[] stringArray2 = dateFormatSymbols.getMonths();
        String[] stringArray3 = dateFormatSymbols.getShortMonths();
        String[] stringArray4 = dateFormatSymbols.getWeekdays();
        String[] stringArray5 = dateFormatSymbols.getShortWeekdays();
        String[] stringArray6 = dateFormatSymbols.getAmPmStrings();
        int n2 = this.mPattern.length();
        int[] nArray = new int[1];
        int n3 = 0;
        while (true) {
            void var16_16;
            int n4;
            int n5;
            String string2;
            block35: {
                block34: {
                    if (n3 >= n2) break block34;
                    nArray[0] = n3;
                    string2 = this.parseToken(this.mPattern, nArray);
                    n5 = nArray[0];
                    n4 = string2.length();
                    if (n4 != 0) break block35;
                }
                return arrayList;
            }
            switch (string2.charAt(0)) {
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string2);
                }
                case 'G': {
                    TextField textField = new TextField(0, stringArray);
                    break;
                }
                case 'y': {
                    if (n4 == 2) {
                        TwoDigitYearField twoDigitYearField = TwoDigitYearField.INSTANCE;
                        break;
                    }
                    if (n4 < 4) {
                        n4 = 4;
                    }
                    NumberRule numberRule = this.selectNumberRule(1, n4);
                    break;
                }
                case 'M': {
                    if (n4 >= 4) {
                        TextField textField = new TextField(2, stringArray2);
                        break;
                    }
                    if (n4 == 3) {
                        TextField textField = new TextField(2, stringArray3);
                        break;
                    }
                    if (n4 == 2) {
                        TwoDigitMonthField twoDigitMonthField = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    UnpaddedMonthField unpaddedMonthField = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    NumberRule numberRule = this.selectNumberRule(5, n4);
                    break;
                }
                case 'h': {
                    TwelveHourField twelveHourField = new TwelveHourField(this.selectNumberRule(10, n4));
                    break;
                }
                case 'H': {
                    NumberRule numberRule = this.selectNumberRule(11, n4);
                    break;
                }
                case 'm': {
                    NumberRule numberRule = this.selectNumberRule(12, n4);
                    break;
                }
                case 's': {
                    NumberRule numberRule = this.selectNumberRule(13, n4);
                    break;
                }
                case 'S': {
                    NumberRule numberRule = this.selectNumberRule(14, n4);
                    break;
                }
                case 'E': {
                    String[] stringArray7 = n4 < 4 ? stringArray5 : stringArray4;
                    TextField textField = new TextField(7, stringArray7);
                    break;
                }
                case 'D': {
                    NumberRule numberRule = this.selectNumberRule(6, n4);
                    break;
                }
                case 'F': {
                    NumberRule numberRule = this.selectNumberRule(8, n4);
                    break;
                }
                case 'w': {
                    NumberRule numberRule = this.selectNumberRule(3, n4);
                    break;
                }
                case 'W': {
                    NumberRule numberRule = this.selectNumberRule(4, n4);
                    break;
                }
                case 'a': {
                    TextField textField = new TextField(9, stringArray6);
                    break;
                }
                case 'k': {
                    TwentyFourHourField twentyFourHourField = new TwentyFourHourField(this.selectNumberRule(11, n4));
                    break;
                }
                case 'K': {
                    NumberRule numberRule = this.selectNumberRule(10, n4);
                    break;
                }
                case 'z': {
                    if (n4 >= 4) {
                        TimeZoneNameRule timeZoneNameRule = new TimeZoneNameRule(this.mTimeZone, this.mLocale, 1);
                        break;
                    }
                    TimeZoneNameRule timeZoneNameRule = new TimeZoneNameRule(this.mTimeZone, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (n4 == 1) {
                        TimeZoneNumberRule timeZoneNumberRule = TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    TimeZoneNumberRule timeZoneNumberRule = TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String string3 = string2.substring(1);
                    if (string3.length() == 1) {
                        CharacterLiteral characterLiteral = new CharacterLiteral(string3.charAt(0));
                        break;
                    }
                    StringLiteral stringLiteral = new StringLiteral(string3);
                }
            }
            arrayList.add((Rule)var16_16);
            n3 = n5 + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String parseToken(String string2, int[] nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = string2.length();
        char c2 = string2.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            stringBuilder.append(c2);
            while (n2 + 1 < n3 && string2.charAt(n2 + 1) == c2) {
                stringBuilder.append(c2);
                ++n2;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl2 = false;
            for (n2 = nArray[0]; n2 < n3; ++n2) {
                char c3 = string2.charAt(n2);
                if (c3 == '\'') {
                    if (n2 + 1 < n3 && string2.charAt(n2 + 1) == '\'') {
                        ++n2;
                        stringBuilder.append(c3);
                        continue;
                    }
                    if (!bl2) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                if (bl2 || (c3 < 'A' || c3 > 'Z') && (c3 < 'a' || c3 > 'z')) {
                    stringBuilder.append(c3);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n2;
        return stringBuilder.toString();
    }

    protected NumberRule selectNumberRule(int n2, int n3) {
        switch (n3) {
            default: {
                return new PaddedNumberField(n2, n3);
            }
            case 1: {
                return new UnpaddedNumberField(n2);
            }
            case 2: 
        }
        return new TwoDigitNumberField(n2);
    }

    public String toString() {
        return "FastDatePrinter[" + this.mPattern + "," + this.mLocale + "," + this.mTimeZone.getID() + "]";
    }

    private static class CharacterLiteral
    implements Rule {
        private final char mValue;

        CharacterLiteral(char c2) {
            this.mValue = c2;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            stringBuffer.append(this.mValue);
        }

        @Override
        public int estimateLength() {
            return 1;
        }
    }

    private static interface NumberRule
    extends Rule {
        public void appendTo(StringBuffer var1, int var2);
    }

    private static class PaddedNumberField
    implements NumberRule {
        private final int mField;
        private final int mSize;

        PaddedNumberField(int n2, int n3) {
            if (n3 < 3) {
                throw new IllegalArgumentException();
            }
            this.mField = n2;
            this.mSize = n3;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final void appendTo(StringBuffer stringBuffer, int n2) {
            int n3;
            if (n2 < 100) {
                int n4 = this.mSize;
                while (true) {
                    if (--n4 < 2) {
                        stringBuffer.append((char)(48 + n2 / 10));
                        stringBuffer.append((char)(48 + n2 % 10));
                        return;
                    }
                    stringBuffer.append('0');
                }
            }
            if (n2 < 1000) {
                n3 = 3;
            } else {
                boolean bl2 = n2 > -1;
                Validate.isTrue(bl2, "Negative values should not be possible", n2);
                n3 = Integer.toString(n2).length();
            }
            int n5 = this.mSize;
            while (true) {
                if (--n5 < n3) {
                    stringBuffer.append(Integer.toString(n2));
                    return;
                }
                stringBuffer.append('0');
            }
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(this.mField));
        }

        @Override
        public int estimateLength() {
            return 4;
        }
    }

    private static interface Rule {
        public void appendTo(StringBuffer var1, Calendar var2);

        public int estimateLength();
    }

    private static class StringLiteral
    implements Rule {
        private final String mValue;

        StringLiteral(String string2) {
            this.mValue = string2;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            stringBuffer.append(this.mValue);
        }

        @Override
        public int estimateLength() {
            return this.mValue.length();
        }
    }

    private static class TextField
    implements Rule {
        private final int mField;
        private final String[] mValues;

        TextField(int n2, String[] stringArray) {
            this.mField = n2;
            this.mValues = stringArray;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            stringBuffer.append(this.mValues[calendar.get(this.mField)]);
        }

        @Override
        public int estimateLength() {
            int n2 = 0;
            int n3 = this.mValues.length;
            while (--n3 >= 0) {
                int n4 = this.mValues[n3].length();
                if (n4 <= n2) continue;
                n2 = n4;
            }
            return n2;
        }
    }

    private static class TimeZoneDisplayKey {
        private final Locale mLocale;
        private final int mStyle;
        private final TimeZone mTimeZone;

        TimeZoneDisplayKey(TimeZone timeZone, boolean bl2, int n2, Locale locale) {
            this.mTimeZone = timeZone;
            if (bl2) {
                n2 |= Integer.MIN_VALUE;
            }
            this.mStyle = n2;
            this.mLocale = locale;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (this == object) break block4;
                    if (!(object instanceof TimeZoneDisplayKey)) {
                        return false;
                    }
                    TimeZoneDisplayKey timeZoneDisplayKey = (TimeZoneDisplayKey)object;
                    if (!this.mTimeZone.equals(timeZoneDisplayKey.mTimeZone) || this.mStyle != timeZoneDisplayKey.mStyle || !this.mLocale.equals(timeZoneDisplayKey.mLocale)) break block5;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * (31 * this.mStyle + this.mLocale.hashCode()) + this.mTimeZone.hashCode();
        }
    }

    private static class TimeZoneNameRule
    implements Rule {
        private final String mDaylight;
        private final Locale mLocale;
        private final String mStandard;
        private final int mStyle;

        TimeZoneNameRule(TimeZone timeZone, Locale locale, int n2) {
            this.mLocale = locale;
            this.mStyle = n2;
            this.mStandard = FastDatePrinter.getTimeZoneDisplay(timeZone, false, n2, locale);
            this.mDaylight = FastDatePrinter.getTimeZoneDisplay(timeZone, true, n2, locale);
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            TimeZone timeZone = calendar.getTimeZone();
            if (timeZone.useDaylightTime() && calendar.get(16) != 0) {
                stringBuffer.append(FastDatePrinter.getTimeZoneDisplay(timeZone, true, this.mStyle, this.mLocale));
                return;
            }
            stringBuffer.append(FastDatePrinter.getTimeZoneDisplay(timeZone, false, this.mStyle, this.mLocale));
        }

        @Override
        public int estimateLength() {
            return Math.max(this.mStandard.length(), this.mDaylight.length());
        }
    }

    private static class TimeZoneNumberRule
    implements Rule {
        static final TimeZoneNumberRule INSTANCE_COLON = new TimeZoneNumberRule(true);
        static final TimeZoneNumberRule INSTANCE_NO_COLON = new TimeZoneNumberRule(false);
        final boolean mColon;

        TimeZoneNumberRule(boolean bl2) {
            this.mColon = bl2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            int n2 = calendar.get(15) + calendar.get(16);
            if (n2 < 0) {
                stringBuffer.append('-');
                n2 = -n2;
            } else {
                stringBuffer.append('+');
            }
            int n3 = n2 / 3600000;
            stringBuffer.append((char)(48 + n3 / 10));
            stringBuffer.append((char)(48 + n3 % 10));
            if (this.mColon) {
                stringBuffer.append(':');
            }
            int n4 = n2 / 60000 - n3 * 60;
            stringBuffer.append((char)(48 + n4 / 10));
            stringBuffer.append((char)(48 + n4 % 10));
        }

        @Override
        public int estimateLength() {
            return 5;
        }
    }

    private static class TwelveHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwelveHourField(NumberRule numberRule) {
            this.mRule = numberRule;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, int n2) {
            this.mRule.appendTo(stringBuffer, n2);
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            int n2 = calendar.get(10);
            if (n2 == 0) {
                n2 = 1 + calendar.getLeastMaximum(10);
            }
            this.mRule.appendTo(stringBuffer, n2);
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }
    }

    private static class TwentyFourHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwentyFourHourField(NumberRule numberRule) {
            this.mRule = numberRule;
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, int n2) {
            this.mRule.appendTo(stringBuffer, n2);
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            int n2 = calendar.get(11);
            if (n2 == 0) {
                n2 = 1 + calendar.getMaximum(11);
            }
            this.mRule.appendTo(stringBuffer, n2);
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }
    }

    private static class TwoDigitMonthField
    implements NumberRule {
        static final TwoDigitMonthField INSTANCE = new TwoDigitMonthField();

        TwoDigitMonthField() {
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n2) {
            stringBuffer.append((char)(48 + n2 / 10));
            stringBuffer.append((char)(48 + n2 % 10));
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, 1 + calendar.get(2));
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static class TwoDigitNumberField
    implements NumberRule {
        private final int mField;

        TwoDigitNumberField(int n2) {
            this.mField = n2;
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n2) {
            if (n2 < 100) {
                stringBuffer.append((char)(48 + n2 / 10));
                stringBuffer.append((char)(48 + n2 % 10));
                return;
            }
            stringBuffer.append(Integer.toString(n2));
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(this.mField));
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static class TwoDigitYearField
    implements NumberRule {
        static final TwoDigitYearField INSTANCE = new TwoDigitYearField();

        TwoDigitYearField() {
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n2) {
            stringBuffer.append((char)(48 + n2 / 10));
            stringBuffer.append((char)(48 + n2 % 10));
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(1) % 100);
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static class UnpaddedMonthField
    implements NumberRule {
        static final UnpaddedMonthField INSTANCE = new UnpaddedMonthField();

        UnpaddedMonthField() {
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n2) {
            if (n2 < 10) {
                stringBuffer.append((char)(n2 + 48));
                return;
            }
            stringBuffer.append((char)(48 + n2 / 10));
            stringBuffer.append((char)(48 + n2 % 10));
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, 1 + calendar.get(2));
        }

        @Override
        public int estimateLength() {
            return 2;
        }
    }

    private static class UnpaddedNumberField
    implements NumberRule {
        private final int mField;

        UnpaddedNumberField(int n2) {
            this.mField = n2;
        }

        @Override
        public final void appendTo(StringBuffer stringBuffer, int n2) {
            if (n2 < 10) {
                stringBuffer.append((char)(n2 + 48));
                return;
            }
            if (n2 < 100) {
                stringBuffer.append((char)(48 + n2 / 10));
                stringBuffer.append((char)(48 + n2 % 10));
                return;
            }
            stringBuffer.append(Integer.toString(n2));
        }

        @Override
        public void appendTo(StringBuffer stringBuffer, Calendar calendar) {
            this.appendTo(stringBuffer, calendar.get(this.mField));
        }

        @Override
        public int estimateLength() {
            return 4;
        }
    }
}

