/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateParser;

public class FastDateParser
implements DateParser,
Serializable {
    private static final Strategy ABBREVIATED_YEAR_STRATEGY;
    private static final Strategy DAY_OF_MONTH_STRATEGY;
    private static final Strategy DAY_OF_WEEK_IN_MONTH_STRATEGY;
    private static final Strategy DAY_OF_YEAR_STRATEGY;
    private static final Strategy HOUR_OF_DAY_STRATEGY;
    private static final Strategy HOUR_STRATEGY;
    static final Locale JAPANESE_IMPERIAL;
    private static final Strategy LITERAL_YEAR_STRATEGY;
    private static final Strategy MILLISECOND_STRATEGY;
    private static final Strategy MINUTE_STRATEGY;
    private static final Strategy MODULO_HOUR_OF_DAY_STRATEGY;
    private static final Strategy MODULO_HOUR_STRATEGY;
    private static final Strategy NUMBER_MONTH_STRATEGY;
    private static final Strategy SECOND_STRATEGY;
    private static final Strategy WEEK_OF_MONTH_STRATEGY;
    private static final Strategy WEEK_OF_YEAR_STRATEGY;
    private static ConcurrentMap<Locale, Strategy>[] caches;
    private static final Pattern formatPattern;
    private static final long serialVersionUID = 1L;
    private transient String currentFormatField;
    private final Locale locale;
    private transient Strategy nextStrategy;
    private transient Pattern parsePattern;
    private final String pattern;
    private transient Strategy[] strategies;
    private transient int thisYear;
    private final TimeZone timeZone;

    static {
        JAPANESE_IMPERIAL = new Locale("ja", "JP", "JP");
        formatPattern = Pattern.compile("D+|E+|F+|G+|H+|K+|M+|S+|W+|Z+|a+|d+|h+|k+|m+|s+|w+|y+|z+|''|'[^']++(''[^']*+)*+'|[^'A-Za-z]++");
        caches = new ConcurrentMap[17];
        ABBREVIATED_YEAR_STRATEGY = new NumberStrategy(1){

            @Override
            void setCalendar(FastDateParser fastDateParser, Calendar calendar, String string2) {
                int n2 = Integer.parseInt(string2);
                if (n2 < 100) {
                    n2 = fastDateParser.adjustYear(n2);
                }
                calendar.set(1, n2);
            }
        };
        NUMBER_MONTH_STRATEGY = new NumberStrategy(2){

            @Override
            int modify(int n2) {
                return n2 - 1;
            }
        };
        LITERAL_YEAR_STRATEGY = new NumberStrategy(1);
        WEEK_OF_YEAR_STRATEGY = new NumberStrategy(3);
        WEEK_OF_MONTH_STRATEGY = new NumberStrategy(4);
        DAY_OF_YEAR_STRATEGY = new NumberStrategy(6);
        DAY_OF_MONTH_STRATEGY = new NumberStrategy(5);
        DAY_OF_WEEK_IN_MONTH_STRATEGY = new NumberStrategy(8);
        HOUR_OF_DAY_STRATEGY = new NumberStrategy(11);
        MODULO_HOUR_OF_DAY_STRATEGY = new NumberStrategy(11){

            @Override
            int modify(int n2) {
                return n2 % 24;
            }
        };
        MODULO_HOUR_STRATEGY = new NumberStrategy(10){

            @Override
            int modify(int n2) {
                return n2 % 12;
            }
        };
        HOUR_STRATEGY = new NumberStrategy(10);
        MINUTE_STRATEGY = new NumberStrategy(12);
        SECOND_STRATEGY = new NumberStrategy(13);
        MILLISECOND_STRATEGY = new NumberStrategy(14);
    }

    protected FastDateParser(String string2, TimeZone timeZone, Locale locale) {
        this.pattern = string2;
        this.timeZone = timeZone;
        this.locale = locale;
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static StringBuilder escapeRegex(StringBuilder stringBuilder, String string2, boolean bl2) {
        stringBuilder.append("\\Q");
        int n2 = 0;
        while (true) {
            if (n2 >= string2.length()) {
                stringBuilder.append("\\E");
                return stringBuilder;
            }
            int n3 = string2.charAt(n2);
            switch (n3) {
                case 39: {
                    if (bl2) {
                        if (++n2 == string2.length()) {
                            return stringBuilder;
                        }
                        n3 = string2.charAt(n2);
                    }
                }
                default: {
                    break;
                }
                case 92: {
                    if (++n2 == string2.length()) break;
                    stringBuilder.append((char)n3);
                    n3 = string2.charAt(n2);
                    if (n3 != 69) break;
                    stringBuilder.append("E\\\\E\\");
                    n3 = 81;
                }
            }
            stringBuilder.append((char)n3);
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ConcurrentMap<Locale, Strategy> getCache(int n2) {
        ConcurrentMap<Locale, Strategy>[] concurrentMapArray = caches;
        synchronized (concurrentMapArray) {
            if (caches[n2] != null) return caches[n2];
            FastDateParser.caches[n2] = new ConcurrentHashMap<Locale, Strategy>(3);
            return caches[n2];
        }
    }

    private static Map<String, Integer> getDisplayNames(int n2, Calendar calendar, Locale locale) {
        return calendar.getDisplayNames(n2, 0, locale);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Strategy getLocaleSpecificStrategy(int n2, Calendar calendar) {
        Strategy strategy;
        ConcurrentMap<Locale, Strategy> concurrentMap = FastDateParser.getCache(n2);
        Strategy strategy2 = (Strategy)concurrentMap.get(this.locale);
        if (strategy2 == null && (strategy = concurrentMap.putIfAbsent(this.locale, strategy2 = n2 == 15 ? new TimeZoneStrategy(this.locale) : new TextStrategy(n2, calendar, this.locale))) != null) {
            return strategy;
        }
        return strategy2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Strategy getStrategy(String string2, Calendar calendar) {
        switch (string2.charAt(0)) {
            case '\'': {
                if (string2.length() > 2) {
                    string2 = string2.substring(1, -1 + string2.length());
                }
            }
            default: {
                return new CopyQuotedStrategy(string2);
            }
            case 'D': {
                return DAY_OF_YEAR_STRATEGY;
            }
            case 'E': {
                return this.getLocaleSpecificStrategy(7, calendar);
            }
            case 'F': {
                return DAY_OF_WEEK_IN_MONTH_STRATEGY;
            }
            case 'G': {
                return this.getLocaleSpecificStrategy(0, calendar);
            }
            case 'H': {
                return MODULO_HOUR_OF_DAY_STRATEGY;
            }
            case 'K': {
                return HOUR_STRATEGY;
            }
            case 'M': {
                if (string2.length() >= 3) {
                    return this.getLocaleSpecificStrategy(2, calendar);
                }
                return NUMBER_MONTH_STRATEGY;
            }
            case 'S': {
                return MILLISECOND_STRATEGY;
            }
            case 'W': {
                return WEEK_OF_MONTH_STRATEGY;
            }
            case 'a': {
                return this.getLocaleSpecificStrategy(9, calendar);
            }
            case 'd': {
                return DAY_OF_MONTH_STRATEGY;
            }
            case 'h': {
                return MODULO_HOUR_STRATEGY;
            }
            case 'k': {
                return HOUR_OF_DAY_STRATEGY;
            }
            case 'm': {
                return MINUTE_STRATEGY;
            }
            case 's': {
                return SECOND_STRATEGY;
            }
            case 'w': {
                return WEEK_OF_YEAR_STRATEGY;
            }
            case 'y': {
                if (string2.length() > 2) {
                    return LITERAL_YEAR_STRATEGY;
                }
                return ABBREVIATED_YEAR_STRATEGY;
            }
            case 'Z': 
            case 'z': 
        }
        return this.getLocaleSpecificStrategy(15, calendar);
    }

    private void init() {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        this.thisYear = calendar.get(1);
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Strategy> arrayList = new ArrayList<Strategy>();
        Matcher matcher = formatPattern.matcher(this.pattern);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException("Illegal pattern character '" + this.pattern.charAt(matcher.regionStart()) + "'");
        }
        this.currentFormatField = matcher.group();
        Strategy strategy = this.getStrategy(this.currentFormatField, calendar);
        while (true) {
            matcher.region(matcher.end(), matcher.regionEnd());
            if (!matcher.lookingAt()) {
                this.nextStrategy = null;
                if (matcher.regionStart() == matcher.regionEnd()) break;
                throw new IllegalArgumentException("Failed to parse \"" + this.pattern + "\" ; gave up at index " + matcher.regionStart());
            }
            String string2 = matcher.group();
            this.nextStrategy = this.getStrategy(string2, calendar);
            if (strategy.addRegex(this, stringBuilder)) {
                arrayList.add(strategy);
            }
            this.currentFormatField = string2;
            strategy = this.nextStrategy;
        }
        if (strategy.addRegex(this, stringBuilder)) {
            arrayList.add(strategy);
        }
        this.currentFormatField = null;
        this.strategies = arrayList.toArray(new Strategy[arrayList.size()]);
        this.parsePattern = Pattern.compile(stringBuilder.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    int adjustYear(int n2) {
        int n3 = n2 + this.thisYear - this.thisYear % 100;
        if (n3 < 20 + this.thisYear) {
            return n3;
        }
        return n3 - 100;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof FastDateParser)) break block2;
                FastDateParser fastDateParser = (FastDateParser)object;
                if (this.pattern.equals(fastDateParser.pattern) && this.timeZone.equals(fastDateParser.timeZone) && this.locale.equals(fastDateParser.locale)) break block3;
            }
            return false;
        }
        return true;
    }

    int getFieldWidth() {
        return this.currentFormatField.length();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    Pattern getParsePattern() {
        return this.parsePattern;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    boolean isNextNumber() {
        return this.nextStrategy != null && this.nextStrategy.isNumber();
    }

    @Override
    public Date parse(String string2) throws ParseException {
        Date date = this.parse(string2, new ParsePosition(0));
        if (date == null) {
            if (this.locale.equals(JAPANESE_IMPERIAL)) {
                throw new ParseException("(The " + this.locale + " locale does not support dates before 1868 AD)\n" + "Unparseable date: \"" + string2 + "\" does not match " + this.parsePattern.pattern(), 0);
            }
            throw new ParseException("Unparseable date: \"" + string2 + "\" does not match " + this.parsePattern.pattern(), 0);
        }
        return date;
    }

    @Override
    public Date parse(String string2, ParsePosition parsePosition) {
        int n2 = parsePosition.getIndex();
        Matcher matcher = this.parsePattern.matcher(string2.substring(n2));
        if (!matcher.lookingAt()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.clear();
        int n3 = 0;
        while (n3 < this.strategies.length) {
            Strategy[] strategyArray = this.strategies;
            int n4 = n3 + 1;
            strategyArray[n3].setCalendar(this, calendar, matcher.group(n4));
            n3 = n4;
        }
        parsePosition.setIndex(n2 + matcher.end());
        return calendar.getTime();
    }

    @Override
    public Object parseObject(String string2) throws ParseException {
        return this.parse(string2);
    }

    @Override
    public Object parseObject(String string2, ParsePosition parsePosition) {
        return this.parse(string2, parsePosition);
    }

    public String toString() {
        return "FastDateParser[" + this.pattern + "," + this.locale + "," + this.timeZone.getID() + "]";
    }

    private static class CopyQuotedStrategy
    extends Strategy {
        private final String formatField;

        CopyQuotedStrategy(String string2) {
            this.formatField = string2;
        }

        @Override
        boolean addRegex(FastDateParser fastDateParser, StringBuilder stringBuilder) {
            FastDateParser.escapeRegex(stringBuilder, this.formatField, true);
            return false;
        }

        @Override
        boolean isNumber() {
            char c2 = this.formatField.charAt(0);
            if (c2 == '\'') {
                c2 = this.formatField.charAt(1);
            }
            return Character.isDigit(c2);
        }
    }

    private static class NumberStrategy
    extends Strategy {
        private final int field;

        NumberStrategy(int n2) {
            this.field = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean addRegex(FastDateParser fastDateParser, StringBuilder stringBuilder) {
            if (fastDateParser.isNextNumber()) {
                stringBuilder.append("(\\p{IsNd}{").append(fastDateParser.getFieldWidth()).append("}+)");
                return true;
            }
            stringBuilder.append("(\\p{IsNd}++)");
            return true;
        }

        @Override
        boolean isNumber() {
            return true;
        }

        int modify(int n2) {
            return n2;
        }

        @Override
        void setCalendar(FastDateParser fastDateParser, Calendar calendar, String string2) {
            calendar.set(this.field, this.modify(Integer.parseInt(string2)));
        }
    }

    private static abstract class Strategy {
        private Strategy() {
        }

        abstract boolean addRegex(FastDateParser var1, StringBuilder var2);

        boolean isNumber() {
            return false;
        }

        void setCalendar(FastDateParser fastDateParser, Calendar calendar, String string2) {
        }
    }

    private static class TextStrategy
    extends Strategy {
        private final int field;
        private final Map<String, Integer> keyValues;

        TextStrategy(int n2, Calendar calendar, Locale locale) {
            this.field = n2;
            this.keyValues = FastDateParser.getDisplayNames(n2, calendar, locale);
        }

        @Override
        boolean addRegex(FastDateParser fastDateParser, StringBuilder stringBuilder) {
            stringBuilder.append('(');
            Iterator<String> iterator = this.keyValues.keySet().iterator();
            while (iterator.hasNext()) {
                FastDateParser.escapeRegex(stringBuilder, iterator.next(), false).append('|');
            }
            stringBuilder.setCharAt(-1 + stringBuilder.length(), ')');
            return true;
        }

        @Override
        void setCalendar(FastDateParser fastDateParser, Calendar calendar, String string2) {
            Integer n2 = this.keyValues.get(string2);
            if (n2 == null) {
                StringBuilder stringBuilder = new StringBuilder(string2);
                stringBuilder.append(" not in (");
                Iterator<String> iterator = this.keyValues.keySet().iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append(iterator.next()).append(' ');
                }
                stringBuilder.setCharAt(-1 + stringBuilder.length(), ')');
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            calendar.set(this.field, n2);
        }
    }

    private static class TimeZoneStrategy
    extends Strategy {
        private static final int ID = 0;
        private static final int LONG_DST = 3;
        private static final int LONG_STD = 1;
        private static final int SHORT_DST = 4;
        private static final int SHORT_STD = 2;
        private final SortedMap<String, TimeZone> tzNames = new TreeMap<String, TimeZone>(String.CASE_INSENSITIVE_ORDER);
        private final String validTimeZoneChars;

        /*
         * Enabled aggressive block sorting
         */
        TimeZoneStrategy(Locale locale) {
            for (String[] stringArray : DateFormatSymbols.getInstance(locale).getZoneStrings()) {
                if (stringArray[0].startsWith("GMT")) continue;
                TimeZone timeZone = TimeZone.getTimeZone(stringArray[0]);
                if (!this.tzNames.containsKey(stringArray[1])) {
                    this.tzNames.put(stringArray[1], timeZone);
                }
                if (!this.tzNames.containsKey(stringArray[2])) {
                    this.tzNames.put(stringArray[2], timeZone);
                }
                if (!timeZone.useDaylightTime()) continue;
                if (!this.tzNames.containsKey(stringArray[3])) {
                    this.tzNames.put(stringArray[3], timeZone);
                }
                if (this.tzNames.containsKey(stringArray[4])) continue;
                this.tzNames.put(stringArray[4], timeZone);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(GMT[+\\-]\\d{0,1}\\d{2}|[+\\-]\\d{2}:?\\d{2}|");
            Iterator<String> iterator = this.tzNames.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    stringBuilder.setCharAt(-1 + stringBuilder.length(), ')');
                    this.validTimeZoneChars = stringBuilder.toString();
                    return;
                }
                FastDateParser.escapeRegex(stringBuilder, iterator.next(), false).append('|');
            }
        }

        @Override
        boolean addRegex(FastDateParser fastDateParser, StringBuilder stringBuilder) {
            stringBuilder.append(this.validTimeZoneChars);
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        void setCalendar(FastDateParser fastDateParser, Calendar calendar, String string2) {
            TimeZone timeZone;
            if (string2.charAt(0) == '+' || string2.charAt(0) == '-') {
                timeZone = TimeZone.getTimeZone("GMT" + string2);
            } else if (string2.startsWith("GMT")) {
                timeZone = TimeZone.getTimeZone(string2);
            } else {
                timeZone = (TimeZone)this.tzNames.get(string2);
                if (timeZone == null) {
                    throw new IllegalArgumentException(string2 + " is not a supported timezone name");
                }
            }
            calendar.setTimeZone(timeZone);
        }
    }
}

