/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateParser;
import org.apache.commons.lang3.time.DatePrinter;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.FastDatePrinter;
import org.apache.commons.lang3.time.FormatCache;

public class FastDateFormat
extends Format
implements DateParser,
DatePrinter {
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private static final FormatCache<FastDateFormat> cache = new FormatCache<FastDateFormat>(){

        @Override
        protected FastDateFormat createInstance(String string2, TimeZone timeZone, Locale locale) {
            return new FastDateFormat(string2, timeZone, locale);
        }
    };
    private static final long serialVersionUID = 2L;
    private final FastDateParser parser;
    private final FastDatePrinter printer;

    protected FastDateFormat(String string2, TimeZone timeZone, Locale locale) {
        this.printer = new FastDatePrinter(string2, timeZone, locale);
        this.parser = new FastDateParser(string2, timeZone, locale);
    }

    public static FastDateFormat getDateInstance(int n2) {
        return cache.getDateInstance(n2, null, null);
    }

    public static FastDateFormat getDateInstance(int n2, Locale locale) {
        return cache.getDateInstance(n2, null, locale);
    }

    public static FastDateFormat getDateInstance(int n2, TimeZone timeZone) {
        return cache.getDateInstance(n2, timeZone, null);
    }

    public static FastDateFormat getDateInstance(int n2, TimeZone timeZone, Locale locale) {
        return cache.getDateInstance(n2, timeZone, locale);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3) {
        return cache.getDateTimeInstance(n2, n3, (TimeZone)null, (Locale)null);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3, Locale locale) {
        return cache.getDateTimeInstance(n2, n3, (TimeZone)null, locale);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3, TimeZone timeZone) {
        return FastDateFormat.getDateTimeInstance(n2, n3, timeZone, null);
    }

    public static FastDateFormat getDateTimeInstance(int n2, int n3, TimeZone timeZone, Locale locale) {
        return cache.getDateTimeInstance(n2, n3, timeZone, locale);
    }

    public static FastDateFormat getInstance() {
        return cache.getInstance();
    }

    public static FastDateFormat getInstance(String string2) {
        return cache.getInstance(string2, null, null);
    }

    public static FastDateFormat getInstance(String string2, Locale locale) {
        return cache.getInstance(string2, null, locale);
    }

    public static FastDateFormat getInstance(String string2, TimeZone timeZone) {
        return cache.getInstance(string2, timeZone, null);
    }

    public static FastDateFormat getInstance(String string2, TimeZone timeZone, Locale locale) {
        return cache.getInstance(string2, timeZone, locale);
    }

    public static FastDateFormat getTimeInstance(int n2) {
        return cache.getTimeInstance(n2, null, null);
    }

    public static FastDateFormat getTimeInstance(int n2, Locale locale) {
        return cache.getTimeInstance(n2, null, locale);
    }

    public static FastDateFormat getTimeInstance(int n2, TimeZone timeZone) {
        return cache.getTimeInstance(n2, timeZone, null);
    }

    public static FastDateFormat getTimeInstance(int n2, TimeZone timeZone, Locale locale) {
        return cache.getTimeInstance(n2, timeZone, locale);
    }

    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        return this.printer.applyRules(calendar, stringBuffer);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDateFormat)) {
            return false;
        }
        FastDateFormat fastDateFormat = (FastDateFormat)object;
        return this.printer.equals(fastDateFormat.printer);
    }

    @Override
    public String format(long l2) {
        return this.printer.format(l2);
    }

    @Override
    public String format(Calendar calendar) {
        return this.printer.format(calendar);
    }

    @Override
    public String format(Date date) {
        return this.printer.format(date);
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer) {
        return this.printer.format(l2, stringBuffer);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.printer.format(object, stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.printer.format(calendar, stringBuffer);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        return this.printer.format(date, stringBuffer);
    }

    @Override
    public Locale getLocale() {
        return this.printer.getLocale();
    }

    public int getMaxLengthEstimate() {
        return this.printer.getMaxLengthEstimate();
    }

    @Override
    public String getPattern() {
        return this.printer.getPattern();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.printer.getTimeZone();
    }

    public int hashCode() {
        return this.printer.hashCode();
    }

    @Override
    public Date parse(String string2) throws ParseException {
        return this.parser.parse(string2);
    }

    @Override
    public Date parse(String string2, ParsePosition parsePosition) {
        return this.parser.parse(string2, parsePosition);
    }

    @Override
    public Object parseObject(String string2, ParsePosition parsePosition) {
        return this.parser.parseObject(string2, parsePosition);
    }

    public String toString() {
        return "FastDateFormat[" + this.printer.getPattern() + "," + this.printer.getLocale() + "," + this.printer.getTimeZone().getID() + "]";
    }
}

