/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class DurationFormatUtils {
    static final Object H;
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'";
    static final Object M;
    static final Object S;
    static final Object d;
    static final Object m;
    static final Object s;
    static final Object y;

    static {
        y = "y";
        M = "M";
        d = "d";
        H = "H";
        m = "m";
        s = "s";
        S = "S";
    }

    /*
     * Enabled aggressive block sorting
     */
    static String format(Token[] tokenArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        int n9 = tokenArray.length;
        int n10 = 0;
        while (n10 < n9) {
            Token token = tokenArray[n10];
            Object object = token.getValue();
            int n11 = token.getCount();
            if (object instanceof StringBuilder) {
                stringBuilder.append(object.toString());
            } else if (object == y) {
                String string2 = bl2 ? StringUtils.leftPad(Integer.toString(n2), n11, '0') : Integer.toString(n2);
                stringBuilder.append(string2);
                bl3 = false;
            } else if (object == M) {
                String string3 = bl2 ? StringUtils.leftPad(Integer.toString(n3), n11, '0') : Integer.toString(n3);
                stringBuilder.append(string3);
                bl3 = false;
            } else if (object == d) {
                String string4 = bl2 ? StringUtils.leftPad(Integer.toString(n4), n11, '0') : Integer.toString(n4);
                stringBuilder.append(string4);
                bl3 = false;
            } else if (object == H) {
                String string5 = bl2 ? StringUtils.leftPad(Integer.toString(n5), n11, '0') : Integer.toString(n5);
                stringBuilder.append(string5);
                bl3 = false;
            } else if (object == m) {
                String string6 = bl2 ? StringUtils.leftPad(Integer.toString(n6), n11, '0') : Integer.toString(n6);
                stringBuilder.append(string6);
                bl3 = false;
            } else if (object == s) {
                String string7 = bl2 ? StringUtils.leftPad(Integer.toString(n7), n11, '0') : Integer.toString(n7);
                stringBuilder.append(string7);
                bl3 = true;
            } else if (object == S) {
                if (bl3) {
                    String string8 = bl2 ? StringUtils.leftPad(Integer.toString(n8), n11, '0') : Integer.toString(n8 += 1000);
                    stringBuilder.append(string8.substring(1));
                } else {
                    String string9 = bl2 ? StringUtils.leftPad(Integer.toString(n8), n11, '0') : Integer.toString(n8);
                    stringBuilder.append(string9);
                }
                bl3 = false;
            }
            ++n10;
        }
        return stringBuilder.toString();
    }

    public static String formatDuration(long l2, String string2) {
        return DurationFormatUtils.formatDuration(l2, string2, true);
    }

    public static String formatDuration(long l2, String string2, boolean bl2) {
        Token[] tokenArray = DurationFormatUtils.lexx(string2);
        boolean bl3 = Token.containsTokenWithValue(tokenArray, d);
        int n2 = 0;
        if (bl3) {
            n2 = (int)(l2 / 86400000L);
            l2 -= 86400000L * (long)n2;
        }
        boolean bl4 = Token.containsTokenWithValue(tokenArray, H);
        int n3 = 0;
        if (bl4) {
            n3 = (int)(l2 / 3600000L);
            l2 -= 3600000L * (long)n3;
        }
        boolean bl5 = Token.containsTokenWithValue(tokenArray, m);
        int n4 = 0;
        if (bl5) {
            n4 = (int)(l2 / 60000L);
            l2 -= 60000L * (long)n4;
        }
        boolean bl6 = Token.containsTokenWithValue(tokenArray, s);
        int n5 = 0;
        if (bl6) {
            n5 = (int)(l2 / 1000L);
            l2 -= 1000L * (long)n5;
        }
        boolean bl7 = Token.containsTokenWithValue(tokenArray, S);
        int n6 = 0;
        if (bl7) {
            n6 = (int)l2;
        }
        return DurationFormatUtils.format(tokenArray, 0, 0, n2, n3, n4, n5, n6, bl2);
    }

    public static String formatDurationHMS(long l2) {
        return DurationFormatUtils.formatDuration(l2, "H:mm:ss.SSS");
    }

    public static String formatDurationISO(long l2) {
        return DurationFormatUtils.formatDuration(l2, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDurationWords(long l2, boolean bl2, boolean bl3) {
        String string2;
        String string3;
        String string4;
        String string5 = DurationFormatUtils.formatDuration(l2, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (bl2) {
            String string6;
            string5 = " " + string5;
            String string7 = StringUtils.replaceOnce(string5, " 0 days", "");
            if (string7.length() != string5.length() && (string6 = StringUtils.replaceOnce(string5 = string7, " 0 hours", "")).length() != string5.length()) {
                String string8;
                string5 = string8 = StringUtils.replaceOnce(string6, " 0 minutes", "");
                if (string8.length() != string5.length()) {
                    string5 = StringUtils.replaceOnce(string8, " 0 seconds", "");
                }
            }
            if (string5.length() != 0) {
                string5 = string5.substring(1);
            }
        }
        if (bl3 && (string4 = StringUtils.replaceOnce(string5, " 0 seconds", "")).length() != string5.length() && (string3 = StringUtils.replaceOnce(string5 = string4, " 0 minutes", "")).length() != string5.length() && (string2 = StringUtils.replaceOnce(string5 = string3, " 0 hours", "")).length() != string5.length()) {
            string5 = StringUtils.replaceOnce(string2, " 0 days", "");
        }
        return StringUtils.replaceOnce(StringUtils.replaceOnce(StringUtils.replaceOnce(StringUtils.replaceOnce(" " + string5, " 1 seconds", " 1 second"), " 1 minutes", " 1 minute"), " 1 hours", " 1 hour"), " 1 days", " 1 day").trim();
    }

    public static String formatPeriod(long l2, long l3, String string2) {
        return DurationFormatUtils.formatPeriod(l2, l3, string2, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long l2, long l3, String string2, boolean bl2, TimeZone timeZone) {
        Token[] tokenArray = DurationFormatUtils.lexx(string2);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(new Date(l2));
        Calendar calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTime(new Date(l3));
        int n2 = calendar2.get(14) - calendar.get(14);
        int n3 = calendar2.get(13) - calendar.get(13);
        int n4 = calendar2.get(12) - calendar.get(12);
        int n5 = calendar2.get(11) - calendar.get(11);
        int n6 = calendar2.get(5) - calendar.get(5);
        int n7 = calendar2.get(2) - calendar.get(2);
        int n8 = calendar2.get(1) - calendar.get(1);
        while (n2 < 0) {
            n2 += 1000;
            --n3;
        }
        while (n3 < 0) {
            n3 += 60;
            --n4;
        }
        while (n4 < 0) {
            n4 += 60;
            --n5;
        }
        while (n5 < 0) {
            n5 += 24;
            --n6;
        }
        if (Token.containsTokenWithValue(tokenArray, M)) {
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
            while (n7 < 0) {
                n7 += 12;
                --n8;
            }
            if (!Token.containsTokenWithValue(tokenArray, y) && n8 != 0) {
                while (n8 != 0) {
                    n7 += n8 * 12;
                    n8 = 0;
                }
            }
        } else {
            if (!Token.containsTokenWithValue(tokenArray, y)) {
                int n9 = calendar2.get(1);
                if (n7 < 0) {
                    --n9;
                }
                while (calendar.get(1) != n9) {
                    int n10 = n6 + (calendar.getActualMaximum(6) - calendar.get(6));
                    if (calendar instanceof GregorianCalendar && calendar.get(2) == 1 && calendar.get(5) == 29) {
                        ++n10;
                    }
                    calendar.add(1, 1);
                    n6 = n10 + calendar.get(6);
                }
                n8 = 0;
            }
            while (calendar.get(2) != calendar2.get(2)) {
                n6 += calendar.getActualMaximum(5);
                calendar.add(2, 1);
            }
            n7 = 0;
            while (n6 < 0) {
                n6 += calendar.getActualMaximum(5);
                --n7;
                calendar.add(2, 1);
            }
        }
        if (!Token.containsTokenWithValue(tokenArray, d)) {
            n5 += n6 * 24;
            n6 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, H)) {
            n4 += n5 * 60;
            n5 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, m)) {
            n3 += n4 * 60;
            n4 = 0;
        }
        if (!Token.containsTokenWithValue(tokenArray, s)) {
            n2 += n3 * 1000;
            n3 = 0;
        }
        return DurationFormatUtils.format(tokenArray, n8, n7, n6, n5, n4, n3, n2, bl2);
    }

    public static String formatPeriodISO(long l2, long l3) {
        return DurationFormatUtils.formatPeriod(l2, l3, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    /*
     * Enabled aggressive block sorting
     */
    static Token[] lexx(String string2) {
        char[] cArray = string2.toCharArray();
        ArrayList<Token> arrayList = new ArrayList<Token>(cArray.length);
        boolean bl2 = false;
        StringBuilder stringBuilder = null;
        Token token = null;
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = cArray[n3];
            if (bl2 && c2 != '\'') {
                stringBuilder.append(c2);
            } else {
                Object object = null;
                switch (c2) {
                    default: {
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder();
                            arrayList.add(new Token(stringBuilder));
                        }
                        stringBuilder.append(c2);
                        break;
                    }
                    case '\'': {
                        if (bl2) {
                            stringBuilder = null;
                            bl2 = false;
                            object = null;
                            break;
                        }
                        stringBuilder = new StringBuilder();
                        arrayList.add(new Token(stringBuilder));
                        bl2 = true;
                        object = null;
                        break;
                    }
                    case 'y': {
                        object = y;
                        break;
                    }
                    case 'M': {
                        object = M;
                        break;
                    }
                    case 'd': {
                        object = d;
                        break;
                    }
                    case 'H': {
                        object = H;
                        break;
                    }
                    case 'm': {
                        object = m;
                        break;
                    }
                    case 's': {
                        object = s;
                        break;
                    }
                    case 'S': {
                        object = S;
                    }
                }
                if (object != null) {
                    if (token != null && token.getValue() == object) {
                        token.increment();
                    } else {
                        Token token2 = new Token(object);
                        arrayList.add(token2);
                        token = token2;
                    }
                    stringBuilder = null;
                }
            }
            ++n3;
        }
        return arrayList.toArray(new Token[arrayList.size()]);
    }

    static class Token {
        private int count;
        private final Object value;

        Token(Object object) {
            this.value = object;
            this.count = 1;
        }

        Token(Object object, int n2) {
            this.value = object;
            this.count = n2;
        }

        static boolean containsTokenWithValue(Token[] tokenArray, Object object) {
            int n2 = tokenArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (tokenArray[i2].getValue() != object) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (!(object instanceof Token)) break block5;
                    Token token = (Token)object;
                    if (this.value.getClass() != token.value.getClass() || this.count != token.count) break block5;
                    if (this.value instanceof StringBuilder) {
                        return this.value.toString().equals(token.value.toString());
                    }
                    if (this.value instanceof Number) {
                        return this.value.equals(token.value);
                    }
                    if (this.value == token.value) break block6;
                }
                return false;
            }
            return true;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        void increment() {
            this.count = 1 + this.count;
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

