/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public class DateUtils {
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_SECOND = 1000L;
    private static final int MODIFY_CEILING = 2;
    private static final int MODIFY_ROUND = 1;
    private static final int MODIFY_TRUNCATE = 0;
    public static final int RANGE_MONTH_MONDAY = 6;
    public static final int RANGE_MONTH_SUNDAY = 5;
    public static final int RANGE_WEEK_CENTER = 4;
    public static final int RANGE_WEEK_MONDAY = 2;
    public static final int RANGE_WEEK_RELATIVE = 3;
    public static final int RANGE_WEEK_SUNDAY = 1;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};

    private static Date add(Date date, int n2, int n3) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(n2, n3);
        return calendar.getTime();
    }

    public static Date addDays(Date date, int n2) {
        return DateUtils.add(date, 5, n2);
    }

    public static Date addHours(Date date, int n2) {
        return DateUtils.add(date, 11, n2);
    }

    public static Date addMilliseconds(Date date, int n2) {
        return DateUtils.add(date, 14, n2);
    }

    public static Date addMinutes(Date date, int n2) {
        return DateUtils.add(date, 12, n2);
    }

    public static Date addMonths(Date date, int n2) {
        return DateUtils.add(date, 2, n2);
    }

    public static Date addSeconds(Date date, int n2) {
        return DateUtils.add(date, 13, n2);
    }

    public static Date addWeeks(Date date, int n2) {
        return DateUtils.add(date, 3, n2);
    }

    public static Date addYears(Date date, int n2) {
        return DateUtils.add(date, 1, n2);
    }

    public static Calendar ceiling(Calendar calendar, int n2) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n2, 2);
        return calendar2;
    }

    public static Date ceiling(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.ceiling((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.ceiling((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not find ceiling of for type: " + object.getClass());
    }

    public static Date ceiling(Date date, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n2, 2);
        return calendar.getTime();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static long getFragment(Calendar calendar, int n2, int n3) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        long l2 = DateUtils.getMillisPerUnit(n3);
        long l3 = 0L;
        switch (n2) {
            case 1: {
                l3 += 86400000L * (long)calendar.get(6) / l2;
            }
            default: {
                break;
            }
            case 2: {
                l3 += 86400000L * (long)calendar.get(5) / l2;
            }
        }
        switch (n2) {
            default: {
                throw new IllegalArgumentException("The fragment " + n2 + " is not supported");
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                l3 += 3600000L * (long)calendar.get(11) / l2;
            }
            case 11: {
                l3 += 60000L * (long)calendar.get(12) / l2;
            }
            case 12: {
                l3 += 1000L * (long)calendar.get(13) / l2;
            }
            case 13: {
                l3 += (long)(1 * calendar.get(14)) / l2;
                return l3;
            }
            case 14: 
        }
        return l3;
    }

    private static long getFragment(Date date, int n2, int n3) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.getFragment(calendar, n2, n3);
    }

    public static long getFragmentInDays(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 6);
    }

    public static long getFragmentInDays(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 6);
    }

    public static long getFragmentInHours(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 11);
    }

    public static long getFragmentInHours(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 11);
    }

    public static long getFragmentInMilliseconds(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 14);
    }

    public static long getFragmentInMilliseconds(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 14);
    }

    public static long getFragmentInMinutes(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 12);
    }

    public static long getFragmentInMinutes(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 12);
    }

    public static long getFragmentInSeconds(Calendar calendar, int n2) {
        return DateUtils.getFragment(calendar, n2, 13);
    }

    public static long getFragmentInSeconds(Date date, int n2) {
        return DateUtils.getFragment(date, n2, 13);
    }

    private static long getMillisPerUnit(int n2) {
        switch (n2) {
            default: {
                throw new IllegalArgumentException("The unit " + n2 + " cannot be represented is milleseconds");
            }
            case 5: 
            case 6: {
                return 86400000L;
            }
            case 11: {
                return 3600000L;
            }
            case 12: {
                return 60000L;
            }
            case 13: {
                return 1000L;
            }
            case 14: 
        }
        return 1L;
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static boolean isSameDay(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtils.isSameDay(calendar, calendar2);
    }

    public static boolean isSameInstant(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.getTime().getTime() == calendar2.getTime().getTime();
    }

    public static boolean isSameInstant(Date date, Date date2) {
        if (date == null || date2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return date.getTime() == date2.getTime();
    }

    public static boolean isSameLocalTime(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(14) == calendar2.get(14) && calendar.get(13) == calendar2.get(13) && calendar.get(12) == calendar2.get(12) && calendar.get(11) == calendar2.get(11) && calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1) && calendar.get(0) == calendar2.get(0) && calendar.getClass() == calendar2.getClass();
    }

    public static Iterator<?> iterator(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.iterator((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.iterator((Calendar)object, n2);
        }
        throw new ClassCastException("Could not iterate based on " + object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Iterator<Calendar> iterator(Calendar calendar, int n2) {
        Calendar calendar2;
        Calendar calendar3;
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        int n3 = 1;
        int n4 = 7;
        block0 : switch (n2) {
            default: {
                throw new IllegalArgumentException("The range style " + n2 + " is not valid.");
            }
            case 5: 
            case 6: {
                calendar3 = DateUtils.truncate(calendar, 2);
                calendar2 = (Calendar)calendar3.clone();
                calendar2.add(2, 1);
                calendar2.add(5, -1);
                if (n2 != 6) break;
                n3 = 2;
                n4 = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                calendar3 = DateUtils.truncate(calendar, 5);
                calendar2 = DateUtils.truncate(calendar, 5);
                switch (n2) {
                    case 1: {
                        break block0;
                    }
                    default: {
                        break block0;
                    }
                    case 2: {
                        n3 = 2;
                        n4 = 1;
                        break block0;
                    }
                    case 3: {
                        n3 = calendar.get(7);
                        n4 = n3 - 1;
                        break block0;
                    }
                    case 4: 
                }
                n3 = -3 + calendar.get(7);
                n4 = 3 + calendar.get(7);
            }
        }
        if (n3 < 1) {
            n3 += 7;
        }
        if (n3 > 7) {
            n3 -= 7;
        }
        if (n4 < 1) {
            n4 += 7;
        }
        if (n4 > 7) {
            n4 -= 7;
        }
        while (calendar3.get(7) != n3) {
            calendar3.add(5, -1);
        }
        while (calendar2.get(7) != n4) {
            calendar2.add(5, 1);
        }
        return new DateIterator(calendar3, calendar2);
    }

    public static Iterator<Calendar> iterator(Date date, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateUtils.iterator(calendar, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void modify(Calendar calendar, int n2, int n3) {
        if (calendar.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (n2 != 14) {
            Date date = calendar.getTime();
            long l2 = date.getTime();
            int n4 = calendar.get(14);
            if (n3 == 0 || n4 < 500) {
                l2 -= (long)n4;
            }
            boolean bl2 = false;
            if (n2 == 13) {
                bl2 = true;
            }
            int n5 = calendar.get(13);
            if (!(bl2 || n3 != 0 && n5 >= 30)) {
                l2 -= 1000L * (long)n5;
            }
            if (n2 == 12) {
                bl2 = true;
            }
            int n6 = calendar.get(12);
            if (!(bl2 || n3 != 0 && n6 >= 30)) {
                l2 -= 60000L * (long)n6;
            }
            if (date.getTime() != l2) {
                date.setTime(l2);
                calendar.setTime(date);
            }
            boolean bl3 = false;
            int[][] nArray = fields;
            int n7 = nArray.length;
            int n8 = 0;
            block4: while (true) {
                if (n8 >= n7) {
                    throw new IllegalArgumentException("The field " + n2 + " is not supported");
                }
                int[] nArray2 = nArray[n8];
                int n9 = nArray2.length;
                for (int i2 = 0; i2 < n9; ++i2) {
                    if (nArray2[i2] != n2) continue;
                    if (n3 != 2 && (n3 != 1 || !bl3)) break block4;
                    if (n2 == 1001) {
                        if (calendar.get(5) == 1) {
                            calendar.add(5, 15);
                            return;
                        }
                        calendar.add(5, -15);
                        calendar.add(2, 1);
                        return;
                    }
                    if (n2 != 9) {
                        calendar.add(nArray2[0], 1);
                        return;
                    }
                    if (calendar.get(11) == 0) {
                        calendar.add(11, 12);
                        return;
                    }
                    calendar.add(11, -12);
                    calendar.add(5, 1);
                    return;
                }
                int n10 = 0;
                boolean bl4 = false;
                switch (n2) {
                    case 1001: {
                        int n11 = nArray2[0];
                        n10 = 0;
                        bl4 = false;
                        if (n11 != 5) break;
                        n10 = -1 + calendar.get(5);
                        if (n10 >= 15) {
                            n10 -= 15;
                        }
                        bl3 = n10 > 7;
                        bl4 = true;
                        break;
                    }
                    case 9: {
                        int n12 = nArray2[0];
                        n10 = 0;
                        bl4 = false;
                        if (n12 != 11) break;
                        n10 = calendar.get(11);
                        if (n10 >= 12) {
                            n10 -= 12;
                        }
                        bl3 = n10 >= 6;
                        bl4 = true;
                        break;
                    }
                }
                if (!bl4) {
                    int n13;
                    int n14 = calendar.getActualMinimum(nArray2[0]);
                    int n15 = calendar.getActualMaximum(nArray2[0]);
                    n10 = calendar.get(nArray2[0]) - n14;
                    bl3 = n10 > (n13 = (n15 - n14) / 2);
                }
                if (n10 != 0) {
                    calendar.set(nArray2[0], calendar.get(nArray2[0]) - n10);
                }
                ++n8;
            }
        }
    }

    public static Date parseDate(String string2, Locale locale, String ... stringArray) throws ParseException {
        return DateUtils.parseDateWithLeniency(string2, locale, stringArray, true);
    }

    public static Date parseDate(String string2, String ... stringArray) throws ParseException {
        return DateUtils.parseDate(string2, null, stringArray);
    }

    public static Date parseDateStrictly(String string2, Locale locale, String ... stringArray) throws ParseException {
        return DateUtils.parseDateWithLeniency(string2, null, stringArray, false);
    }

    public static Date parseDateStrictly(String string2, String ... stringArray) throws ParseException {
        return DateUtils.parseDateStrictly(string2, null, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Date parseDateWithLeniency(String string2, Locale locale, String[] stringArray, boolean bl2) throws ParseException {
        if (string2 == null || stringArray == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat simpleDateFormat = locale == null ? new SimpleDateFormat() : new SimpleDateFormat("", locale);
        simpleDateFormat.setLenient(bl2);
        ParsePosition parsePosition = new ParsePosition(0);
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            Date date;
            String string3;
            if (n3 >= n2) {
                throw new ParseException("Unable to parse the date: " + string2, -1);
            }
            String string4 = string3 = stringArray[n3];
            if (string3.endsWith("ZZ")) {
                string4 = string4.substring(0, -1 + string4.length());
            }
            simpleDateFormat.applyPattern(string4);
            parsePosition.setIndex(0);
            String string5 = string2;
            if (string3.endsWith("ZZ")) {
                string5 = string2.replaceAll("([-+][0-9][0-9]):([0-9][0-9])$", "$1$2");
            }
            if ((date = simpleDateFormat.parse(string5, parsePosition)) != null && parsePosition.getIndex() == string5.length()) {
                return date;
            }
            ++n3;
        }
    }

    public static Calendar round(Calendar calendar, int n2) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n2, 1);
        return calendar2;
    }

    public static Date round(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.round((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.round((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not round " + object);
    }

    public static Date round(Date date, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n2, 1);
        return calendar.getTime();
    }

    private static Date set(Date date, int n2, int n3) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        calendar.set(n2, n3);
        return calendar.getTime();
    }

    public static Date setDays(Date date, int n2) {
        return DateUtils.set(date, 5, n2);
    }

    public static Date setHours(Date date, int n2) {
        return DateUtils.set(date, 11, n2);
    }

    public static Date setMilliseconds(Date date, int n2) {
        return DateUtils.set(date, 14, n2);
    }

    public static Date setMinutes(Date date, int n2) {
        return DateUtils.set(date, 12, n2);
    }

    public static Date setMonths(Date date, int n2) {
        return DateUtils.set(date, 2, n2);
    }

    public static Date setSeconds(Date date, int n2) {
        return DateUtils.set(date, 13, n2);
    }

    public static Date setYears(Date date, int n2) {
        return DateUtils.set(date, 1, n2);
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar truncate(Calendar calendar, int n2) {
        if (calendar == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n2, 0);
        return calendar2;
    }

    public static Date truncate(Object object, int n2) {
        if (object == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (object instanceof Date) {
            return DateUtils.truncate((Date)object, n2);
        }
        if (object instanceof Calendar) {
            return DateUtils.truncate((Calendar)object, n2).getTime();
        }
        throw new ClassCastException("Could not truncate " + object);
    }

    public static Date truncate(Date date, int n2) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n2, 0);
        return calendar.getTime();
    }

    public static int truncatedCompareTo(Calendar calendar, Calendar calendar2, int n2) {
        return DateUtils.truncate(calendar, n2).compareTo(DateUtils.truncate(calendar2, n2));
    }

    public static int truncatedCompareTo(Date date, Date date2, int n2) {
        return DateUtils.truncate(date, n2).compareTo(DateUtils.truncate(date2, n2));
    }

    public static boolean truncatedEquals(Calendar calendar, Calendar calendar2, int n2) {
        return DateUtils.truncatedCompareTo(calendar, calendar2, n2) == 0;
    }

    public static boolean truncatedEquals(Date date, Date date2, int n2) {
        return DateUtils.truncatedCompareTo(date, date2, n2) == 0;
    }

    static class DateIterator
    implements Iterator<Calendar> {
        private final Calendar endFinal;
        private final Calendar spot;

        DateIterator(Calendar calendar, Calendar calendar2) {
            this.endFinal = calendar2;
            this.spot = calendar;
            this.spot.add(5, -1);
        }

        @Override
        public boolean hasNext() {
            return this.spot.before(this.endFinal);
        }

        @Override
        public Calendar next() {
            if (this.spot.equals(this.endFinal)) {
                throw new NoSuchElementException();
            }
            this.spot.add(5, 1);
            return (Calendar)this.spot.clone();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

