/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateFormatUtils {
    public static final FastDateFormat ISO_DATETIME_FORMAT;
    public static final FastDateFormat ISO_DATETIME_TIME_ZONE_FORMAT;
    public static final FastDateFormat ISO_DATE_FORMAT;
    public static final FastDateFormat ISO_DATE_TIME_ZONE_FORMAT;
    public static final FastDateFormat ISO_TIME_FORMAT;
    public static final FastDateFormat ISO_TIME_NO_T_FORMAT;
    public static final FastDateFormat ISO_TIME_NO_T_TIME_ZONE_FORMAT;
    public static final FastDateFormat ISO_TIME_TIME_ZONE_FORMAT;
    public static final FastDateFormat SMTP_DATETIME_FORMAT;
    private static final TimeZone UTC_TIME_ZONE;

    static {
        UTC_TIME_ZONE = TimeZone.getTimeZone("GMT");
        ISO_DATETIME_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss");
        ISO_DATETIME_TIME_ZONE_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ssZZ");
        ISO_DATE_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd");
        ISO_DATE_TIME_ZONE_FORMAT = FastDateFormat.getInstance("yyyy-MM-ddZZ");
        ISO_TIME_FORMAT = FastDateFormat.getInstance("'T'HH:mm:ss");
        ISO_TIME_TIME_ZONE_FORMAT = FastDateFormat.getInstance("'T'HH:mm:ssZZ");
        ISO_TIME_NO_T_FORMAT = FastDateFormat.getInstance("HH:mm:ss");
        ISO_TIME_NO_T_TIME_ZONE_FORMAT = FastDateFormat.getInstance("HH:mm:ssZZ");
        SMTP_DATETIME_FORMAT = FastDateFormat.getInstance("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
    }

    public static String format(long l2, String string2) {
        return DateFormatUtils.format(new Date(l2), string2, null, null);
    }

    public static String format(long l2, String string2, Locale locale) {
        return DateFormatUtils.format(new Date(l2), string2, null, locale);
    }

    public static String format(long l2, String string2, TimeZone timeZone) {
        return DateFormatUtils.format(new Date(l2), string2, timeZone, null);
    }

    public static String format(long l2, String string2, TimeZone timeZone, Locale locale) {
        return DateFormatUtils.format(new Date(l2), string2, timeZone, locale);
    }

    public static String format(Calendar calendar, String string2) {
        return DateFormatUtils.format(calendar, string2, null, null);
    }

    public static String format(Calendar calendar, String string2, Locale locale) {
        return DateFormatUtils.format(calendar, string2, null, locale);
    }

    public static String format(Calendar calendar, String string2, TimeZone timeZone) {
        return DateFormatUtils.format(calendar, string2, timeZone, null);
    }

    public static String format(Calendar calendar, String string2, TimeZone timeZone, Locale locale) {
        return FastDateFormat.getInstance(string2, timeZone, locale).format(calendar);
    }

    public static String format(Date date, String string2) {
        return DateFormatUtils.format(date, string2, null, null);
    }

    public static String format(Date date, String string2, Locale locale) {
        return DateFormatUtils.format(date, string2, null, locale);
    }

    public static String format(Date date, String string2, TimeZone timeZone) {
        return DateFormatUtils.format(date, string2, timeZone, null);
    }

    public static String format(Date date, String string2, TimeZone timeZone, Locale locale) {
        return FastDateFormat.getInstance(string2, timeZone, locale).format(date);
    }

    public static String formatUTC(long l2, String string2) {
        return DateFormatUtils.format(new Date(l2), string2, UTC_TIME_ZONE, null);
    }

    public static String formatUTC(long l2, String string2, Locale locale) {
        return DateFormatUtils.format(new Date(l2), string2, UTC_TIME_ZONE, locale);
    }

    public static String formatUTC(Date date, String string2) {
        return DateFormatUtils.format(date, string2, UTC_TIME_ZONE, null);
    }

    public static String formatUTC(Date date, String string2, Locale locale) {
        return DateFormatUtils.format(date, string2, UTC_TIME_ZONE, locale);
    }
}

