/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.text.translate.CodePointTranslator;

public class UnicodeEscaper
extends CodePointTranslator {
    private final int above;
    private final int below;
    private final boolean between;

    public UnicodeEscaper() {
        this(0, Integer.MAX_VALUE, true);
    }

    protected UnicodeEscaper(int n2, int n3, boolean bl2) {
        this.below = n2;
        this.above = n3;
        this.between = bl2;
    }

    public static UnicodeEscaper above(int n2) {
        return UnicodeEscaper.outsideOf(0, n2);
    }

    public static UnicodeEscaper below(int n2) {
        return UnicodeEscaper.outsideOf(n2, Integer.MAX_VALUE);
    }

    public static UnicodeEscaper between(int n2, int n3) {
        return new UnicodeEscaper(n2, n3, true);
    }

    public static UnicodeEscaper outsideOf(int n2, int n3) {
        return new UnicodeEscaper(n2, n3, false);
    }

    protected String toUtf16Escape(int n2) {
        return "\\u" + UnicodeEscaper.hex(n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean translate(int n2, Writer writer) throws IOException {
        if (this.between) {
            if (n2 < this.below) return false;
            if (n2 > this.above) {
                return false;
            }
        } else if (n2 >= this.below) {
            if (n2 <= this.above) return false;
        }
        if (n2 > 65535) {
            writer.write(this.toUtf16Escape(n2));
            return true;
        }
        if (n2 > 4095) {
            writer.write("\\u" + UnicodeEscaper.hex(n2));
            return true;
        }
        if (n2 > 255) {
            writer.write("\\u0" + UnicodeEscaper.hex(n2));
            return true;
        }
        if (n2 > 15) {
            writer.write("\\u00" + UnicodeEscaper.hex(n2));
            return true;
        }
        writer.write("\\u000" + UnicodeEscaper.hex(n2));
        return true;
    }
}

