/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.commons.lang3.text.translate.AggregateTranslator;

public abstract class CharSequenceTranslator {
    public static String hex(int n2) {
        return Integer.toHexString(n2).toUpperCase(Locale.ENGLISH);
    }

    public abstract int translate(CharSequence var1, int var2, Writer var3) throws IOException;

    public final String translate(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(2 * charSequence.length());
            this.translate(charSequence, stringWriter);
            String string2 = stringWriter.toString();
            return string2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void translate(CharSequence charSequence, Writer writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (charSequence != null) {
            int n2 = 0;
            int n3 = charSequence.length();
            while (n2 < n3) {
                int n4 = this.translate(charSequence, n2, writer);
                if (n4 == 0) {
                    char[] cArray = Character.toChars(Character.codePointAt(charSequence, n2));
                    writer.write(cArray);
                    n2 += cArray.length;
                    continue;
                }
                for (int i2 = 0; i2 < n4; n2 += Character.charCount(Character.codePointAt(charSequence, i2)), ++i2) {
                }
            }
        }
    }

    public final CharSequenceTranslator with(CharSequenceTranslator ... charSequenceTranslatorArray) {
        CharSequenceTranslator[] charSequenceTranslatorArray2 = new CharSequenceTranslator[1 + charSequenceTranslatorArray.length];
        charSequenceTranslatorArray2[0] = this;
        System.arraycopy(charSequenceTranslatorArray, 0, charSequenceTranslatorArray2, 1, charSequenceTranslatorArray.length);
        return new AggregateTranslator(charSequenceTranslatorArray2);
    }
}

