/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class WordUtils {
    public static String capitalize(String string2) {
        return WordUtils.capitalize(string2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String capitalize(String string2, char ... cArray) {
        int n2 = cArray == null ? -1 : cArray.length;
        if (StringUtils.isEmpty(string2) || n2 == 0) {
            return string2;
        }
        char[] cArray2 = string2.toCharArray();
        boolean bl2 = true;
        int n3 = 0;
        while (n3 < cArray2.length) {
            char c2 = cArray2[n3];
            if (WordUtils.isDelimiter(c2, cArray)) {
                bl2 = true;
            } else if (bl2) {
                cArray2[n3] = Character.toTitleCase(c2);
                bl2 = false;
            }
            ++n3;
        }
        return new String(cArray2);
    }

    public static String capitalizeFully(String string2) {
        return WordUtils.capitalizeFully(string2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String capitalizeFully(String string2, char ... cArray) {
        int n2 = cArray == null ? -1 : cArray.length;
        if (!StringUtils.isEmpty(string2) && n2 != 0) {
            return WordUtils.capitalize(string2.toLowerCase(), cArray);
        }
        return string2;
    }

    public static String initials(String string2) {
        return WordUtils.initials(string2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String initials(String string2, char ... cArray) {
        if (StringUtils.isEmpty(string2)) {
            return string2;
        }
        if (cArray != null && cArray.length == 0) {
            return "";
        }
        int n2 = string2.length();
        char[] cArray2 = new char[1 + n2 / 2];
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5;
            char c2 = string2.charAt(n3);
            if (WordUtils.isDelimiter(c2, cArray)) {
                bl2 = true;
                n5 = n4;
            } else if (bl2) {
                n5 = n4 + 1;
                cArray2[n4] = c2;
                bl2 = false;
            } else {
                n5 = n4;
            }
            ++n3;
            n4 = n5;
        }
        return new String(cArray2, 0, n4);
    }

    private static boolean isDelimiter(char c2, char[] cArray) {
        if (cArray == null) {
            return Character.isWhitespace(c2);
        }
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (c2 != cArray[i2]) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String swapCase(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return string2;
        }
        char[] cArray = string2.toCharArray();
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c2 = cArray[n2];
            if (Character.isUpperCase(c2)) {
                cArray[n2] = Character.toLowerCase(c2);
                bl2 = false;
            } else if (Character.isTitleCase(c2)) {
                cArray[n2] = Character.toLowerCase(c2);
                bl2 = false;
            } else if (Character.isLowerCase(c2)) {
                if (bl2) {
                    cArray[n2] = Character.toTitleCase(c2);
                    bl2 = false;
                } else {
                    cArray[n2] = Character.toUpperCase(c2);
                }
            } else {
                bl2 = Character.isWhitespace(c2);
            }
            ++n2;
        }
        return new String(cArray);
    }

    public static String uncapitalize(String string2) {
        return WordUtils.uncapitalize(string2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String uncapitalize(String string2, char ... cArray) {
        int n2 = cArray == null ? -1 : cArray.length;
        if (StringUtils.isEmpty(string2) || n2 == 0) {
            return string2;
        }
        char[] cArray2 = string2.toCharArray();
        boolean bl2 = true;
        int n3 = 0;
        while (n3 < cArray2.length) {
            char c2 = cArray2[n3];
            if (WordUtils.isDelimiter(c2, cArray)) {
                bl2 = true;
            } else if (bl2) {
                cArray2[n3] = Character.toLowerCase(c2);
                bl2 = false;
            }
            ++n3;
        }
        return new String(cArray2);
    }

    public static String wrap(String string2, int n2) {
        return WordUtils.wrap(string2, n2, null, false);
    }

    public static String wrap(String string2, int n2, String string3, boolean bl2) {
        if (string2 == null) {
            return null;
        }
        if (string3 == null) {
            string3 = SystemUtils.LINE_SEPARATOR;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = string2.length();
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder(n3 + 32);
        while (n3 - n4 > n2) {
            if (string2.charAt(n4) == ' ') {
                ++n4;
                continue;
            }
            int n5 = string2.lastIndexOf(32, n2 + n4);
            if (n5 >= n4) {
                stringBuilder.append(string2.substring(n4, n5));
                stringBuilder.append(string3);
                n4 = n5 + 1;
                continue;
            }
            if (bl2) {
                stringBuilder.append(string2.substring(n4, n2 + n4));
                stringBuilder.append(string3);
                n4 += n2;
                continue;
            }
            int n6 = string2.indexOf(32, n2 + n4);
            if (n6 >= 0) {
                stringBuilder.append(string2.substring(n4, n6));
                stringBuilder.append(string3);
                n4 = n6 + 1;
                continue;
            }
            stringBuilder.append(string2.substring(n4));
            n4 = n3;
        }
        stringBuilder.append(string2.substring(n4));
        return stringBuilder.toString();
    }
}

