/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrMatcher;

public class StrTokenizer
implements ListIterator<String>,
Cloneable {
    private static final StrTokenizer CSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
    private static final StrTokenizer TSV_TOKENIZER_PROTOTYPE;
    private char[] chars;
    private StrMatcher delimMatcher = StrMatcher.splitMatcher();
    private boolean emptyAsNull = false;
    private boolean ignoreEmptyTokens = true;
    private StrMatcher ignoredMatcher;
    private StrMatcher quoteMatcher = StrMatcher.noneMatcher();
    private int tokenPos;
    private String[] tokens;
    private StrMatcher trimmerMatcher;

    static {
        CSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StrMatcher.commaMatcher());
        CSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        CSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StrMatcher.noneMatcher());
        CSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StrMatcher.trimMatcher());
        CSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        CSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
        TSV_TOKENIZER_PROTOTYPE = new StrTokenizer();
        TSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StrMatcher.tabMatcher());
        TSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        TSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StrMatcher.noneMatcher());
        TSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StrMatcher.trimMatcher());
        TSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        TSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
    }

    public StrTokenizer() {
        this.ignoredMatcher = StrMatcher.noneMatcher();
        this.trimmerMatcher = StrMatcher.noneMatcher();
        this.chars = null;
    }

    public StrTokenizer(String string2) {
        this.ignoredMatcher = StrMatcher.noneMatcher();
        this.trimmerMatcher = StrMatcher.noneMatcher();
        if (string2 != null) {
            this.chars = string2.toCharArray();
            return;
        }
        this.chars = null;
    }

    public StrTokenizer(String string2, char c2) {
        this(string2);
        this.setDelimiterChar(c2);
    }

    public StrTokenizer(String string2, char c2, char c3) {
        this(string2, c2);
        this.setQuoteChar(c3);
    }

    public StrTokenizer(String string2, String string3) {
        this(string2);
        this.setDelimiterString(string3);
    }

    public StrTokenizer(String string2, StrMatcher strMatcher) {
        this(string2);
        this.setDelimiterMatcher(strMatcher);
    }

    public StrTokenizer(String string2, StrMatcher strMatcher, StrMatcher strMatcher2) {
        this(string2, strMatcher);
        this.setQuoteMatcher(strMatcher2);
    }

    public StrTokenizer(char[] cArray) {
        this.ignoredMatcher = StrMatcher.noneMatcher();
        this.trimmerMatcher = StrMatcher.noneMatcher();
        this.chars = ArrayUtils.clone(cArray);
    }

    public StrTokenizer(char[] cArray, char c2) {
        this(cArray);
        this.setDelimiterChar(c2);
    }

    public StrTokenizer(char[] cArray, char c2, char c3) {
        this(cArray, c2);
        this.setQuoteChar(c3);
    }

    public StrTokenizer(char[] cArray, String string2) {
        this(cArray);
        this.setDelimiterString(string2);
    }

    public StrTokenizer(char[] cArray, StrMatcher strMatcher) {
        this(cArray);
        this.setDelimiterMatcher(strMatcher);
    }

    public StrTokenizer(char[] cArray, StrMatcher strMatcher, StrMatcher strMatcher2) {
        this(cArray, strMatcher);
        this.setQuoteMatcher(strMatcher2);
    }

    private void addToken(List<String> list, String string2) {
        if (StringUtils.isEmpty(string2)) {
            if (this.isIgnoreEmptyTokens()) {
                return;
            }
            if (this.isEmptyTokenAsNull()) {
                string2 = null;
            }
        }
        list.add(string2);
    }

    private void checkTokenized() {
        block3: {
            block2: {
                if (this.tokens != null) break block2;
                if (this.chars != null) break block3;
                List<String> list = this.tokenize(null, 0, 0);
                this.tokens = list.toArray(new String[list.size()]);
            }
            return;
        }
        List<String> list = this.tokenize(this.chars, 0, this.chars.length);
        this.tokens = list.toArray(new String[list.size()]);
    }

    private static StrTokenizer getCSVClone() {
        return (StrTokenizer)CSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getCSVInstance() {
        return StrTokenizer.getCSVClone();
    }

    public static StrTokenizer getCSVInstance(String string2) {
        StrTokenizer strTokenizer = StrTokenizer.getCSVClone();
        strTokenizer.reset(string2);
        return strTokenizer;
    }

    public static StrTokenizer getCSVInstance(char[] cArray) {
        StrTokenizer strTokenizer = StrTokenizer.getCSVClone();
        strTokenizer.reset(cArray);
        return strTokenizer;
    }

    private static StrTokenizer getTSVClone() {
        return (StrTokenizer)TSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StrTokenizer getTSVInstance() {
        return StrTokenizer.getTSVClone();
    }

    public static StrTokenizer getTSVInstance(String string2) {
        StrTokenizer strTokenizer = StrTokenizer.getTSVClone();
        strTokenizer.reset(string2);
        return strTokenizer;
    }

    public static StrTokenizer getTSVInstance(char[] cArray) {
        StrTokenizer strTokenizer = StrTokenizer.getTSVClone();
        strTokenizer.reset(cArray);
        return strTokenizer;
    }

    private boolean isQuote(char[] cArray, int n2, int n3, int n4, int n5) {
        for (int i2 = 0; i2 < n5; ++i2) {
            if (n2 + i2 < n3 && cArray[n2 + i2] == cArray[n4 + i2]) continue;
            return false;
        }
        return true;
    }

    private int readNextToken(char[] cArray, int n2, int n3, StrBuilder strBuilder, List<String> list) {
        while (true) {
            int n4;
            if (n2 >= n3 || (n4 = Math.max(this.getIgnoredMatcher().isMatch(cArray, n2, n2, n3), this.getTrimmerMatcher().isMatch(cArray, n2, n2, n3))) == 0 || this.getDelimiterMatcher().isMatch(cArray, n2, n2, n3) > 0 || this.getQuoteMatcher().isMatch(cArray, n2, n2, n3) > 0) {
                if (n2 < n3) break;
                this.addToken(list, "");
                return -1;
            }
            n2 += n4;
        }
        int n5 = this.getDelimiterMatcher().isMatch(cArray, n2, n2, n3);
        if (n5 > 0) {
            this.addToken(list, "");
            return n2 + n5;
        }
        int n6 = this.getQuoteMatcher().isMatch(cArray, n2, n2, n3);
        if (n6 > 0) {
            return this.readWithQuotes(cArray, n2 + n6, n3, strBuilder, list, n2, n6);
        }
        return this.readWithQuotes(cArray, n2, n3, strBuilder, list, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int readWithQuotes(char[] cArray, int n2, int n3, StrBuilder strBuilder, List<String> list, int n4, int n5) {
        strBuilder.clear();
        int n6 = n2;
        boolean bl2 = n5 > 0;
        int n7 = 0;
        while (true) {
            if (n6 >= n3) {
                this.addToken(list, strBuilder.substring(0, n7));
                return -1;
            }
            if (bl2) {
                if (this.isQuote(cArray, n6, n3, n4, n5)) {
                    if (this.isQuote(cArray, n6 + n5, n3, n4, n5)) {
                        strBuilder.append(cArray, n6, n5);
                        n6 += n5 * 2;
                        n7 = strBuilder.size();
                        continue;
                    }
                    n6 += n5;
                    bl2 = false;
                    continue;
                }
                int n8 = n6 + 1;
                strBuilder.append(cArray[n6]);
                n7 = strBuilder.size();
                n6 = n8;
                continue;
            }
            int n9 = this.getDelimiterMatcher().isMatch(cArray, n6, n2, n3);
            if (n9 > 0) {
                this.addToken(list, strBuilder.substring(0, n7));
                return n6 + n9;
            }
            if (n5 > 0 && this.isQuote(cArray, n6, n3, n4, n5)) {
                bl2 = true;
                n6 += n5;
                continue;
            }
            int n10 = this.getIgnoredMatcher().isMatch(cArray, n6, n2, n3);
            if (n10 > 0) {
                n6 += n10;
                continue;
            }
            int n11 = this.getTrimmerMatcher().isMatch(cArray, n6, n2, n3);
            if (n11 > 0) {
                strBuilder.append(cArray, n6, n11);
                n6 += n11;
                continue;
            }
            int n12 = n6 + 1;
            strBuilder.append(cArray[n6]);
            n7 = strBuilder.size();
            n6 = n12;
        }
    }

    @Override
    public void add(String string2) {
        throw new UnsupportedOperationException("add() is unsupported");
    }

    public Object clone() {
        try {
            Object object = this.cloneReset();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    Object cloneReset() throws CloneNotSupportedException {
        StrTokenizer strTokenizer = (StrTokenizer)super.clone();
        if (strTokenizer.chars != null) {
            strTokenizer.chars = (char[])strTokenizer.chars.clone();
        }
        strTokenizer.reset();
        return strTokenizer;
    }

    public String getContent() {
        if (this.chars == null) {
            return null;
        }
        return new String(this.chars);
    }

    public StrMatcher getDelimiterMatcher() {
        return this.delimMatcher;
    }

    public StrMatcher getIgnoredMatcher() {
        return this.ignoredMatcher;
    }

    public StrMatcher getQuoteMatcher() {
        return this.quoteMatcher;
    }

    public String[] getTokenArray() {
        this.checkTokenized();
        return (String[])this.tokens.clone();
    }

    public List<String> getTokenList() {
        this.checkTokenized();
        ArrayList<String> arrayList = new ArrayList<String>(this.tokens.length);
        String[] stringArray = this.tokens;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    public StrMatcher getTrimmerMatcher() {
        return this.trimmerMatcher;
    }

    @Override
    public boolean hasNext() {
        this.checkTokenized();
        return this.tokenPos < this.tokens.length;
    }

    @Override
    public boolean hasPrevious() {
        this.checkTokenized();
        return this.tokenPos > 0;
    }

    public boolean isEmptyTokenAsNull() {
        return this.emptyAsNull;
    }

    public boolean isIgnoreEmptyTokens() {
        return this.ignoreEmptyTokens;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            String[] stringArray = this.tokens;
            int n2 = this.tokenPos;
            this.tokenPos = n2 + 1;
            return stringArray[n2];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.tokenPos;
    }

    public String nextToken() {
        if (this.hasNext()) {
            String[] stringArray = this.tokens;
            int n2 = this.tokenPos;
            this.tokenPos = n2 + 1;
            return stringArray[n2];
        }
        return null;
    }

    @Override
    public String previous() {
        if (this.hasPrevious()) {
            int n2;
            String[] stringArray = this.tokens;
            this.tokenPos = n2 = -1 + this.tokenPos;
            return stringArray[n2];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return -1 + this.tokenPos;
    }

    public String previousToken() {
        if (this.hasPrevious()) {
            int n2;
            String[] stringArray = this.tokens;
            this.tokenPos = n2 = -1 + this.tokenPos;
            return stringArray[n2];
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported");
    }

    public StrTokenizer reset() {
        this.tokenPos = 0;
        this.tokens = null;
        return this;
    }

    public StrTokenizer reset(String string2) {
        this.reset();
        if (string2 != null) {
            this.chars = string2.toCharArray();
            return this;
        }
        this.chars = null;
        return this;
    }

    public StrTokenizer reset(char[] cArray) {
        this.reset();
        this.chars = ArrayUtils.clone(cArray);
        return this;
    }

    @Override
    public void set(String string2) {
        throw new UnsupportedOperationException("set() is unsupported");
    }

    public StrTokenizer setDelimiterChar(char c2) {
        return this.setDelimiterMatcher(StrMatcher.charMatcher(c2));
    }

    public StrTokenizer setDelimiterMatcher(StrMatcher strMatcher) {
        if (strMatcher == null) {
            this.delimMatcher = StrMatcher.noneMatcher();
            return this;
        }
        this.delimMatcher = strMatcher;
        return this;
    }

    public StrTokenizer setDelimiterString(String string2) {
        return this.setDelimiterMatcher(StrMatcher.stringMatcher(string2));
    }

    public StrTokenizer setEmptyTokenAsNull(boolean bl2) {
        this.emptyAsNull = bl2;
        return this;
    }

    public StrTokenizer setIgnoreEmptyTokens(boolean bl2) {
        this.ignoreEmptyTokens = bl2;
        return this;
    }

    public StrTokenizer setIgnoredChar(char c2) {
        return this.setIgnoredMatcher(StrMatcher.charMatcher(c2));
    }

    public StrTokenizer setIgnoredMatcher(StrMatcher strMatcher) {
        if (strMatcher != null) {
            this.ignoredMatcher = strMatcher;
        }
        return this;
    }

    public StrTokenizer setQuoteChar(char c2) {
        return this.setQuoteMatcher(StrMatcher.charMatcher(c2));
    }

    public StrTokenizer setQuoteMatcher(StrMatcher strMatcher) {
        if (strMatcher != null) {
            this.quoteMatcher = strMatcher;
        }
        return this;
    }

    public StrTokenizer setTrimmerMatcher(StrMatcher strMatcher) {
        if (strMatcher != null) {
            this.trimmerMatcher = strMatcher;
        }
        return this;
    }

    public int size() {
        this.checkTokenized();
        return this.tokens.length;
    }

    public String toString() {
        if (this.tokens == null) {
            return "StrTokenizer[not tokenized yet]";
        }
        return "StrTokenizer" + this.getTokenList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<String> tokenize(char[] cArray, int n2, int n3) {
        if (cArray == null) return Collections.emptyList();
        if (n3 == 0) {
            return Collections.emptyList();
        }
        StrBuilder strBuilder = new StrBuilder();
        List<String> list = new ArrayList<String>();
        int n4 = n2;
        while (n4 >= 0) {
            if (n4 >= n3) return list;
            if ((n4 = this.readNextToken(cArray, n4, n3, strBuilder, list)) < n3) continue;
            this.addToken(list, "");
        }
        return list;
    }
}

