/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrMatcher;

public class StrSubstitutor {
    public static final char DEFAULT_ESCAPE = '$';
    public static final StrMatcher DEFAULT_PREFIX = StrMatcher.stringMatcher("${");
    public static final StrMatcher DEFAULT_SUFFIX = StrMatcher.stringMatcher("}");
    public static final StrMatcher DEFAULT_VALUE_DELIMITER = StrMatcher.stringMatcher(":-");
    private boolean enableSubstitutionInVariables;
    private char escapeChar;
    private StrMatcher prefixMatcher;
    private StrMatcher suffixMatcher;
    private StrMatcher valueDelimiterMatcher;
    private StrLookup<?> variableResolver;

    public StrSubstitutor() {
        this((StrLookup)null, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public <V> StrSubstitutor(Map<String, V> map) {
        this(StrLookup.mapLookup(map), DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public <V> StrSubstitutor(Map<String, V> map, String string2, String string3) {
        this(StrLookup.mapLookup(map), string2, string3, '$');
    }

    public <V> StrSubstitutor(Map<String, V> map, String string2, String string3, char c2) {
        this(StrLookup.mapLookup(map), string2, string3, c2);
    }

    public <V> StrSubstitutor(Map<String, V> map, String string2, String string3, char c2, String string4) {
        this(StrLookup.mapLookup(map), string2, string3, c2, string4);
    }

    public StrSubstitutor(StrLookup<?> strLookup) {
        this(strLookup, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(StrLookup<?> strLookup, String string2, String string3, char c2) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefix(string2);
        this.setVariableSuffix(string3);
        this.setEscapeChar(c2);
        this.setValueDelimiterMatcher(DEFAULT_VALUE_DELIMITER);
    }

    public StrSubstitutor(StrLookup<?> strLookup, String string2, String string3, char c2, String string4) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefix(string2);
        this.setVariableSuffix(string3);
        this.setEscapeChar(c2);
        this.setValueDelimiter(string4);
    }

    public StrSubstitutor(StrLookup<?> strLookup, StrMatcher strMatcher, StrMatcher strMatcher2, char c2) {
        this(strLookup, strMatcher, strMatcher2, c2, DEFAULT_VALUE_DELIMITER);
    }

    public StrSubstitutor(StrLookup<?> strLookup, StrMatcher strMatcher, StrMatcher strMatcher2, char c2, StrMatcher strMatcher3) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefixMatcher(strMatcher);
        this.setVariableSuffixMatcher(strMatcher2);
        this.setEscapeChar(c2);
        this.setValueDelimiterMatcher(strMatcher3);
    }

    private void checkCyclicSubstitution(String string2, List<String> list) {
        if (!list.contains(string2)) {
            return;
        }
        StrBuilder strBuilder = new StrBuilder(256);
        strBuilder.append("Infinite loop in property interpolation of ");
        strBuilder.append(list.remove(0));
        strBuilder.append(": ");
        strBuilder.appendWithSeparators(list, "->");
        throw new IllegalStateException(strBuilder.toString());
    }

    public static <V> String replace(Object object, Map<String, V> map) {
        return new StrSubstitutor(map).replace(object);
    }

    public static <V> String replace(Object object, Map<String, V> map, String string2, String string3) {
        return new StrSubstitutor(map, string2, string3).replace(object);
    }

    public static String replace(Object object, Properties properties) {
        if (properties == null) {
            return object.toString();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            hashMap.put(string2, properties.getProperty(string2));
        }
        return StrSubstitutor.replace(object, hashMap);
    }

    public static String replaceSystemProperties(Object object) {
        return new StrSubstitutor(StrLookup.systemPropertiesLookup()).replace(object);
    }

    /*
     * Unable to fully structure code
     */
    private int substitute(StrBuilder var1_1, int var2_2, int var3_3, List<String> var4_4) {
        block17: {
            block18: {
                block16: {
                    var5_5 = this.getVariablePrefixMatcher();
                    var6_6 = this.getVariableSuffixMatcher();
                    var7_7 = this.getEscapeChar();
                    var8_8 = this.getValueDelimiterMatcher();
                    var9_9 = this.isEnableSubstitutionInVariables();
                    if (var4_4 == null) {
                        var10_10 = true;
lbl8:
                        // 2 sources

                        while (true) {
                            var11_11 = false;
                            var12_12 = 0;
                            var13_13 = var1_1.buffer;
                            var14_14 = var2_2 + var3_3;
                            var15_15 = var2_2;
lbl14:
                            // 5 sources

                            while (var15_15 < var14_14) {
                                var16_16 = var5_5.isMatch(var13_13, var15_15, var2_2, var14_14);
                                if (var16_16 == 0) {
                                    ++var15_15;
                                    continue;
                                }
                                break block16;
                            }
                            break block17;
                            break;
                        }
                    }
                    var10_10 = false;
                    ** while (true)
                }
                if (var15_15 <= var2_2 || var13_13[var15_15 - 1] != var7_7) break block18;
                var1_1.deleteCharAt(var15_15 - 1);
                var13_13 = var1_1.buffer;
                --var12_12;
                var11_11 = true;
                --var14_14;
                ** GOTO lbl14
            }
            var17_17 = var15_15;
            var15_15 += var16_16;
            var18_18 = 0;
            while (var15_15 < var14_14) {
                block19: {
                    if (var9_9 && (var43_38 = var5_5.isMatch(var13_13, var15_15, var2_2, var14_14)) != 0) {
                        ++var18_18;
                        var15_15 += var43_38;
                        continue;
                    }
                    var19_19 = var6_6.isMatch(var13_13, var15_15, var2_2, var14_14);
                    if (var19_19 == 0) {
                        ++var15_15;
                        continue;
                    }
                    if (var18_18 != 0) break block19;
                    var20_20 = var17_17 + var16_16;
                    var21_21 = var15_15 - var17_17 - var16_16;
                    var22_22 = new String(var13_13, var20_20, var21_21);
                    if (var9_9) {
                        var23_23 = new StrBuilder(var22_22);
                        this.substitute(var23_23, 0, var23_23.length());
                        var22_22 = var23_23.toString();
                    }
                    var25_24 = var15_15 += var19_19;
                    var26_25 = var22_22;
                    var27_26 = null;
                    if (var8_8 == null) ** GOTO lbl68
                    var37_32 = var22_22.toCharArray();
                    var38_33 = 0;
                    while (true) {
                        block21: {
                            block20: {
                                var39_34 = var37_32.length;
                                var27_26 = null;
                                if (var38_33 >= var39_34) break block20;
                                if (var9_9) break block21;
                                var42_37 = var5_5.isMatch(var37_32, var38_33, var38_33, var37_32.length);
                                var27_26 = null;
                                if (var42_37 == 0) break block21;
                            }
lbl69:
                            // 2 sources

                            while (true) {
                                if (var4_4 == null) {
                                    var4_4 = new ArrayList<String>();
                                    var28_27 = new String(var13_13, var2_2, var3_3);
                                    var4_4.add(var28_27);
                                }
                                this.checkCyclicSubstitution(var26_25, var4_4);
                                var4_4.add(var26_25);
                                var31_28 = this.resolveVariable(var26_25, var1_1, var17_17, var25_24);
                                if (var31_28 == null) {
                                    var31_28 = var27_26;
                                }
                                if (var31_28 != null) {
                                    var34_30 = var31_28.length();
                                    var1_1.replace(var17_17, var25_24, var31_28);
                                    var11_11 = true;
                                    var36_31 = var34_30 + this.substitute(var1_1, var17_17, var34_30, var4_4) - (var25_24 - var17_17);
                                    var15_15 += var36_31;
                                    var14_14 += var36_31;
                                    var12_12 += var36_31;
                                    var13_13 = var1_1.buffer;
                                }
                                var32_29 = -1 + var4_4.size();
                                var4_4.remove(var32_29);
                                ** GOTO lbl14
                                break;
                            }
                        }
                        if ((var40_35 = var8_8.isMatch(var37_32, var38_33)) != 0) {
                            var26_25 = var22_22.substring(0, var38_33);
                            var41_36 = var38_33 + var40_35;
                            var27_26 = var22_22.substring(var41_36);
                            ** continue;
                        }
                        ++var38_33;
                    }
                }
                --var18_18;
                var15_15 += var19_19;
            }
            ** GOTO lbl14
        }
        if (var10_10) {
            if (var11_11) {
                return 1;
            }
            return 0;
        }
        return var12_12;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public StrMatcher getValueDelimiterMatcher() {
        return this.valueDelimiterMatcher;
    }

    public StrMatcher getVariablePrefixMatcher() {
        return this.prefixMatcher;
    }

    public StrLookup<?> getVariableResolver() {
        return this.variableResolver;
    }

    public StrMatcher getVariableSuffixMatcher() {
        return this.suffixMatcher;
    }

    public boolean isEnableSubstitutionInVariables() {
        return this.enableSubstitutionInVariables;
    }

    public String replace(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return this.replace(charSequence, 0, charSequence.length());
    }

    public String replace(CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            return null;
        }
        Appendable appendable = new StrBuilder(n3).append(charSequence, n2, n3);
        this.substitute((StrBuilder)appendable, 0, n3);
        return ((StrBuilder)appendable).toString();
    }

    public String replace(Object object) {
        if (object == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder().append(object);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String replace(String string2) {
        if (string2 == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(string2);
        if (!this.substitute(strBuilder, 0, string2.length())) return string2;
        return strBuilder.toString();
    }

    public String replace(String string2, int n2, int n3) {
        if (string2 == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(string2, n2, n3);
        if (!this.substitute(strBuilder, 0, n3)) {
            return string2.substring(n2, n2 + n3);
        }
        return strBuilder.toString();
    }

    public String replace(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(stringBuffer.length()).append(stringBuffer);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public String replace(StringBuffer stringBuffer, int n2, int n3) {
        if (stringBuffer == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(stringBuffer, n2, n3);
        this.substitute(strBuilder, 0, n3);
        return strBuilder.toString();
    }

    public String replace(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return null;
        }
        StrBuilder strBuilder2 = new StrBuilder(strBuilder.length()).append(strBuilder);
        this.substitute(strBuilder2, 0, strBuilder2.length());
        return strBuilder2.toString();
    }

    public String replace(StrBuilder strBuilder, int n2, int n3) {
        if (strBuilder == null) {
            return null;
        }
        StrBuilder strBuilder2 = new StrBuilder(n3).append(strBuilder, n2, n3);
        this.substitute(strBuilder2, 0, n3);
        return strBuilder2.toString();
    }

    public String replace(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(cArray.length).append(cArray);
        this.substitute(strBuilder, 0, cArray.length);
        return strBuilder.toString();
    }

    public String replace(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(cArray, n2, n3);
        this.substitute(strBuilder, 0, n3);
        return strBuilder.toString();
    }

    public boolean replaceIn(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return false;
        }
        return this.replaceIn(stringBuffer, 0, stringBuffer.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean replaceIn(StringBuffer stringBuffer, int n2, int n3) {
        StrBuilder strBuilder;
        if (stringBuffer == null || !this.substitute(strBuilder = new StrBuilder(n3).append(stringBuffer, n2, n3), 0, n3)) {
            return false;
        }
        stringBuffer.replace(n2, n2 + n3, strBuilder.toString());
        return true;
    }

    public boolean replaceIn(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return false;
        }
        return this.replaceIn(stringBuilder, 0, stringBuilder.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean replaceIn(StringBuilder stringBuilder, int n2, int n3) {
        StrBuilder strBuilder;
        if (stringBuilder == null || !this.substitute(strBuilder = new StrBuilder(n3).append(stringBuilder, n2, n3), 0, n3)) {
            return false;
        }
        stringBuilder.replace(n2, n2 + n3, strBuilder.toString());
        return true;
    }

    public boolean replaceIn(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return false;
        }
        return this.substitute(strBuilder, 0, strBuilder.length());
    }

    public boolean replaceIn(StrBuilder strBuilder, int n2, int n3) {
        if (strBuilder == null) {
            return false;
        }
        return this.substitute(strBuilder, n2, n3);
    }

    protected String resolveVariable(String string2, StrBuilder strBuilder, int n2, int n3) {
        StrLookup<?> strLookup = this.getVariableResolver();
        if (strLookup == null) {
            return null;
        }
        return strLookup.lookup(string2);
    }

    public void setEnableSubstitutionInVariables(boolean bl2) {
        this.enableSubstitutionInVariables = bl2;
    }

    public void setEscapeChar(char c2) {
        this.escapeChar = c2;
    }

    public StrSubstitutor setValueDelimiter(char c2) {
        return this.setValueDelimiterMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setValueDelimiter(String string2) {
        if (StringUtils.isEmpty(string2)) {
            this.setValueDelimiterMatcher(null);
            return this;
        }
        return this.setValueDelimiterMatcher(StrMatcher.stringMatcher(string2));
    }

    public StrSubstitutor setValueDelimiterMatcher(StrMatcher strMatcher) {
        this.valueDelimiterMatcher = strMatcher;
        return this;
    }

    public StrSubstitutor setVariablePrefix(char c2) {
        return this.setVariablePrefixMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setVariablePrefix(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Variable prefix must not be null!");
        }
        return this.setVariablePrefixMatcher(StrMatcher.stringMatcher(string2));
    }

    public StrSubstitutor setVariablePrefixMatcher(StrMatcher strMatcher) {
        if (strMatcher == null) {
            throw new IllegalArgumentException("Variable prefix matcher must not be null!");
        }
        this.prefixMatcher = strMatcher;
        return this;
    }

    public void setVariableResolver(StrLookup<?> strLookup) {
        this.variableResolver = strLookup;
    }

    public StrSubstitutor setVariableSuffix(char c2) {
        return this.setVariableSuffixMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setVariableSuffix(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Variable suffix must not be null!");
        }
        return this.setVariableSuffixMatcher(StrMatcher.stringMatcher(string2));
    }

    public StrSubstitutor setVariableSuffixMatcher(StrMatcher strMatcher) {
        if (strMatcher == null) {
            throw new IllegalArgumentException("Variable suffix matcher must not be null!");
        }
        this.suffixMatcher = strMatcher;
        return this;
    }

    protected boolean substitute(StrBuilder strBuilder, int n2, int n3) {
        return this.substitute(strBuilder, n2, n3, null) > 0;
    }
}

