/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.Map;

public abstract class StrLookup<V> {
    private static final StrLookup<String> NONE_LOOKUP;
    private static final StrLookup<String> SYSTEM_PROPERTIES_LOOKUP;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        StrLookup<String> strLookup;
        NONE_LOOKUP = new MapStrLookup<String>(null);
        try {
            strLookup = new MapStrLookup<Object>(System.getProperties());
        }
        catch (SecurityException securityException) {
            strLookup = NONE_LOOKUP;
        }
        SYSTEM_PROPERTIES_LOOKUP = strLookup;
    }

    protected StrLookup() {
    }

    public static <V> StrLookup<V> mapLookup(Map<String, V> map) {
        return new MapStrLookup<V>(map);
    }

    public static StrLookup<?> noneLookup() {
        return NONE_LOOKUP;
    }

    public static StrLookup<String> systemPropertiesLookup() {
        return SYSTEM_PROPERTIES_LOOKUP;
    }

    public abstract String lookup(String var1);

    static class MapStrLookup<V>
    extends StrLookup<V> {
        private final Map<String, V> map;

        MapStrLookup(Map<String, V> map) {
            this.map = map;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String lookup(String string2) {
            V v2;
            if (this.map == null || (v2 = this.map.get(string2)) == null) {
                return null;
            }
            return v2.toString();
        }
    }
}

