/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;

public class StrBuilder
implements CharSequence,
Appendable,
Serializable,
Builder<String> {
    static final int CAPACITY = 32;
    private static final long serialVersionUID = 7628716375283629643L;
    protected char[] buffer;
    private String newLine;
    private String nullText;
    protected int size;

    public StrBuilder() {
        this(32);
    }

    public StrBuilder(int n2) {
        if (n2 <= 0) {
            n2 = 32;
        }
        this.buffer = new char[n2];
    }

    public StrBuilder(String string2) {
        if (string2 == null) {
            this.buffer = new char[32];
            return;
        }
        this.buffer = new char[32 + string2.length()];
        this.append(string2);
    }

    private void deleteImpl(int n2, int n3, int n4) {
        System.arraycopy(this.buffer, n3, this.buffer, n2, this.size - n3);
        this.size -= n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private StrBuilder replaceImpl(StrMatcher strMatcher, String string2, int n2, int n3, int n4) {
        if (strMatcher != null && this.size != 0) {
            int n5 = string2 == null ? 0 : string2.length();
            char[] cArray = this.buffer;
            for (int i2 = n2; i2 < n3 && n4 != 0; ++i2) {
                int n6 = strMatcher.isMatch(cArray, i2, n2, n3);
                if (n6 <= 0) continue;
                this.replaceImpl(i2, i2 + n6, n6, string2, n5);
                n3 = n5 + (n3 - n6);
                i2 = -1 + (i2 + n5);
                if (n4 <= 0) continue;
                --n4;
            }
        }
        return this;
    }

    private void replaceImpl(int n2, int n3, int n4, String string2, int n5) {
        int n6 = n5 + (this.size - n4);
        if (n5 != n4) {
            this.ensureCapacity(n6);
            System.arraycopy(this.buffer, n3, this.buffer, n2 + n5, this.size - n3);
            this.size = n6;
        }
        if (n5 > 0) {
            string2.getChars(0, n5, this.buffer, n2);
        }
    }

    @Override
    public StrBuilder append(char c2) {
        this.ensureCapacity(1 + this.length());
        char[] cArray = this.buffer;
        int n2 = this.size;
        this.size = n2 + 1;
        cArray[n2] = c2;
        return this;
    }

    public StrBuilder append(double d2) {
        return this.append(String.valueOf(d2));
    }

    public StrBuilder append(float f2) {
        return this.append(String.valueOf(f2));
    }

    public StrBuilder append(int n2) {
        return this.append(String.valueOf(n2));
    }

    public StrBuilder append(long l2) {
        return this.append(String.valueOf(l2));
    }

    @Override
    public StrBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.appendNull();
        }
        return this.append(charSequence.toString());
    }

    @Override
    public StrBuilder append(CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            return this.appendNull();
        }
        return this.append(charSequence.toString(), n2, n3);
    }

    public StrBuilder append(Object object) {
        if (object == null) {
            return this.appendNull();
        }
        return this.append(object.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(String string2) {
        if (string2 == null) {
            return this.appendNull();
        }
        int n2 = string2.length();
        if (n2 <= 0) return this;
        int n3 = this.length();
        this.ensureCapacity(n3 + n2);
        string2.getChars(0, n2, this.buffer, n3);
        this.size = n2 + this.size;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(String string2, int n2, int n3) {
        if (string2 == null) {
            return this.appendNull();
        }
        if (n2 < 0) throw new StringIndexOutOfBoundsException("startIndex must be valid");
        if (n2 > string2.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n3 < 0) throw new StringIndexOutOfBoundsException("length must be valid");
        if (n2 + n3 > string2.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n3 <= 0) return this;
        int n4 = this.length();
        this.ensureCapacity(n4 + n3);
        string2.getChars(n2, n2 + n3, this.buffer, n4);
        this.size = n3 + this.size;
        return this;
    }

    public StrBuilder append(String string2, Object ... objectArray) {
        return this.append(String.format(string2, objectArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.appendNull();
        }
        int n2 = stringBuffer.length();
        if (n2 <= 0) return this;
        int n3 = this.length();
        this.ensureCapacity(n3 + n2);
        stringBuffer.getChars(0, n2, this.buffer, n3);
        this.size = n2 + this.size;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(StringBuffer stringBuffer, int n2, int n3) {
        if (stringBuffer == null) {
            return this.appendNull();
        }
        if (n2 < 0) throw new StringIndexOutOfBoundsException("startIndex must be valid");
        if (n2 > stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n3 < 0) throw new StringIndexOutOfBoundsException("length must be valid");
        if (n2 + n3 > stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n3 <= 0) return this;
        int n4 = this.length();
        this.ensureCapacity(n4 + n3);
        stringBuffer.getChars(n2, n2 + n3, this.buffer, n4);
        this.size = n3 + this.size;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return this.appendNull();
        }
        int n2 = stringBuilder.length();
        if (n2 <= 0) return this;
        int n3 = this.length();
        this.ensureCapacity(n3 + n2);
        stringBuilder.getChars(0, n2, this.buffer, n3);
        this.size = n2 + this.size;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(StringBuilder stringBuilder, int n2, int n3) {
        if (stringBuilder == null) {
            return this.appendNull();
        }
        if (n2 < 0) throw new StringIndexOutOfBoundsException("startIndex must be valid");
        if (n2 > stringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n3 < 0) throw new StringIndexOutOfBoundsException("length must be valid");
        if (n2 + n3 > stringBuilder.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n3 <= 0) return this;
        int n4 = this.length();
        this.ensureCapacity(n4 + n3);
        stringBuilder.getChars(n2, n2 + n3, this.buffer, n4);
        this.size = n3 + this.size;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return this.appendNull();
        }
        int n2 = strBuilder.length();
        if (n2 <= 0) return this;
        int n3 = this.length();
        this.ensureCapacity(n3 + n2);
        System.arraycopy(strBuilder.buffer, 0, this.buffer, n3, n2);
        this.size = n2 + this.size;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(StrBuilder strBuilder, int n2, int n3) {
        if (strBuilder == null) {
            return this.appendNull();
        }
        if (n2 < 0) throw new StringIndexOutOfBoundsException("startIndex must be valid");
        if (n2 > strBuilder.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (n3 < 0) throw new StringIndexOutOfBoundsException("length must be valid");
        if (n2 + n3 > strBuilder.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (n3 <= 0) return this;
        int n4 = this.length();
        this.ensureCapacity(n4 + n3);
        strBuilder.getChars(n2, n2 + n3, this.buffer, n4);
        this.size = n3 + this.size;
        return this;
    }

    public StrBuilder append(boolean bl2) {
        if (bl2) {
            this.ensureCapacity(4 + this.size);
            char[] cArray = this.buffer;
            int n2 = this.size;
            this.size = n2 + 1;
            cArray[n2] = 116;
            char[] cArray2 = this.buffer;
            int n3 = this.size;
            this.size = n3 + 1;
            cArray2[n3] = 114;
            char[] cArray3 = this.buffer;
            int n4 = this.size;
            this.size = n4 + 1;
            cArray3[n4] = 117;
            char[] cArray4 = this.buffer;
            int n5 = this.size;
            this.size = n5 + 1;
            cArray4[n5] = 101;
            return this;
        }
        this.ensureCapacity(5 + this.size);
        char[] cArray = this.buffer;
        int n6 = this.size;
        this.size = n6 + 1;
        cArray[n6] = 102;
        char[] cArray5 = this.buffer;
        int n7 = this.size;
        this.size = n7 + 1;
        cArray5[n7] = 97;
        char[] cArray6 = this.buffer;
        int n8 = this.size;
        this.size = n8 + 1;
        cArray6[n8] = 108;
        char[] cArray7 = this.buffer;
        int n9 = this.size;
        this.size = n9 + 1;
        cArray7[n9] = 115;
        char[] cArray8 = this.buffer;
        int n10 = this.size;
        this.size = n10 + 1;
        cArray8[n10] = 101;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(char[] cArray) {
        if (cArray == null) {
            return this.appendNull();
        }
        int n2 = cArray.length;
        if (n2 <= 0) return this;
        int n3 = this.length();
        this.ensureCapacity(n3 + n2);
        System.arraycopy(cArray, 0, this.buffer, n3, n2);
        this.size = n2 + this.size;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder append(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return this.appendNull();
        }
        if (n2 < 0) throw new StringIndexOutOfBoundsException("Invalid startIndex: " + n3);
        if (n2 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid startIndex: " + n3);
        }
        if (n3 < 0) throw new StringIndexOutOfBoundsException("Invalid length: " + n3);
        if (n2 + n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + n3);
        }
        if (n3 <= 0) return this;
        int n4 = this.length();
        this.ensureCapacity(n4 + n3);
        System.arraycopy(cArray, n2, this.buffer, n4, n3);
        this.size = n3 + this.size;
        return this;
    }

    public StrBuilder appendAll(Iterable<?> iterable) {
        if (iterable != null) {
            Iterator<?> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                this.append(iterator.next());
            }
        }
        return this;
    }

    public StrBuilder appendAll(Iterator<?> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.append(iterator.next());
            }
        }
        return this;
    }

    public <T> StrBuilder appendAll(T ... TArray) {
        if (TArray != null && TArray.length > 0) {
            int n2 = TArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(TArray[i2]);
            }
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadLeft(int n2, int n3, char c2) {
        return this.appendFixedWidthPadLeft(String.valueOf(n2), n3, c2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder appendFixedWidthPadLeft(Object object, int n2, char c2) {
        if (n2 > 0) {
            int n3;
            this.ensureCapacity(n2 + this.size);
            String string2 = object == null ? this.getNullText() : object.toString();
            if (string2 == null) {
                string2 = "";
            }
            if ((n3 = string2.length()) >= n2) {
                string2.getChars(n3 - n2, n3, this.buffer, this.size);
            } else {
                int n4 = n2 - n3;
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.buffer[i2 + this.size] = c2;
                }
                string2.getChars(0, n3, this.buffer, n4 + this.size);
            }
            this.size = n2 + this.size;
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadRight(int n2, int n3, char c2) {
        return this.appendFixedWidthPadRight(String.valueOf(n2), n3, c2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder appendFixedWidthPadRight(Object object, int n2, char c2) {
        if (n2 > 0) {
            int n3;
            this.ensureCapacity(n2 + this.size);
            String string2 = object == null ? this.getNullText() : object.toString();
            if (string2 == null) {
                string2 = "";
            }
            if ((n3 = string2.length()) >= n2) {
                string2.getChars(0, n2, this.buffer, this.size);
            } else {
                int n4 = n2 - n3;
                string2.getChars(0, n3, this.buffer, this.size);
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.buffer[i2 + (n3 + this.size)] = c2;
                }
            }
            this.size = n2 + this.size;
        }
        return this;
    }

    public StrBuilder appendNewLine() {
        if (this.newLine == null) {
            this.append(SystemUtils.LINE_SEPARATOR);
            return this;
        }
        return this.append(this.newLine);
    }

    public StrBuilder appendNull() {
        if (this.nullText == null) {
            return this;
        }
        return this.append(this.nullText);
    }

    public StrBuilder appendPadding(int n2, char c2) {
        if (n2 >= 0) {
            this.ensureCapacity(n2 + this.size);
            for (int i2 = 0; i2 < n2; ++i2) {
                char[] cArray = this.buffer;
                int n3 = this.size;
                this.size = n3 + 1;
                cArray[n3] = c2;
            }
        }
        return this;
    }

    public StrBuilder appendSeparator(char c2) {
        if (this.size() > 0) {
            this.append(c2);
        }
        return this;
    }

    public StrBuilder appendSeparator(char c2, char c3) {
        if (this.size() > 0) {
            this.append(c2);
            return this;
        }
        this.append(c3);
        return this;
    }

    public StrBuilder appendSeparator(char c2, int n2) {
        if (n2 > 0) {
            this.append(c2);
        }
        return this;
    }

    public StrBuilder appendSeparator(String string2) {
        return this.appendSeparator(string2, null);
    }

    public StrBuilder appendSeparator(String string2, int n2) {
        if (string2 != null && n2 > 0) {
            this.append(string2);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder appendSeparator(String string2, String string3) {
        String string4 = this.isEmpty() ? string3 : string2;
        if (string4 != null) {
            this.append(string4);
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Iterable<?> iterable, String string2) {
        if (iterable != null) {
            String string3 = ObjectUtils.toString(string2);
            Iterator<?> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                this.append(iterator.next());
                if (!iterator.hasNext()) continue;
                this.append(string3);
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Iterator<?> iterator, String string2) {
        if (iterator != null) {
            String string3 = ObjectUtils.toString(string2);
            while (iterator.hasNext()) {
                this.append(iterator.next());
                if (!iterator.hasNext()) continue;
                this.append(string3);
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Object[] objectArray, String string2) {
        if (objectArray != null && objectArray.length > 0) {
            String string3 = ObjectUtils.toString(string2);
            this.append(objectArray[0]);
            for (int i2 = 1; i2 < objectArray.length; ++i2) {
                this.append(string3);
                this.append(objectArray[i2]);
            }
        }
        return this;
    }

    public StrBuilder appendln(char c2) {
        return ((StrBuilder)this.append(c2)).appendNewLine();
    }

    public StrBuilder appendln(double d2) {
        return this.append(d2).appendNewLine();
    }

    public StrBuilder appendln(float f2) {
        return this.append(f2).appendNewLine();
    }

    public StrBuilder appendln(int n2) {
        return this.append(n2).appendNewLine();
    }

    public StrBuilder appendln(long l2) {
        return this.append(l2).appendNewLine();
    }

    public StrBuilder appendln(Object object) {
        return this.append(object).appendNewLine();
    }

    public StrBuilder appendln(String string2) {
        return this.append(string2).appendNewLine();
    }

    public StrBuilder appendln(String string2, int n2, int n3) {
        return this.append(string2, n2, n3).appendNewLine();
    }

    public StrBuilder appendln(String string2, Object ... objectArray) {
        return this.append(string2, objectArray).appendNewLine();
    }

    public StrBuilder appendln(StringBuffer stringBuffer) {
        return this.append(stringBuffer).appendNewLine();
    }

    public StrBuilder appendln(StringBuffer stringBuffer, int n2, int n3) {
        return this.append(stringBuffer, n2, n3).appendNewLine();
    }

    public StrBuilder appendln(StringBuilder stringBuilder) {
        return this.append(stringBuilder).appendNewLine();
    }

    public StrBuilder appendln(StringBuilder stringBuilder, int n2, int n3) {
        return this.append(stringBuilder, n2, n3).appendNewLine();
    }

    public StrBuilder appendln(StrBuilder strBuilder) {
        return this.append(strBuilder).appendNewLine();
    }

    public StrBuilder appendln(StrBuilder strBuilder, int n2, int n3) {
        return this.append(strBuilder, n2, n3).appendNewLine();
    }

    public StrBuilder appendln(boolean bl2) {
        return this.append(bl2).appendNewLine();
    }

    public StrBuilder appendln(char[] cArray) {
        return this.append(cArray).appendNewLine();
    }

    public StrBuilder appendln(char[] cArray, int n2, int n3) {
        return this.append(cArray, n2, n3).appendNewLine();
    }

    public Reader asReader() {
        return new StrBuilderReader();
    }

    public StrTokenizer asTokenizer() {
        return new StrBuilderTokenizer();
    }

    public Writer asWriter() {
        return new StrBuilderWriter();
    }

    @Override
    public String build() {
        return this.toString();
    }

    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public char charAt(int n2) {
        if (n2 < 0 || n2 >= this.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return this.buffer[n2];
    }

    public StrBuilder clear() {
        this.size = 0;
        return this;
    }

    public boolean contains(char c2) {
        char[] cArray = this.buffer;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (cArray[i2] != c2) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string2) {
        int n2 = this.indexOf(string2, 0);
        boolean bl2 = false;
        if (n2 >= 0) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean contains(StrMatcher strMatcher) {
        int n2 = this.indexOf(strMatcher, 0);
        boolean bl2 = false;
        if (n2 >= 0) {
            bl2 = true;
        }
        return bl2;
    }

    public StrBuilder delete(int n2, int n3) {
        int n4 = this.validateRange(n2, n3);
        int n5 = n4 - n2;
        if (n5 > 0) {
            this.deleteImpl(n2, n4, n5);
        }
        return this;
    }

    public StrBuilder deleteAll(char c2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.buffer[i2] != c2) continue;
            int n2 = i2;
            while (++i2 < this.size && this.buffer[i2] == c2) {
            }
            int n3 = i2 - n2;
            this.deleteImpl(n2, i2, n3);
            i2 -= n3;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder deleteAll(String string2) {
        int n2 = string2 == null ? 0 : string2.length();
        if (n2 > 0) {
            int n3 = this.indexOf(string2, 0);
            while (n3 >= 0) {
                this.deleteImpl(n3, n3 + n2, n2);
                n3 = this.indexOf(string2, n3);
            }
        }
        return this;
    }

    public StrBuilder deleteAll(StrMatcher strMatcher) {
        return this.replace(strMatcher, null, 0, this.size, -1);
    }

    public StrBuilder deleteCharAt(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        this.deleteImpl(n2, n2 + 1, 1);
        return this;
    }

    public StrBuilder deleteFirst(char c2) {
        int n2 = 0;
        while (true) {
            block4: {
                block3: {
                    if (n2 >= this.size) break block3;
                    if (this.buffer[n2] != c2) break block4;
                    this.deleteImpl(n2, n2 + 1, 1);
                }
                return this;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder deleteFirst(String string2) {
        int n2;
        int n3 = string2 == null ? 0 : string2.length();
        if (n3 > 0 && (n2 = this.indexOf(string2, 0)) >= 0) {
            this.deleteImpl(n2, n2 + n3, n3);
        }
        return this;
    }

    public StrBuilder deleteFirst(StrMatcher strMatcher) {
        return this.replace(strMatcher, null, 0, this.size, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean endsWith(String string2) {
        if (string2 != null) {
            int n2 = string2.length();
            if (n2 == 0) {
                return true;
            }
            if (n2 <= this.size) {
                int n3 = this.size - n2;
                int n4 = 0;
                while (true) {
                    if (n4 >= n2) {
                        return true;
                    }
                    if (this.buffer[n3] != string2.charAt(n4)) break;
                    ++n4;
                    ++n3;
                }
            }
        }
        return false;
    }

    public StrBuilder ensureCapacity(int n2) {
        if (n2 > this.buffer.length) {
            char[] cArray = this.buffer;
            this.buffer = new char[n2 * 2];
            System.arraycopy(cArray, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof StrBuilder) {
            return this.equals((StrBuilder)object);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(StrBuilder strBuilder) {
        if (this != strBuilder) {
            if (this.size != strBuilder.size) {
                return false;
            }
            char[] cArray = this.buffer;
            char[] cArray2 = strBuilder.buffer;
            for (int i2 = -1 + this.size; i2 >= 0; --i2) {
                if (cArray[i2] == cArray2[i2]) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equalsIgnoreCase(StrBuilder strBuilder) {
        if (this != strBuilder) {
            if (this.size != strBuilder.size) {
                return false;
            }
            char[] cArray = this.buffer;
            char[] cArray2 = strBuilder.buffer;
            for (int i2 = -1 + this.size; i2 >= 0; --i2) {
                char c2 = cArray[i2];
                char c3 = cArray2[i2];
                if (c2 == c3 || Character.toUpperCase(c2) == Character.toUpperCase(c3)) continue;
                return false;
            }
        }
        return true;
    }

    public void getChars(int n2, int n3, char[] cArray, int n4) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0 || n3 > this.length()) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        System.arraycopy(this.buffer, n2, cArray, n4, n3 - n2);
    }

    public char[] getChars(char[] cArray) {
        int n2 = this.length();
        if (cArray == null || cArray.length < n2) {
            cArray = new char[n2];
        }
        System.arraycopy(this.buffer, 0, cArray, 0, n2);
        return cArray;
    }

    public String getNewLineText() {
        return this.newLine;
    }

    public String getNullText() {
        return this.nullText;
    }

    public int hashCode() {
        char[] cArray = this.buffer;
        int n2 = 0;
        for (int i2 = -1 + this.size; i2 >= 0; --i2) {
            n2 = n2 * 31 + cArray[i2];
        }
        return n2;
    }

    public int indexOf(char c2) {
        return this.indexOf(c2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOf(char c2, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.size) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n3 = n2;
        while (n3 < this.size) {
            if (cArray[n3] == c2) return n3;
            ++n3;
        }
        return -1;
    }

    public int indexOf(String string2) {
        return this.indexOf(string2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOf(String string2, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (string2 == null) return -1;
        if (n2 >= this.size) {
            return -1;
        }
        int n3 = string2.length();
        if (n3 == 1) {
            return this.indexOf(string2.charAt(0), n2);
        }
        if (n3 == 0) return n2;
        if (n3 > this.size) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n4 = 1 + (this.size - n3);
        int n5 = n2;
        block0: while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                if (string2.charAt(n6) != cArray[n5 + n6]) {
                    ++n5;
                    continue block0;
                }
                ++n6;
            }
            return n5;
        }
        return -1;
    }

    public int indexOf(StrMatcher strMatcher) {
        return this.indexOf(strMatcher, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indexOf(StrMatcher strMatcher, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (strMatcher == null) return -1;
        if (n2 >= this.size) {
            return -1;
        }
        int n3 = this.size;
        char[] cArray = this.buffer;
        int n4 = n2;
        while (n4 < n3) {
            if (strMatcher.isMatch(cArray, n4, n2, n3) > 0) return n4;
            ++n4;
        }
        return -1;
    }

    public StrBuilder insert(int n2, char c2) {
        this.validateIndex(n2);
        this.ensureCapacity(1 + this.size);
        System.arraycopy(this.buffer, n2, this.buffer, n2 + 1, this.size - n2);
        this.buffer[n2] = c2;
        this.size = 1 + this.size;
        return this;
    }

    public StrBuilder insert(int n2, double d2) {
        return this.insert(n2, String.valueOf(d2));
    }

    public StrBuilder insert(int n2, float f2) {
        return this.insert(n2, String.valueOf(f2));
    }

    public StrBuilder insert(int n2, int n3) {
        return this.insert(n2, String.valueOf(n3));
    }

    public StrBuilder insert(int n2, long l2) {
        return this.insert(n2, String.valueOf(l2));
    }

    public StrBuilder insert(int n2, Object object) {
        if (object == null) {
            return this.insert(n2, this.nullText);
        }
        return this.insert(n2, object.toString());
    }

    public StrBuilder insert(int n2, String string2) {
        int n3;
        this.validateIndex(n2);
        if (string2 == null) {
            string2 = this.nullText;
        }
        if (string2 != null && (n3 = string2.length()) > 0) {
            int n4 = n3 + this.size;
            this.ensureCapacity(n4);
            System.arraycopy(this.buffer, n2, this.buffer, n2 + n3, this.size - n2);
            this.size = n4;
            string2.getChars(0, n3, this.buffer, n2);
        }
        return this;
    }

    public StrBuilder insert(int n2, boolean bl2) {
        this.validateIndex(n2);
        if (bl2) {
            this.ensureCapacity(4 + this.size);
            System.arraycopy(this.buffer, n2, this.buffer, n2 + 4, this.size - n2);
            char[] cArray = this.buffer;
            int n3 = n2 + 1;
            cArray[n2] = 116;
            char[] cArray2 = this.buffer;
            int n4 = n3 + 1;
            cArray2[n3] = 114;
            char[] cArray3 = this.buffer;
            int n5 = n4 + 1;
            cArray3[n4] = 117;
            this.buffer[n5] = 101;
            this.size = 4 + this.size;
            return this;
        }
        this.ensureCapacity(5 + this.size);
        System.arraycopy(this.buffer, n2, this.buffer, n2 + 5, this.size - n2);
        char[] cArray = this.buffer;
        int n6 = n2 + 1;
        cArray[n2] = 102;
        char[] cArray4 = this.buffer;
        int n7 = n6 + 1;
        cArray4[n6] = 97;
        char[] cArray5 = this.buffer;
        int n8 = n7 + 1;
        cArray5[n7] = 108;
        char[] cArray6 = this.buffer;
        int n9 = n8 + 1;
        cArray6[n8] = 115;
        this.buffer[n9] = 101;
        this.size = 5 + this.size;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder insert(int n2, char[] cArray) {
        this.validateIndex(n2);
        if (cArray == null) {
            return this.insert(n2, this.nullText);
        }
        int n3 = cArray.length;
        if (n3 <= 0) return this;
        this.ensureCapacity(n3 + this.size);
        System.arraycopy(this.buffer, n2, this.buffer, n2 + n3, this.size - n2);
        System.arraycopy(cArray, 0, this.buffer, n2, n3);
        this.size = n3 + this.size;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder insert(int n2, char[] cArray, int n3, int n4) {
        this.validateIndex(n2);
        if (cArray == null) {
            return this.insert(n2, this.nullText);
        }
        if (n3 < 0) throw new StringIndexOutOfBoundsException("Invalid offset: " + n3);
        if (n3 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid offset: " + n3);
        }
        if (n4 < 0) throw new StringIndexOutOfBoundsException("Invalid length: " + n4);
        if (n3 + n4 > cArray.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + n4);
        }
        if (n4 <= 0) return this;
        this.ensureCapacity(n4 + this.size);
        System.arraycopy(this.buffer, n2, this.buffer, n2 + n4, this.size - n2);
        System.arraycopy(cArray, n3, this.buffer, n2, n4);
        this.size = n4 + this.size;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public int lastIndexOf(char c2) {
        return this.lastIndexOf(c2, -1 + this.size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int lastIndexOf(char c2, int n2) {
        if (n2 >= this.size) {
            n2 = -1 + this.size;
        }
        if (n2 < 0) {
            return -1;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (this.buffer[n3] == c2) return n3;
            --n3;
        }
        return -1;
    }

    public int lastIndexOf(String string2) {
        return this.lastIndexOf(string2, -1 + this.size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int lastIndexOf(String string2, int n2) {
        if (n2 >= this.size) {
            n2 = -1 + this.size;
        }
        if (string2 == null) return -1;
        if (n2 < 0) {
            return -1;
        }
        int n3 = string2.length();
        if (n3 > 0 && n3 <= this.size) {
            if (n3 == 1) {
                return this.lastIndexOf(string2.charAt(0), n2);
            }
            int n4 = 1 + (n2 - n3);
            block0: while (true) {
                if (n4 < 0) return -1;
                int n5 = 0;
                while (n5 < n3) {
                    if (string2.charAt(n5) != this.buffer[n4 + n5]) {
                        --n4;
                        continue block0;
                    }
                    ++n5;
                }
                return n4;
            }
        }
        if (n3 != 0) return -1;
        return n2;
    }

    public int lastIndexOf(StrMatcher strMatcher) {
        return this.lastIndexOf(strMatcher, this.size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int lastIndexOf(StrMatcher strMatcher, int n2) {
        if (n2 >= this.size) {
            n2 = -1 + this.size;
        }
        if (strMatcher == null) return -1;
        if (n2 < 0) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n3 = n2 + 1;
        int n4 = n2;
        while (n4 >= 0) {
            if (strMatcher.isMatch(cArray, n4, 0, n3) > 0) return n4;
            --n4;
        }
        return -1;
    }

    public String leftString(int n2) {
        if (n2 <= 0) {
            return "";
        }
        if (n2 >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, 0, n2);
    }

    @Override
    public int length() {
        return this.size;
    }

    public String midString(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 <= 0 || n2 >= this.size) {
            return "";
        }
        if (this.size <= n2 + n3) {
            return new String(this.buffer, n2, this.size - n2);
        }
        return new String(this.buffer, n2, n3);
    }

    public StrBuilder minimizeCapacity() {
        if (this.buffer.length > this.length()) {
            char[] cArray = this.buffer;
            this.buffer = new char[this.length()];
            System.arraycopy(cArray, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder replace(int n2, int n3, String string2) {
        int n4 = this.validateRange(n2, n3);
        int n5 = string2 == null ? 0 : string2.length();
        this.replaceImpl(n2, n4, n4 - n2, string2, n5);
        return this;
    }

    public StrBuilder replace(StrMatcher strMatcher, String string2, int n2, int n3, int n4) {
        return this.replaceImpl(strMatcher, string2, n2, this.validateRange(n2, n3), n4);
    }

    public StrBuilder replaceAll(char c2, char c3) {
        if (c2 != c3) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.buffer[i2] != c2) continue;
                this.buffer[i2] = c3;
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder replaceAll(String string2, String string3) {
        int n2 = string2 == null ? 0 : string2.length();
        if (n2 > 0) {
            int n3 = string3 == null ? 0 : string3.length();
            int n4 = this.indexOf(string2, 0);
            while (n4 >= 0) {
                this.replaceImpl(n4, n4 + n2, n2, string3, n3);
                n4 = this.indexOf(string2, n4 + n3);
            }
        }
        return this;
    }

    public StrBuilder replaceAll(StrMatcher strMatcher, String string2) {
        return this.replace(strMatcher, string2, 0, this.size, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StrBuilder replaceFirst(char c2, char c3) {
        if (c2 == c3) return this;
        int n2 = 0;
        while (n2 < this.size) {
            if (this.buffer[n2] == c2) {
                this.buffer[n2] = c3;
                return this;
            }
            ++n2;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder replaceFirst(String string2, String string3) {
        int n2;
        int n3 = string2 == null ? 0 : string2.length();
        if (n3 > 0 && (n2 = this.indexOf(string2, 0)) >= 0) {
            int n4 = 0;
            if (string3 != null) {
                n4 = string3.length();
            }
            this.replaceImpl(n2, n2 + n3, n3, string3, n4);
        }
        return this;
    }

    public StrBuilder replaceFirst(StrMatcher strMatcher, String string2) {
        return this.replace(strMatcher, string2, 0, this.size, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder reverse() {
        if (this.size != 0) {
            int n2 = this.size / 2;
            char[] cArray = this.buffer;
            int n3 = -1 + this.size;
            for (int i2 = 0; i2 < n2; ++i2, --n3) {
                char c2 = cArray[i2];
                cArray[i2] = cArray[n3];
                cArray[n3] = c2;
            }
        }
        return this;
    }

    public String rightString(int n2) {
        if (n2 <= 0) {
            return "";
        }
        if (n2 >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, this.size - n2, n2);
    }

    public StrBuilder setCharAt(int n2, char c2) {
        if (n2 < 0 || n2 >= this.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        this.buffer[n2] = c2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder setLength(int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 < this.size) {
            this.size = n2;
            return this;
        } else {
            if (n2 <= this.size) return this;
            this.ensureCapacity(n2);
            int n3 = this.size;
            this.size = n2;
            for (int i2 = n3; i2 < n2; ++i2) {
                this.buffer[i2] = '\u0000';
            }
        }
        return this;
    }

    public StrBuilder setNewLineText(String string2) {
        this.newLine = string2;
        return this;
    }

    public StrBuilder setNullText(String string2) {
        if (string2 != null && string2.isEmpty()) {
            string2 = null;
        }
        this.nullText = string2;
        return this;
    }

    public int size() {
        return this.size;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean startsWith(String string2) {
        if (string2 != null) {
            int n2 = string2.length();
            if (n2 == 0) {
                return true;
            }
            if (n2 <= this.size) {
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        return true;
                    }
                    if (this.buffer[n3] != string2.charAt(n3)) break;
                    ++n3;
                }
            }
        }
        return false;
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.size) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n3 - n2);
        }
        return this.substring(n2, n3);
    }

    public String substring(int n2) {
        return this.substring(n2, this.size);
    }

    public String substring(int n2, int n3) {
        int n4 = this.validateRange(n2, n3);
        return new String(this.buffer, n2, n4 - n2);
    }

    public char[] toCharArray() {
        if (this.size == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[this.size];
        System.arraycopy(this.buffer, 0, cArray, 0, this.size);
        return cArray;
    }

    public char[] toCharArray(int n2, int n3) {
        int n4 = this.validateRange(n2, n3) - n2;
        if (n4 == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[n4];
        System.arraycopy(this.buffer, n2, cArray, 0, n4);
        return cArray;
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.size);
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.size).append(this.buffer, 0, this.size);
    }

    public StringBuilder toStringBuilder() {
        return new StringBuilder(this.size).append(this.buffer, 0, this.size);
    }

    /*
     * Enabled aggressive block sorting
     */
    public StrBuilder trim() {
        int n2;
        block7: {
            block6: {
                if (this.size == 0) break block6;
                int n3 = this.size;
                char[] cArray = this.buffer;
                for (n2 = 0; n2 < n3 && cArray[n2] <= ' '; ++n2) {
                }
                while (n2 < n3 && cArray[n3 - 1] <= ' ') {
                    --n3;
                }
                if (n3 < this.size) {
                    this.delete(n3, this.size);
                }
                if (n2 > 0) break block7;
            }
            return this;
        }
        this.delete(0, n2);
        return this;
    }

    protected void validateIndex(int n2) {
        if (n2 < 0 || n2 > this.size) {
            throw new StringIndexOutOfBoundsException(n2);
        }
    }

    protected int validateRange(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.size) {
            n3 = this.size;
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        return n3;
    }

    class StrBuilderReader
    extends Reader {
        private int mark;
        private int pos;

        StrBuilderReader() {
        }

        @Override
        public void close() {
        }

        @Override
        public void mark(int n2) {
            this.mark = this.pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() {
            if (!this.ready()) {
                return -1;
            }
            StrBuilder strBuilder = StrBuilder.this;
            int n2 = this.pos;
            this.pos = n2 + 1;
            return strBuilder.charAt(n2);
        }

        @Override
        public int read(char[] cArray, int n2, int n3) {
            if (n2 < 0 || n3 < 0 || n2 > cArray.length || n2 + n3 > cArray.length || n2 + n3 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (this.pos >= StrBuilder.this.size()) {
                return -1;
            }
            if (n3 + this.pos > StrBuilder.this.size()) {
                n3 = StrBuilder.this.size() - this.pos;
            }
            StrBuilder.this.getChars(this.pos, n3 + this.pos, cArray, n2);
            this.pos = n3 + this.pos;
            return n3;
        }

        @Override
        public boolean ready() {
            return this.pos < StrBuilder.this.size();
        }

        @Override
        public void reset() {
            this.pos = this.mark;
        }

        @Override
        public long skip(long l2) {
            if (l2 + (long)this.pos > (long)StrBuilder.this.size()) {
                l2 = StrBuilder.this.size() - this.pos;
            }
            if (l2 < 0L) {
                return 0L;
            }
            this.pos = (int)(l2 + (long)this.pos);
            return l2;
        }
    }

    class StrBuilderTokenizer
    extends StrTokenizer {
        StrBuilderTokenizer() {
        }

        @Override
        public String getContent() {
            String string2 = super.getContent();
            if (string2 == null) {
                string2 = StrBuilder.this.toString();
            }
            return string2;
        }

        @Override
        protected List<String> tokenize(char[] cArray, int n2, int n3) {
            if (cArray == null) {
                return super.tokenize(StrBuilder.this.buffer, 0, StrBuilder.this.size());
            }
            return super.tokenize(cArray, n2, n3);
        }
    }

    class StrBuilderWriter
    extends Writer {
        StrBuilderWriter() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(int n2) {
            StrBuilder.this.append((char)n2);
        }

        @Override
        public void write(String string2) {
            StrBuilder.this.append(string2);
        }

        @Override
        public void write(String string2, int n2, int n3) {
            StrBuilder.this.append(string2, n2, n3);
        }

        @Override
        public void write(char[] cArray) {
            StrBuilder.this.append(cArray);
        }

        @Override
        public void write(char[] cArray, int n2, int n3) {
            StrBuilder.this.append(cArray, n2, n3);
        }
    }
}

