/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.Formattable;
import java.util.Formatter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;

public class FormattableUtils {
    private static final String SIMPLEST_FORMAT = "%s";

    public static Formatter append(CharSequence charSequence, Formatter formatter, int n2, int n3, int n4) {
        return FormattableUtils.append(charSequence, formatter, n2, n3, n4, ' ', null);
    }

    public static Formatter append(CharSequence charSequence, Formatter formatter, int n2, int n3, int n4, char c2) {
        return FormattableUtils.append(charSequence, formatter, n2, n3, n4, c2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Formatter append(CharSequence charSequence, Formatter formatter, int n2, int n3, int n4, char c2, CharSequence charSequence2) {
        boolean bl2 = charSequence2 == null || n4 < 0 || charSequence2.length() <= n4;
        Object[] objectArray = new Object[]{charSequence2, n4};
        Validate.isTrue(bl2, "Specified ellipsis '%1$s' exceeds precision of %2$s", objectArray);
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        if (n4 >= 0 && n4 < charSequence.length()) {
            CharSequence charSequence3 = ObjectUtils.defaultIfNull(charSequence2, "");
            stringBuilder.replace(n4 - charSequence3.length(), charSequence.length(), charSequence3.toString());
        }
        boolean bl3 = (n2 & 1) == 1;
        int n5 = stringBuilder.length();
        while (true) {
            if (n5 >= n3) {
                formatter.format(stringBuilder.toString(), new Object[0]);
                return formatter;
            }
            int n6 = bl3 ? n5 : 0;
            stringBuilder.insert(n6, c2);
            ++n5;
        }
    }

    public static Formatter append(CharSequence charSequence, Formatter formatter, int n2, int n3, int n4, CharSequence charSequence2) {
        return FormattableUtils.append(charSequence, formatter, n2, n3, n4, ' ', charSequence2);
    }

    public static String toString(Formattable formattable) {
        return String.format(SIMPLEST_FORMAT, formattable);
    }
}

