/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.FormatFactory;
import org.apache.commons.lang3.text.StrMatcher;

public class ExtendedMessageFormat
extends MessageFormat {
    private static final String DUMMY_PATTERN = "";
    private static final char END_FE = '}';
    private static final String ESCAPED_QUOTE = "''";
    private static final int HASH_SEED = 31;
    private static final char QUOTE = '\'';
    private static final char START_FE = '{';
    private static final char START_FMT = ',';
    private static final long serialVersionUID = -2362048321261811743L;
    private final Map<String, ? extends FormatFactory> registry;
    private String toPattern;

    public ExtendedMessageFormat(String string2) {
        this(string2, Locale.getDefault());
    }

    public ExtendedMessageFormat(String string2, Locale locale) {
        this(string2, locale, null);
    }

    public ExtendedMessageFormat(String string2, Locale locale, Map<String, ? extends FormatFactory> map) {
        super(DUMMY_PATTERN);
        this.setLocale(locale);
        this.registry = map;
        this.applyPattern(string2);
    }

    public ExtendedMessageFormat(String string2, Map<String, ? extends FormatFactory> map) {
        this(string2, Locale.getDefault(), map);
    }

    /*
     * Unable to fully structure code
     */
    private StringBuilder appendQuotedString(String var1_1, ParsePosition var2_2, StringBuilder var3_3, boolean var4_4) {
        var5_5 = var2_2.getIndex();
        var6_6 = var1_1.toCharArray();
        if (var4_4 && var6_6[var5_5] == '\'') {
            this.next(var2_2);
            if (var3_3 == null) {
                return null;
            }
            return var3_3.append('\'');
        }
        var7_7 = var5_5;
        block4: for (var8_8 = var2_2.getIndex(); var8_8 < var1_1.length(); ++var8_8) {
            if (var4_4 && var1_1.substring(var8_8).startsWith("''")) {
                var3_3.append(var6_6, var7_7, var2_2.getIndex() - var7_7).append('\'');
                var2_2.setIndex(var8_8 + "''".length());
                var7_7 = var2_2.getIndex();
lbl17:
                // 2 sources

                continue block4;
            }
            switch (var6_6[var2_2.getIndex()]) {
                default: {
                    this.next(var2_2);
                    ** continue;
                }
                case '\'': 
            }
            this.next(var2_2);
            if (var3_3 == null) ** continue;
            return var3_3.append(var6_6, var7_7, var2_2.getIndex() - var7_7);
        }
        throw new IllegalArgumentException("Unterminated quoted string at position " + var5_5);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private boolean containsElements(Collection<?> collection) {
        if (collection == null) return false;
        if (collection.isEmpty()) {
            return false;
        }
        Iterator<?> iterator = collection.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (iterator.next() == null);
        return true;
    }

    private Format getFormat(String string2) {
        if (this.registry != null) {
            FormatFactory formatFactory;
            String string3 = string2;
            int n2 = string2.indexOf(44);
            String string4 = null;
            if (n2 > 0) {
                string3 = string2.substring(0, n2).trim();
                string4 = string2.substring(n2 + 1).trim();
            }
            if ((formatFactory = this.registry.get(string3)) != null) {
                return formatFactory.getFormat(string3, string4, this.getLocale());
            }
        }
        return null;
    }

    private void getQuotedString(String string2, ParsePosition parsePosition, boolean bl2) {
        this.appendQuotedString(string2, parsePosition, null, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String insertFormats(String string2, ArrayList<String> arrayList) {
        if (!this.containsElements(arrayList)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * string2.length());
        ParsePosition parsePosition = new ParsePosition(0);
        int n2 = -1;
        int n3 = 0;
        block5: while (parsePosition.getIndex() < string2.length()) {
            char c2 = string2.charAt(parsePosition.getIndex());
            switch (c2) {
                default: {
                    break;
                }
                case '\'': {
                    this.appendQuotedString(string2, parsePosition, stringBuilder, false);
                    continue block5;
                }
                case '{': {
                    String string3;
                    stringBuilder.append('{').append(this.readArgumentIndex(string2, this.next(parsePosition)));
                    if (++n3 != 1 || (string3 = arrayList.get(++n2)) == null) continue block5;
                    stringBuilder.append(',').append(string3);
                    continue block5;
                }
                case '}': {
                    --n3;
                }
            }
            stringBuilder.append(c2);
            this.next(parsePosition);
        }
        return stringBuilder.toString();
    }

    private ParsePosition next(ParsePosition parsePosition) {
        parsePosition.setIndex(1 + parsePosition.getIndex());
        return parsePosition;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseFormatDescription(String string2, ParsePosition parsePosition) {
        int n2 = parsePosition.getIndex();
        this.seekNonWs(string2, parsePosition);
        int n3 = parsePosition.getIndex();
        int n4 = 1;
        while (true) {
            if (parsePosition.getIndex() >= string2.length()) {
                throw new IllegalArgumentException("Unterminated format element at position " + n2);
            }
            switch (string2.charAt(parsePosition.getIndex())) {
                case '{': {
                    ++n4;
                    break;
                }
                case '}': {
                    if (--n4 != 0) break;
                    return string2.substring(n3, parsePosition.getIndex());
                }
                case '\'': {
                    this.getQuotedString(string2, parsePosition, false);
                    break;
                }
            }
            this.next(parsePosition);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int readArgumentIndex(String var1_1, ParsePosition var2_2) {
        var3_3 = var2_2.getIndex();
        this.seekNonWs(var1_1, var2_2);
        var4_4 = new StringBuilder();
        var5_5 = false;
        block2: while (!var5_5 && var2_2.getIndex() < var1_1.length()) {
            var6_6 = var1_1.charAt(var2_2.getIndex());
            if (Character.isWhitespace(var6_6)) {
                this.seekNonWs(var1_1, var2_2);
                var6_6 = var1_1.charAt(var2_2.getIndex());
                if (var6_6 != ',' && var6_6 != '}') {
                    var5_5 = true;
lbl12:
                    // 2 sources

                    while (true) {
                        this.next(var2_2);
                        continue block2;
                        break;
                    }
                }
            }
            if ((var6_6 == ',' || var6_6 == '}') && var4_4.length() > 0) {
                try {
                    var10_8 = Integer.parseInt(var4_4.toString());
                    return var10_8;
                }
                catch (NumberFormatException var9_7) {
                    // empty catch block
                }
            }
            if (!Character.isDigit(var6_6)) {
                var5_5 = true;
lbl24:
                // 2 sources

                while (true) {
                    var4_4.append(var6_6);
                    ** continue;
                    break;
                }
            }
            var5_5 = false;
            ** continue;
        }
        if (var5_5) {
            throw new IllegalArgumentException("Invalid format argument index at position " + var3_3 + ": " + var1_1.substring(var3_3, var2_2.getIndex()));
        }
        throw new IllegalArgumentException("Unterminated format element at position " + var3_3);
    }

    private void seekNonWs(String string2, ParsePosition parsePosition) {
        int n2;
        char[] cArray = string2.toCharArray();
        do {
            n2 = StrMatcher.splitMatcher().isMatch(cArray, parsePosition.getIndex());
            parsePosition.setIndex(n2 + parsePosition.getIndex());
        } while (n2 > 0 && parsePosition.getIndex() < string2.length());
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    public final void applyPattern(String string2) {
        if (this.registry == null) {
            super.applyPattern(string2);
            this.toPattern = super.toPattern();
            return;
        }
        ArrayList<Format> arrayList = new ArrayList<Format>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        ParsePosition parsePosition = new ParsePosition(0);
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        block4: while (parsePosition.getIndex() < string2.length()) {
            switch (cArray[parsePosition.getIndex()]) {
                default: {
                    break;
                }
                case '\'': {
                    this.appendQuotedString(string2, parsePosition, stringBuilder, true);
                    continue block4;
                }
                case '{': {
                    ++n2;
                    this.seekNonWs(string2, parsePosition);
                    int n3 = parsePosition.getIndex();
                    int n4 = this.readArgumentIndex(string2, this.next(parsePosition));
                    stringBuilder.append('{').append(n4);
                    this.seekNonWs(string2, parsePosition);
                    char c2 = cArray[parsePosition.getIndex()];
                    Format format = null;
                    String string3 = null;
                    if (c2 == ',' && (format = this.getFormat(string3 = this.parseFormatDescription(string2, this.next(parsePosition)))) == null) {
                        stringBuilder.append(',').append(string3);
                    }
                    arrayList.add(format);
                    if (format == null) {
                        string3 = null;
                    }
                    arrayList2.add(string3);
                    boolean bl2 = arrayList.size() == n2;
                    Validate.isTrue(bl2);
                    boolean bl3 = arrayList2.size() == n2;
                    Validate.isTrue(bl3);
                    if (cArray[parsePosition.getIndex()] == '}') break;
                    throw new IllegalArgumentException("Unreadable format element at position " + n3);
                }
            }
            stringBuilder.append(cArray[parsePosition.getIndex()]);
            this.next(parsePosition);
        }
        super.applyPattern(stringBuilder.toString());
        this.toPattern = this.insertFormats(super.toPattern(), arrayList2);
        if (!this.containsElements(arrayList)) return;
        Format[] formatArray = this.getFormats();
        int n5 = 0;
        Iterator iterator = arrayList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                super.setFormats(formatArray);
                return;
            }
            Format format = (Format)iterator.next();
            if (format != null) {
                formatArray[n5] = format;
            }
            ++n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        block8: {
            block7: {
                if (object == this) break block7;
                if (object == null) {
                    return false;
                }
                if (!super.equals(object)) {
                    return false;
                }
                if (ObjectUtils.notEqual(this.getClass(), object.getClass())) {
                    return false;
                }
                ExtendedMessageFormat extendedMessageFormat = (ExtendedMessageFormat)object;
                if (ObjectUtils.notEqual(this.toPattern, extendedMessageFormat.toPattern)) {
                    return false;
                }
                if (ObjectUtils.notEqual(this.registry, extendedMessageFormat.registry)) break block8;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * super.hashCode() + ObjectUtils.hashCode(this.registry)) + ObjectUtils.hashCode(this.toPattern);
    }

    @Override
    public void setFormat(int n2, Format format) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatByArgumentIndex(int n2, Format format) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormats(Format[] formatArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormatsByArgumentIndex(Format[] formatArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toPattern() {
        return this.toPattern;
    }
}

