/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.reflect.Typed;

public class TypeUtils {
    public static final WildcardType WILDCARD_ALL = TypeUtils.wildcardType().withUpperBounds(new Type[]{Object.class}).build();

    private static StringBuilder appendAllTo(StringBuilder stringBuilder, String string2, Type ... typeArray) {
        Validate.notEmpty(Validate.noNullElements(typeArray));
        if (typeArray.length > 0) {
            stringBuilder.append(TypeUtils.toString(typeArray[0]));
            for (int i2 = 1; i2 < typeArray.length; ++i2) {
                stringBuilder.append(string2).append(TypeUtils.toString(typeArray[i2]));
            }
        }
        return stringBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String classToString(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        if (clazz.getEnclosingClass() != null) {
            stringBuilder.append(TypeUtils.classToString(clazz.getEnclosingClass())).append('.').append(clazz.getSimpleName());
        } else {
            stringBuilder.append(clazz.getName());
        }
        if (clazz.getTypeParameters().length > 0) {
            stringBuilder.append('<');
            TypeUtils.appendAllTo(stringBuilder, ", ", clazz.getTypeParameters());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsTypeVariables(Type type) {
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof Class) {
            if (((Class)type).getTypeParameters().length > 0) return true;
            return false;
        }
        if (type instanceof ParameterizedType) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            int n2 = typeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (TypeUtils.containsTypeVariables(typeArray[n3])) return true;
                ++n3;
            }
            return false;
        }
        if (!(type instanceof WildcardType)) return false;
        WildcardType wildcardType = (WildcardType)type;
        if (TypeUtils.containsTypeVariables(TypeUtils.getImplicitLowerBounds(wildcardType)[0])) return true;
        boolean bl2 = TypeUtils.containsTypeVariables(TypeUtils.getImplicitUpperBounds(wildcardType)[0]);
        boolean bl3 = false;
        if (!bl2) return bl3;
        return true;
    }

    public static Map<TypeVariable<?>, Type> determineTypeArguments(Class<?> clazz, ParameterizedType parameterizedType) {
        Validate.notNull(clazz, "cls is null", new Object[0]);
        Validate.notNull(parameterizedType, "superType is null", new Object[0]);
        Class<?> clazz2 = TypeUtils.getRawType(parameterizedType);
        if (!TypeUtils.isAssignable(clazz, clazz2)) {
            return null;
        }
        if (clazz.equals(clazz2)) {
            return TypeUtils.getTypeArguments(parameterizedType, clazz2, null);
        }
        Type type = TypeUtils.getClosestParentType(clazz, clazz2);
        if (type instanceof Class) {
            return TypeUtils.determineTypeArguments((Class)type, parameterizedType);
        }
        ParameterizedType parameterizedType2 = (ParameterizedType)type;
        Map<TypeVariable<?>, Type> map = TypeUtils.determineTypeArguments(TypeUtils.getRawType(parameterizedType2), parameterizedType);
        TypeUtils.mapTypeVariablesToArguments(clazz, parameterizedType2, map);
        return map;
    }

    private static boolean equals(GenericArrayType genericArrayType, Type type) {
        return type instanceof GenericArrayType && TypeUtils.equals(genericArrayType.getGenericComponentType(), ((GenericArrayType)type).getGenericComponentType());
    }

    private static boolean equals(ParameterizedType parameterizedType, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType2 = (ParameterizedType)type;
            if (TypeUtils.equals(parameterizedType.getRawType(), parameterizedType2.getRawType()) && TypeUtils.equals(parameterizedType.getOwnerType(), parameterizedType2.getOwnerType())) {
                return TypeUtils.equals(parameterizedType.getActualTypeArguments(), parameterizedType2.getActualTypeArguments());
            }
        }
        return false;
    }

    public static boolean equals(Type type, Type type2) {
        if (ObjectUtils.equals(type, type2)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.equals((ParameterizedType)type, type2);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.equals((GenericArrayType)type, type2);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.equals((WildcardType)type, type2);
        }
        return false;
    }

    private static boolean equals(WildcardType wildcardType, Type type) {
        block3: {
            block2: {
                if (!(type instanceof WildcardType)) break block2;
                WildcardType wildcardType2 = (WildcardType)type;
                if (!TypeUtils.equals(wildcardType.getLowerBounds(), wildcardType2.getLowerBounds()) || !TypeUtils.equals(TypeUtils.getImplicitUpperBounds(wildcardType), TypeUtils.getImplicitUpperBounds(wildcardType2))) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean equals(Type[] typeArray, Type[] typeArray2) {
        if (typeArray.length != typeArray2.length) return false;
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            if (TypeUtils.equals(typeArray[i2], typeArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static Type[] extractTypeArgumentsFrom(Map<TypeVariable<?>, Type> map, TypeVariable<?>[] typeVariableArray) {
        Type[] typeArray = new Type[typeVariableArray.length];
        int n2 = typeVariableArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            TypeVariable<?> typeVariable = typeVariableArray[i2];
            boolean bl2 = map.containsKey(typeVariable);
            Object[] objectArray = new Object[]{TypeUtils.toString(typeVariable)};
            Validate.isTrue(bl2, "missing argument mapping for %s", objectArray);
            int n4 = n3 + 1;
            typeArray[n3] = map.get(typeVariable);
            n3 = n4;
        }
        return typeArray;
    }

    public static GenericArrayType genericArrayType(Type type) {
        return new GenericArrayTypeImpl(Validate.notNull(type, "componentType is null", new Object[0]));
    }

    private static String genericArrayTypeToString(GenericArrayType genericArrayType) {
        Object[] objectArray = new Object[]{TypeUtils.toString(genericArrayType.getGenericComponentType())};
        return String.format("%s[]", objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type getArrayComponentType(Type type) {
        Class<?> clazz;
        if (type instanceof Class) {
            Class clazz2 = (Class)type;
            boolean bl2 = clazz2.isArray();
            clazz = null;
            if (!bl2) return clazz;
            return clazz2.getComponentType();
        }
        boolean bl3 = type instanceof GenericArrayType;
        clazz = null;
        if (!bl3) return clazz;
        return ((GenericArrayType)type).getGenericComponentType();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Type getClosestParentType(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isInterface()) {
            Type[] typeArray = clazz.getGenericInterfaces();
            Type type = null;
            for (Type type2 : typeArray) {
                Class clazz3;
                if (type2 instanceof ParameterizedType) {
                    clazz3 = TypeUtils.getRawType((ParameterizedType)type2);
                } else {
                    if (!(type2 instanceof Class)) {
                        throw new IllegalStateException("Unexpected generic interface type found: " + type2);
                    }
                    clazz3 = (Class)type2;
                }
                if (!TypeUtils.isAssignable((Type)clazz3, clazz2) || !TypeUtils.isAssignable(type, (Type)clazz3)) continue;
                type = type2;
            }
            if (type != null) {
                return type;
            }
        }
        return clazz.getGenericSuperclass();
    }

    public static Type[] getImplicitBounds(TypeVariable<?> typeVariable) {
        Validate.notNull(typeVariable, "typeVariable is null", new Object[0]);
        Type[] typeArray = typeVariable.getBounds();
        if (typeArray.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    public static Type[] getImplicitLowerBounds(WildcardType wildcardType) {
        Validate.notNull(wildcardType, "wildcardType is null", new Object[0]);
        Type[] typeArray = wildcardType.getLowerBounds();
        if (typeArray.length == 0) {
            typeArray = new Type[]{null};
        }
        return typeArray;
    }

    public static Type[] getImplicitUpperBounds(WildcardType wildcardType) {
        Validate.notNull(wildcardType, "wildcardType is null", new Object[0]);
        Type[] typeArray = wildcardType.getUpperBounds();
        if (typeArray.length == 0) {
            return new Type[]{Object.class};
        }
        return TypeUtils.normalizeUpperBounds(typeArray);
    }

    private static Class<?> getRawType(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getRawType();
        if (!(type instanceof Class)) {
            throw new IllegalStateException("Wait... What!? Type of rawType: " + type);
        }
        return (Class)type;
    }

    public static Class<?> getRawType(Type type, Type type2) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getRawType((ParameterizedType)type);
        }
        if (type instanceof TypeVariable) {
            if (type2 == null) {
                return null;
            }
            Object d2 = ((TypeVariable)type).getGenericDeclaration();
            if (!(d2 instanceof Class)) {
                return null;
            }
            Map<TypeVariable<?>, Type> map = TypeUtils.getTypeArguments(type2, (Class)d2);
            if (map == null) {
                return null;
            }
            Type type3 = map.get(type);
            if (type3 == null) {
                return null;
            }
            return TypeUtils.getRawType(type3, type2);
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(TypeUtils.getRawType(((GenericArrayType)type).getGenericComponentType(), type2), 0).getClass();
        }
        if (type instanceof WildcardType) {
            return null;
        }
        throw new IllegalArgumentException("unknown type: " + type);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<TypeVariable<?>, Type> getTypeArguments(Class<?> clazz, Class<?> clazz2, Map<TypeVariable<?>, Type> map) {
        if (!TypeUtils.isAssignable(clazz, clazz2)) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (clazz2.isPrimitive()) {
                return new HashMap();
            }
            clazz = ClassUtils.primitiveToWrapper(clazz);
        }
        HashMap<Object, Object> hashMap = map == null ? new HashMap() : new HashMap(map);
        if (clazz2.equals(clazz)) return hashMap;
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(clazz, clazz2), clazz2, hashMap);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType) {
        return TypeUtils.getTypeArguments(parameterizedType, TypeUtils.getRawType(parameterizedType), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<TypeVariable<?>, Type> getTypeArguments(ParameterizedType parameterizedType, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Map<Object, Object> map2;
        Class<?> clazz2 = TypeUtils.getRawType(parameterizedType);
        if (!TypeUtils.isAssignable(clazz2, clazz)) {
            return null;
        }
        Type type = parameterizedType.getOwnerType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType2 = (ParameterizedType)type;
            map2 = TypeUtils.getTypeArguments(parameterizedType2, TypeUtils.getRawType(parameterizedType2), map);
        } else {
            map2 = map == null ? new HashMap() : new HashMap(map);
        }
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeVariableArray = clazz2.getTypeParameters();
        for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
            Type type2 = typeArray[i2];
            TypeVariable<Class<?>> typeVariable = typeVariableArray[i2];
            Type type3 = map2.containsKey(type2) ? (Type)map2.get(type2) : type2;
            map2.put(typeVariable, type3);
        }
        if (clazz.equals(clazz2)) return map2;
        return TypeUtils.getTypeArguments(TypeUtils.getClosestParentType(clazz2, clazz), clazz, map2);
    }

    public static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> clazz) {
        return TypeUtils.getTypeArguments(type, clazz, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<TypeVariable<?>, Type> getTypeArguments(Type type, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Map<TypeVariable<?>, Type> map2;
        if (type instanceof Class) {
            return TypeUtils.getTypeArguments((Class)type, clazz, map);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getTypeArguments((ParameterizedType)type, clazz, map);
        }
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            if (!clazz.isArray()) return TypeUtils.getTypeArguments(type2, clazz, map);
            clazz = clazz.getComponentType();
            return TypeUtils.getTypeArguments(type2, clazz, map);
        }
        if (type instanceof WildcardType) {
            Type[] typeArray = TypeUtils.getImplicitUpperBounds((WildcardType)type);
            int n2 = typeArray.length;
            int n3 = 0;
            while (true) {
                map2 = null;
                if (n3 >= n2) return map2;
                Type type3 = typeArray[n3];
                if (TypeUtils.isAssignable(type3, clazz)) {
                    return TypeUtils.getTypeArguments(type3, clazz, map);
                }
                ++n3;
            }
        }
        if (!(type instanceof TypeVariable)) throw new IllegalStateException("found an unhandled type: " + type);
        Type[] typeArray = TypeUtils.getImplicitBounds((TypeVariable)type);
        int n4 = typeArray.length;
        int n5 = 0;
        while (true) {
            map2 = null;
            if (n5 >= n4) return map2;
            Type type4 = typeArray[n5];
            if (TypeUtils.isAssignable(type4, clazz)) {
                return TypeUtils.getTypeArguments(type4, clazz, map);
            }
            ++n5;
        }
    }

    public static boolean isArrayType(Type type) {
        return type instanceof GenericArrayType || type instanceof Class && ((Class)type).isArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAssignable(Type type, Class<?> clazz) {
        boolean bl2;
        if (type == null) {
            if (clazz == null) return true;
            boolean bl3 = clazz.isPrimitive();
            bl2 = false;
            if (bl3) return bl2;
            return true;
        }
        bl2 = false;
        if (clazz == null) return bl2;
        if (clazz.equals(type)) {
            return true;
        }
        if (type instanceof Class) {
            return ClassUtils.isAssignable((Class)type, clazz);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.isAssignable(TypeUtils.getRawType((ParameterizedType)type), clazz);
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = ((TypeVariable)type).getBounds();
            int n2 = typeArray.length;
            int n3 = 0;
            while (true) {
                bl2 = false;
                if (n3 >= n2) return bl2;
                if (TypeUtils.isAssignable(typeArray[n3], clazz)) {
                    return true;
                }
                ++n3;
            }
        }
        if (type instanceof GenericArrayType) {
            if (clazz.equals(Object.class)) return true;
            boolean bl4 = clazz.isArray();
            bl2 = false;
            if (!bl4) return bl2;
            boolean bl5 = TypeUtils.isAssignable(((GenericArrayType)type).getGenericComponentType(), clazz.getComponentType());
            bl2 = false;
            if (!bl5) return bl2;
            return true;
        }
        boolean bl6 = type instanceof WildcardType;
        bl2 = false;
        if (bl6) return bl2;
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isAssignable(Type type, GenericArrayType genericArrayType, Map<TypeVariable<?>, Type> map) {
        if (type == null) return true;
        if (genericArrayType == null) {
            return false;
        }
        if (genericArrayType.equals(type)) return true;
        Type type2 = genericArrayType.getGenericComponentType();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray() && TypeUtils.isAssignable(clazz.getComponentType(), type2, map)) return true;
            return false;
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.isAssignable(((GenericArrayType)type).getGenericComponentType(), type2, map);
        }
        if (type instanceof WildcardType) {
            Type[] typeArray = TypeUtils.getImplicitUpperBounds((WildcardType)type);
            int n2 = typeArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return false;
                }
                if (TypeUtils.isAssignable(typeArray[n3], genericArrayType)) return true;
                ++n3;
            }
        }
        if (!(type instanceof TypeVariable)) {
            if (!(type instanceof ParameterizedType)) throw new IllegalStateException("found an unhandled type: " + type);
            return false;
        }
        Type[] typeArray = TypeUtils.getImplicitBounds((TypeVariable)type);
        int n4 = typeArray.length;
        int n5 = 0;
        while (n5 < n4) {
            if (TypeUtils.isAssignable(typeArray[n5], genericArrayType)) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static boolean isAssignable(Type type, ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> map) {
        if (type == null) {
            return true;
        }
        if (parameterizedType == null) {
            return false;
        }
        if (parameterizedType.equals(type)) return true;
        Class<?> clazz = TypeUtils.getRawType(parameterizedType);
        Map<TypeVariable<?>, Type> map2 = TypeUtils.getTypeArguments(type, clazz, null);
        if (map2 == null) {
            return false;
        }
        if (map2.isEmpty()) return true;
        Map<TypeVariable<?>, Type> map3 = TypeUtils.getTypeArguments(parameterizedType, clazz, map);
        Iterator<TypeVariable<?>> iterator = map3.keySet().iterator();
        while (iterator.hasNext()) {
            TypeVariable<?> typeVariable = iterator.next();
            Type type2 = TypeUtils.unrollVariableAssignments(typeVariable, map3);
            Type type3 = TypeUtils.unrollVariableAssignments(typeVariable, map2);
            if (type3 == null || type2.equals(type3)) continue;
            if (!(type2 instanceof WildcardType)) return false;
            if (!TypeUtils.isAssignable(type3, type2, map)) return false;
        }
        return true;
    }

    public static boolean isAssignable(Type type, Type type2) {
        return TypeUtils.isAssignable(type, type2, null);
    }

    private static boolean isAssignable(Type type, Type type2, Map<TypeVariable<?>, Type> map) {
        if (type2 == null || type2 instanceof Class) {
            return TypeUtils.isAssignable(type, (Class)type2);
        }
        if (type2 instanceof ParameterizedType) {
            return TypeUtils.isAssignable(type, (ParameterizedType)type2, map);
        }
        if (type2 instanceof GenericArrayType) {
            return TypeUtils.isAssignable(type, (GenericArrayType)type2, map);
        }
        if (type2 instanceof WildcardType) {
            return TypeUtils.isAssignable(type, (WildcardType)type2, map);
        }
        if (type2 instanceof TypeVariable) {
            return TypeUtils.isAssignable(type, (TypeVariable)type2, map);
        }
        throw new IllegalStateException("found an unhandled type: " + type2);
    }

    private static boolean isAssignable(Type type, TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> map) {
        if (type == null) {
            return true;
        }
        if (typeVariable == null) {
            return false;
        }
        if (typeVariable.equals(type)) {
            return true;
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray = TypeUtils.getImplicitBounds((TypeVariable)type);
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!TypeUtils.isAssignable(typeArray[i2], typeVariable, map)) continue;
                return true;
            }
        }
        if (type instanceof Class || type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
            return false;
        }
        throw new IllegalStateException("found an unhandled type: " + type);
    }

    private static boolean isAssignable(Type type, WildcardType wildcardType, Map<TypeVariable<?>, Type> map) {
        if (type == null) {
            return true;
        }
        if (wildcardType == null) {
            return false;
        }
        if (wildcardType.equals(type)) {
            return true;
        }
        Type[] typeArray = TypeUtils.getImplicitUpperBounds(wildcardType);
        Type[] typeArray2 = TypeUtils.getImplicitLowerBounds(wildcardType);
        if (type instanceof WildcardType) {
            WildcardType wildcardType2 = (WildcardType)type;
            Type[] typeArray3 = TypeUtils.getImplicitUpperBounds(wildcardType2);
            Type[] typeArray4 = TypeUtils.getImplicitLowerBounds(wildcardType2);
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type2 = TypeUtils.substituteTypeVariables(typeArray[i2], map);
                int n3 = typeArray3.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (TypeUtils.isAssignable(typeArray3[i3], type2, map)) continue;
                    return false;
                }
            }
            int n4 = typeArray2.length;
            for (int i4 = 0; i4 < n4; ++i4) {
                Type type3 = TypeUtils.substituteTypeVariables(typeArray2[i4], map);
                int n5 = typeArray4.length;
                for (int i5 = 0; i5 < n5; ++i5) {
                    if (TypeUtils.isAssignable(type3, typeArray4[i5], map)) continue;
                    return false;
                }
            }
            return true;
        }
        int n6 = typeArray.length;
        for (int i6 = 0; i6 < n6; ++i6) {
            if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(typeArray[i6], map), map)) continue;
            return false;
        }
        int n7 = typeArray2.length;
        for (int i7 = 0; i7 < n7; ++i7) {
            if (TypeUtils.isAssignable(TypeUtils.substituteTypeVariables(typeArray2[i7], map), type, map)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isInstance(Object object, Type type) {
        block5: {
            block4: {
                if (type == null) break block4;
                if (object != null) {
                    return TypeUtils.isAssignable(object.getClass(), type, null);
                }
                if (!(type instanceof Class) || !((Class)type).isPrimitive()) break block5;
            }
            return false;
        }
        return true;
    }

    private static <T> void mapTypeVariablesToArguments(Class<T> clazz, ParameterizedType parameterizedType, Map<TypeVariable<?>, Type> map) {
        Type type = parameterizedType.getOwnerType();
        if (type instanceof ParameterizedType) {
            TypeUtils.mapTypeVariablesToArguments(clazz, (ParameterizedType)type, map);
        }
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeVariableArray = TypeUtils.getRawType(parameterizedType).getTypeParameters();
        List<TypeVariable<Class<T>>> list = Arrays.asList(clazz.getTypeParameters());
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            TypeVariable<Class<?>> typeVariable = typeVariableArray[i2];
            Type type2 = typeArray[i2];
            if (!list.contains(type2) || !map.containsKey(typeVariable)) continue;
            map.put((TypeVariable)type2, map.get(typeVariable));
        }
    }

    public static Type[] normalizeUpperBounds(Type[] typeArray) {
        Validate.notNull(typeArray, "null value specified for bounds array", new Object[0]);
        if (typeArray.length < 2) {
            return typeArray;
        }
        HashSet<Type> hashSet = new HashSet<Type>(typeArray.length);
        int n2 = typeArray.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            Type type = typeArray[i2];
            int n3 = typeArray.length;
            int n4 = 0;
            while (true) {
                block7: {
                    boolean bl2;
                    block6: {
                        bl2 = false;
                        if (n4 >= n3) break block6;
                        Type type2 = typeArray[n4];
                        if (type == type2 || !TypeUtils.isAssignable(type2, type, null)) break block7;
                        bl2 = true;
                    }
                    if (bl2) continue block0;
                    hashSet.add(type);
                    continue block0;
                }
                ++n4;
            }
        }
        return hashSet.toArray(new Type[hashSet.size()]);
    }

    public static final ParameterizedType parameterize(Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Validate.notNull(clazz, "raw class is null", new Object[0]);
        Validate.notNull(map, "typeArgMappings is null", new Object[0]);
        return TypeUtils.parameterizeWithOwner(null, clazz, TypeUtils.extractTypeArgumentsFrom(map, clazz.getTypeParameters()));
    }

    public static final ParameterizedType parameterize(Class<?> clazz, Type ... typeArray) {
        return TypeUtils.parameterizeWithOwner(null, clazz, typeArray);
    }

    public static final ParameterizedType parameterizeWithOwner(Type type, Class<?> clazz, Map<TypeVariable<?>, Type> map) {
        Validate.notNull(clazz, "raw class is null", new Object[0]);
        Validate.notNull(map, "typeArgMappings is null", new Object[0]);
        return TypeUtils.parameterizeWithOwner(type, clazz, TypeUtils.extractTypeArgumentsFrom(map, clazz.getTypeParameters()));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final ParameterizedType parameterizeWithOwner(Type type, Class<?> clazz, Type ... typeArray) {
        void var4_5;
        Validate.notNull(clazz, "raw class is null", new Object[0]);
        if (clazz.getEnclosingClass() == null) {
            boolean bl2 = type == null;
            Validate.isTrue(bl2, "no owner allowed for top-level %s", clazz);
            Object var4_4 = null;
        } else if (type == null) {
            Class<?> clazz2 = clazz.getEnclosingClass();
        } else {
            Validate.isTrue(TypeUtils.isAssignable(type, clazz.getEnclosingClass()), "%s is invalid owner type for parameterized %s", type, clazz);
            Type type2 = type;
        }
        Validate.noNullElements(typeArray, "null type argument at index %s", new Object[0]);
        boolean bl3 = clazz.getTypeParameters().length == typeArray.length;
        Object[] objectArray = new Object[]{clazz.getTypeParameters().length, typeArray.length};
        Validate.isTrue(bl3, "invalid number of type parameters specified: expected %s, got %s", objectArray);
        return new ParameterizedTypeImpl(clazz, (Type)var4_5, typeArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String parameterizedTypeToString(ParameterizedType parameterizedType) {
        StringBuilder stringBuilder = new StringBuilder();
        Type type = parameterizedType.getOwnerType();
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (type == null) {
            stringBuilder.append(clazz.getName());
        } else {
            if (type instanceof Class) {
                stringBuilder.append(((Class)type).getName());
            } else {
                stringBuilder.append(type.toString());
            }
            stringBuilder.append('.').append(clazz.getSimpleName());
        }
        TypeUtils.appendAllTo(stringBuilder.append('<'), ", ", typeArray).append('>');
        return stringBuilder.toString();
    }

    private static Type substituteTypeVariables(Type type, Map<TypeVariable<?>, Type> map) {
        Type type2;
        if (type instanceof TypeVariable && map != null) {
            type2 = map.get(type);
            if (type2 == null) {
                throw new IllegalArgumentException("missing assignment type for type variable " + type);
            }
        } else {
            type2 = type;
        }
        return type2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toLongString(TypeVariable<?> typeVariable) {
        Validate.notNull(typeVariable, "var is null", new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        Object obj = typeVariable.getGenericDeclaration();
        if (obj instanceof Class) {
            Class<?> clazz = (Class<?>)obj;
            while (true) {
                if (clazz.getEnclosingClass() == null) {
                    stringBuilder.insert(0, clazz.getName());
                    return stringBuilder.append(':').append(TypeUtils.typeVariableToString(typeVariable)).toString();
                }
                stringBuilder.insert(0, clazz.getSimpleName()).insert(0, '.');
                clazz = clazz.getEnclosingClass();
            }
        }
        if (obj instanceof Type) {
            stringBuilder.append(TypeUtils.toString((Type)obj));
            return stringBuilder.append(':').append(TypeUtils.typeVariableToString(typeVariable)).toString();
        }
        stringBuilder.append(obj);
        return stringBuilder.append(':').append(TypeUtils.typeVariableToString(typeVariable)).toString();
    }

    public static String toString(Type type) {
        Validate.notNull(type);
        if (type instanceof Class) {
            return TypeUtils.classToString((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.parameterizedTypeToString((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return TypeUtils.wildcardTypeToString((WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.typeVariableToString((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return TypeUtils.genericArrayTypeToString((GenericArrayType)type);
        }
        throw new IllegalArgumentException(ObjectUtils.identityToString(type));
    }

    private static String typeVariableToString(TypeVariable<?> typeVariable) {
        StringBuilder stringBuilder = new StringBuilder(typeVariable.getName());
        Type[] typeArray = typeVariable.getBounds();
        if (!(typeArray.length <= 0 || typeArray.length == 1 && Object.class.equals((Object)typeArray[0]))) {
            stringBuilder.append(" extends ");
            TypeUtils.appendAllTo(stringBuilder, " & ", typeVariable.getBounds());
        }
        return stringBuilder.toString();
    }

    public static boolean typesSatisfyVariables(Map<TypeVariable<?>, Type> map) {
        Validate.notNull(map, "typeVarAssigns is null", new Object[0]);
        for (Map.Entry<TypeVariable<?>, Type> entry : map.entrySet()) {
            TypeVariable<?> typeVariable = entry.getKey();
            Type type = entry.getValue();
            Type[] typeArray = TypeUtils.getImplicitBounds(typeVariable);
            int n2 = typeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (TypeUtils.isAssignable(type, TypeUtils.substituteTypeVariables(typeArray[i2], map), map)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Type[] unrollBounds(Map<TypeVariable<?>, Type> map, Type[] typeArray) {
        Type[] typeArray2 = typeArray;
        int n2 = 0;
        while (n2 < typeArray2.length) {
            Type type = TypeUtils.unrollVariables(map, typeArray2[n2]);
            if (type == null) {
                int n3 = n2 - 1;
                typeArray2 = ArrayUtils.remove(typeArray2, n2);
                n2 = n3;
            } else {
                typeArray2[n2] = type;
            }
            ++n2;
        }
        return typeArray2;
    }

    private static Type unrollVariableAssignments(TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> map) {
        Type type;
        while ((type = map.get(typeVariable)) instanceof TypeVariable && !type.equals(typeVariable)) {
            typeVariable = (TypeVariable)type;
        }
        return type;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Type unrollVariables(Map<TypeVariable<?>, Type> map, Type type) {
        if (map == null) {
            map = Collections.emptyMap();
        }
        if (!TypeUtils.containsTypeVariables(type)) return type;
        if (type instanceof TypeVariable) {
            return TypeUtils.unrollVariables(map, map.get(type));
        }
        if (type instanceof ParameterizedType) {
            Map<TypeVariable<?>, Type> map2;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getOwnerType() == null) {
                map2 = map;
            } else {
                map2 = new HashMap(map);
                map2.putAll(TypeUtils.getTypeArguments(parameterizedType));
            }
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            int n2 = 0;
            while (true) {
                if (n2 >= typeArray.length) {
                    return TypeUtils.parameterizeWithOwner(parameterizedType.getOwnerType(), (Class)parameterizedType.getRawType(), typeArray);
                }
                Type type2 = TypeUtils.unrollVariables(map2, typeArray[n2]);
                if (type2 != null) {
                    typeArray[n2] = type2;
                }
                ++n2;
            }
        }
        if (!(type instanceof WildcardType)) return type;
        WildcardType wildcardType = (WildcardType)type;
        return TypeUtils.wildcardType().withUpperBounds(TypeUtils.unrollBounds(map, wildcardType.getUpperBounds())).withLowerBounds(TypeUtils.unrollBounds(map, wildcardType.getLowerBounds())).build();
    }

    public static WildcardTypeBuilder wildcardType() {
        return new WildcardTypeBuilder();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String wildcardTypeToString(WildcardType wildcardType) {
        StringBuilder stringBuilder = new StringBuilder().append('?');
        Type[] typeArray = wildcardType.getLowerBounds();
        Type[] typeArray2 = wildcardType.getUpperBounds();
        if (typeArray.length > 0) {
            TypeUtils.appendAllTo(stringBuilder.append(" super "), " & ", typeArray);
            return stringBuilder.toString();
        }
        if (typeArray2.length == 1) {
            if (Object.class.equals((Object)typeArray2[0])) return stringBuilder.toString();
        }
        TypeUtils.appendAllTo(stringBuilder.append(" extends "), " & ", typeArray2);
        return stringBuilder.toString();
    }

    public static <T> Typed<T> wrap(Class<T> clazz) {
        return TypeUtils.wrap(clazz);
    }

    public static <T> Typed<T> wrap(final Type type) {
        return new Typed<T>(){

            @Override
            public Type getType() {
                return type;
            }
        };
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        private GenericArrayTypeImpl(Type type) {
            this.componentType = type;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof GenericArrayType && TypeUtils.equals(this, (GenericArrayType)object);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public int hashCode() {
            return 0x430 | this.componentType.hashCode();
        }

        public String toString() {
            return TypeUtils.toString(this);
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> raw;
        private final Type[] typeArguments;
        private final Type useOwner;

        private ParameterizedTypeImpl(Class<?> clazz, Type type, Type[] typeArray) {
            this.raw = clazz;
            this.useOwner = type;
            this.typeArguments = typeArray;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof ParameterizedType && TypeUtils.equals(this, (ParameterizedType)object);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getOwnerType() {
            return this.useOwner;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        public int hashCode() {
            return ((0x470 | this.raw.hashCode()) << 4 | ObjectUtils.hashCode(this.useOwner)) << 8 | Arrays.hashCode(this.typeArguments);
        }

        public String toString() {
            return TypeUtils.toString(this);
        }
    }

    public static class WildcardTypeBuilder
    implements Builder<WildcardType> {
        private Type[] lowerBounds;
        private Type[] upperBounds;

        private WildcardTypeBuilder() {
        }

        @Override
        public WildcardType build() {
            return new WildcardTypeImpl(this.upperBounds, this.lowerBounds);
        }

        public WildcardTypeBuilder withLowerBounds(Type ... typeArray) {
            this.lowerBounds = typeArray;
            return this;
        }

        public WildcardTypeBuilder withUpperBounds(Type ... typeArray) {
            this.upperBounds = typeArray;
            return this;
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType {
        private static final Type[] EMPTY_BOUNDS = new Type[0];
        private final Type[] lowerBounds;
        private final Type[] upperBounds;

        private WildcardTypeImpl(Type[] typeArray, Type[] typeArray2) {
            this.upperBounds = ObjectUtils.defaultIfNull(typeArray, EMPTY_BOUNDS);
            this.lowerBounds = ObjectUtils.defaultIfNull(typeArray2, EMPTY_BOUNDS);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof WildcardType && TypeUtils.equals(this, (WildcardType)object);
        }

        @Override
        public Type[] getLowerBounds() {
            return (Type[])this.lowerBounds.clone();
        }

        @Override
        public Type[] getUpperBounds() {
            return (Type[])this.upperBounds.clone();
        }

        public int hashCode() {
            return (0x4900 | Arrays.hashCode(this.upperBounds)) << 8 | Arrays.hashCode(this.lowerBounds);
        }

        public String toString() {
            return TypeUtils.toString(this);
        }
    }
}

