/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.reflect.Typed;

public abstract class TypeLiteral<T>
implements Typed<T> {
    private static final TypeVariable<Class<TypeLiteral>> T = TypeLiteral.class.getTypeParameters()[0];
    private final String toString;
    public final Type value;

    protected TypeLiteral() {
        Type type = TypeUtils.getTypeArguments(this.getClass(), TypeLiteral.class).get(T);
        Object[] objectArray = new Object[]{this.getClass(), TypeUtils.toLongString(T)};
        this.value = Validate.notNull(type, "%s does not assign type parameter %s", objectArray);
        Object[] objectArray2 = new Object[]{TypeLiteral.class.getSimpleName(), TypeUtils.toString(this.value)};
        this.toString = String.format("%s<%s>", objectArray2);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TypeLiteral)) {
            return false;
        }
        TypeLiteral typeLiteral = (TypeLiteral)object;
        return TypeUtils.equals(this.value, typeLiteral.value);
    }

    @Override
    public Type getType() {
        return this.value;
    }

    public int hashCode() {
        return 0x250 | this.value.hashCode();
    }

    public String toString() {
        return this.toString;
    }
}

