/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public class MethodUtils {
    public static Method getAccessibleMethod(Class<?> clazz, String string2, Class<?> ... classArray) {
        try {
            Method method = MethodUtils.getAccessibleMethod(clazz.getMethod(string2, classArray));
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Method getAccessibleMethod(Method method) {
        Class<?>[] classArray;
        if (!MemberUtils.isAccessible(method)) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) return method;
        String string2 = method.getName();
        if ((method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, string2, classArray = method.getParameterTypes())) != null) return method;
        return MethodUtils.getAccessibleMethodFromSuperclass(clazz, string2, classArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Method getAccessibleMethodFromInterfaceNest(Class<?> clazz, String string2, Class<?> ... classArray) {
        while (clazz != null) {
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                if (!Modifier.isPublic(classArray2[i2].getModifiers())) continue;
                try {
                    return classArray2[i2].getDeclaredMethod(string2, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = MethodUtils.getAccessibleMethodFromInterfaceNest(classArray2[i2], string2, classArray);
                    if (method == null) continue;
                    return method;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> clazz, String string2, Class<?> ... classArray) {
        Class<?> clazz2 = clazz.getSuperclass();
        while (true) {
            block6: {
                Method method;
                block5: {
                    method = null;
                    if (clazz2 == null) break block5;
                    if (!Modifier.isPublic(clazz2.getModifiers())) break block6;
                    try {
                        Method method2;
                        method = method2 = clazz2.getMethod(string2, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return null;
                    }
                }
                return method;
            }
            clazz2 = clazz2.getSuperclass();
        }
    }

    public static Method getMatchingAccessibleMethod(Class<?> clazz, String string2, Class<?> ... classArray) {
        try {
            Method method = clazz.getMethod(string2, classArray);
            MemberUtils.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Method method = null;
            for (Method method2 : clazz.getMethods()) {
                Method method3;
                if (!method2.getName().equals(string2) || !ClassUtils.isAssignable(classArray, method2.getParameterTypes(), true) || (method3 = MethodUtils.getAccessibleMethod(method2)) == null || method != null && MemberUtils.compareParameterTypes(method3.getParameterTypes(), method.getParameterTypes(), classArray) >= 0) continue;
                method = method3;
            }
            if (method != null) {
                MemberUtils.setAccessibleWorkaround(method);
            }
            return method;
        }
    }

    public static Set<Method> getOverrideHierarchy(Method method, ClassUtils.Interfaces interfaces) {
        Validate.notNull(method);
        LinkedHashSet<Method> linkedHashSet = new LinkedHashSet<Method>();
        linkedHashSet.add(method);
        Object[] objectArray = method.getParameterTypes();
        Class<?> clazz = method.getDeclaringClass();
        Iterator<Class<?>> iterator = ClassUtils.hierarchy(clazz, interfaces).iterator();
        iterator.next();
        block0: while (iterator.hasNext()) {
            Method method2 = MethodUtils.getMatchingAccessibleMethod(iterator.next(), method.getName(), objectArray);
            if (method2 == null) continue;
            if (Arrays.equals(method2.getParameterTypes(), objectArray)) {
                linkedHashSet.add(method2);
                continue;
            }
            Map<TypeVariable<?>, Type> map = TypeUtils.getTypeArguments(clazz, method2.getDeclaringClass());
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (!TypeUtils.equals(TypeUtils.unrollVariables(map, method.getGenericParameterTypes()[i2]), TypeUtils.unrollVariables(map, method2.getGenericParameterTypes()[i2]))) continue block0;
            }
            linkedHashSet.add(method2);
        }
        return linkedHashSet;
    }

    public static Object invokeExactMethod(Object object, String string2, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeExactMethod(object, string2, objectArray2, ClassUtils.toClass(objectArray2));
    }

    public static Object invokeExactMethod(Object object, String string2, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        Class<?>[] classArray2 = ArrayUtils.nullToEmpty(classArray);
        Method method = MethodUtils.getAccessibleMethod(object.getClass(), string2, classArray2);
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + string2 + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray2);
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string2, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeExactStaticMethod(clazz, string2, objectArray2, ClassUtils.toClass(objectArray2));
    }

    public static Object invokeExactStaticMethod(Class<?> clazz, String string2, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        Method method = MethodUtils.getAccessibleMethod(clazz, string2, ArrayUtils.nullToEmpty(classArray));
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + string2 + "() on class: " + clazz.getName());
        }
        return method.invoke(null, objectArray2);
    }

    public static Object invokeMethod(Object object, String string2, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeMethod(object, string2, objectArray2, ClassUtils.toClass(objectArray2));
    }

    public static Object invokeMethod(Object object, String string2, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?>[] classArray2 = ArrayUtils.nullToEmpty(classArray);
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        Method method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), string2, classArray2);
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + string2 + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, objectArray2);
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string2, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        return MethodUtils.invokeStaticMethod(clazz, string2, objectArray2, ClassUtils.toClass(objectArray2));
    }

    public static Object invokeStaticMethod(Class<?> clazz, String string2, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, string2, ArrayUtils.nullToEmpty(classArray));
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + string2 + "() on class: " + clazz.getName());
        }
        return method.invoke(null, objectArray2);
    }
}

