/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ClassUtils;

abstract class MemberUtils {
    private static final int ACCESS_TEST = 7;
    private static final Class<?>[] ORDERED_PRIMITIVE_TYPES;

    static {
        Class[] classArray = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        ORDERED_PRIMITIVE_TYPES = classArray;
    }

    MemberUtils() {
    }

    static int compareParameterTypes(Class<?>[] classArray, Class<?>[] classArray2, Class<?>[] classArray3) {
        float f2;
        float f3 = MemberUtils.getTotalTransformationCost(classArray3, classArray);
        if (f3 < (f2 = MemberUtils.getTotalTransformationCost(classArray3, classArray2))) {
            return -1;
        }
        if (f2 < f3) {
            return 1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float getObjectTransformationCost(Class<?> clazz, Class<?> clazz2) {
        if (clazz2.isPrimitive()) {
            return MemberUtils.getPrimitivePromotionCost(clazz, clazz2);
        }
        float f2 = 0.0f;
        while (true) {
            block6: {
                block5: {
                    if (clazz == null || clazz2.equals(clazz)) break block5;
                    if (!clazz2.isInterface() || !ClassUtils.isAssignable(clazz, clazz2)) break block6;
                    f2 += 0.25f;
                }
                if (clazz != null) return f2;
                return f2 + 1.5f;
            }
            f2 += 1.0f;
            clazz = clazz.getSuperclass();
        }
    }

    private static float getPrimitivePromotionCost(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3 = clazz;
        boolean bl2 = clazz3.isPrimitive();
        float f2 = 0.0f;
        if (!bl2) {
            f2 = 0.0f + 0.1f;
            clazz3 = ClassUtils.wrapperToPrimitive(clazz3);
        }
        for (int i2 = 0; clazz3 != clazz2 && i2 < ORDERED_PRIMITIVE_TYPES.length; ++i2) {
            if (clazz3 != ORDERED_PRIMITIVE_TYPES[i2]) continue;
            f2 += 0.1f;
            if (i2 >= -1 + ORDERED_PRIMITIVE_TYPES.length) continue;
            clazz3 = ORDERED_PRIMITIVE_TYPES[i2 + 1];
        }
        return f2;
    }

    private static float getTotalTransformationCost(Class<?>[] classArray, Class<?>[] classArray2) {
        float f2 = 0.0f;
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            f2 += MemberUtils.getObjectTransformationCost(classArray[i2], classArray2[i2]);
        }
        return f2;
    }

    static boolean isAccessible(Member member) {
        return member != null && Modifier.isPublic(member.getModifiers()) && !member.isSynthetic();
    }

    static boolean isPackageAccess(int n2) {
        return (n2 & 7) == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setAccessibleWorkaround(AccessibleObject accessibleObject) {
        Member member;
        if (accessibleObject == null || accessibleObject.isAccessible() || !Modifier.isPublic((member = (Member)((Object)accessibleObject)).getModifiers()) || !MemberUtils.isPackageAccess(member.getDeclaringClass().getModifiers())) {
            return;
        }
        try {
            accessibleObject.setAccessible(true);
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }
}

