/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;

public class FieldUtils {
    public static Field[] getAllFields(Class<?> clazz) {
        List<Field> list = FieldUtils.getAllFieldsList(clazz);
        return list.toArray(new Field[list.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<Field> getAllFieldsList(Class<?> clazz) {
        boolean bl2 = clazz != null;
        Validate.isTrue(bl2, "The class must not be null", new Object[0]);
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Class<?> clazz2 = clazz;
        while (clazz2 != null) {
            Field[] fieldArray = clazz2.getDeclaredFields();
            int n2 = fieldArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(fieldArray[i2]);
            }
            clazz2 = clazz2.getSuperclass();
        }
        return arrayList;
    }

    public static Field getDeclaredField(Class<?> clazz, String string2) {
        return FieldUtils.getDeclaredField(clazz, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Field getDeclaredField(Class<?> clazz, String string2, boolean bl2) {
        boolean bl3 = true;
        if (clazz == null) {
            bl3 = false;
        }
        Validate.isTrue(bl3, "The class must not be null", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(string2), "The field name must not be blank/empty", new Object[0]);
        try {
            block7: {
                Field field;
                block6: {
                    field = clazz.getDeclaredField(string2);
                    if (MemberUtils.isAccessible(field)) break block6;
                    if (!bl2) break block7;
                    field.setAccessible(true);
                }
                return field;
            }
            return null;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String string2) {
        Field field = FieldUtils.getField(clazz, string2, false);
        MemberUtils.setAccessibleWorkaround(field);
        return field;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Field getField(Class<?> clazz, String string2, boolean bl2) {
        boolean bl3 = clazz != null;
        Validate.isTrue(bl3, "The class must not be null", new Object[0]);
        Validate.isTrue(StringUtils.isNotBlank(string2), "The field name must not be blank/empty", new Object[0]);
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                Field field = clazz2.getDeclaredField(string2);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!bl2) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Field field = null;
        Iterator<Class<?>> iterator = ClassUtils.getAllInterfaces(clazz).iterator();
        while (iterator.hasNext()) {
            Class<?> clazz3 = iterator.next();
            try {
                Field field2 = clazz3.getField(string2);
                boolean bl4 = field == null;
                Validate.isTrue(bl4, "Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", string2, clazz);
                field = field2;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return field;
    }

    public static Object readDeclaredField(Object object, String string2) throws IllegalAccessException {
        return FieldUtils.readDeclaredField(object, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object readDeclaredField(Object object, String string2, boolean bl2) throws IllegalAccessException {
        boolean bl3 = object != null;
        Validate.isTrue(bl3, "target object must not be null", new Object[0]);
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, string2, bl2);
        boolean bl4 = field != null;
        Validate.isTrue(bl4, "Cannot locate declared field %s.%s", clazz, string2);
        return FieldUtils.readField(field, object);
    }

    public static Object readDeclaredStaticField(Class<?> clazz, String string2) throws IllegalAccessException {
        return FieldUtils.readDeclaredStaticField(clazz, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object readDeclaredStaticField(Class<?> clazz, String string2, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(clazz, string2, bl2);
        boolean bl3 = field != null;
        Object[] objectArray = new Object[]{clazz.getName(), string2};
        Validate.isTrue(bl3, "Cannot locate declared field %s.%s", objectArray);
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readField(Object object, String string2) throws IllegalAccessException {
        return FieldUtils.readField(object, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object readField(Object object, String string2, boolean bl2) throws IllegalAccessException {
        boolean bl3 = object != null;
        Validate.isTrue(bl3, "target object must not be null", new Object[0]);
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string2, bl2);
        boolean bl4 = field != null;
        Validate.isTrue(bl4, "Cannot locate field %s on %s", string2, clazz);
        return FieldUtils.readField(field, object);
    }

    public static Object readField(Field field, Object object) throws IllegalAccessException {
        return FieldUtils.readField(field, object, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object readField(Field field, Object object, boolean bl2) throws IllegalAccessException {
        boolean bl3 = field != null;
        Validate.isTrue(bl3, "The field must not be null", new Object[0]);
        if (bl2 && !field.isAccessible()) {
            field.setAccessible(true);
            return field.get(object);
        }
        MemberUtils.setAccessibleWorkaround(field);
        return field.get(object);
    }

    public static Object readStaticField(Class<?> clazz, String string2) throws IllegalAccessException {
        return FieldUtils.readStaticField(clazz, string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object readStaticField(Class<?> clazz, String string2, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getField(clazz, string2, bl2);
        boolean bl3 = field != null;
        Validate.isTrue(bl3, "Cannot locate field '%s' on %s", string2, clazz);
        return FieldUtils.readStaticField(field, false);
    }

    public static Object readStaticField(Field field) throws IllegalAccessException {
        return FieldUtils.readStaticField(field, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object readStaticField(Field field, boolean bl2) throws IllegalAccessException {
        boolean bl3 = field != null;
        Validate.isTrue(bl3, "The field must not be null", new Object[0]);
        boolean bl4 = Modifier.isStatic(field.getModifiers());
        Object[] objectArray = new Object[]{field.getName()};
        Validate.isTrue(bl4, "The field '%s' is not static", objectArray);
        return FieldUtils.readField(field, (Object)null, bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeFinalModifier(Field field) {
        boolean bl2 = true;
        if (field == null) {
            bl2 = false;
        }
        Validate.isTrue(bl2, "The field must not be null", new Object[0]);
        try {
            if (Modifier.isFinal(field.getModifiers())) {
                Field field2 = Field.class.getDeclaredField("modifiers");
                field2.setAccessible(true);
                field2.setInt(field, 0xFFFFFFEF & field.getModifiers());
            }
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return;
        }
    }

    public static void writeDeclaredField(Object object, String string2, Object object2) throws IllegalAccessException {
        FieldUtils.writeDeclaredField(object, string2, object2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeDeclaredField(Object object, String string2, Object object2, boolean bl2) throws IllegalAccessException {
        boolean bl3 = object != null;
        Validate.isTrue(bl3, "target object must not be null", new Object[0]);
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getDeclaredField(clazz, string2, bl2);
        boolean bl4 = field != null;
        Object[] objectArray = new Object[]{clazz.getName(), string2};
        Validate.isTrue(bl4, "Cannot locate declared field %s.%s", objectArray);
        FieldUtils.writeField(field, object, object2);
    }

    public static void writeDeclaredStaticField(Class<?> clazz, String string2, Object object) throws IllegalAccessException {
        FieldUtils.writeDeclaredStaticField(clazz, string2, object, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeDeclaredStaticField(Class<?> clazz, String string2, Object object, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getDeclaredField(clazz, string2, bl2);
        boolean bl3 = field != null;
        Object[] objectArray = new Object[]{clazz.getName(), string2};
        Validate.isTrue(bl3, "Cannot locate declared field %s.%s", objectArray);
        FieldUtils.writeField(field, (Object)null, object);
    }

    public static void writeField(Object object, String string2, Object object2) throws IllegalAccessException {
        FieldUtils.writeField(object, string2, object2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeField(Object object, String string2, Object object2, boolean bl2) throws IllegalAccessException {
        boolean bl3 = object != null;
        Validate.isTrue(bl3, "target object must not be null", new Object[0]);
        Class<?> clazz = object.getClass();
        Field field = FieldUtils.getField(clazz, string2, bl2);
        boolean bl4 = field != null;
        Object[] objectArray = new Object[]{clazz.getName(), string2};
        Validate.isTrue(bl4, "Cannot locate declared field %s.%s", objectArray);
        FieldUtils.writeField(field, object, object2);
    }

    public static void writeField(Field field, Object object, Object object2) throws IllegalAccessException {
        FieldUtils.writeField(field, object, object2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeField(Field field, Object object, Object object2, boolean bl2) throws IllegalAccessException {
        boolean bl3 = field != null;
        Validate.isTrue(bl3, "The field must not be null", new Object[0]);
        if (bl2 && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        field.set(object, object2);
    }

    public static void writeStaticField(Class<?> clazz, String string2, Object object) throws IllegalAccessException {
        FieldUtils.writeStaticField(clazz, string2, object, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeStaticField(Class<?> clazz, String string2, Object object, boolean bl2) throws IllegalAccessException {
        Field field = FieldUtils.getField(clazz, string2, bl2);
        boolean bl3 = field != null;
        Validate.isTrue(bl3, "Cannot locate field %s on %s", string2, clazz);
        FieldUtils.writeStaticField(field, object);
    }

    public static void writeStaticField(Field field, Object object) throws IllegalAccessException {
        FieldUtils.writeStaticField(field, object, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeStaticField(Field field, Object object, boolean bl2) throws IllegalAccessException {
        boolean bl3 = field != null;
        Validate.isTrue(bl3, "The field must not be null", new Object[0]);
        boolean bl4 = Modifier.isStatic(field.getModifiers());
        Object[] objectArray = new Object[]{field.getDeclaringClass().getName(), field.getName()};
        Validate.isTrue(bl4, "The field %s.%s is not static", objectArray);
        FieldUtils.writeField(field, (Object)null, object, bl2);
    }
}

