/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MemberUtils;

public class ConstructorUtils {
    public static <T> Constructor<T> getAccessibleConstructor(Class<T> clazz, Class<?> ... classArray) {
        Validate.notNull(clazz, "class cannot be null", new Object[0]);
        try {
            Constructor<T> constructor = ConstructorUtils.getAccessibleConstructor(clazz.getConstructor(classArray));
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> constructor) {
        Validate.notNull(constructor, "constructor cannot be null", new Object[0]);
        if (MemberUtils.isAccessible(constructor) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers())) {
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> clazz, Class<?> ... classArray) {
        Validate.notNull(clazz, "class cannot be null", new Object[0]);
        try {
            Constructor<T> constructor = clazz.getConstructor(classArray);
            MemberUtils.setAccessibleWorkaround(constructor);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?> constructor = null;
            for (Constructor<?> constructor2 : clazz.getConstructors()) {
                Constructor<?> constructor3;
                if (!ClassUtils.isAssignable(classArray, constructor2.getParameterTypes(), true) || (constructor3 = ConstructorUtils.getAccessibleConstructor(constructor2)) == null) continue;
                MemberUtils.setAccessibleWorkaround(constructor3);
                if (constructor != null && MemberUtils.compareParameterTypes(constructor3.getParameterTypes(), constructor.getParameterTypes(), classArray) >= 0) continue;
                constructor = constructor3;
            }
            return constructor;
        }
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        return ConstructorUtils.invokeConstructor(clazz, objectArray2, ClassUtils.toClass(objectArray2));
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        Constructor<T> constructor = ConstructorUtils.getMatchingAccessibleConstructor(clazz, ArrayUtils.nullToEmpty(classArray));
        if (constructor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(objectArray2);
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object ... objectArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        return ConstructorUtils.invokeExactConstructor(clazz, objectArray2, ClassUtils.toClass(objectArray2));
    }

    public static <T> T invokeExactConstructor(Class<T> clazz, Object[] objectArray, Class<?>[] classArray) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] objectArray2 = ArrayUtils.nullToEmpty(objectArray);
        Constructor<T> constructor = ConstructorUtils.getAccessibleConstructor(clazz, ArrayUtils.nullToEmpty(classArray));
        if (constructor == null) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + clazz.getName());
        }
        return constructor.newInstance(objectArray2);
    }
}

