/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.Mutable;

public class MutableLong
extends Number
implements Comparable<MutableLong>,
Mutable<Number> {
    private static final long serialVersionUID = 62986528375L;
    private long value;

    public MutableLong() {
    }

    public MutableLong(long l2) {
        this.value = l2;
    }

    public MutableLong(Number number) {
        this.value = number.longValue();
    }

    public MutableLong(String string2) throws NumberFormatException {
        this.value = Long.parseLong(string2);
    }

    public void add(long l2) {
        this.value = l2 + this.value;
    }

    public void add(Number number) {
        this.value += number.longValue();
    }

    @Override
    public int compareTo(MutableLong mutableLong) {
        long l2 = mutableLong.value;
        if (this.value < l2) {
            return -1;
        }
        if (this.value == l2) {
            return 0;
        }
        return 1;
    }

    public void decrement() {
        --this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        boolean bl2 = object instanceof MutableLong;
        boolean bl3 = false;
        if (bl2) {
            long l2 = this.value - ((MutableLong)object).longValue();
            long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
            bl3 = false;
            if (l3 == false) {
                bl3 = true;
            }
        }
        return bl3;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public void increment() {
        this.value = 1L + this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public void setValue(long l2) {
        this.value = l2;
    }

    @Override
    public void setValue(Number number) {
        this.value = number.longValue();
    }

    public void subtract(long l2) {
        this.value -= l2;
    }

    public void subtract(Number number) {
        this.value -= number.longValue();
    }

    public Long toLong() {
        return this.longValue();
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

