/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.Mutable;

public class MutableByte
extends Number
implements Comparable<MutableByte>,
Mutable<Number> {
    private static final long serialVersionUID = -1585823265L;
    private byte value;

    public MutableByte() {
    }

    public MutableByte(byte by2) {
        this.value = by2;
    }

    public MutableByte(Number number) {
        this.value = number.byteValue();
    }

    public MutableByte(String string2) throws NumberFormatException {
        this.value = Byte.parseByte(string2);
    }

    public void add(byte by2) {
        this.value = (byte)(by2 + this.value);
    }

    public void add(Number number) {
        this.value = (byte)(this.value + number.byteValue());
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public int compareTo(MutableByte mutableByte) {
        byte by2 = mutableByte.value;
        if (this.value < by2) {
            return -1;
        }
        if (this.value == by2) {
            return 0;
        }
        return 1;
    }

    public void decrement() {
        this.value = (byte)(-1 + this.value);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        boolean bl2 = object instanceof MutableByte;
        boolean bl3 = false;
        if (bl2) {
            byte by2 = this.value;
            byte by3 = ((MutableByte)object).byteValue();
            bl3 = false;
            if (by2 == by3) {
                bl3 = true;
            }
        }
        return bl3;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public void increment() {
        this.value = (byte)(1 + this.value);
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public void setValue(byte by2) {
        this.value = by2;
    }

    @Override
    public void setValue(Number number) {
        this.value = number.byteValue();
    }

    public void subtract(byte by2) {
        this.value = (byte)(this.value - by2);
    }

    public void subtract(Number number) {
        this.value = (byte)(this.value - number.byteValue());
    }

    public Byte toByte() {
        return this.byteValue();
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

