/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

public class NumberUtils {
    public static final Byte BYTE_MINUS_ONE;
    public static final Byte BYTE_ONE;
    public static final Byte BYTE_ZERO;
    public static final Double DOUBLE_MINUS_ONE;
    public static final Double DOUBLE_ONE;
    public static final Double DOUBLE_ZERO;
    public static final Float FLOAT_MINUS_ONE;
    public static final Float FLOAT_ONE;
    public static final Float FLOAT_ZERO;
    public static final Integer INTEGER_MINUS_ONE;
    public static final Integer INTEGER_ONE;
    public static final Integer INTEGER_ZERO;
    public static final Long LONG_MINUS_ONE;
    public static final Long LONG_ONE;
    public static final Long LONG_ZERO;
    public static final Short SHORT_MINUS_ONE;
    public static final Short SHORT_ONE;
    public static final Short SHORT_ZERO;

    static {
        LONG_ZERO = 0L;
        LONG_ONE = 1L;
        LONG_MINUS_ONE = -1L;
        INTEGER_ZERO = 0;
        INTEGER_ONE = 1;
        INTEGER_MINUS_ONE = -1;
        SHORT_ZERO = 0;
        SHORT_ONE = 1;
        SHORT_MINUS_ONE = -1;
        BYTE_ZERO = 0;
        BYTE_ONE = 1;
        BYTE_MINUS_ONE = -1;
        DOUBLE_ZERO = 0.0;
        DOUBLE_ONE = 1.0;
        DOUBLE_MINUS_ONE = -1.0;
        FLOAT_ZERO = Float.valueOf(0.0f);
        FLOAT_ONE = Float.valueOf(1.0f);
        FLOAT_MINUS_ONE = Float.valueOf(-1.0f);
    }

    public static BigDecimal createBigDecimal(String string2) {
        if (string2 == null) {
            return null;
        }
        if (StringUtils.isBlank(string2)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (string2.trim().startsWith("--")) {
            throw new NumberFormatException(string2 + " is not a valid number.");
        }
        return new BigDecimal(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BigInteger createBigInteger(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = 10;
        boolean bl2 = string2.startsWith("-");
        boolean bl3 = false;
        int n3 = 0;
        if (bl2) {
            bl3 = true;
            n3 = 1;
        }
        if (string2.startsWith("0x", n3) || string2.startsWith("0x", n3)) {
            n2 = 16;
            n3 += 2;
        } else if (string2.startsWith("#", n3)) {
            n2 = 16;
            ++n3;
        } else if (string2.startsWith("0", n3) && string2.length() > n3 + 1) {
            n2 = 8;
            ++n3;
        }
        BigInteger bigInteger = new BigInteger(string2.substring(n3), n2);
        if (!bl3) return bigInteger;
        return bigInteger.negate();
    }

    public static Double createDouble(String string2) {
        if (string2 == null) {
            return null;
        }
        return Double.valueOf(string2);
    }

    public static Float createFloat(String string2) {
        if (string2 == null) {
            return null;
        }
        return Float.valueOf(string2);
    }

    public static Integer createInteger(String string2) {
        if (string2 == null) {
            return null;
        }
        return Integer.decode(string2);
    }

    public static Long createLong(String string2) {
        if (string2 == null) {
            return null;
        }
        return Long.decode(string2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Number createNumber(String var0) throws NumberFormatException {
        block44: {
            if (var0 == null) {
                return null;
            }
            if (StringUtils.isBlank(var0)) {
                throw new NumberFormatException("A blank string is not a valid number");
            }
            var1_2 = new String[]{"0x", "0X", "-0x", "-0X", "#", "-#"};
            var2_3 = var1_2.length;
            var3_4 = 0;
            while (true) {
                block46: {
                    block45: {
                        var4_5 = 0;
                        if (var3_4 >= var2_3) break block45;
                        var39_6 = var1_2[var3_4];
                        if (!var0.startsWith(var39_6)) break block46;
                        var4_5 = 0 + var39_6.length();
                    }
                    if (var4_5 <= 0) break block44;
                    var36_7 = '\u0000';
                    for (var37_8 = var4_5; var37_8 < var0.length() && (var36_7 = var0.charAt(var37_8)) == '0'; ++var4_5, ++var37_8) {
                    }
                    break;
                }
                ++var3_4;
            }
            var38_9 = var0.length() - var4_5;
            if (var38_9 > 16) return NumberUtils.createBigInteger(var0);
            if (var38_9 == 16 && var36_7 > '7') {
                return NumberUtils.createBigInteger(var0);
            }
            if (var38_9 > 8) return NumberUtils.createLong(var0);
            if (var38_9 != 8) return NumberUtils.createInteger(var0);
            if (var36_7 <= '7') return NumberUtils.createInteger(var0);
            return NumberUtils.createLong(var0);
        }
        var5_10 = var0.charAt(-1 + var0.length());
        var6_11 = var0.indexOf(46);
        var7_12 = 1 + (var0.indexOf(101) + var0.indexOf(69));
        if (var6_11 > -1) {
            if (var7_12 > -1) {
                if (var7_12 < var6_11) throw new NumberFormatException(var0 + " is not a valid number.");
                if (var7_12 > var0.length()) {
                    throw new NumberFormatException(var0 + " is not a valid number.");
                }
                var9_13 = var0.substring(var6_11 + 1, var7_12);
            } else {
                var9_13 = var0.substring(var6_11 + 1);
            }
            var8_14 = var0.substring(0, var6_11);
            var10_15 = var9_13.length();
        } else {
            if (var7_12 > -1) {
                if (var7_12 > var0.length()) {
                    throw new NumberFormatException(var0 + " is not a valid number.");
                }
                var8_14 = var0.substring(0, var7_12);
            } else {
                var8_14 = var0;
            }
            var9_13 = null;
            var10_15 = 0;
        }
        if (!Character.isDigit(var5_10) && var5_10 != '.') {
            var24_16 = var7_12 > -1 && var7_12 < -1 + var0.length() ? var0.substring(var7_12 + 1, -1 + var0.length()) : null;
            var25_17 = var0.substring(0, -1 + var0.length());
            var26_18 = NumberUtils.isAllZeros(var8_14) != false && NumberUtils.isAllZeros(var24_16) != false;
            switch (var5_10) {
                default: {
                    throw new NumberFormatException(var0 + " is not a valid number.");
                }
                case 'L': 
                case 'l': {
                    if (var9_13 != null) throw new NumberFormatException(var0 + " is not a valid number.");
                    if (var24_16 != null) throw new NumberFormatException(var0 + " is not a valid number.");
                    if (var25_17.charAt(0) != '-' || !NumberUtils.isDigits(var25_17.substring(1))) {
                        if (NumberUtils.isDigits(var25_17) == false) throw new NumberFormatException(var0 + " is not a valid number.");
                    }
                    try {
                        return NumberUtils.createLong(var25_17);
                    }
                    catch (NumberFormatException var34_20) {
                        return NumberUtils.createBigInteger(var25_17);
                    }
                }
                case 'F': 
                case 'f': {
                    var18_1 = NumberUtils.createFloat(var25_17);
                    if (var18_1.isInfinite()) break;
                    var33_21 = var18_1.floatValue();
                    if (var33_21 != 0.0f) return var18_1;
                    if (var26_18 != false) return var18_1;
                    break;
                }
                case 'D': 
                case 'd': {
                    break;
                }
            }
        } else {
            var11_26 = var7_12 > -1 && var7_12 < -1 + var0.length() ? var0.substring(var7_12 + 1, var0.length()) : null;
            if (var9_13 == null && var11_26 == null) {
                try {
                    return NumberUtils.createInteger(var0);
                }
                catch (NumberFormatException var20_28) {
                    try {
                        return NumberUtils.createLong(var0);
                    }
                    catch (NumberFormatException var21_30) {
                        return NumberUtils.createBigInteger(var0);
                    }
                }
            }
            var12_31 = NumberUtils.isAllZeros(var8_14) != false && NumberUtils.isAllZeros(var11_26) != false;
            if (var10_15 <= 7) {
                try {
                    var18_1 = NumberUtils.createFloat(var0);
                    if (!var18_1.isInfinite()) {
                        var19_32 = var18_1.floatValue();
                        if (var19_32 != 0.0f) return var18_1;
                        if (var12_31 != false) return var18_1;
                    }
                }
                catch (NumberFormatException var17_37) {}
            }
            if (var10_15 > 16) return NumberUtils.createBigDecimal(var0);
            try {
                var14_33 = NumberUtils.createDouble(var0);
                if (var14_33.isInfinite() != false) return NumberUtils.createBigDecimal(var0);
                var15_34 = var14_33;
                if (var15_34 != 0.0) return var14_33;
                if (var12_31 == false) return NumberUtils.createBigDecimal(var0);
                return var14_33;
            }
            catch (NumberFormatException var13_35) {
                // empty catch block
            }
            return NumberUtils.createBigDecimal(var0);
            catch (NumberFormatException var32_38) {}
        }
        try {
            var30_22 = NumberUtils.createDouble(var25_17);
            ** if (var30_22.isInfinite()) goto lbl-1000
        }
        catch (NumberFormatException var27_24) {
            // empty catch block
        }
lbl-1000:
        // 1 sources

        {
            var31_23 = var30_22.floatValue();
            if ((double)var31_23 != 0.0) return var30_22;
            if (var26_18) {
                return var30_22;
            }
        }
lbl-1000:
        // 3 sources

        {
        }
        try {
            return NumberUtils.createBigDecimal(var25_17);
        }
        catch (NumberFormatException var28_36) {
            throw new NumberFormatException(var0 + " is not a valid number.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isAllZeros(String string2) {
        block4: {
            block3: {
                if (string2 == null) break block3;
                for (int i2 = -1 + string2.length(); i2 >= 0; --i2) {
                    if (string2.charAt(i2) == '0') continue;
                    return false;
                }
                if (string2.length() <= 0) break block4;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isDigits(String string2) {
        if (!StringUtils.isEmpty(string2)) {
            int n2 = 0;
            while (true) {
                if (n2 >= string2.length()) {
                    return true;
                }
                if (!Character.isDigit(string2.charAt(n2))) break;
                ++n2;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isNumber(String string2) {
        int n2;
        int n3 = 1;
        if (StringUtils.isEmpty(string2)) {
            return false;
        }
        char[] cArray = string2.toCharArray();
        int n4 = cArray.length;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n5 = cArray[0] == '-' ? n3 : 0;
        if (n4 > n5 + 1 && cArray[n5] == '0' && cArray[n5 + 1] == 'x') {
            int n6 = n5 + 2;
            if (n6 == n4) return false;
            while (n6 < cArray.length) {
                if (!(cArray[n6] >= '0' && cArray[n6] <= '9' || cArray[n6] >= 'a' && cArray[n6] <= 'f')) {
                    if (cArray[n6] < 'A') return false;
                    if (cArray[n6] > 'F') return false;
                }
                ++n6;
            }
            return n3 != 0;
        }
        int n7 = n4 - 1;
        for (n2 = n5; n2 < n7 || n2 < n7 + 1 && bl4 && !bl5; ++n2) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                bl5 = true;
                bl4 = false;
                continue;
            }
            if (cArray[n2] == '.') {
                if (bl3) return false;
                if (bl2) return false;
                bl3 = true;
                continue;
            }
            if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                if (bl2) return false;
                if (!bl5) return false;
                bl2 = true;
                bl4 = true;
                continue;
            }
            if (cArray[n2] != '+') {
                if (cArray[n2] != '-') return false;
            }
            if (!bl4) return false;
            bl4 = false;
            bl5 = false;
        }
        if (n2 < cArray.length) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                return n3 != 0;
            }
            if (cArray[n2] == 'e') return false;
            if (cArray[n2] == 'E') return false;
            if (cArray[n2] == '.') {
                if (bl3) return false;
                if (bl2) return false;
                return bl5;
            }
            if (!bl4) {
                if (cArray[n2] == 'd') return bl5;
                if (cArray[n2] == 'D') return bl5;
                if (cArray[n2] == 'f') return bl5;
                if (cArray[n2] == 'F') {
                    return bl5;
                }
            }
            if (cArray[n2] != 'l') {
                if (cArray[n2] != 'L') return false;
            }
            if (!bl5) return 0 != 0;
            if (bl2) return 0 != 0;
            if (bl3) return 0 != 0;
            return n3 != 0;
        }
        if (bl4) return 0 != 0;
        if (!bl5) return 0 != 0;
        return n3 != 0;
    }

    public static byte max(byte by2, byte by3, byte by4) {
        if (by3 > by2) {
            by2 = by3;
        }
        if (by4 > by2) {
            by2 = by4;
        }
        return by2;
    }

    public static byte max(byte[] byArray) {
        NumberUtils.validateArray(byArray);
        byte by2 = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] <= by2) continue;
            by2 = byArray[i2];
        }
        return by2;
    }

    public static double max(double d2, double d3, double d4) {
        return Math.max(Math.max(d2, d3), d4);
    }

    public static double max(double[] dArray) {
        NumberUtils.validateArray(dArray);
        double d2 = dArray[0];
        int n2 = 1;
        while (true) {
            block6: {
                block5: {
                    if (n2 >= dArray.length) break block5;
                    if (!Double.isNaN(dArray[n2])) break block6;
                    d2 = Double.NaN;
                }
                return d2;
            }
            if (dArray[n2] > d2) {
                d2 = dArray[n2];
            }
            ++n2;
        }
    }

    public static float max(float f2, float f3, float f4) {
        return Math.max(Math.max(f2, f3), f4);
    }

    public static float max(float[] fArray) {
        NumberUtils.validateArray(fArray);
        float f2 = fArray[0];
        int n2 = 1;
        while (true) {
            block6: {
                block5: {
                    if (n2 >= fArray.length) break block5;
                    if (!Float.isNaN(fArray[n2])) break block6;
                    f2 = Float.NaN;
                }
                return f2;
            }
            if (fArray[n2] > f2) {
                f2 = fArray[n2];
            }
            ++n2;
        }
    }

    public static int max(int n2, int n3, int n4) {
        if (n3 > n2) {
            n2 = n3;
        }
        if (n4 > n2) {
            n2 = n4;
        }
        return n2;
    }

    public static int max(int[] nArray) {
        NumberUtils.validateArray(nArray);
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static long max(long l2, long l3, long l4) {
        if (l3 > l2) {
            l2 = l3;
        }
        if (l4 > l2) {
            l2 = l4;
        }
        return l2;
    }

    public static long max(long[] lArray) {
        NumberUtils.validateArray(lArray);
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2] <= l2) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    public static short max(short s2, short s3, short s4) {
        if (s3 > s2) {
            s2 = s3;
        }
        if (s4 > s2) {
            s2 = s4;
        }
        return s2;
    }

    public static short max(short[] sArray) {
        NumberUtils.validateArray(sArray);
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (sArray[i2] <= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static byte min(byte by2, byte by3, byte by4) {
        if (by3 < by2) {
            by2 = by3;
        }
        if (by4 < by2) {
            by2 = by4;
        }
        return by2;
    }

    public static byte min(byte[] byArray) {
        NumberUtils.validateArray(byArray);
        byte by2 = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] >= by2) continue;
            by2 = byArray[i2];
        }
        return by2;
    }

    public static double min(double d2, double d3, double d4) {
        return Math.min(Math.min(d2, d3), d4);
    }

    public static double min(double[] dArray) {
        NumberUtils.validateArray(dArray);
        double d2 = dArray[0];
        int n2 = 1;
        while (true) {
            block6: {
                block5: {
                    if (n2 >= dArray.length) break block5;
                    if (!Double.isNaN(dArray[n2])) break block6;
                    d2 = Double.NaN;
                }
                return d2;
            }
            if (dArray[n2] < d2) {
                d2 = dArray[n2];
            }
            ++n2;
        }
    }

    public static float min(float f2, float f3, float f4) {
        return Math.min(Math.min(f2, f3), f4);
    }

    public static float min(float[] fArray) {
        NumberUtils.validateArray(fArray);
        float f2 = fArray[0];
        int n2 = 1;
        while (true) {
            block6: {
                block5: {
                    if (n2 >= fArray.length) break block5;
                    if (!Float.isNaN(fArray[n2])) break block6;
                    f2 = Float.NaN;
                }
                return f2;
            }
            if (fArray[n2] < f2) {
                f2 = fArray[n2];
            }
            ++n2;
        }
    }

    public static int min(int n2, int n3, int n4) {
        if (n3 < n2) {
            n2 = n3;
        }
        if (n4 < n2) {
            n2 = n4;
        }
        return n2;
    }

    public static int min(int[] nArray) {
        NumberUtils.validateArray(nArray);
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static long min(long l2, long l3, long l4) {
        if (l3 < l2) {
            l2 = l3;
        }
        if (l4 < l2) {
            l2 = l4;
        }
        return l2;
    }

    public static long min(long[] lArray) {
        NumberUtils.validateArray(lArray);
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2] >= l2) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    public static short min(short s2, short s3, short s4) {
        if (s3 < s2) {
            s2 = s3;
        }
        if (s4 < s2) {
            s2 = s4;
        }
        return s2;
    }

    public static short min(short[] sArray) {
        NumberUtils.validateArray(sArray);
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (sArray[i2] >= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static byte toByte(String string2) {
        return NumberUtils.toByte(string2, (byte)0);
    }

    public static byte toByte(String string2, byte by2) {
        if (string2 == null) {
            return by2;
        }
        try {
            byte by3 = Byte.parseByte(string2);
            return by3;
        }
        catch (NumberFormatException numberFormatException) {
            return by2;
        }
    }

    public static double toDouble(String string2) {
        return NumberUtils.toDouble(string2, 0.0);
    }

    public static double toDouble(String string2, double d2) {
        if (string2 == null) {
            return d2;
        }
        try {
            double d3 = Double.parseDouble(string2);
            return d3;
        }
        catch (NumberFormatException numberFormatException) {
            return d2;
        }
    }

    public static float toFloat(String string2) {
        return NumberUtils.toFloat(string2, 0.0f);
    }

    public static float toFloat(String string2, float f2) {
        if (string2 == null) {
            return f2;
        }
        try {
            float f3 = Float.parseFloat(string2);
            return f3;
        }
        catch (NumberFormatException numberFormatException) {
            return f2;
        }
    }

    public static int toInt(String string2) {
        return NumberUtils.toInt(string2, 0);
    }

    public static int toInt(String string2, int n2) {
        if (string2 == null) {
            return n2;
        }
        try {
            int n3 = Integer.parseInt(string2);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static long toLong(String string2) {
        return NumberUtils.toLong(string2, 0L);
    }

    public static long toLong(String string2, long l2) {
        if (string2 == null) {
            return l2;
        }
        try {
            long l3 = Long.parseLong(string2);
            return l3;
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    public static short toShort(String string2) {
        return NumberUtils.toShort(string2, (short)0);
    }

    public static short toShort(String string2, short s2) {
        if (string2 == null) {
            return s2;
        }
        try {
            short s3 = Short.parseShort(string2);
            return s3;
        }
        catch (NumberFormatException numberFormatException) {
            return s2;
        }
    }

    private static void validateArray(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (Array.getLength(object) == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
    }
}

