/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.math.BigInteger;

public final class Fraction
extends Number
implements Comparable<Fraction> {
    public static final Fraction FOUR_FIFTHS;
    public static final Fraction ONE;
    public static final Fraction ONE_FIFTH;
    public static final Fraction ONE_HALF;
    public static final Fraction ONE_QUARTER;
    public static final Fraction ONE_THIRD;
    public static final Fraction THREE_FIFTHS;
    public static final Fraction THREE_QUARTERS;
    public static final Fraction TWO_FIFTHS;
    public static final Fraction TWO_QUARTERS;
    public static final Fraction TWO_THIRDS;
    public static final Fraction ZERO;
    private static final long serialVersionUID = 65382027393090L;
    private final int denominator;
    private transient int hashCode = 0;
    private final int numerator;
    private transient String toProperString = null;
    private transient String toString = null;

    static {
        ZERO = new Fraction(0, 1);
        ONE = new Fraction(1, 1);
        ONE_HALF = new Fraction(1, 2);
        ONE_THIRD = new Fraction(1, 3);
        TWO_THIRDS = new Fraction(2, 3);
        ONE_QUARTER = new Fraction(1, 4);
        TWO_QUARTERS = new Fraction(2, 4);
        THREE_QUARTERS = new Fraction(3, 4);
        ONE_FIFTH = new Fraction(1, 5);
        TWO_FIFTHS = new Fraction(2, 5);
        THREE_FIFTHS = new Fraction(3, 5);
        FOUR_FIFTHS = new Fraction(4, 5);
    }

    private Fraction(int n2, int n3) {
        this.numerator = n2;
        this.denominator = n3;
    }

    private static int addAndCheck(int n2, int n3) {
        long l2 = (long)n2 + (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Fraction addSub(Fraction fraction, boolean bl2) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0) {
            if (!bl2) return fraction.negate();
            return fraction;
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int n2 = Fraction.greatestCommonDivisor(this.denominator, fraction.denominator);
        if (n2 == 1) {
            int n3;
            int n4 = Fraction.mulAndCheck(this.numerator, fraction.denominator);
            int n5 = Fraction.mulAndCheck(fraction.numerator, this.denominator);
            if (bl2) {
                n3 = Fraction.addAndCheck(n4, n5);
                return new Fraction(n3, Fraction.mulPosAndCheck(this.denominator, fraction.denominator));
            }
            n3 = Fraction.subAndCheck(n4, n5);
            return new Fraction(n3, Fraction.mulPosAndCheck(this.denominator, fraction.denominator));
        }
        BigInteger bigInteger = BigInteger.valueOf(this.numerator).multiply(BigInteger.valueOf(fraction.denominator / n2));
        BigInteger bigInteger2 = BigInteger.valueOf(fraction.numerator).multiply(BigInteger.valueOf(this.denominator / n2));
        BigInteger bigInteger3 = bl2 ? bigInteger.add(bigInteger2) : bigInteger.subtract(bigInteger2);
        int n6 = bigInteger3.mod(BigInteger.valueOf(n2)).intValue();
        int n7 = n6 == 0 ? n2 : Fraction.greatestCommonDivisor(n6, n2);
        BigInteger bigInteger4 = bigInteger3.divide(BigInteger.valueOf(n7));
        if (bigInteger4.bitLength() <= 31) return new Fraction(bigInteger4.intValue(), Fraction.mulPosAndCheck(this.denominator / n2, fraction.denominator / n7));
        throw new ArithmeticException("overflow: numerator too large after multiply");
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Fraction getFraction(double d2) {
        int n2;
        double d3;
        int n3 = d2 < 0.0 ? -1 : 1;
        double d4 = Math.abs(d2);
        if (d4 > 2.147483647E9 || Double.isNaN(d4)) {
            throw new ArithmeticException("The value must not be greater than Integer.MAX_VALUE or NaN");
        }
        int n4 = (int)d4;
        double d5 = d4 - (double)n4;
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        int n8 = 0;
        int n9 = (int)d5;
        double d6 = 1.0;
        double d7 = d5 - (double)n9;
        double d8 = Double.MAX_VALUE;
        int n10 = 1;
        do {
            d3 = d8;
            int n11 = (int)(d6 / d7);
            double d9 = d7;
            double d10 = d6 - d7 * (double)n11;
            int n12 = n5 + n9 * n7;
            n2 = n6 + n9 * n8;
            d8 = Math.abs(d5 - (double)n12 / (double)n2);
            n9 = n11;
            d6 = d9;
            d7 = d10;
            n5 = n7;
            n6 = n8;
            n7 = n12;
            n8 = n2;
        } while (d3 > d8 && n2 <= 10000 && n2 > 0 && ++n10 < 25);
        if (n10 == 25) {
            throw new ArithmeticException("Unable to convert double to fraction");
        }
        return Fraction.getReducedFraction(n3 * (n5 + n4 * n6), n6);
    }

    public static Fraction getFraction(int n2, int n3) {
        if (n3 == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (n3 < 0) {
            if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            n2 = -n2;
            n3 = -n3;
        }
        return new Fraction(n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Fraction getFraction(int n2, int n3, int n4) {
        if (n4 == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (n4 < 0) {
            throw new ArithmeticException("The denominator must not be negative");
        }
        if (n3 < 0) {
            throw new ArithmeticException("The numerator must not be negative");
        }
        long l2 = n2 < 0 ? (long)n2 * (long)n4 - (long)n3 : (long)n2 * (long)n4 + (long)n3;
        if (l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE) {
            return new Fraction((int)l2, n4);
        }
        throw new ArithmeticException("Numerator too large to represent as an Integer.");
    }

    public static Fraction getFraction(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("The string must not be null");
        }
        if (string2.indexOf(46) >= 0) {
            return Fraction.getFraction(Double.parseDouble(string2));
        }
        int n2 = string2.indexOf(32);
        if (n2 > 0) {
            int n3 = Integer.parseInt(string2.substring(0, n2));
            String string3 = string2.substring(n2 + 1);
            int n4 = string3.indexOf(47);
            if (n4 < 0) {
                throw new NumberFormatException("The fraction could not be parsed as the format X Y/Z");
            }
            return Fraction.getFraction(n3, Integer.parseInt(string3.substring(0, n4)), Integer.parseInt(string3.substring(n4 + 1)));
        }
        int n5 = string2.indexOf(47);
        if (n5 < 0) {
            return Fraction.getFraction(Integer.parseInt(string2), 1);
        }
        return Fraction.getFraction(Integer.parseInt(string2.substring(0, n5)), Integer.parseInt(string2.substring(n5 + 1)));
    }

    public static Fraction getReducedFraction(int n2, int n3) {
        if (n3 == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (n2 == 0) {
            return ZERO;
        }
        if (n3 == Integer.MIN_VALUE && (n2 & 1) == 0) {
            n2 /= 2;
            n3 /= 2;
        }
        if (n3 < 0) {
            if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            n2 = -n2;
            n3 = -n3;
        }
        int n4 = Fraction.greatestCommonDivisor(n2, n3);
        return new Fraction(n2 / n4, n3 / n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int greatestCommonDivisor(int n2, int n3) {
        int n4;
        int n5 = 1;
        if (n2 == 0 || n3 == 0) {
            if (n2 == Integer.MIN_VALUE) throw new ArithmeticException("overflow: gcd is 2^31");
            if (n3 != Integer.MIN_VALUE) return Math.abs(n2) + Math.abs(n3);
            throw new ArithmeticException("overflow: gcd is 2^31");
        }
        if (Math.abs(n2) == n5) return n5;
        if (Math.abs(n3) == n5) return n5;
        if (n2 > 0) {
            n2 = -n2;
        }
        if (n3 > 0) {
            n3 = -n3;
        }
        for (n4 = 0; (n2 & 1) == 0 && (n3 & 1) == 0 && n4 < 31; n2 /= 2, n3 /= 2, ++n4) {
        }
        if (n4 == 31) {
            throw new ArithmeticException("overflow: gcd is 2^31");
        }
        int n6 = (n2 & 1) == n5 ? n3 : -(n2 / 2);
        while (true) {
            if ((n6 & 1) == 0) {
                n6 /= 2;
                continue;
            }
            if (n6 > 0) {
                n2 = -n6;
            } else {
                n3 = n6;
            }
            if ((n6 = (n3 - n2) / 2) == 0) break;
        }
        return -n2 * (n5 << n4);
    }

    private static int mulAndCheck(int n2, int n3) {
        long l2 = (long)n2 * (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mul");
        }
        return (int)l2;
    }

    private static int mulPosAndCheck(int n2, int n3) {
        long l2 = (long)n2 * (long)n3;
        if (l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: mulPos");
        }
        return (int)l2;
    }

    private static int subAndCheck(int n2, int n3) {
        long l2 = (long)n2 - (long)n3;
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: add");
        }
        return (int)l2;
    }

    public Fraction abs() {
        if (this.numerator >= 0) {
            return this;
        }
        return this.negate();
    }

    public Fraction add(Fraction fraction) {
        return this.addSub(fraction, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int compareTo(Fraction fraction) {
        long l2;
        long l3;
        if (this == fraction || this.numerator == fraction.numerator && this.denominator == fraction.denominator || (l3 = (long)this.numerator * (long)fraction.denominator) == (l2 = (long)fraction.numerator * (long)this.denominator)) {
            return 0;
        }
        if (l3 < l2) {
            return -1;
        }
        return 1;
    }

    public Fraction divideBy(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (fraction.numerator == 0) {
            throw new ArithmeticException("The fraction to divide by must not be zero");
        }
        return this.multiplyBy(fraction.invert());
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof Fraction)) {
                    return false;
                }
                Fraction fraction = (Fraction)object;
                if (this.getNumerator() != fraction.getNumerator() || this.getDenominator() != fraction.getDenominator()) break block5;
            }
            return true;
        }
        return false;
    }

    @Override
    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getProperNumerator() {
        return Math.abs(this.numerator % this.denominator);
    }

    public int getProperWhole() {
        return this.numerator / this.denominator;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * (629 + this.getNumerator()) + this.getDenominator();
        }
        return this.hashCode;
    }

    @Override
    public int intValue() {
        return this.numerator / this.denominator;
    }

    public Fraction invert() {
        if (this.numerator == 0) {
            throw new ArithmeticException("Unable to invert zero.");
        }
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: can't negate numerator");
        }
        if (this.numerator < 0) {
            return new Fraction(-this.denominator, -this.numerator);
        }
        return new Fraction(this.denominator, this.numerator);
    }

    @Override
    public long longValue() {
        return (long)this.numerator / (long)this.denominator;
    }

    public Fraction multiplyBy(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int n2 = Fraction.greatestCommonDivisor(this.numerator, fraction.denominator);
        int n3 = Fraction.greatestCommonDivisor(fraction.numerator, this.denominator);
        return Fraction.getReducedFraction(Fraction.mulAndCheck(this.numerator / n2, fraction.numerator / n3), Fraction.mulPosAndCheck(this.denominator / n3, fraction.denominator / n2));
    }

    public Fraction negate() {
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: too large to negate");
        }
        return new Fraction(-this.numerator, this.denominator);
    }

    public Fraction pow(int n2) {
        if (n2 == 1) {
            return this;
        }
        if (n2 == 0) {
            return ONE;
        }
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                return this.invert().pow(2).pow(-(n2 / 2));
            }
            return this.invert().pow(-n2);
        }
        Fraction fraction = this.multiplyBy(this);
        if (n2 % 2 == 0) {
            return fraction.pow(n2 / 2);
        }
        return fraction.pow(n2 / 2).multiplyBy(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Fraction reduce() {
        if (this.numerator == 0) {
            if (this.equals(ZERO)) return this;
            return ZERO;
        }
        int n2 = Fraction.greatestCommonDivisor(Math.abs(this.numerator), this.denominator);
        if (n2 != 1) return Fraction.getFraction(this.numerator / n2, this.denominator / n2);
        return this;
    }

    public Fraction subtract(Fraction fraction) {
        return this.addSub(fraction, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toProperString() {
        if (this.toProperString != null) return this.toProperString;
        if (this.numerator == 0) {
            this.toProperString = "0";
            return this.toProperString;
        }
        if (this.numerator == this.denominator) {
            this.toProperString = "1";
            return this.toProperString;
        }
        if (this.numerator == -1 * this.denominator) {
            this.toProperString = "-1";
            return this.toProperString;
        }
        int n2 = this.numerator > 0 ? -this.numerator : this.numerator;
        if (n2 >= -this.denominator) {
            this.toProperString = new StringBuilder(32).append(this.getNumerator()).append('/').append(this.getDenominator()).toString();
            return this.toProperString;
        }
        int n3 = this.getProperNumerator();
        if (n3 == 0) {
            this.toProperString = Integer.toString(this.getProperWhole());
            return this.toProperString;
        }
        this.toProperString = new StringBuilder(32).append(this.getProperWhole()).append(' ').append(n3).append('/').append(this.getDenominator()).toString();
        return this.toProperString;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = new StringBuilder(32).append(this.getNumerator()).append('/').append(this.getDenominator()).toString();
        }
        return this.toString;
    }
}

