/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class ExceptionUtils {
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
    static final String WRAPPED_MARKER = " [wrapped] ";

    @Deprecated
    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static Throwable getCause(Throwable throwable, String[] stringArray) {
        if (throwable == null) {
            return null;
        }
        if (stringArray == null) {
            stringArray = CAUSE_METHOD_NAMES;
        }
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[n3];
            if (string2 != null) {
                Throwable throwable2 = ExceptionUtils.getCauseUsingMethodName(throwable, string2);
                if (throwable2 != null) return throwable2;
            }
            ++n3;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Throwable getCauseUsingMethodName(Throwable throwable, String string2) {
        Method method;
        Method method2 = method = throwable.getClass().getMethod(string2, new Class[0]);
        if (method2 == null) return null;
        if (!Throwable.class.isAssignableFrom(method2.getReturnType())) return null;
        try {
            return (Throwable)method2.invoke((Object)throwable, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Deprecated
    public static String[] getDefaultCauseMethodNames() {
        return ArrayUtils.clone(CAUSE_METHOD_NAMES);
    }

    public static String getMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        String string2 = ClassUtils.getShortClassName(throwable, null);
        String string3 = throwable.getMessage();
        return string2 + ": " + StringUtils.defaultString(string3);
    }

    public static Throwable getRootCause(Throwable throwable) {
        List<Throwable> list = ExceptionUtils.getThrowableList(throwable);
        if (list.size() < 2) {
            return null;
        }
        return list.get(-1 + list.size());
    }

    public static String getRootCauseMessage(Throwable throwable) {
        Throwable throwable2 = ExceptionUtils.getRootCause(throwable);
        if (throwable2 == null) {
            throwable2 = throwable;
        }
        return ExceptionUtils.getMessage(throwable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] getRootCauseStackTrace(Throwable throwable) {
        if (throwable == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Throwable[] throwableArray = ExceptionUtils.getThrowables(throwable);
        int n2 = throwableArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = ExceptionUtils.getStackFrameList(throwableArray[n2 - 1]);
        int n3 = n2;
        block0: while (--n3 >= 0) {
            List<String> list2 = list;
            if (n3 != 0) {
                list = ExceptionUtils.getStackFrameList(throwableArray[n3 - 1]);
                ExceptionUtils.removeCommonFrames(list2, list);
            }
            if (n3 == n2 - 1) {
                arrayList.add(throwableArray[n3].toString());
            } else {
                arrayList.add(WRAPPED_MARKER + throwableArray[n3].toString());
            }
            int n4 = 0;
            while (true) {
                if (n4 >= list2.size()) continue block0;
                arrayList.add(list2.get(n4));
                ++n4;
            }
            break;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static List<String> getStackFrameList(Throwable throwable) {
        StringTokenizer stringTokenizer = new StringTokenizer(ExceptionUtils.getStackTrace(throwable), SystemUtils.LINE_SEPARATOR);
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf("at");
            if (n2 != -1 && string2.substring(0, n2).trim().isEmpty()) {
                bl2 = true;
                arrayList.add(string2);
                continue;
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    static String[] getStackFrames(String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SystemUtils.LINE_SEPARATOR);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getStackFrames(Throwable throwable) {
        if (throwable == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable));
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.getBuffer().toString();
    }

    public static int getThrowableCount(Throwable throwable) {
        return ExceptionUtils.getThrowableList(throwable).size();
    }

    public static List<Throwable> getThrowableList(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null && !arrayList.contains(throwable)) {
            arrayList.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return arrayList;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        List<Throwable> list = ExceptionUtils.getThrowableList(throwable);
        return list.toArray(new Throwable[list.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int indexOf(Throwable throwable, Class<?> clazz, int n2, boolean bl2) {
        int n3;
        Throwable[] throwableArray;
        if (throwable == null) return -1;
        if (clazz == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= (throwableArray = ExceptionUtils.getThrowables(throwable)).length) {
            return -1;
        }
        if (bl2) {
            n3 = n2;
            while (n3 < throwableArray.length) {
                if (clazz.isAssignableFrom(throwableArray[n3].getClass())) return n3;
                ++n3;
            }
            return -1;
        }
        n3 = n2;
        while (n3 < throwableArray.length) {
            if (clazz.equals(throwableArray[n3].getClass())) return n3;
            ++n3;
        }
        return -1;
    }

    public static int indexOfThrowable(Throwable throwable, Class<?> clazz) {
        return ExceptionUtils.indexOf(throwable, clazz, 0, false);
    }

    public static int indexOfThrowable(Throwable throwable, Class<?> clazz, int n2) {
        return ExceptionUtils.indexOf(throwable, clazz, n2, false);
    }

    public static int indexOfType(Throwable throwable, Class<?> clazz) {
        return ExceptionUtils.indexOf(throwable, clazz, 0, true);
    }

    public static int indexOfType(Throwable throwable, Class<?> clazz, int n2) {
        return ExceptionUtils.indexOf(throwable, clazz, n2, true);
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        ExceptionUtils.printRootCauseStackTrace(throwable, System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintStream printStream) {
        if (throwable == null) {
            return;
        }
        if (printStream == null) {
            throw new IllegalArgumentException("The PrintStream must not be null");
        }
        String[] stringArray = ExceptionUtils.getRootCauseStackTrace(throwable);
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            printStream.println(stringArray[i2]);
        }
        printStream.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintWriter printWriter) {
        if (throwable == null) {
            return;
        }
        if (printWriter == null) {
            throw new IllegalArgumentException("The PrintWriter must not be null");
        }
        String[] stringArray = ExceptionUtils.getRootCauseStackTrace(throwable);
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            printWriter.println(stringArray[i2]);
        }
        printWriter.flush();
    }

    public static void removeCommonFrames(List<String> list, List<String> list2) {
        if (list == null || list2 == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int n2 = -1 + list.size();
        for (int i2 = -1 + list2.size(); n2 >= 0 && i2 >= 0; --n2, --i2) {
            if (!list.get(n2).equals(list2.get(i2))) continue;
            list.remove(n2);
        }
    }
}

