/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String string2, Object object) {
        this.contextValues.add(new ImmutablePair<String, Object>(string2, object));
        return this;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public Set<String> getContextLabels() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator<Pair<String, Object>> iterator = this.contextValues.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next().getKey());
        }
        return hashSet;
    }

    @Override
    public List<Object> getContextValues(String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Pair<String, Object> pair : this.contextValues) {
            if (!StringUtils.equals(string2, pair.getKey())) continue;
            arrayList.add(pair.getValue());
        }
        return arrayList;
    }

    @Override
    public Object getFirstContextValue(String string2) {
        for (Pair<String, Object> pair : this.contextValues) {
            if (!StringUtils.equals(string2, pair.getKey())) continue;
            return pair.getValue();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getFormattedExceptionMessage(String string2) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        if (this.contextValues.size() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append("Exception Context:\n");
            int n2 = 0;
            for (Pair<String, Object> pair : this.contextValues) {
                stringBuilder.append("\t[");
                stringBuilder.append(++n2);
                stringBuilder.append(':');
                stringBuilder.append(pair.getKey());
                stringBuilder.append("=");
                Object object = pair.getValue();
                if (object == null) {
                    stringBuilder.append("null");
                } else {
                    String string3;
                    try {
                        String string4;
                        string3 = string4 = object.toString();
                    }
                    catch (Exception exception) {
                        string3 = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(exception);
                    }
                    stringBuilder.append(string3);
                }
                stringBuilder.append("]\n");
            }
            stringBuilder.append("---------------------------------");
        }
        return stringBuilder.toString();
    }

    @Override
    public DefaultExceptionContext setContextValue(String string2, Object object) {
        Iterator<Pair<String, Object>> iterator = this.contextValues.iterator();
        while (iterator.hasNext()) {
            if (!StringUtils.equals(string2, iterator.next().getKey())) continue;
            iterator.remove();
        }
        this.addContextValue(string2, object);
        return this;
    }
}

