/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.event;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.Validate;

public class EventListenerSupport<L>
implements Serializable {
    private static final long serialVersionUID = 3593265990380473632L;
    private List<L> listeners = new CopyOnWriteArrayList<L>();
    private transient L[] prototypeArray;
    private transient L proxy;

    private EventListenerSupport() {
    }

    public EventListenerSupport(Class<L> clazz) {
        this(clazz, Thread.currentThread().getContextClassLoader());
    }

    public EventListenerSupport(Class<L> clazz, ClassLoader classLoader) {
        this();
        Validate.notNull(clazz, "Listener interface cannot be null.", new Object[0]);
        Validate.notNull(classLoader, "ClassLoader cannot be null.", new Object[0]);
        boolean bl2 = clazz.isInterface();
        Object[] objectArray = new Object[]{clazz.getName()};
        Validate.isTrue(bl2, "Class {0} is not an interface", objectArray);
        super.initializeTransientFields(clazz, classLoader);
    }

    public static <T> EventListenerSupport<T> create(Class<T> clazz) {
        return new EventListenerSupport<T>(clazz);
    }

    private void createProxy(Class<L> clazz, ClassLoader classLoader) {
        this.proxy = clazz.cast(Proxy.newProxyInstance(classLoader, new Class[]{clazz}, this.createInvocationHandler()));
    }

    private void initializeTransientFields(Class<L> clazz, ClassLoader classLoader) {
        this.prototypeArray = (Object[])Array.newInstance(clazz, 0);
        this.createProxy(clazz, classLoader);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object[] objectArray = (Object[])objectInputStream.readObject();
        this.listeners = new CopyOnWriteArrayList<Object>(objectArray);
        this.initializeTransientFields(objectArray.getClass().getComponentType(), Thread.currentThread().getContextClassLoader());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ArrayList<L> arrayList = new ArrayList<L>();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(new ByteArrayOutputStream());
        for (L l2 : this.listeners) {
            try {
                objectOutputStream2.writeObject(l2);
                arrayList.add(l2);
            }
            catch (IOException iOException) {
                objectOutputStream2 = new ObjectOutputStream(new ByteArrayOutputStream());
            }
        }
        objectOutputStream.writeObject(arrayList.toArray(this.prototypeArray));
    }

    public void addListener(L l2) {
        Validate.notNull(l2, "Listener object cannot be null.", new Object[0]);
        this.listeners.add(l2);
    }

    protected InvocationHandler createInvocationHandler() {
        return new ProxyInvocationHandler();
    }

    public L fire() {
        return this.proxy;
    }

    int getListenerCount() {
        return this.listeners.size();
    }

    public L[] getListeners() {
        return this.listeners.toArray(this.prototypeArray);
    }

    public void removeListener(L l2) {
        Validate.notNull(l2, "Listener object cannot be null.", new Object[0]);
        this.listeners.remove(l2);
    }

    protected class ProxyInvocationHandler
    implements InvocationHandler {
        protected ProxyInvocationHandler() {
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Iterator iterator = EventListenerSupport.this.listeners.iterator();
            while (iterator.hasNext()) {
                method.invoke(iterator.next(), objectArray);
            }
            return null;
        }
    }
}

