/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TimedSemaphore {
    public static final int NO_LIMIT = 0;
    private static final int THREAD_POOL_SIZE = 1;
    private int acquireCount;
    private final ScheduledExecutorService executorService;
    private int lastCallsPerPeriod;
    private int limit;
    private final boolean ownExecutor;
    private final long period;
    private long periodCount;
    private boolean shutdown;
    private ScheduledFuture<?> task;
    private long totalAcquireCount;
    private final TimeUnit unit;

    public TimedSemaphore(long l2, TimeUnit timeUnit, int n2) {
        this(null, l2, timeUnit, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TimedSemaphore(ScheduledExecutorService scheduledExecutorService, long l2, TimeUnit timeUnit, int n2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Time period must be greater 0!");
        }
        this.period = l2;
        this.unit = timeUnit;
        if (scheduledExecutorService != null) {
            this.executorService = scheduledExecutorService;
            this.ownExecutor = false;
        } else {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
            scheduledThreadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.executorService = scheduledThreadPoolExecutor;
            this.ownExecutor = true;
        }
        this.setLimit(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquire() throws InterruptedException {
        synchronized (this) {
            boolean bl2;
            if (this.isShutdown()) {
                throw new IllegalStateException("TimedSemaphore is shut down!");
            }
            if (this.task == null) {
                this.task = this.startTimer();
            }
            do {
                bl2 = this.getLimit() <= 0 || this.acquireCount < this.getLimit();
                if (!bl2) {
                    this.wait();
                    continue;
                }
                this.acquireCount = 1 + this.acquireCount;
            } while (!bl2);
            return;
        }
    }

    void endOfPeriod() {
        synchronized (this) {
            this.lastCallsPerPeriod = this.acquireCount;
            this.totalAcquireCount += (long)this.acquireCount;
            this.periodCount = 1L + this.periodCount;
            this.acquireCount = 0;
            this.notifyAll();
            return;
        }
    }

    public int getAcquireCount() {
        synchronized (this) {
            int n2 = this.acquireCount;
            return n2;
        }
    }

    public int getAvailablePermits() {
        synchronized (this) {
            int n2 = this.getLimit();
            int n3 = this.getAcquireCount();
            int n4 = n2 - n3;
            return n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getAverageCallsPerPeriod() {
        synchronized (this) {
            block4: {
                long l2 = this.periodCount;
                if (l2 != 0L) break block4;
                return 0.0;
            }
            double d2 = this.totalAcquireCount;
            long l3 = this.periodCount;
            return d2 / (double)l3;
        }
    }

    protected ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    public int getLastAcquiresPerPeriod() {
        synchronized (this) {
            int n2 = this.lastCallsPerPeriod;
            return n2;
        }
    }

    public final int getLimit() {
        synchronized (this) {
            int n2 = this.limit;
            return n2;
        }
    }

    public long getPeriod() {
        return this.period;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public boolean isShutdown() {
        synchronized (this) {
            boolean bl2 = this.shutdown;
            return bl2;
        }
    }

    public final void setLimit(int n2) {
        synchronized (this) {
            this.limit = n2;
            return;
        }
    }

    public void shutdown() {
        synchronized (this) {
            if (!this.shutdown) {
                if (this.ownExecutor) {
                    this.getExecutorService().shutdownNow();
                }
                if (this.task != null) {
                    this.task.cancel(false);
                }
                this.shutdown = true;
            }
            return;
        }
    }

    protected ScheduledFuture<?> startTimer() {
        return this.getExecutorService().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TimedSemaphore.this.endOfPeriod();
            }
        }, this.getPeriod(), this.getPeriod(), this.getUnit());
    }
}

