/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;

public abstract class LazyInitializer<T>
implements ConcurrentInitializer<T> {
    private volatile T object;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T get() throws ConcurrentException {
        T t2 = this.object;
        if (t2 != null) {
            return t2;
        }
        synchronized (this) {
            T t3 = this.object;
            if (t3 == null) {
                this.object = t3 = this.initialize();
            }
            return t3;
        }
    }

    protected abstract T initialize() throws ConcurrentException;
}

