/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;

public class ConstantInitializer<T>
implements ConcurrentInitializer<T> {
    private static final String FMT_TO_STRING = "ConstantInitializer@%d [ object = %s ]";
    private final T object;

    public ConstantInitializer(T t2) {
        this.object = t2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConstantInitializer)) {
            return false;
        }
        ConstantInitializer constantInitializer = (ConstantInitializer)object;
        return ObjectUtils.equals(this.getObject(), constantInitializer.getObject());
    }

    @Override
    public T get() throws ConcurrentException {
        return this.getObject();
    }

    public final T getObject() {
        return this.object;
    }

    public int hashCode() {
        if (this.getObject() != null) {
            return this.getObject().hashCode();
        }
        return 0;
    }

    public String toString() {
        Object[] objectArray = new Object[]{System.identityHashCode(this), String.valueOf(this.getObject())};
        return String.format(FMT_TO_STRING, objectArray);
    }
}

