/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;

public class ConcurrentUtils {
    private ConcurrentUtils() {
    }

    static Throwable checkedException(Throwable throwable) {
        if (throwable != null && !(throwable instanceof RuntimeException) && !(throwable instanceof Error)) {
            return throwable;
        }
        throw new IllegalArgumentException("Not a checked exception: " + throwable);
    }

    public static <T> Future<T> constantFuture(T t2) {
        return new ConstantFuture<T>(t2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <K, V> V createIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) throws ConcurrentException {
        V v2;
        if (concurrentMap == null || concurrentInitializer == null) {
            v2 = null;
            return v2;
        } else {
            v2 = concurrentMap.get(k2);
            if (v2 != null) return v2;
            return ConcurrentUtils.putIfAbsent(concurrentMap, k2, concurrentInitializer.get());
        }
    }

    public static <K, V> V createIfAbsentUnchecked(ConcurrentMap<K, V> concurrentMap, K k2, ConcurrentInitializer<V> concurrentInitializer) {
        V v2;
        try {
            v2 = ConcurrentUtils.createIfAbsent(concurrentMap, k2, concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
        return v2;
    }

    public static ConcurrentException extractCause(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(executionException);
        return new ConcurrentException(executionException.getMessage(), executionException.getCause());
    }

    public static ConcurrentRuntimeException extractCauseUnchecked(ExecutionException executionException) {
        if (executionException == null || executionException.getCause() == null) {
            return null;
        }
        ConcurrentUtils.throwCause(executionException);
        return new ConcurrentRuntimeException(executionException.getMessage(), executionException.getCause());
    }

    public static void handleCause(ExecutionException executionException) throws ConcurrentException {
        ConcurrentException concurrentException = ConcurrentUtils.extractCause(executionException);
        if (concurrentException != null) {
            throw concurrentException;
        }
    }

    public static void handleCauseUnchecked(ExecutionException executionException) {
        ConcurrentRuntimeException concurrentRuntimeException = ConcurrentUtils.extractCauseUnchecked(executionException);
        if (concurrentRuntimeException != null) {
            throw concurrentRuntimeException;
        }
    }

    public static <T> T initialize(ConcurrentInitializer<T> concurrentInitializer) throws ConcurrentException {
        if (concurrentInitializer != null) {
            return concurrentInitializer.get();
        }
        return null;
    }

    public static <T> T initializeUnchecked(ConcurrentInitializer<T> concurrentInitializer) {
        T t2;
        try {
            t2 = ConcurrentUtils.initialize(concurrentInitializer);
        }
        catch (ConcurrentException concurrentException) {
            throw new ConcurrentRuntimeException(concurrentException.getCause());
        }
        return t2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> concurrentMap, K k2, V v2) {
        V v3;
        if (concurrentMap == null) {
            v3 = null;
            return v3;
        } else {
            v3 = concurrentMap.putIfAbsent(k2, v2);
            if (v3 != null) return v3;
            return v2;
        }
    }

    private static void throwCause(ExecutionException executionException) {
        if (executionException.getCause() instanceof RuntimeException) {
            throw (RuntimeException)executionException.getCause();
        }
        if (executionException.getCause() instanceof Error) {
            throw (Error)executionException.getCause();
        }
    }

    static final class ConstantFuture<T>
    implements Future<T> {
        private final T value;

        ConstantFuture(T t2) {
            this.value = t2;
        }

        @Override
        public boolean cancel(boolean bl2) {
            return false;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T get(long l2, TimeUnit timeUnit) {
            return this.value;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }
}

