/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;

public abstract class BackgroundInitializer<T>
implements ConcurrentInitializer<T> {
    private ExecutorService executor;
    private ExecutorService externalExecutor;
    private Future<T> future;

    protected BackgroundInitializer() {
        this(null);
    }

    protected BackgroundInitializer(ExecutorService executorService) {
        this.setExternalExecutor(executorService);
    }

    private ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.getTaskCount());
    }

    private Callable<T> createTask(ExecutorService executorService) {
        return new InitializationTask(executorService);
    }

    @Override
    public T get() throws ConcurrentException {
        T t2;
        try {
            t2 = this.getFuture().get();
        }
        catch (ExecutionException executionException) {
            ConcurrentUtils.handleCause(executionException);
            return null;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ConcurrentException(interruptedException);
        }
        return t2;
    }

    protected final ExecutorService getActiveExecutor() {
        synchronized (this) {
            ExecutorService executorService = this.executor;
            return executorService;
        }
    }

    public final ExecutorService getExternalExecutor() {
        synchronized (this) {
            ExecutorService executorService = this.externalExecutor;
            return executorService;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Future<T> getFuture() {
        synchronized (this) {
            if (this.future != null) return this.future;
            throw new IllegalStateException("start() must be called first!");
        }
    }

    protected int getTaskCount() {
        return 1;
    }

    protected abstract T initialize() throws Exception;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isStarted() {
        synchronized (this) {
            Future<T> future = this.future;
            if (future == null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void setExternalExecutor(ExecutorService executorService) {
        synchronized (this) {
            if (this.isStarted()) {
                throw new IllegalStateException("Cannot set ExecutorService after start()!");
            }
            this.externalExecutor = executorService;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean start() {
        synchronized (this) {
            ExecutorService executorService;
            if (this.isStarted()) return false;
            this.executor = this.getExternalExecutor();
            if (this.executor == null) {
                this.executor = executorService = this.createExecutor();
            } else {
                executorService = null;
            }
            this.future = this.executor.submit(this.createTask(executorService));
            return true;
        }
    }

    private class InitializationTask
    implements Callable<T> {
        private final ExecutorService execFinally;

        public InitializationTask(ExecutorService executorService) {
            this.execFinally = executorService;
        }

        @Override
        public T call() throws Exception {
            try {
                Object t2 = BackgroundInitializer.this.initialize();
                return t2;
            }
            finally {
                if (this.execFinally != null) {
                    this.execFinally.shutdown();
                }
            }
        }
    }
}

