/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SystemUtils;

public abstract class ToStringStyle
implements Serializable {
    public static final ToStringStyle DEFAULT_STYLE = new DefaultToStringStyle();
    public static final ToStringStyle MULTI_LINE_STYLE = new MultiLineToStringStyle();
    public static final ToStringStyle NO_FIELD_NAMES_STYLE = new NoFieldNameToStringStyle();
    private static final ThreadLocal<WeakHashMap<Object, Object>> REGISTRY;
    public static final ToStringStyle SHORT_PREFIX_STYLE;
    public static final ToStringStyle SIMPLE_STYLE;
    private static final long serialVersionUID = -2587890625525655916L;
    private boolean arrayContentDetail = true;
    private String arrayEnd = "}";
    private String arraySeparator = ",";
    private String arrayStart = "{";
    private String contentEnd = "]";
    private String contentStart = "[";
    private boolean defaultFullDetail = true;
    private String fieldNameValueSeparator = "=";
    private String fieldSeparator = ",";
    private boolean fieldSeparatorAtEnd = false;
    private boolean fieldSeparatorAtStart = false;
    private String nullText = "<null>";
    private String sizeEndText = ">";
    private String sizeStartText = "<size=";
    private String summaryObjectEndText = ">";
    private String summaryObjectStartText = "<";
    private boolean useClassName = true;
    private boolean useFieldNames = true;
    private boolean useIdentityHashCode = true;
    private boolean useShortClassName = false;

    static {
        SHORT_PREFIX_STYLE = new ShortPrefixToStringStyle();
        SIMPLE_STYLE = new SimpleToStringStyle();
        REGISTRY = new ThreadLocal();
    }

    protected ToStringStyle() {
    }

    static Map<Object, Object> getRegistry() {
        return REGISTRY.get();
    }

    static boolean isRegistered(Object object) {
        Map<Object, Object> map = ToStringStyle.getRegistry();
        return map != null && map.containsKey(object);
    }

    static void register(Object object) {
        if (object != null) {
            if (ToStringStyle.getRegistry() == null) {
                REGISTRY.set(new WeakHashMap());
            }
            ToStringStyle.getRegistry().put(object, null);
        }
    }

    static void unregister(Object object) {
        Map<Object, Object> map;
        if (object != null && (map = ToStringStyle.getRegistry()) != null) {
            map.remove(object);
            if (map.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    public void append(StringBuffer stringBuffer, String string2, byte by2) {
        this.appendFieldStart(stringBuffer, string2);
        this.appendDetail(stringBuffer, string2, by2);
        this.appendFieldEnd(stringBuffer, string2);
    }

    public void append(StringBuffer stringBuffer, String string2, char c2) {
        this.appendFieldStart(stringBuffer, string2);
        this.appendDetail(stringBuffer, string2, c2);
        this.appendFieldEnd(stringBuffer, string2);
    }

    public void append(StringBuffer stringBuffer, String string2, double d2) {
        this.appendFieldStart(stringBuffer, string2);
        this.appendDetail(stringBuffer, string2, d2);
        this.appendFieldEnd(stringBuffer, string2);
    }

    public void append(StringBuffer stringBuffer, String string2, float f2) {
        this.appendFieldStart(stringBuffer, string2);
        this.appendDetail(stringBuffer, string2, f2);
        this.appendFieldEnd(stringBuffer, string2);
    }

    public void append(StringBuffer stringBuffer, String string2, int n2) {
        this.appendFieldStart(stringBuffer, string2);
        this.appendDetail(stringBuffer, string2, n2);
        this.appendFieldEnd(stringBuffer, string2);
    }

    public void append(StringBuffer stringBuffer, String string2, long l2) {
        this.appendFieldStart(stringBuffer, string2);
        this.appendDetail(stringBuffer, string2, l2);
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, Object object, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (object == null) {
            this.appendNullText(stringBuffer, string2);
        } else {
            this.appendInternal(stringBuffer, string2, object, this.isFullDetail(bl2));
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    public void append(StringBuffer stringBuffer, String string2, short s2) {
        this.appendFieldStart(stringBuffer, string2);
        this.appendDetail(stringBuffer, string2, s2);
        this.appendFieldEnd(stringBuffer, string2);
    }

    public void append(StringBuffer stringBuffer, String string2, boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        this.appendDetail(stringBuffer, string2, bl2);
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, byte[] byArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (byArray == null) {
            this.appendNullText(stringBuffer, string2);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string2, byArray);
        } else {
            this.appendSummary(stringBuffer, string2, byArray);
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, char[] cArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (cArray == null) {
            this.appendNullText(stringBuffer, string2);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string2, cArray);
        } else {
            this.appendSummary(stringBuffer, string2, cArray);
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, double[] dArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (dArray == null) {
            this.appendNullText(stringBuffer, string2);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string2, dArray);
        } else {
            this.appendSummary(stringBuffer, string2, dArray);
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, float[] fArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (fArray == null) {
            this.appendNullText(stringBuffer, string2);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string2, fArray);
        } else {
            this.appendSummary(stringBuffer, string2, fArray);
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, int[] nArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (nArray == null) {
            this.appendNullText(stringBuffer, string2);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string2, nArray);
        } else {
            this.appendSummary(stringBuffer, string2, nArray);
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, long[] lArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (lArray == null) {
            this.appendNullText(stringBuffer, string2);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string2, lArray);
        } else {
            this.appendSummary(stringBuffer, string2, lArray);
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, Object[] objectArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (objectArray == null) {
            this.appendNullText(stringBuffer, string2);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string2, objectArray);
        } else {
            this.appendSummary(stringBuffer, string2, objectArray);
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, short[] sArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (sArray == null) {
            this.appendNullText(stringBuffer, string2);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string2, sArray);
        } else {
            this.appendSummary(stringBuffer, string2, sArray);
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(StringBuffer stringBuffer, String string2, boolean[] blArray, Boolean bl2) {
        this.appendFieldStart(stringBuffer, string2);
        if (blArray == null) {
            this.appendNullText(stringBuffer, string2);
        } else if (this.isFullDetail(bl2)) {
            this.appendDetail(stringBuffer, string2, blArray);
        } else {
            this.appendSummary(stringBuffer, string2, blArray);
        }
        this.appendFieldEnd(stringBuffer, string2);
    }

    protected void appendClassName(StringBuffer stringBuffer, Object object) {
        block3: {
            block2: {
                if (!this.useClassName || object == null) break block2;
                ToStringStyle.register(object);
                if (!this.useShortClassName) break block3;
                stringBuffer.append(this.getShortClassName(object.getClass()));
            }
            return;
        }
        stringBuffer.append(object.getClass().getName());
    }

    protected void appendContentEnd(StringBuffer stringBuffer) {
        stringBuffer.append(this.contentEnd);
    }

    protected void appendContentStart(StringBuffer stringBuffer) {
        stringBuffer.append(this.contentStart);
    }

    protected void appendCyclicObject(StringBuffer stringBuffer, String string2, Object object) {
        ObjectUtils.identityToString(stringBuffer, object);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, byte by2) {
        stringBuffer.append(by2);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, char c2) {
        stringBuffer.append(c2);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, double d2) {
        stringBuffer.append(d2);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, float f2) {
        stringBuffer.append(f2);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, int n2) {
        stringBuffer.append(n2);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, long l2) {
        stringBuffer.append(l2);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, Object object) {
        stringBuffer.append(object);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, Collection<?> collection) {
        stringBuffer.append(collection);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, Map<?, ?> map) {
        stringBuffer.append(map);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, short s2) {
        stringBuffer.append(s2);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, boolean bl2) {
        stringBuffer.append(bl2);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, byte[] byArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string2, byArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, char[] cArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string2, cArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, double[] dArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string2, dArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, float[] fArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string2, fArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, int[] nArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string2, nArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, long[] lArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string2, lArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void appendDetail(StringBuffer stringBuffer, String string2, Object[] objectArray) {
        stringBuffer.append(this.arrayStart);
        int n2 = 0;
        while (true) {
            if (n2 >= objectArray.length) {
                stringBuffer.append(this.arrayEnd);
                return;
            }
            Object object = objectArray[n2];
            if (n2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            if (object == null) {
                this.appendNullText(stringBuffer, string2);
            } else {
                this.appendInternal(stringBuffer, string2, object, this.arrayContentDetail);
            }
            ++n2;
        }
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, short[] sArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string2, sArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer stringBuffer, String string2, boolean[] blArray) {
        stringBuffer.append(this.arrayStart);
        for (int i2 = 0; i2 < blArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            this.appendDetail(stringBuffer, string2, blArray[i2]);
        }
        stringBuffer.append(this.arrayEnd);
    }

    public void appendEnd(StringBuffer stringBuffer, Object object) {
        if (!this.fieldSeparatorAtEnd) {
            this.removeLastFieldSeparator(stringBuffer);
        }
        this.appendContentEnd(stringBuffer);
        ToStringStyle.unregister(object);
    }

    protected void appendFieldEnd(StringBuffer stringBuffer, String string2) {
        this.appendFieldSeparator(stringBuffer);
    }

    protected void appendFieldSeparator(StringBuffer stringBuffer) {
        stringBuffer.append(this.fieldSeparator);
    }

    protected void appendFieldStart(StringBuffer stringBuffer, String string2) {
        if (this.useFieldNames && string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(this.fieldNameValueSeparator);
        }
    }

    protected void appendIdentityHashCode(StringBuffer stringBuffer, Object object) {
        if (this.isUseIdentityHashCode() && object != null) {
            ToStringStyle.register(object);
            stringBuffer.append('@');
            stringBuffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void appendInternal(StringBuffer stringBuffer, String string2, Object object, boolean bl2) {
        if (ToStringStyle.isRegistered(object) && !(object instanceof Number) && !(object instanceof Boolean) && !(object instanceof Character)) {
            this.appendCyclicObject(stringBuffer, string2, object);
            return;
        }
        ToStringStyle.register(object);
        try {
            if (object instanceof Collection) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (Collection)object);
                    return;
                }
                this.appendSummarySize(stringBuffer, string2, ((Collection)object).size());
                return;
            }
            if (object instanceof Map) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (Map)object);
                    return;
                }
                this.appendSummarySize(stringBuffer, string2, ((Map)object).size());
                return;
            }
            if (object instanceof long[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (long[])object);
                    return;
                }
                this.appendSummary(stringBuffer, string2, (long[])object);
                return;
            }
            if (object instanceof int[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (int[])object);
                    return;
                }
                this.appendSummary(stringBuffer, string2, (int[])object);
                return;
            }
            if (object instanceof short[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (short[])object);
                    return;
                }
                this.appendSummary(stringBuffer, string2, (short[])object);
                return;
            }
            if (object instanceof byte[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (byte[])object);
                    return;
                }
                this.appendSummary(stringBuffer, string2, (byte[])object);
                return;
            }
            if (object instanceof char[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (char[])object);
                    return;
                }
                this.appendSummary(stringBuffer, string2, (char[])object);
                return;
            }
            if (object instanceof double[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (double[])object);
                    return;
                }
                this.appendSummary(stringBuffer, string2, (double[])object);
                return;
            }
            if (object instanceof float[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (float[])object);
                    return;
                }
                this.appendSummary(stringBuffer, string2, (float[])object);
                return;
            }
            if (object instanceof boolean[]) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (boolean[])object);
                    return;
                }
                this.appendSummary(stringBuffer, string2, (boolean[])object);
                return;
            }
            if (object.getClass().isArray()) {
                if (bl2) {
                    this.appendDetail(stringBuffer, string2, (Object[])object);
                    return;
                }
                this.appendSummary(stringBuffer, string2, (Object[])object);
                return;
            }
            if (bl2) {
                this.appendDetail(stringBuffer, string2, object);
                return;
            }
            this.appendSummary(stringBuffer, string2, object);
            return;
        }
        finally {
            ToStringStyle.unregister(object);
        }
    }

    protected void appendNullText(StringBuffer stringBuffer, String string2) {
        stringBuffer.append(this.nullText);
    }

    public void appendStart(StringBuffer stringBuffer, Object object) {
        if (object != null) {
            this.appendClassName(stringBuffer, object);
            this.appendIdentityHashCode(stringBuffer, object);
            this.appendContentStart(stringBuffer);
            if (this.fieldSeparatorAtStart) {
                this.appendFieldSeparator(stringBuffer);
            }
        }
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, Object object) {
        stringBuffer.append(this.summaryObjectStartText);
        stringBuffer.append(this.getShortClassName(object.getClass()));
        stringBuffer.append(this.summaryObjectEndText);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, byte[] byArray) {
        this.appendSummarySize(stringBuffer, string2, byArray.length);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, char[] cArray) {
        this.appendSummarySize(stringBuffer, string2, cArray.length);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, double[] dArray) {
        this.appendSummarySize(stringBuffer, string2, dArray.length);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, float[] fArray) {
        this.appendSummarySize(stringBuffer, string2, fArray.length);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, int[] nArray) {
        this.appendSummarySize(stringBuffer, string2, nArray.length);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, long[] lArray) {
        this.appendSummarySize(stringBuffer, string2, lArray.length);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, Object[] objectArray) {
        this.appendSummarySize(stringBuffer, string2, objectArray.length);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, short[] sArray) {
        this.appendSummarySize(stringBuffer, string2, sArray.length);
    }

    protected void appendSummary(StringBuffer stringBuffer, String string2, boolean[] blArray) {
        this.appendSummarySize(stringBuffer, string2, blArray.length);
    }

    protected void appendSummarySize(StringBuffer stringBuffer, String string2, int n2) {
        stringBuffer.append(this.sizeStartText);
        stringBuffer.append(n2);
        stringBuffer.append(this.sizeEndText);
    }

    public void appendSuper(StringBuffer stringBuffer, String string2) {
        this.appendToString(stringBuffer, string2);
    }

    public void appendToString(StringBuffer stringBuffer, String string2) {
        int n2;
        int n3;
        if (string2 != null && (n3 = string2.indexOf(this.contentStart) + this.contentStart.length()) != (n2 = string2.lastIndexOf(this.contentEnd)) && n3 >= 0 && n2 >= 0) {
            String string3 = string2.substring(n3, n2);
            if (this.fieldSeparatorAtStart) {
                this.removeLastFieldSeparator(stringBuffer);
            }
            stringBuffer.append(string3);
            this.appendFieldSeparator(stringBuffer);
        }
    }

    protected String getArrayEnd() {
        return this.arrayEnd;
    }

    protected String getArraySeparator() {
        return this.arraySeparator;
    }

    protected String getArrayStart() {
        return this.arrayStart;
    }

    protected String getContentEnd() {
        return this.contentEnd;
    }

    protected String getContentStart() {
        return this.contentStart;
    }

    protected String getFieldNameValueSeparator() {
        return this.fieldNameValueSeparator;
    }

    protected String getFieldSeparator() {
        return this.fieldSeparator;
    }

    protected String getNullText() {
        return this.nullText;
    }

    protected String getShortClassName(Class<?> clazz) {
        return ClassUtils.getShortClassName(clazz);
    }

    protected String getSizeEndText() {
        return this.sizeEndText;
    }

    protected String getSizeStartText() {
        return this.sizeStartText;
    }

    protected String getSummaryObjectEndText() {
        return this.summaryObjectEndText;
    }

    protected String getSummaryObjectStartText() {
        return this.summaryObjectStartText;
    }

    protected boolean isArrayContentDetail() {
        return this.arrayContentDetail;
    }

    protected boolean isDefaultFullDetail() {
        return this.defaultFullDetail;
    }

    protected boolean isFieldSeparatorAtEnd() {
        return this.fieldSeparatorAtEnd;
    }

    protected boolean isFieldSeparatorAtStart() {
        return this.fieldSeparatorAtStart;
    }

    protected boolean isFullDetail(Boolean bl2) {
        if (bl2 == null) {
            return this.defaultFullDetail;
        }
        return bl2;
    }

    protected boolean isUseClassName() {
        return this.useClassName;
    }

    protected boolean isUseFieldNames() {
        return this.useFieldNames;
    }

    protected boolean isUseIdentityHashCode() {
        return this.useIdentityHashCode;
    }

    protected boolean isUseShortClassName() {
        return this.useShortClassName;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void reflectionAppendArrayDetail(StringBuffer stringBuffer, String string2, Object object) {
        stringBuffer.append(this.arrayStart);
        int n2 = Array.getLength(object);
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                stringBuffer.append(this.arrayEnd);
                return;
            }
            Object object2 = Array.get(object, n3);
            if (n3 > 0) {
                stringBuffer.append(this.arraySeparator);
            }
            if (object2 == null) {
                this.appendNullText(stringBuffer, string2);
            } else {
                this.appendInternal(stringBuffer, string2, object2, this.arrayContentDetail);
            }
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeLastFieldSeparator(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        int n3 = this.fieldSeparator.length();
        if (n2 <= 0) return;
        if (n3 <= 0) return;
        if (n2 < n3) return;
        boolean bl2 = true;
        int n4 = 0;
        while (true) {
            if (n4 < n3) {
                if (stringBuffer.charAt(n2 - 1 - n4) != this.fieldSeparator.charAt(n3 - 1 - n4)) {
                    return;
                }
            } else {
                if (!bl2) return;
                stringBuffer.setLength(n2 - n3);
                return;
            }
            ++n4;
        }
    }

    protected void setArrayContentDetail(boolean bl2) {
        this.arrayContentDetail = bl2;
    }

    protected void setArrayEnd(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.arrayEnd = string2;
    }

    protected void setArraySeparator(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.arraySeparator = string2;
    }

    protected void setArrayStart(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.arrayStart = string2;
    }

    protected void setContentEnd(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.contentEnd = string2;
    }

    protected void setContentStart(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.contentStart = string2;
    }

    protected void setDefaultFullDetail(boolean bl2) {
        this.defaultFullDetail = bl2;
    }

    protected void setFieldNameValueSeparator(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.fieldNameValueSeparator = string2;
    }

    protected void setFieldSeparator(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.fieldSeparator = string2;
    }

    protected void setFieldSeparatorAtEnd(boolean bl2) {
        this.fieldSeparatorAtEnd = bl2;
    }

    protected void setFieldSeparatorAtStart(boolean bl2) {
        this.fieldSeparatorAtStart = bl2;
    }

    protected void setNullText(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.nullText = string2;
    }

    protected void setSizeEndText(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.sizeEndText = string2;
    }

    protected void setSizeStartText(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.sizeStartText = string2;
    }

    protected void setSummaryObjectEndText(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.summaryObjectEndText = string2;
    }

    protected void setSummaryObjectStartText(String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.summaryObjectStartText = string2;
    }

    protected void setUseClassName(boolean bl2) {
        this.useClassName = bl2;
    }

    protected void setUseFieldNames(boolean bl2) {
        this.useFieldNames = bl2;
    }

    protected void setUseIdentityHashCode(boolean bl2) {
        this.useIdentityHashCode = bl2;
    }

    protected void setUseShortClassName(boolean bl2) {
        this.useShortClassName = bl2;
    }

    private static final class DefaultToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        DefaultToStringStyle() {
        }

        private Object readResolve() {
            return DEFAULT_STYLE;
        }
    }

    private static final class MultiLineToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        MultiLineToStringStyle() {
            this.setContentStart("[");
            this.setFieldSeparator(SystemUtils.LINE_SEPARATOR + "  ");
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd(SystemUtils.LINE_SEPARATOR + "]");
        }

        private Object readResolve() {
            return MULTI_LINE_STYLE;
        }
    }

    private static final class NoFieldNameToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        NoFieldNameToStringStyle() {
            this.setUseFieldNames(false);
        }

        private Object readResolve() {
            return NO_FIELD_NAMES_STYLE;
        }
    }

    private static final class ShortPrefixToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        ShortPrefixToStringStyle() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
        }

        private Object readResolve() {
            return SHORT_PREFIX_STYLE;
        }
    }

    private static final class SimpleToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        SimpleToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setUseFieldNames(false);
            this.setContentStart("");
            this.setContentEnd("");
        }

        private Object readResolve() {
            return SIMPLE_STYLE;
        }
    }
}

