/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ToStringBuilder
implements Builder<String> {
    private static volatile ToStringStyle defaultStyle = ToStringStyle.DEFAULT_STYLE;
    private final StringBuffer buffer;
    private final Object object;
    private final ToStringStyle style;

    public ToStringBuilder(Object object) {
        this(object, null, null);
    }

    public ToStringBuilder(Object object, ToStringStyle toStringStyle) {
        this(object, toStringStyle, null);
    }

    public ToStringBuilder(Object object, ToStringStyle toStringStyle, StringBuffer stringBuffer) {
        if (toStringStyle == null) {
            toStringStyle = ToStringBuilder.getDefaultStyle();
        }
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(512);
        }
        this.buffer = stringBuffer;
        this.style = toStringStyle;
        this.object = object;
        toStringStyle.appendStart(stringBuffer, object);
    }

    public static ToStringStyle getDefaultStyle() {
        return defaultStyle;
    }

    public static String reflectionToString(Object object) {
        return ReflectionToStringBuilder.toString(object);
    }

    public static String reflectionToString(Object object, ToStringStyle toStringStyle) {
        return ReflectionToStringBuilder.toString(object, toStringStyle);
    }

    public static String reflectionToString(Object object, ToStringStyle toStringStyle, boolean bl2) {
        return ReflectionToStringBuilder.toString(object, toStringStyle, bl2, false, null);
    }

    public static <T> String reflectionToString(T t2, ToStringStyle toStringStyle, boolean bl2, Class<? super T> clazz) {
        return ReflectionToStringBuilder.toString(t2, toStringStyle, bl2, false, clazz);
    }

    public static void setDefaultStyle(ToStringStyle toStringStyle) {
        if (toStringStyle == null) {
            throw new IllegalArgumentException("The style must not be null");
        }
        defaultStyle = toStringStyle;
    }

    public ToStringBuilder append(byte by2) {
        this.style.append(this.buffer, (String)null, by2);
        return this;
    }

    public ToStringBuilder append(char c2) {
        this.style.append(this.buffer, (String)null, c2);
        return this;
    }

    public ToStringBuilder append(double d2) {
        this.style.append(this.buffer, null, d2);
        return this;
    }

    public ToStringBuilder append(float f2) {
        this.style.append(this.buffer, (String)null, f2);
        return this;
    }

    public ToStringBuilder append(int n2) {
        this.style.append(this.buffer, (String)null, n2);
        return this;
    }

    public ToStringBuilder append(long l2) {
        this.style.append(this.buffer, (String)null, l2);
        return this;
    }

    public ToStringBuilder append(Object object) {
        this.style.append(this.buffer, null, object, null);
        return this;
    }

    public ToStringBuilder append(String string2, byte by2) {
        this.style.append(this.buffer, string2, by2);
        return this;
    }

    public ToStringBuilder append(String string2, char c2) {
        this.style.append(this.buffer, string2, c2);
        return this;
    }

    public ToStringBuilder append(String string2, double d2) {
        this.style.append(this.buffer, string2, d2);
        return this;
    }

    public ToStringBuilder append(String string2, float f2) {
        this.style.append(this.buffer, string2, f2);
        return this;
    }

    public ToStringBuilder append(String string2, int n2) {
        this.style.append(this.buffer, string2, n2);
        return this;
    }

    public ToStringBuilder append(String string2, long l2) {
        this.style.append(this.buffer, string2, l2);
        return this;
    }

    public ToStringBuilder append(String string2, Object object) {
        this.style.append(this.buffer, string2, object, null);
        return this;
    }

    public ToStringBuilder append(String string2, Object object, boolean bl2) {
        this.style.append(this.buffer, string2, object, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(String string2, short s2) {
        this.style.append(this.buffer, string2, s2);
        return this;
    }

    public ToStringBuilder append(String string2, boolean bl2) {
        this.style.append(this.buffer, string2, bl2);
        return this;
    }

    public ToStringBuilder append(String string2, byte[] byArray) {
        this.style.append(this.buffer, string2, byArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String string2, byte[] byArray, boolean bl2) {
        this.style.append(this.buffer, string2, byArray, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(String string2, char[] cArray) {
        this.style.append(this.buffer, string2, cArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String string2, char[] cArray, boolean bl2) {
        this.style.append(this.buffer, string2, cArray, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(String string2, double[] dArray) {
        this.style.append(this.buffer, string2, dArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String string2, double[] dArray, boolean bl2) {
        this.style.append(this.buffer, string2, dArray, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(String string2, float[] fArray) {
        this.style.append(this.buffer, string2, fArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String string2, float[] fArray, boolean bl2) {
        this.style.append(this.buffer, string2, fArray, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(String string2, int[] nArray) {
        this.style.append(this.buffer, string2, nArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String string2, int[] nArray, boolean bl2) {
        this.style.append(this.buffer, string2, nArray, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(String string2, long[] lArray) {
        this.style.append(this.buffer, string2, lArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String string2, long[] lArray, boolean bl2) {
        this.style.append(this.buffer, string2, lArray, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(String string2, Object[] objectArray) {
        this.style.append(this.buffer, string2, objectArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String string2, Object[] objectArray, boolean bl2) {
        this.style.append(this.buffer, string2, objectArray, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(String string2, short[] sArray) {
        this.style.append(this.buffer, string2, sArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String string2, short[] sArray, boolean bl2) {
        this.style.append(this.buffer, string2, sArray, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(String string2, boolean[] blArray) {
        this.style.append(this.buffer, string2, blArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(String string2, boolean[] blArray, boolean bl2) {
        this.style.append(this.buffer, string2, blArray, (Boolean)bl2);
        return this;
    }

    public ToStringBuilder append(short s2) {
        this.style.append(this.buffer, (String)null, s2);
        return this;
    }

    public ToStringBuilder append(boolean bl2) {
        this.style.append(this.buffer, null, bl2);
        return this;
    }

    public ToStringBuilder append(byte[] byArray) {
        this.style.append(this.buffer, (String)null, byArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(char[] cArray) {
        this.style.append(this.buffer, (String)null, cArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(double[] dArray) {
        this.style.append(this.buffer, (String)null, dArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(float[] fArray) {
        this.style.append(this.buffer, (String)null, fArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(int[] nArray) {
        this.style.append(this.buffer, (String)null, nArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(long[] lArray) {
        this.style.append(this.buffer, (String)null, lArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(Object[] objectArray) {
        this.style.append(this.buffer, (String)null, objectArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(short[] sArray) {
        this.style.append(this.buffer, (String)null, sArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder append(boolean[] blArray) {
        this.style.append(this.buffer, (String)null, blArray, (Boolean)null);
        return this;
    }

    public ToStringBuilder appendAsObjectToString(Object object) {
        ObjectUtils.identityToString(this.getStringBuffer(), object);
        return this;
    }

    public ToStringBuilder appendSuper(String string2) {
        if (string2 != null) {
            this.style.appendSuper(this.buffer, string2);
        }
        return this;
    }

    public ToStringBuilder appendToString(String string2) {
        if (string2 != null) {
            this.style.appendToString(this.buffer, string2);
        }
        return this;
    }

    @Override
    public String build() {
        return this.toString();
    }

    public Object getObject() {
        return this.object;
    }

    public StringBuffer getStringBuffer() {
        return this.buffer;
    }

    public ToStringStyle getStyle() {
        return this.style;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        if (this.getObject() == null) {
            this.getStringBuffer().append(this.getStyle().getNullText());
            return this.getStringBuffer().toString();
        }
        this.style.appendEnd(this.getStringBuffer(), this.getObject());
        return this.getStringBuffer().toString();
    }
}

