/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.IDKey;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class HashCodeBuilder
implements Builder<Integer> {
    private static final ThreadLocal<Set<IDKey>> REGISTRY = new ThreadLocal();
    private final int iConstant;
    private int iTotal = 0;

    public HashCodeBuilder() {
        this.iConstant = 37;
        this.iTotal = 17;
    }

    public HashCodeBuilder(int n2, int n3) {
        if (n2 % 2 == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires an odd initial value");
        }
        if (n3 % 2 == 0) {
            throw new IllegalArgumentException("HashCodeBuilder requires an odd multiplier");
        }
        this.iConstant = n3;
        this.iTotal = n2;
    }

    static Set<IDKey> getRegistry() {
        return REGISTRY.get();
    }

    static boolean isRegistered(Object object) {
        Set<IDKey> set = HashCodeBuilder.getRegistry();
        return set != null && set.contains(new IDKey(object));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static void reflectionAppend(Object object, Class<?> clazz, HashCodeBuilder hashCodeBuilder, boolean bl2, String[] stringArray) {
        if (HashCodeBuilder.isRegistered(object)) {
            return;
        }
        HashCodeBuilder.register(object);
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            boolean bl3;
            if (ArrayUtils.contains(stringArray, ((Field)accessibleObject).getName()) || ((Field)accessibleObject).getName().indexOf(36) != -1 || !bl2 && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || (bl3 = Modifier.isStatic(((Field)accessibleObject).getModifiers()))) continue;
            try {
                hashCodeBuilder.append(((Field)accessibleObject).get(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
                catch (Throwable throwable) {
                    HashCodeBuilder.unregister(object);
                    throw throwable;
                }
            }
        }
        HashCodeBuilder.unregister(object);
    }

    public static int reflectionHashCode(int n2, int n3, Object object) {
        return HashCodeBuilder.reflectionHashCode(n2, n3, object, false, null, new String[0]);
    }

    public static int reflectionHashCode(int n2, int n3, Object object, boolean bl2) {
        return HashCodeBuilder.reflectionHashCode(n2, n3, object, bl2, null, new String[0]);
    }

    public static <T> int reflectionHashCode(int n2, int n3, T t2, boolean bl2, Class<? super T> clazz, String ... stringArray) {
        Class<?> clazz2;
        if (t2 == null) {
            throw new IllegalArgumentException("The object to build a hash code for must not be null");
        }
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(n2, n3);
        HashCodeBuilder.reflectionAppend(t2, clazz2, hashCodeBuilder, bl2, stringArray);
        for (clazz2 = t2.getClass(); clazz2.getSuperclass() != null && clazz2 != clazz; clazz2 = clazz2.getSuperclass()) {
            HashCodeBuilder.reflectionAppend(t2, clazz2, hashCodeBuilder, bl2, stringArray);
        }
        return hashCodeBuilder.toHashCode();
    }

    public static int reflectionHashCode(Object object, Collection<String> collection) {
        return HashCodeBuilder.reflectionHashCode(object, ReflectionToStringBuilder.toNoNullStringArray(collection));
    }

    public static int reflectionHashCode(Object object, boolean bl2) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, bl2, null, new String[0]);
    }

    public static int reflectionHashCode(Object object, String ... stringArray) {
        return HashCodeBuilder.reflectionHashCode(17, 37, object, false, null, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void register(Object object) {
        synchronized (HashCodeBuilder.class) {
            if (HashCodeBuilder.getRegistry() == null) {
                REGISTRY.set(new HashSet());
            }
        }
        HashCodeBuilder.getRegistry().add(new IDKey(object));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void unregister(Object object) {
        Set<IDKey> set = HashCodeBuilder.getRegistry();
        if (set == null) {
            return;
        }
        set.remove(new IDKey(object));
        synchronized (HashCodeBuilder.class) {
            Set<IDKey> set2 = HashCodeBuilder.getRegistry();
            if (set2 != null && set2.isEmpty()) {
                REGISTRY.remove();
            }
            return;
        }
    }

    public HashCodeBuilder append(byte by2) {
        this.iTotal = by2 + this.iTotal * this.iConstant;
        return this;
    }

    public HashCodeBuilder append(char c2) {
        this.iTotal = c2 + this.iTotal * this.iConstant;
        return this;
    }

    public HashCodeBuilder append(double d2) {
        return this.append(Double.doubleToLongBits(d2));
    }

    public HashCodeBuilder append(float f2) {
        this.iTotal = this.iTotal * this.iConstant + Float.floatToIntBits(f2);
        return this;
    }

    public HashCodeBuilder append(int n2) {
        this.iTotal = n2 + this.iTotal * this.iConstant;
        return this;
    }

    public HashCodeBuilder append(long l2) {
        this.iTotal = this.iTotal * this.iConstant + (int)(l2 ^ l2 >> 32);
        return this;
    }

    public HashCodeBuilder append(Object object) {
        if (object == null) {
            this.iTotal *= this.iConstant;
            return this;
        }
        if (object.getClass().isArray()) {
            if (object instanceof long[]) {
                this.append((long[])object);
                return this;
            }
            if (object instanceof int[]) {
                this.append((int[])object);
                return this;
            }
            if (object instanceof short[]) {
                this.append((short[])object);
                return this;
            }
            if (object instanceof char[]) {
                this.append((char[])object);
                return this;
            }
            if (object instanceof byte[]) {
                this.append((byte[])object);
                return this;
            }
            if (object instanceof double[]) {
                this.append((double[])object);
                return this;
            }
            if (object instanceof float[]) {
                this.append((float[])object);
                return this;
            }
            if (object instanceof boolean[]) {
                this.append((boolean[])object);
                return this;
            }
            this.append((Object[])object);
            return this;
        }
        this.iTotal = this.iTotal * this.iConstant + object.hashCode();
        return this;
    }

    public HashCodeBuilder append(short s2) {
        this.iTotal = s2 + this.iTotal * this.iConstant;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(boolean bl2) {
        int n2 = this.iTotal * this.iConstant;
        int n3 = bl2 ? 0 : 1;
        this.iTotal = n3 + n2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(byte[] byArray) {
        if (byArray == null) {
            this.iTotal *= this.iConstant;
            return this;
        } else {
            int n2 = byArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(byArray[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(char[] cArray) {
        if (cArray == null) {
            this.iTotal *= this.iConstant;
            return this;
        } else {
            int n2 = cArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(cArray[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(double[] dArray) {
        if (dArray == null) {
            this.iTotal *= this.iConstant;
            return this;
        } else {
            int n2 = dArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(dArray[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(float[] fArray) {
        if (fArray == null) {
            this.iTotal *= this.iConstant;
            return this;
        } else {
            int n2 = fArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(fArray[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(int[] nArray) {
        if (nArray == null) {
            this.iTotal *= this.iConstant;
            return this;
        } else {
            int n2 = nArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(nArray[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(long[] lArray) {
        if (lArray == null) {
            this.iTotal *= this.iConstant;
            return this;
        } else {
            int n2 = lArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(lArray[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(Object[] objectArray) {
        if (objectArray == null) {
            this.iTotal *= this.iConstant;
            return this;
        } else {
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(objectArray[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(short[] sArray) {
        if (sArray == null) {
            this.iTotal *= this.iConstant;
            return this;
        } else {
            int n2 = sArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(sArray[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashCodeBuilder append(boolean[] blArray) {
        if (blArray == null) {
            this.iTotal *= this.iConstant;
            return this;
        } else {
            int n2 = blArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.append(blArray[i2]);
            }
        }
        return this;
    }

    public HashCodeBuilder appendSuper(int n2) {
        this.iTotal = n2 + this.iTotal * this.iConstant;
        return this;
    }

    @Override
    public Integer build() {
        return this.toHashCode();
    }

    public int hashCode() {
        return this.toHashCode();
    }

    public int toHashCode() {
        return this.iTotal;
    }
}

