/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.IDKey;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class EqualsBuilder
implements Builder<Boolean> {
    private static final ThreadLocal<Set<Pair<IDKey, IDKey>>> REGISTRY = new ThreadLocal();
    private boolean isEquals = true;

    static Pair<IDKey, IDKey> getRegisterPair(Object object, Object object2) {
        return Pair.of(new IDKey(object), new IDKey(object2));
    }

    static Set<Pair<IDKey, IDKey>> getRegistry() {
        return REGISTRY.get();
    }

    static boolean isRegistered(Object object, Object object2) {
        Set<Pair<IDKey, IDKey>> set = EqualsBuilder.getRegistry();
        Pair<IDKey, IDKey> pair = EqualsBuilder.getRegisterPair(object, object2);
        Pair<IDKey, IDKey> pair2 = Pair.of(pair.getLeft(), pair.getRight());
        return set != null && (set.contains(pair) || set.contains(pair2));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static void reflectionAppend(Object object, Object object2, Class<?> clazz, EqualsBuilder equalsBuilder, boolean bl2, String[] stringArray) {
        if (EqualsBuilder.isRegistered(object, object2)) {
            return;
        }
        EqualsBuilder.register(object, object2);
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        for (int i2 = 0; i2 < accessibleObjectArray.length && equalsBuilder.isEquals; ++i2) {
            boolean bl3;
            AccessibleObject accessibleObject = accessibleObjectArray[i2];
            if (ArrayUtils.contains(stringArray, ((Field)accessibleObject).getName()) || ((Field)accessibleObject).getName().indexOf(36) != -1 || !bl2 && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || (bl3 = Modifier.isStatic(((Field)accessibleObject).getModifiers()))) continue;
            try {
                equalsBuilder.append(((Field)accessibleObject).get(object), ((Field)accessibleObject).get(object2));
            }
            catch (IllegalAccessException illegalAccessException) {
                try {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
                catch (Throwable throwable) {
                    EqualsBuilder.unregister(object, object2);
                    throw throwable;
                }
            }
        }
        EqualsBuilder.unregister(object, object2);
    }

    public static boolean reflectionEquals(Object object, Object object2, Collection<String> collection) {
        return EqualsBuilder.reflectionEquals(object, object2, ReflectionToStringBuilder.toNoNullStringArray(collection));
    }

    public static boolean reflectionEquals(Object object, Object object2, boolean bl2) {
        return EqualsBuilder.reflectionEquals(object, object2, bl2, null, new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean reflectionEquals(Object object, Object object2, boolean bl2, Class<?> clazz, String ... stringArray) {
        Class<?> clazz2;
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz3 = object.getClass();
        Class<?> clazz4 = object2.getClass();
        if (clazz3.isInstance(object2)) {
            clazz2 = clazz3;
            if (!clazz4.isInstance(object)) {
                clazz2 = clazz4;
            }
        } else {
            if (!clazz4.isInstance(object)) {
                return false;
            }
            clazz2 = clazz4;
            if (!clazz3.isInstance(object2)) {
                clazz2 = clazz3;
            }
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        try {
            if (clazz2.isArray()) {
                equalsBuilder.append(object, object2);
                return equalsBuilder.isEquals();
            }
            EqualsBuilder.reflectionAppend(object, object2, clazz2, equalsBuilder, bl2, stringArray);
            while (true) {
                if (clazz2.getSuperclass() == null || clazz2 == clazz) {
                    return equalsBuilder.isEquals();
                }
                clazz2 = clazz2.getSuperclass();
                EqualsBuilder.reflectionAppend(object, object2, clazz2, equalsBuilder, bl2, stringArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean reflectionEquals(Object object, Object object2, String ... stringArray) {
        return EqualsBuilder.reflectionEquals(object, object2, false, null, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void register(Object object, Object object2) {
        synchronized (EqualsBuilder.class) {
            if (EqualsBuilder.getRegistry() == null) {
                REGISTRY.set(new HashSet());
            }
        }
        EqualsBuilder.getRegistry().add(EqualsBuilder.getRegisterPair(object, object2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void unregister(Object object, Object object2) {
        Set<Pair<IDKey, IDKey>> set = EqualsBuilder.getRegistry();
        if (set == null) {
            return;
        }
        set.remove(EqualsBuilder.getRegisterPair(object, object2));
        synchronized (EqualsBuilder.class) {
            Set<Pair<IDKey, IDKey>> set2 = EqualsBuilder.getRegistry();
            if (set2 != null && set2.isEmpty()) {
                REGISTRY.remove();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(byte by2, byte by3) {
        if (!this.isEquals) {
            return this;
        }
        boolean bl2 = by2 == by3;
        this.isEquals = bl2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(char c2, char c3) {
        if (!this.isEquals) {
            return this;
        }
        boolean bl2 = c2 == c3;
        this.isEquals = bl2;
        return this;
    }

    public EqualsBuilder append(double d2, double d3) {
        if (!this.isEquals) {
            return this;
        }
        return this.append(Double.doubleToLongBits(d2), Double.doubleToLongBits(d3));
    }

    public EqualsBuilder append(float f2, float f3) {
        if (!this.isEquals) {
            return this;
        }
        return this.append(Float.floatToIntBits(f2), Float.floatToIntBits(f3));
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(int n2, int n3) {
        if (!this.isEquals) {
            return this;
        }
        boolean bl2 = n2 == n3;
        this.isEquals = bl2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(long l2, long l3) {
        if (!this.isEquals) {
            return this;
        }
        boolean bl2 = l2 == l3;
        this.isEquals = bl2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(Object object, Object object2) {
        if (!this.isEquals || object == object2) {
            return this;
        }
        if (object == null || object2 == null) {
            this.setEquals(false);
            return this;
        }
        if (!object.getClass().isArray()) {
            this.isEquals = object.equals(object2);
            return this;
        }
        if (object.getClass() != object2.getClass()) {
            this.setEquals(false);
            return this;
        }
        if (object instanceof long[]) {
            this.append((long[])object, (long[])object2);
            return this;
        }
        if (object instanceof int[]) {
            this.append((int[])object, (int[])object2);
            return this;
        }
        if (object instanceof short[]) {
            this.append((short[])object, (short[])object2);
            return this;
        }
        if (object instanceof char[]) {
            this.append((char[])object, (char[])object2);
            return this;
        }
        if (object instanceof byte[]) {
            this.append((byte[])object, (byte[])object2);
            return this;
        }
        if (object instanceof double[]) {
            this.append((double[])object, (double[])object2);
            return this;
        }
        if (object instanceof float[]) {
            this.append((float[])object, (float[])object2);
            return this;
        }
        if (object instanceof boolean[]) {
            this.append((boolean[])object, (boolean[])object2);
            return this;
        }
        this.append((Object[])object, (Object[])object2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(short s2, short s3) {
        if (!this.isEquals) {
            return this;
        }
        boolean bl2 = s2 == s3;
        this.isEquals = bl2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(boolean bl2, boolean bl3) {
        if (!this.isEquals) {
            return this;
        }
        boolean bl4 = bl2 == bl3;
        this.isEquals = bl4;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(byte[] byArray, byte[] byArray2) {
        if (this.isEquals && byArray != byArray2) {
            if (byArray == null || byArray2 == null) {
                this.setEquals(false);
                return this;
            }
            if (byArray.length != byArray2.length) {
                this.setEquals(false);
                return this;
            }
            for (int i2 = 0; i2 < byArray.length && this.isEquals; ++i2) {
                this.append(byArray[i2], byArray2[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(char[] cArray, char[] cArray2) {
        if (this.isEquals && cArray != cArray2) {
            if (cArray == null || cArray2 == null) {
                this.setEquals(false);
                return this;
            }
            if (cArray.length != cArray2.length) {
                this.setEquals(false);
                return this;
            }
            for (int i2 = 0; i2 < cArray.length && this.isEquals; ++i2) {
                this.append(cArray[i2], cArray2[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(double[] dArray, double[] dArray2) {
        if (this.isEquals && dArray != dArray2) {
            if (dArray == null || dArray2 == null) {
                this.setEquals(false);
                return this;
            }
            if (dArray.length != dArray2.length) {
                this.setEquals(false);
                return this;
            }
            for (int i2 = 0; i2 < dArray.length && this.isEquals; ++i2) {
                this.append(dArray[i2], dArray2[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(float[] fArray, float[] fArray2) {
        if (this.isEquals && fArray != fArray2) {
            if (fArray == null || fArray2 == null) {
                this.setEquals(false);
                return this;
            }
            if (fArray.length != fArray2.length) {
                this.setEquals(false);
                return this;
            }
            for (int i2 = 0; i2 < fArray.length && this.isEquals; ++i2) {
                this.append(fArray[i2], fArray2[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(int[] nArray, int[] nArray2) {
        if (this.isEquals && nArray != nArray2) {
            if (nArray == null || nArray2 == null) {
                this.setEquals(false);
                return this;
            }
            if (nArray.length != nArray2.length) {
                this.setEquals(false);
                return this;
            }
            for (int i2 = 0; i2 < nArray.length && this.isEquals; ++i2) {
                this.append(nArray[i2], nArray2[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(long[] lArray, long[] lArray2) {
        if (this.isEquals && lArray != lArray2) {
            if (lArray == null || lArray2 == null) {
                this.setEquals(false);
                return this;
            }
            if (lArray.length != lArray2.length) {
                this.setEquals(false);
                return this;
            }
            for (int i2 = 0; i2 < lArray.length && this.isEquals; ++i2) {
                this.append(lArray[i2], lArray2[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(Object[] objectArray, Object[] objectArray2) {
        if (this.isEquals && objectArray != objectArray2) {
            if (objectArray == null || objectArray2 == null) {
                this.setEquals(false);
                return this;
            }
            if (objectArray.length != objectArray2.length) {
                this.setEquals(false);
                return this;
            }
            for (int i2 = 0; i2 < objectArray.length && this.isEquals; ++i2) {
                this.append(objectArray[i2], objectArray2[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(short[] sArray, short[] sArray2) {
        if (this.isEquals && sArray != sArray2) {
            if (sArray == null || sArray2 == null) {
                this.setEquals(false);
                return this;
            }
            if (sArray.length != sArray2.length) {
                this.setEquals(false);
                return this;
            }
            for (int i2 = 0; i2 < sArray.length && this.isEquals; ++i2) {
                this.append(sArray[i2], sArray2[i2]);
            }
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public EqualsBuilder append(boolean[] blArray, boolean[] blArray2) {
        if (this.isEquals && blArray != blArray2) {
            if (blArray == null || blArray2 == null) {
                this.setEquals(false);
                return this;
            }
            if (blArray.length != blArray2.length) {
                this.setEquals(false);
                return this;
            }
            for (int i2 = 0; i2 < blArray.length && this.isEquals; ++i2) {
                this.append(blArray[i2], blArray2[i2]);
            }
        }
        return this;
    }

    public EqualsBuilder appendSuper(boolean bl2) {
        if (!this.isEquals) {
            return this;
        }
        this.isEquals = bl2;
        return this;
    }

    @Override
    public Boolean build() {
        return this.isEquals();
    }

    public boolean isEquals() {
        return this.isEquals;
    }

    public void reset() {
        this.isEquals = true;
    }

    protected void setEquals(boolean bl2) {
        this.isEquals = bl2;
    }
}

