/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.File;
import org.apache.commons.lang3.JavaVersion;

public class SystemUtils {
    public static final String AWT_TOOLKIT;
    public static final String FILE_ENCODING;
    public static final String FILE_SEPARATOR;
    public static final boolean IS_JAVA_1_1 = false;
    public static final boolean IS_JAVA_1_2 = false;
    public static final boolean IS_JAVA_1_3 = false;
    public static final boolean IS_JAVA_1_4 = false;
    public static final boolean IS_JAVA_1_5 = false;
    public static final boolean IS_JAVA_1_6 = false;
    public static final boolean IS_JAVA_1_7 = false;
    public static final boolean IS_OS_AIX = false;
    public static final boolean IS_OS_FREE_BSD = false;
    public static final boolean IS_OS_HP_UX = false;
    public static final boolean IS_OS_IRIX = false;
    public static final boolean IS_OS_LINUX = false;
    public static final boolean IS_OS_MAC = false;
    public static final boolean IS_OS_MAC_OSX = false;
    public static final boolean IS_OS_NET_BSD = false;
    public static final boolean IS_OS_OPEN_BSD = false;
    public static final boolean IS_OS_OS2 = false;
    public static final boolean IS_OS_SOLARIS = false;
    public static final boolean IS_OS_SUN_OS = false;
    public static final boolean IS_OS_UNIX = false;
    public static final boolean IS_OS_WINDOWS = false;
    public static final boolean IS_OS_WINDOWS_2000 = false;
    public static final boolean IS_OS_WINDOWS_2003 = false;
    public static final boolean IS_OS_WINDOWS_2008 = false;
    public static final boolean IS_OS_WINDOWS_7 = false;
    public static final boolean IS_OS_WINDOWS_8 = false;
    public static final boolean IS_OS_WINDOWS_95 = false;
    public static final boolean IS_OS_WINDOWS_98 = false;
    public static final boolean IS_OS_WINDOWS_ME = false;
    public static final boolean IS_OS_WINDOWS_NT = false;
    public static final boolean IS_OS_WINDOWS_VISTA = false;
    public static final boolean IS_OS_WINDOWS_XP = false;
    public static final String JAVA_AWT_FONTS;
    public static final String JAVA_AWT_GRAPHICSENV;
    public static final String JAVA_AWT_HEADLESS;
    public static final String JAVA_AWT_PRINTERJOB;
    public static final String JAVA_CLASS_PATH;
    public static final String JAVA_CLASS_VERSION;
    public static final String JAVA_COMPILER;
    public static final String JAVA_ENDORSED_DIRS;
    public static final String JAVA_EXT_DIRS;
    public static final String JAVA_HOME;
    private static final String JAVA_HOME_KEY = "java.home";
    public static final String JAVA_IO_TMPDIR;
    private static final String JAVA_IO_TMPDIR_KEY = "java.io.tmpdir";
    public static final String JAVA_LIBRARY_PATH;
    public static final String JAVA_RUNTIME_NAME;
    public static final String JAVA_RUNTIME_VERSION;
    public static final String JAVA_SPECIFICATION_NAME;
    public static final String JAVA_SPECIFICATION_VENDOR;
    public static final String JAVA_SPECIFICATION_VERSION;
    private static final JavaVersion JAVA_SPECIFICATION_VERSION_AS_ENUM;
    public static final String JAVA_UTIL_PREFS_PREFERENCES_FACTORY;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VENDOR_URL;
    public static final String JAVA_VERSION;
    public static final String JAVA_VM_INFO;
    public static final String JAVA_VM_NAME;
    public static final String JAVA_VM_SPECIFICATION_NAME;
    public static final String JAVA_VM_SPECIFICATION_VENDOR;
    public static final String JAVA_VM_SPECIFICATION_VERSION;
    public static final String JAVA_VM_VENDOR;
    public static final String JAVA_VM_VERSION;
    public static final String LINE_SEPARATOR;
    public static final String OS_ARCH;
    public static final String OS_NAME;
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    public static final String OS_VERSION;
    public static final String PATH_SEPARATOR;
    public static final String USER_COUNTRY;
    public static final String USER_DIR;
    private static final String USER_DIR_KEY = "user.dir";
    public static final String USER_HOME;
    private static final String USER_HOME_KEY = "user.home";
    public static final String USER_LANGUAGE;
    public static final String USER_NAME;
    public static final String USER_TIMEZONE;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl2;
        block3: {
            block2: {
                AWT_TOOLKIT = SystemUtils.getSystemProperty("awt.toolkit");
                FILE_ENCODING = SystemUtils.getSystemProperty("file.encoding");
                FILE_SEPARATOR = SystemUtils.getSystemProperty("file.separator");
                JAVA_AWT_FONTS = SystemUtils.getSystemProperty("java.awt.fonts");
                JAVA_AWT_GRAPHICSENV = SystemUtils.getSystemProperty("java.awt.graphicsenv");
                JAVA_AWT_HEADLESS = SystemUtils.getSystemProperty("java.awt.headless");
                JAVA_AWT_PRINTERJOB = SystemUtils.getSystemProperty("java.awt.printerjob");
                JAVA_CLASS_PATH = SystemUtils.getSystemProperty("java.class.path");
                JAVA_CLASS_VERSION = SystemUtils.getSystemProperty("java.class.version");
                JAVA_COMPILER = SystemUtils.getSystemProperty("java.compiler");
                JAVA_ENDORSED_DIRS = SystemUtils.getSystemProperty("java.endorsed.dirs");
                JAVA_EXT_DIRS = SystemUtils.getSystemProperty("java.ext.dirs");
                JAVA_HOME = SystemUtils.getSystemProperty(JAVA_HOME_KEY);
                JAVA_IO_TMPDIR = SystemUtils.getSystemProperty(JAVA_IO_TMPDIR_KEY);
                JAVA_LIBRARY_PATH = SystemUtils.getSystemProperty("java.library.path");
                JAVA_RUNTIME_NAME = SystemUtils.getSystemProperty("java.runtime.name");
                JAVA_RUNTIME_VERSION = SystemUtils.getSystemProperty("java.runtime.version");
                JAVA_SPECIFICATION_NAME = SystemUtils.getSystemProperty("java.specification.name");
                JAVA_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty("java.specification.vendor");
                JAVA_SPECIFICATION_VERSION = SystemUtils.getSystemProperty("java.specification.version");
                JAVA_SPECIFICATION_VERSION_AS_ENUM = JavaVersion.get(JAVA_SPECIFICATION_VERSION);
                JAVA_UTIL_PREFS_PREFERENCES_FACTORY = SystemUtils.getSystemProperty("java.util.prefs.PreferencesFactory");
                JAVA_VENDOR = SystemUtils.getSystemProperty("java.vendor");
                JAVA_VENDOR_URL = SystemUtils.getSystemProperty("java.vendor.url");
                JAVA_VERSION = SystemUtils.getSystemProperty("java.version");
                JAVA_VM_INFO = SystemUtils.getSystemProperty("java.vm.info");
                JAVA_VM_NAME = SystemUtils.getSystemProperty("java.vm.name");
                JAVA_VM_SPECIFICATION_NAME = SystemUtils.getSystemProperty("java.vm.specification.name");
                JAVA_VM_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty("java.vm.specification.vendor");
                JAVA_VM_SPECIFICATION_VERSION = SystemUtils.getSystemProperty("java.vm.specification.version");
                JAVA_VM_VENDOR = SystemUtils.getSystemProperty("java.vm.vendor");
                JAVA_VM_VERSION = SystemUtils.getSystemProperty("java.vm.version");
                LINE_SEPARATOR = SystemUtils.getSystemProperty("line.separator");
                OS_ARCH = SystemUtils.getSystemProperty("os.arch");
                OS_NAME = SystemUtils.getSystemProperty("os.name");
                OS_VERSION = SystemUtils.getSystemProperty("os.version");
                PATH_SEPARATOR = SystemUtils.getSystemProperty("path.separator");
                String string2 = SystemUtils.getSystemProperty("user.country") == null ? SystemUtils.getSystemProperty("user.region") : SystemUtils.getSystemProperty("user.country");
                USER_COUNTRY = string2;
                USER_DIR = SystemUtils.getSystemProperty(USER_DIR_KEY);
                USER_HOME = SystemUtils.getSystemProperty(USER_HOME_KEY);
                USER_LANGUAGE = SystemUtils.getSystemProperty("user.language");
                USER_NAME = SystemUtils.getSystemProperty("user.name");
                USER_TIMEZONE = SystemUtils.getSystemProperty("user.timezone");
                IS_JAVA_1_1 = SystemUtils.getJavaVersionMatches("1.1");
                IS_JAVA_1_2 = SystemUtils.getJavaVersionMatches("1.2");
                IS_JAVA_1_3 = SystemUtils.getJavaVersionMatches("1.3");
                IS_JAVA_1_4 = SystemUtils.getJavaVersionMatches("1.4");
                IS_JAVA_1_5 = SystemUtils.getJavaVersionMatches("1.5");
                IS_JAVA_1_6 = SystemUtils.getJavaVersionMatches("1.6");
                IS_JAVA_1_7 = SystemUtils.getJavaVersionMatches("1.7");
                IS_OS_AIX = SystemUtils.getOSMatchesName("AIX");
                IS_OS_HP_UX = SystemUtils.getOSMatchesName("HP-UX");
                IS_OS_IRIX = SystemUtils.getOSMatchesName("Irix");
                boolean bl3 = SystemUtils.getOSMatchesName("Linux") || SystemUtils.getOSMatchesName("LINUX");
                IS_OS_LINUX = bl3;
                IS_OS_MAC = SystemUtils.getOSMatchesName("Mac");
                IS_OS_MAC_OSX = SystemUtils.getOSMatchesName("Mac OS X");
                IS_OS_FREE_BSD = SystemUtils.getOSMatchesName("FreeBSD");
                IS_OS_OPEN_BSD = SystemUtils.getOSMatchesName("OpenBSD");
                IS_OS_NET_BSD = SystemUtils.getOSMatchesName("NetBSD");
                IS_OS_OS2 = SystemUtils.getOSMatchesName("OS/2");
                IS_OS_SOLARIS = SystemUtils.getOSMatchesName("Solaris");
                IS_OS_SUN_OS = SystemUtils.getOSMatchesName("SunOS");
                if (IS_OS_AIX || IS_OS_HP_UX || IS_OS_IRIX || IS_OS_LINUX || IS_OS_MAC_OSX || IS_OS_SOLARIS || IS_OS_SUN_OS || IS_OS_FREE_BSD || IS_OS_OPEN_BSD) break block2;
                boolean bl4 = IS_OS_NET_BSD;
                bl2 = false;
                if (!bl4) break block3;
            }
            bl2 = true;
        }
        IS_OS_UNIX = bl2;
        IS_OS_WINDOWS = SystemUtils.getOSMatchesName(OS_NAME_WINDOWS_PREFIX);
        IS_OS_WINDOWS_2000 = SystemUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "5.0");
        IS_OS_WINDOWS_2003 = SystemUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "5.2");
        IS_OS_WINDOWS_2008 = SystemUtils.getOSMatches("Windows Server 2008", "6.1");
        IS_OS_WINDOWS_95 = SystemUtils.getOSMatches("Windows 9", "4.0");
        IS_OS_WINDOWS_98 = SystemUtils.getOSMatches("Windows 9", "4.1");
        IS_OS_WINDOWS_ME = SystemUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "4.9");
        IS_OS_WINDOWS_NT = SystemUtils.getOSMatchesName("Windows NT");
        IS_OS_WINDOWS_XP = SystemUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "5.1");
        IS_OS_WINDOWS_VISTA = SystemUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "6.0");
        IS_OS_WINDOWS_7 = SystemUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "6.1");
        IS_OS_WINDOWS_8 = SystemUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "6.2");
    }

    public static File getJavaHome() {
        return new File(System.getProperty(JAVA_HOME_KEY));
    }

    public static File getJavaIoTmpDir() {
        return new File(System.getProperty(JAVA_IO_TMPDIR_KEY));
    }

    private static boolean getJavaVersionMatches(String string2) {
        return SystemUtils.isJavaVersionMatch(JAVA_SPECIFICATION_VERSION, string2);
    }

    private static boolean getOSMatches(String string2, String string3) {
        return SystemUtils.isOSMatch(OS_NAME, OS_VERSION, string2, string3);
    }

    private static boolean getOSMatchesName(String string2) {
        return SystemUtils.isOSNameMatch(OS_NAME, string2);
    }

    private static String getSystemProperty(String string2) {
        try {
            String string3 = System.getProperty(string2);
            return string3;
        }
        catch (SecurityException securityException) {
            System.err.println("Caught a SecurityException reading the system property '" + string2 + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    public static File getUserDir() {
        return new File(System.getProperty(USER_DIR_KEY));
    }

    public static File getUserHome() {
        return new File(System.getProperty(USER_HOME_KEY));
    }

    public static boolean isJavaAwtHeadless() {
        if (JAVA_AWT_HEADLESS != null) {
            return JAVA_AWT_HEADLESS.equals(Boolean.TRUE.toString());
        }
        return false;
    }

    public static boolean isJavaVersionAtLeast(JavaVersion javaVersion) {
        return JAVA_SPECIFICATION_VERSION_AS_ENUM.atLeast(javaVersion);
    }

    static boolean isJavaVersionMatch(String string2, String string3) {
        if (string2 == null) {
            return false;
        }
        return string2.startsWith(string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean isOSMatch(String string2, String string3, String string4, String string5) {
        return string2 != null && string3 != null && string2.startsWith(string4) && string3.startsWith(string5);
    }

    static boolean isOSNameMatch(String string2, String string3) {
        if (string2 == null) {
            return false;
        }
        return string2.startsWith(string3);
    }
}

