/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharSequenceUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.ObjectUtils;

public class StringUtils {
    public static final String CR = "\r";
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;
    public static final String LF = "\n";
    private static final int PAD_LIMIT = 8192;
    public static final String SPACE = " ";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?: |\\u00A0|\\s|[\\s&&[^ ]])\\s*");

    public static String abbreviate(String string2, int n2) {
        return StringUtils.abbreviate(string2, 0, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String abbreviate(String string2, int n2, int n3) {
        if (string2 == null) {
            return null;
        }
        if (n3 < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (string2.length() <= n3) return string2;
        if (n2 > string2.length()) {
            n2 = string2.length();
        }
        if (string2.length() - n2 < n3 - 3) {
            n2 = string2.length() - (n3 - 3);
        }
        if (n2 <= 4) {
            return string2.substring(0, n3 - 3) + "...";
        }
        if (n3 < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (-3 + (n2 + n3) >= string2.length()) return "..." + string2.substring(string2.length() - (n3 - 3));
        return "..." + StringUtils.abbreviate(string2.substring(n2), n3 - 3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String abbreviateMiddle(String string2, String string3, int n2) {
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3) || n2 >= string2.length() || n2 < 2 + string3.length()) {
            return string2;
        }
        int n3 = n2 - string3.length();
        int n4 = n3 / 2 + n3 % 2;
        int n5 = string2.length() - n3 / 2;
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(string2.substring(0, n4));
        stringBuilder.append(string3);
        stringBuilder.append(string2.substring(n5));
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String appendIfMissing(String string2, CharSequence charSequence, boolean bl2, CharSequence ... charSequenceArray) {
        if (string2 == null || StringUtils.isEmpty(charSequence) || StringUtils.endsWith(string2, charSequence, bl2)) return string2;
        if (charSequenceArray == null || charSequenceArray.length <= 0) return string2 + charSequence.toString();
        int n2 = charSequenceArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!StringUtils.endsWith(string2, charSequenceArray[i2], bl2)) continue;
            return string2;
        }
        return string2 + charSequence.toString();
    }

    public static String appendIfMissing(String string2, CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.appendIfMissing(string2, charSequence, false, charSequenceArray);
    }

    public static String appendIfMissingIgnoreCase(String string2, CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.appendIfMissing(string2, charSequence, true, charSequenceArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String capitalize(String string2) {
        char c2;
        int n2;
        if (string2 == null || (n2 = string2.length()) == 0 || Character.isTitleCase(c2 = string2.charAt(0))) {
            return string2;
        }
        return new StringBuilder(n2).append(Character.toTitleCase(c2)).append(string2.substring(1)).toString();
    }

    public static String center(String string2, int n2) {
        return StringUtils.center(string2, n2, ' ');
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String center(String string2, int n2, char c2) {
        int n3;
        int n4;
        if (string2 == null || n2 <= 0 || (n4 = n2 - (n3 = string2.length())) <= 0) {
            return string2;
        }
        return StringUtils.rightPad(StringUtils.leftPad(string2, n3 + n4 / 2, c2), n2, c2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String center(String string2, int n2, String string3) {
        int n3;
        int n4;
        block5: {
            block4: {
                if (string2 == null || n2 <= 0) break block4;
                if (StringUtils.isEmpty(string3)) {
                    string3 = SPACE;
                }
                if ((n4 = n2 - (n3 = string2.length())) > 0) break block5;
            }
            return string2;
        }
        return StringUtils.rightPad(StringUtils.leftPad(string2, n3 + n4 / 2, string3), n2, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String chomp(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return string2;
        }
        if (string2.length() == 1) {
            char c2 = string2.charAt(0);
            if (c2 == '\r') return EMPTY;
            if (c2 != '\n') return string2;
            return EMPTY;
        }
        int n2 = -1 + string2.length();
        char c3 = string2.charAt(n2);
        if (c3 == '\n') {
            if (string2.charAt(n2 - 1) != '\r') return string2.substring(0, n2);
            --n2;
            return string2.substring(0, n2);
        }
        if (c3 == '\r') return string2.substring(0, n2);
        return string2.substring(0, ++n2);
    }

    @Deprecated
    public static String chomp(String string2, String string3) {
        return StringUtils.removeEnd(string2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String chop(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = string2.length();
        if (n2 < 2) {
            return EMPTY;
        }
        int n3 = n2 - 1;
        String string3 = string2.substring(0, n3);
        if (string2.charAt(n3) != '\n') return string3;
        if (string3.charAt(n3 - 1) != '\r') return string3;
        return string3.substring(0, n3 - 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean contains(CharSequence charSequence, int n2) {
        return !StringUtils.isEmpty(charSequence) && CharSequenceUtils.indexOf(charSequence, n2, 0) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        return charSequence != null && charSequence2 != null && CharSequenceUtils.indexOf(charSequence, charSequence2, 0) >= 0;
    }

    public static boolean containsAny(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence2 == null) {
            return false;
        }
        return StringUtils.containsAny(charSequence, CharSequenceUtils.toCharArray(charSequence2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsAny(CharSequence charSequence, char ... cArray) {
        boolean bl2 = true;
        if (StringUtils.isEmpty(charSequence)) return false;
        if (ArrayUtils.isEmpty(cArray)) {
            return false;
        }
        int n2 = charSequence.length();
        int n3 = cArray.length;
        int n4 = n2 - 1;
        int n5 = n3 - 1;
        int n6 = 0;
        while (n6 < n2) {
            char c2 = charSequence.charAt(n6);
            for (int i2 = 0; i2 < n3; ++i2) {
                if (cArray[i2] != c2) continue;
                if (!Character.isHighSurrogate(c2)) return bl2;
                if (i2 == n5) return bl2;
                if (n6 >= n4) continue;
                if (cArray[i2 + 1] == charSequence.charAt(n6 + 1)) return bl2;
            }
            ++n6;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean containsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence != null && charSequence2 != null) {
            int n2 = charSequence2.length();
            int n3 = charSequence.length() - n2;
            for (int i2 = 0; i2 <= n3; ++i2) {
                if (!CharSequenceUtils.regionMatches(charSequence, true, i2, charSequence2, 0, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsNone(CharSequence charSequence, String string2) {
        if (charSequence == null || string2 == null) {
            return true;
        }
        return StringUtils.containsNone(charSequence, string2.toCharArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsNone(CharSequence charSequence, char ... cArray) {
        if (charSequence == null) return true;
        if (cArray == null) {
            return true;
        }
        int n2 = charSequence.length();
        int n3 = n2 - 1;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        int n6 = 0;
        while (n6 < n2) {
            char c2 = charSequence.charAt(n6);
            for (int i2 = 0; i2 < n4; ++i2) {
                if (cArray[i2] != c2) continue;
                boolean bl2 = Character.isHighSurrogate(c2);
                boolean bl3 = false;
                if (!bl2) return bl3;
                bl3 = false;
                if (i2 == n5) return bl3;
                if (n6 >= n3) continue;
                char c3 = cArray[i2 + 1];
                char c4 = charSequence.charAt(n6 + 1);
                bl3 = false;
                if (c3 == c4) return bl3;
            }
            ++n6;
        }
        return true;
    }

    public static boolean containsOnly(CharSequence charSequence, String string2) {
        if (charSequence == null || string2 == null) {
            return false;
        }
        return StringUtils.containsOnly(charSequence, string2.toCharArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean containsOnly(CharSequence charSequence, char ... cArray) {
        boolean bl2 = true;
        if (cArray == null) return false;
        if (charSequence == null) {
            return false;
        }
        if (charSequence.length() == 0) return bl2;
        if (cArray.length == 0) {
            return false;
        }
        if (StringUtils.indexOfAnyBut(charSequence, cArray) == -1) return bl2;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean containsWhitespace(CharSequence charSequence) {
        if (!StringUtils.isEmpty(charSequence)) {
            int n2 = charSequence.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!Character.isWhitespace(charSequence.charAt(i2))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int countMatches(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        if (StringUtils.isEmpty(charSequence)) return 0;
        if (StringUtils.isEmpty(charSequence2)) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        while ((n2 = CharSequenceUtils.indexOf(charSequence, charSequence2, n4)) != -1) {
            ++n3;
            n4 = n2 + charSequence2.length();
        }
        return n3;
    }

    public static <T extends CharSequence> T defaultIfBlank(T t2, T t3) {
        if (StringUtils.isBlank(t2)) {
            return t3;
        }
        return t2;
    }

    public static <T extends CharSequence> T defaultIfEmpty(T t2, T t3) {
        if (StringUtils.isEmpty(t2)) {
            return t3;
        }
        return t2;
    }

    public static String defaultString(String string2) {
        if (string2 == null) {
            string2 = EMPTY;
        }
        return string2;
    }

    public static String defaultString(String string2, String string3) {
        if (string2 == null) {
            return string3;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String deleteWhitespace(String string2) {
        int n2;
        char[] cArray;
        block7: {
            block6: {
                if (StringUtils.isEmpty(string2)) break block6;
                int n3 = string2.length();
                cArray = new char[n3];
                n2 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4;
                    if (!Character.isWhitespace(string2.charAt(i2))) {
                        n4 = n2 + 1;
                        cArray[n2] = string2.charAt(i2);
                    } else {
                        n4 = n2;
                    }
                    n2 = n4;
                }
                if (n2 != n3) break block7;
            }
            return string2;
        }
        return new String(cArray, 0, n2);
    }

    public static String difference(String string2, String string3) {
        if (string2 == null) {
            return string3;
        }
        if (string3 == null) {
            return string2;
        }
        int n2 = StringUtils.indexOfDifference((CharSequence)string2, (CharSequence)string3);
        if (n2 == -1) {
            return EMPTY;
        }
        return string3.substring(n2);
    }

    public static boolean endsWith(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.endsWith(charSequence, charSequence2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean endsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        boolean bl3;
        if (charSequence == null || charSequence2 == null) {
            bl3 = false;
            if (charSequence != null) return bl3;
            bl3 = false;
            if (charSequence2 != null) return bl3;
            return true;
        }
        int n2 = charSequence2.length();
        int n3 = charSequence.length();
        bl3 = false;
        if (n2 > n3) return bl3;
        return CharSequenceUtils.regionMatches(charSequence, bl2, charSequence.length() - charSequence2.length(), charSequence2, 0, charSequence2.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean endsWithAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (!StringUtils.isEmpty(charSequence) && !ArrayUtils.isEmpty(charSequenceArray)) {
            int n2 = charSequenceArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!StringUtils.endsWith(charSequence, charSequenceArray[i2])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.endsWith(charSequence, charSequence2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return true;
        }
        boolean bl2 = false;
        if (charSequence == null) return bl2;
        bl2 = false;
        if (charSequence2 == null) return bl2;
        if (!(charSequence instanceof String)) return CharSequenceUtils.regionMatches(charSequence, false, 0, charSequence2, 0, Math.max(charSequence.length(), charSequence2.length()));
        if (!(charSequence2 instanceof String)) return CharSequenceUtils.regionMatches(charSequence, false, 0, charSequence2, 0, Math.max(charSequence.length(), charSequence2.length()));
        return charSequence.equals(charSequence2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            if (charSequence == charSequence2) return true;
            return false;
        }
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence.length() == charSequence2.length()) return CharSequenceUtils.regionMatches(charSequence, true, 0, charSequence2, 0, charSequence.length());
        return false;
    }

    public static String getCommonPrefix(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY;
        }
        int n2 = StringUtils.indexOfDifference(stringArray);
        if (n2 == -1) {
            if (stringArray[0] == null) {
                return EMPTY;
            }
            return stringArray[0];
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return stringArray[0].substring(0, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getLevenshteinDistance(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = charSequence.length();
        int n3 = charSequence2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        if (n2 > n3) {
            CharSequence charSequence3 = charSequence;
            charSequence = charSequence2;
            charSequence2 = charSequence3;
            n2 = n3;
            n3 = charSequence2.length();
        }
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            nArray[i2] = i2;
        }
        int n4 = 1;
        while (n4 <= n3) {
            char c2 = charSequence2.charAt(n4 - 1);
            nArray2[0] = n4;
            for (int i3 = 1; i3 <= n2; ++i3) {
                int n5 = charSequence.charAt(i3 - 1) == c2 ? 0 : 1;
                nArray2[i3] = Math.min(Math.min(1 + nArray2[i3 - 1], 1 + nArray[i3]), n5 + nArray[i3 - 1]);
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
            ++n4;
        }
        return nArray[n2];
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getLevenshteinDistance(CharSequence charSequence, CharSequence charSequence2, int n2) {
        if (charSequence == null || charSequence2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        if (n3 == 0) {
            if (n4 <= n2) {
                return n4;
            }
            return -1;
        }
        if (n4 == 0) {
            if (n3 <= n2) {
                return n3;
            }
            return -1;
        }
        if (n3 > n4) {
            CharSequence charSequence3 = charSequence;
            charSequence = charSequence2;
            charSequence2 = charSequence3;
            n3 = n4;
            n4 = charSequence2.length();
        }
        int[] nArray = new int[n3 + 1];
        int[] nArray2 = new int[n3 + 1];
        int n5 = 1 + Math.min(n3, n2);
        for (int i2 = 0; i2 < n5; ++i2) {
            nArray[i2] = i2;
        }
        Arrays.fill(nArray, n5, nArray.length, Integer.MAX_VALUE);
        Arrays.fill(nArray2, Integer.MAX_VALUE);
        int n6 = 1;
        while (true) {
            int n7;
            char c2;
            if (n6 <= n4) {
                int n8 = n6 - 1;
                c2 = charSequence2.charAt(n8);
                nArray2[0] = n6;
                int n9 = Math.max(1, n6 - n2);
                if (n9 > (n7 = Math.min(n3, n6 + n2))) {
                    return -1;
                }
                if (n9 > 1) {
                    nArray2[n9 - 1] = Integer.MAX_VALUE;
                }
            } else {
                if (nArray[n3] <= n2) {
                    return nArray[n3];
                }
                return -1;
            }
            for (int i3 = n9; i3 <= n7; ++i3) {
                nArray2[i3] = charSequence.charAt(i3 - 1) == c2 ? nArray[i3 - 1] : 1 + Math.min(Math.min(nArray2[i3 - 1], nArray[i3]), nArray[i3 - 1]);
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
            ++n6;
        }
    }

    public static int indexOf(CharSequence charSequence, int n2) {
        if (StringUtils.isEmpty(charSequence)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, n2, 0);
    }

    public static int indexOf(CharSequence charSequence, int n2, int n3) {
        if (StringUtils.isEmpty(charSequence)) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, n2, n3);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, charSequence2, 0);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        return CharSequenceUtils.indexOf(charSequence, charSequence2, n2);
    }

    public static int indexOfAny(CharSequence charSequence, String string2) {
        if (StringUtils.isEmpty(charSequence) || StringUtils.isEmpty(string2)) {
            return -1;
        }
        return StringUtils.indexOfAny(charSequence, string2.toCharArray());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOfAny(CharSequence charSequence, char ... cArray) {
        if (StringUtils.isEmpty(charSequence)) return -1;
        if (ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n2 = charSequence.length();
        int n3 = n2 - 1;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        int n6 = 0;
        while (n6 < n2) {
            char c2 = charSequence.charAt(n6);
            for (int i2 = 0; i2 < n4; ++i2) {
                if (cArray[i2] != c2) continue;
                if (n6 >= n3) return n6;
                if (i2 >= n5) return n6;
                if (!Character.isHighSurrogate(c2)) return n6;
                if (cArray[i2 + 1] == charSequence.charAt(n6 + 1)) return n6;
            }
            ++n6;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int indexOfAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (charSequence == null) return -1;
        if (charSequenceArray == null) {
            return -1;
        }
        int n2 = charSequenceArray.length;
        int n3 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            CharSequence charSequence2 = charSequenceArray[i2];
            if (charSequence2 == null || (n4 = CharSequenceUtils.indexOf(charSequence, charSequence2, 0)) == -1 || n4 >= n3) continue;
            n3 = n4;
        }
        if (n3 != Integer.MAX_VALUE) return n3;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int indexOfAnyBut(CharSequence charSequence, CharSequence charSequence2) {
        if (StringUtils.isEmpty(charSequence)) return -1;
        if (StringUtils.isEmpty(charSequence2)) {
            return -1;
        }
        int n2 = charSequence.length();
        int n3 = 0;
        while (n3 < n2) {
            char c2 = charSequence.charAt(n3);
            boolean bl2 = CharSequenceUtils.indexOf(charSequence2, c2, 0) >= 0;
            if (n3 + 1 < n2 && Character.isHighSurrogate(c2)) {
                char c3 = charSequence.charAt(n3 + 1);
                if (bl2) {
                    if (CharSequenceUtils.indexOf(charSequence2, c3, 0) < 0) return n3;
                }
            } else if (!bl2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOfAnyBut(CharSequence charSequence, char ... cArray) {
        if (StringUtils.isEmpty(charSequence)) return -1;
        if (ArrayUtils.isEmpty(cArray)) {
            return -1;
        }
        int n2 = charSequence.length();
        int n3 = n2 - 1;
        int n4 = cArray.length;
        int n5 = n4 - 1;
        int n6 = 0;
        block0: while (n6 < n2) {
            char c2 = charSequence.charAt(n6);
            int n7 = 0;
            while (n7 < n4) {
                if (!(cArray[n7] != c2 || n6 < n3 && n7 < n5 && Character.isHighSurrogate(c2) && cArray[n7 + 1] != charSequence.charAt(n6 + 1))) {
                    ++n6;
                    continue block0;
                }
                ++n7;
            }
            return n6;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOfDifference(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return -1;
        }
        if (charSequence == null) return 0;
        if (charSequence2 == null) {
            return 0;
        }
        int n2 = 0;
        while (true) {
            if (n2 >= charSequence.length() || n2 >= charSequence2.length() || charSequence.charAt(n2) != charSequence2.charAt(n2)) {
                if (n2 < charSequence2.length()) return n2;
                if (n2 < charSequence.length()) return n2;
                return -1;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int indexOfDifference(CharSequence ... charSequenceArray) {
        if (charSequenceArray == null) return -1;
        if (charSequenceArray.length <= 1) {
            return -1;
        }
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = charSequenceArray.length;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (charSequenceArray[i2] == null) {
                bl2 = true;
                n3 = 0;
                continue;
            }
            n3 = Math.min(charSequenceArray[i2].length(), n3);
            n4 = Math.max(charSequenceArray[i2].length(), n4);
            bl3 = false;
        }
        if (bl3) return -1;
        if (n4 == 0 && !bl2) {
            return -1;
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = -1;
        block1: for (int i3 = 0; i3 < n3; ++i3) {
            char c2 = charSequenceArray[0].charAt(i3);
            int n6 = 1;
            while (true) {
                block11: {
                    block10: {
                        if (n6 >= n2) break block10;
                        if (charSequenceArray[n6].charAt(i3) == c2) break block11;
                        n5 = i3;
                    }
                    if (n5 == -1) continue block1;
                    break block1;
                }
                ++n6;
            }
        }
        if (n5 != -1) return n5;
        if (n3 != n4) return n3;
        return n5;
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.indexOfIgnoreCase(charSequence, charSequence2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2, int n2) {
        int n3;
        if (charSequence == null) return -1;
        if (charSequence2 == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > (n3 = 1 + (charSequence.length() - charSequence2.length()))) {
            return -1;
        }
        if (charSequence2.length() == 0) {
            return n2;
        }
        int n4 = n2;
        while (n4 < n3) {
            if (CharSequenceUtils.regionMatches(charSequence, true, n4, charSequence2, 0, charSequence2.length())) return n4;
            ++n4;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAllLowerCase(CharSequence charSequence) {
        if (charSequence != null && !StringUtils.isEmpty(charSequence)) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isLowerCase(charSequence.charAt(n3))) break;
                ++n3;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAllUpperCase(CharSequence charSequence) {
        if (charSequence != null && !StringUtils.isEmpty(charSequence)) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isUpperCase(charSequence.charAt(n3))) break;
                ++n3;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAlpha(CharSequence charSequence) {
        if (!StringUtils.isEmpty(charSequence)) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isLetter(charSequence.charAt(n3))) break;
                ++n3;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAlphaSpace(CharSequence charSequence) {
        if (charSequence != null) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isLetter(charSequence.charAt(n3)) && charSequence.charAt(n3) != ' ') break;
                ++n3;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAlphanumeric(CharSequence charSequence) {
        if (!StringUtils.isEmpty(charSequence)) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isLetterOrDigit(charSequence.charAt(n3))) break;
                ++n3;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAlphanumericSpace(CharSequence charSequence) {
        if (charSequence != null) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isLetterOrDigit(charSequence.charAt(n3)) && charSequence.charAt(n3) != ' ') break;
                ++n3;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAnyBlank(CharSequence ... charSequenceArray) {
        if (!ArrayUtils.isEmpty(charSequenceArray)) {
            int n2 = charSequenceArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return false;
                }
                if (StringUtils.isBlank(charSequenceArray[n3])) break;
                ++n3;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAnyEmpty(CharSequence ... charSequenceArray) {
        if (!ArrayUtils.isEmpty(charSequenceArray)) {
            int n2 = charSequenceArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return false;
                }
                if (StringUtils.isEmpty(charSequenceArray[n3])) break;
                ++n3;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isAsciiPrintable(CharSequence charSequence) {
        if (charSequence != null) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!CharUtils.isAsciiPrintable(charSequence.charAt(n3))) break;
                ++n3;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isBlank(CharSequence charSequence) {
        int n2;
        if (charSequence != null && (n2 = charSequence.length()) != 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (Character.isWhitespace(charSequence.charAt(i2))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isNoneBlank(CharSequence ... charSequenceArray) {
        return !StringUtils.isAnyBlank(charSequenceArray);
    }

    public static boolean isNoneEmpty(CharSequence ... charSequenceArray) {
        return !StringUtils.isAnyEmpty(charSequenceArray);
    }

    public static boolean isNotBlank(CharSequence charSequence) {
        return !StringUtils.isBlank(charSequence);
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !StringUtils.isEmpty(charSequence);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isNumeric(CharSequence charSequence) {
        if (!StringUtils.isEmpty(charSequence)) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isDigit(charSequence.charAt(n3))) break;
                ++n3;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isNumericSpace(CharSequence charSequence) {
        if (charSequence != null) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isDigit(charSequence.charAt(n3)) && charSequence.charAt(n3) != ' ') break;
                ++n3;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isWhitespace(CharSequence charSequence) {
        if (charSequence != null) {
            int n2 = charSequence.length();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    return true;
                }
                if (!Character.isWhitespace(charSequence.charAt(n3))) break;
                ++n3;
            }
        }
        return false;
    }

    public static String join(Iterable<?> iterable, char c2) {
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable.iterator(), c2);
    }

    public static String join(Iterable<?> iterable, String string2) {
        if (iterable == null) {
            return null;
        }
        return StringUtils.join(iterable.iterator(), string2);
    }

    public static String join(Iterator<?> iterator, char c2) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object obj = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(obj);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (obj != null) {
            stringBuilder.append(obj);
        }
        while (iterator.hasNext()) {
            stringBuilder.append(c2);
            Object obj2 = iterator.next();
            if (obj2 == null) continue;
            stringBuilder.append(obj2);
        }
        return stringBuilder.toString();
    }

    public static String join(Iterator<?> iterator, String string2) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object obj = iterator.next();
        if (!iterator.hasNext()) {
            return ObjectUtils.toString(obj);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (obj != null) {
            stringBuilder.append(obj);
        }
        while (iterator.hasNext()) {
            Object obj2;
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            if ((obj2 = iterator.next()) == null) continue;
            stringBuilder.append(obj2);
        }
        return stringBuilder.toString();
    }

    public static String join(byte[] byArray, char c2) {
        if (byArray == null) {
            return null;
        }
        return StringUtils.join(byArray, c2, 0, byArray.length);
    }

    public static String join(byte[] byArray, char c2, int n2, int n3) {
        if (byArray == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 * 16);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(byArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(char[] cArray, char c2) {
        if (cArray == null) {
            return null;
        }
        return StringUtils.join(cArray, c2, 0, cArray.length);
    }

    public static String join(char[] cArray, char c2, int n2, int n3) {
        if (cArray == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 * 16);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(cArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(double[] dArray, char c2) {
        if (dArray == null) {
            return null;
        }
        return StringUtils.join(dArray, c2, 0, dArray.length);
    }

    public static String join(double[] dArray, char c2, int n2, int n3) {
        if (dArray == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 * 16);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(dArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(float[] fArray, char c2) {
        if (fArray == null) {
            return null;
        }
        return StringUtils.join(fArray, c2, 0, fArray.length);
    }

    public static String join(float[] fArray, char c2, int n2, int n3) {
        if (fArray == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 * 16);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(fArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(int[] nArray, char c2) {
        if (nArray == null) {
            return null;
        }
        return StringUtils.join(nArray, c2, 0, nArray.length);
    }

    public static String join(int[] nArray, char c2, int n2, int n3) {
        if (nArray == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 * 16);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(nArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(long[] lArray, char c2) {
        if (lArray == null) {
            return null;
        }
        return StringUtils.join(lArray, c2, 0, lArray.length);
    }

    public static String join(long[] lArray, char c2, int n2, int n3) {
        if (lArray == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 * 16);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(lArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static <T> String join(T ... TArray) {
        return StringUtils.join((Object[])TArray, null);
    }

    public static String join(Object[] objectArray, char c2) {
        if (objectArray == null) {
            return null;
        }
        return StringUtils.join(objectArray, c2, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, char c2, int n2, int n3) {
        if (objectArray == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 * 16);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                stringBuilder.append(c2);
            }
            if (objectArray[i2] == null) continue;
            stringBuilder.append(objectArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, String string2) {
        if (objectArray == null) {
            return null;
        }
        return StringUtils.join(objectArray, string2, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, String string2, int n2, int n3) {
        int n4;
        if (objectArray == null) {
            return null;
        }
        if (string2 == null) {
            string2 = EMPTY;
        }
        if ((n4 = n3 - n2) <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 * 16);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                stringBuilder.append(string2);
            }
            if (objectArray[i2] == null) continue;
            stringBuilder.append(objectArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String join(short[] sArray, char c2) {
        if (sArray == null) {
            return null;
        }
        return StringUtils.join(sArray, c2, 0, sArray.length);
    }

    public static String join(short[] sArray, char c2, int n2, int n3) {
        if (sArray == null) {
            return null;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n4 * 16);
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 > n2) {
                stringBuilder.append(c2);
            }
            stringBuilder.append(sArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(CharSequence charSequence, int n2) {
        if (StringUtils.isEmpty(charSequence)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(charSequence, n2, charSequence.length());
    }

    public static int lastIndexOf(CharSequence charSequence, int n2, int n3) {
        if (StringUtils.isEmpty(charSequence)) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(charSequence, n2, n3);
    }

    public static int lastIndexOf(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(charSequence, charSequence2, charSequence.length());
    }

    public static int lastIndexOf(CharSequence charSequence, CharSequence charSequence2, int n2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        return CharSequenceUtils.lastIndexOf(charSequence, charSequence2, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int lastIndexOfAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (charSequence == null) return -1;
        if (charSequenceArray == null) {
            return -1;
        }
        int n2 = charSequenceArray.length;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            CharSequence charSequence2 = charSequenceArray[n4];
            if (charSequence2 != null && (n5 = CharSequenceUtils.lastIndexOf(charSequence, charSequence2, charSequence.length())) > n3) {
                n3 = n5;
            }
            ++n4;
        }
        return n3;
    }

    public static int lastIndexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        return StringUtils.lastIndexOfIgnoreCase(charSequence, charSequence2, charSequence.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2, int n2) {
        if (charSequence == null) return -1;
        if (charSequence2 == null) {
            return -1;
        }
        if (n2 > charSequence.length() - charSequence2.length()) {
            n2 = charSequence.length() - charSequence2.length();
        }
        if (n2 < 0) {
            return -1;
        }
        if (charSequence2.length() == 0) {
            return n2;
        }
        int n3 = n2;
        while (n3 >= 0) {
            if (CharSequenceUtils.regionMatches(charSequence, true, n3, charSequence2, 0, charSequence2.length())) return n3;
            --n3;
        }
        return -1;
    }

    public static int lastOrdinalIndexOf(CharSequence charSequence, CharSequence charSequence2, int n2) {
        return StringUtils.ordinalIndexOf(charSequence, charSequence2, n2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String left(String string2, int n2) {
        if (string2 == null) {
            return null;
        }
        if (n2 < 0) {
            return EMPTY;
        }
        if (string2.length() <= n2) return string2;
        return string2.substring(0, n2);
    }

    public static String leftPad(String string2, int n2) {
        return StringUtils.leftPad(string2, n2, ' ');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String leftPad(String string2, int n2, char c2) {
        if (string2 == null) {
            return null;
        }
        int n3 = n2 - string2.length();
        if (n3 <= 0) return string2;
        if (n3 <= 8192) return StringUtils.repeat(c2, n3).concat(string2);
        return StringUtils.leftPad(string2, n2, String.valueOf(c2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String leftPad(String string2, int n2, String string3) {
        if (string2 == null) {
            return null;
        }
        if (StringUtils.isEmpty(string3)) {
            string3 = SPACE;
        }
        int n3 = string3.length();
        int n4 = n2 - string2.length();
        if (n4 <= 0) return string2;
        if (n3 == 1 && n4 <= 8192) {
            return StringUtils.leftPad(string2, n2, string3.charAt(0));
        }
        if (n4 == n3) {
            return string3.concat(string2);
        }
        if (n4 < n3) {
            return string3.substring(0, n4).concat(string2);
        }
        char[] cArray = new char[n4];
        char[] cArray2 = string3.toCharArray();
        int n5 = 0;
        while (n5 < n4) {
            cArray[n5] = cArray2[n5 % n3];
            ++n5;
        }
        return new String(cArray).concat(string2);
    }

    public static int length(CharSequence charSequence) {
        if (charSequence == null) {
            return 0;
        }
        return charSequence.length();
    }

    public static String lowerCase(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.toLowerCase();
    }

    public static String lowerCase(String string2, Locale locale) {
        if (string2 == null) {
            return null;
        }
        return string2.toLowerCase(locale);
    }

    public static String mid(String string2, int n2, int n3) {
        if (string2 == null) {
            return null;
        }
        if (n3 < 0 || n2 > string2.length()) {
            return EMPTY;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (string2.length() <= n2 + n3) {
            return string2.substring(n2);
        }
        return string2.substring(n2, n2 + n3);
    }

    public static String normalizeSpace(String string2) {
        if (string2 == null) {
            return null;
        }
        return WHITESPACE_PATTERN.matcher(StringUtils.trim(string2)).replaceAll(SPACE);
    }

    public static int ordinalIndexOf(CharSequence charSequence, CharSequence charSequence2, int n2) {
        return StringUtils.ordinalIndexOf(charSequence, charSequence2, n2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int ordinalIndexOf(CharSequence charSequence, CharSequence charSequence2, int n2, boolean bl2) {
        int n3 = -1;
        if (charSequence == null) return n3;
        if (charSequence2 == null) return n3;
        if (n2 <= 0) {
            return n3;
        }
        if (charSequence2.length() == 0) {
            if (!bl2) return 0;
            return charSequence.length();
        }
        int n4 = 0;
        if (bl2) {
            n3 = charSequence.length();
        }
        do {
            n3 = bl2 ? CharSequenceUtils.lastIndexOf(charSequence, charSequence2, n3 - 1) : CharSequenceUtils.indexOf(charSequence, charSequence2, n3 + 1);
            if (n3 < 0) return n3;
        } while (++n4 < n2);
        return n3;
    }

    public static String overlay(String string2, String string3, int n2, int n3) {
        if (string2 == null) {
            return null;
        }
        if (string3 == null) {
            string3 = EMPTY;
        }
        int n4 = string2.length();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        return new StringBuilder(1 + (n4 + n2 - n3 + string3.length())).append(string2.substring(0, n2)).append(string3).append(string2.substring(n3)).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String prependIfMissing(String string2, CharSequence charSequence, boolean bl2, CharSequence ... charSequenceArray) {
        if (string2 == null || StringUtils.isEmpty(charSequence) || StringUtils.startsWith(string2, charSequence, bl2)) return string2;
        if (charSequenceArray == null || charSequenceArray.length <= 0) return charSequence.toString() + string2;
        int n2 = charSequenceArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!StringUtils.startsWith(string2, charSequenceArray[i2], bl2)) continue;
            return string2;
        }
        return charSequence.toString() + string2;
    }

    public static String prependIfMissing(String string2, CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.prependIfMissing(string2, charSequence, false, charSequenceArray);
    }

    public static String prependIfMissingIgnoreCase(String string2, CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StringUtils.prependIfMissing(string2, charSequence, true, charSequenceArray);
    }

    public static String remove(String string2, char c2) {
        if (StringUtils.isEmpty(string2) || string2.indexOf(c2) == -1) {
            return string2;
        }
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == c2) continue;
            int n3 = n2 + 1;
            cArray[n2] = cArray[i2];
            n2 = n3;
        }
        return new String(cArray, 0, n2);
    }

    public static String remove(String string2, String string3) {
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3)) {
            return string2;
        }
        return StringUtils.replace(string2, string3, EMPTY, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String removeEnd(String string2, String string3) {
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3) || !string2.endsWith(string3)) {
            return string2;
        }
        return string2.substring(0, string2.length() - string3.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String removeEndIgnoreCase(String string2, String string3) {
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3) || !StringUtils.endsWithIgnoreCase(string2, string3)) {
            return string2;
        }
        return string2.substring(0, string2.length() - string3.length());
    }

    public static String removePattern(String string2, String string3) {
        return StringUtils.replacePattern(string2, string3, EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String removeStart(String string2, String string3) {
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3) || !string2.startsWith(string3)) {
            return string2;
        }
        return string2.substring(string3.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String removeStartIgnoreCase(String string2, String string3) {
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3) || !StringUtils.startsWithIgnoreCase(string2, string3)) {
            return string2;
        }
        return string2.substring(string3.length());
    }

    public static String repeat(char c2, int n2) {
        char[] cArray = new char[n2];
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String repeat(String string2, int n2) {
        if (string2 == null) {
            return null;
        }
        if (n2 <= 0) {
            return EMPTY;
        }
        int n3 = string2.length();
        if (n2 == 1) return string2;
        if (n3 == 0) return string2;
        if (n3 == 1 && n2 <= 8192) {
            return StringUtils.repeat(string2.charAt(0), n2);
        }
        int n4 = n3 * n2;
        switch (n3) {
            default: {
                StringBuilder stringBuilder = new StringBuilder(n4);
                int n5 = 0;
                while (n5 < n2) {
                    stringBuilder.append(string2);
                    ++n5;
                }
                return stringBuilder.toString();
            }
            case 1: {
                return StringUtils.repeat(string2.charAt(0), n2);
            }
            case 2: {
                char c2 = string2.charAt(0);
                char c3 = string2.charAt(1);
                char[] cArray = new char[n4];
                int n6 = -2 + n2 * 2;
                while (n6 >= 0) {
                    cArray[n6] = c2;
                    cArray[n6 + 1] = c3;
                    n6 = -1 + (n6 - 1);
                }
                return new String(cArray);
            }
        }
    }

    public static String repeat(String string2, String string3, int n2) {
        if (string2 == null || string3 == null) {
            return StringUtils.repeat(string2, n2);
        }
        return StringUtils.removeEnd(StringUtils.repeat(string2 + string3, n2), string3);
    }

    public static String replace(String string2, String string3, String string4) {
        return StringUtils.replace(string2, string3, string4, -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String replace(String string2, String string3, String string4, int n2) {
        int n3 = 64;
        if (StringUtils.isEmpty(string2)) return string2;
        if (StringUtils.isEmpty(string3) || string4 == null || n2 == 0) {
            return string2;
        }
        int n4 = 0;
        int n5 = string2.indexOf(string3, 0);
        if (n5 == -1) return string2;
        int n6 = string3.length();
        int n7 = string4.length() - n6;
        if (n7 < 0) {
            n7 = 0;
        }
        if (n2 < 0) {
            n3 = 16;
        } else if (n2 <= n3) {
            n3 = n2;
        }
        StringBuilder stringBuilder = new StringBuilder(n7 * n3 + string2.length());
        while (true) {
            block10: {
                block9: {
                    if (n5 == -1) break block9;
                    stringBuilder.append(string2.substring(n4, n5)).append(string4);
                    n4 = n5 + n6;
                    if (--n2 != 0) break block10;
                }
                stringBuilder.append(string2.substring(n4));
                return stringBuilder.toString();
            }
            n5 = string2.indexOf(string3, n4);
        }
    }

    public static String replaceChars(String string2, char c2, char c3) {
        if (string2 == null) {
            return null;
        }
        return string2.replace(c2, c3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String replaceChars(String string2, String string3, String string4) {
        StringBuilder stringBuilder;
        block7: {
            block6: {
                if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3)) break block6;
                if (string4 == null) {
                    string4 = EMPTY;
                }
                boolean bl2 = false;
                int n2 = string4.length();
                int n3 = string2.length();
                stringBuilder = new StringBuilder(n3);
                for (int i2 = 0; i2 < n3; ++i2) {
                    char c2 = string2.charAt(i2);
                    int n4 = string3.indexOf(c2);
                    if (n4 >= 0) {
                        bl2 = true;
                        if (n4 >= n2) continue;
                        stringBuilder.append(string4.charAt(n4));
                        continue;
                    }
                    stringBuilder.append(c2);
                }
                if (bl2) break block7;
            }
            return string2;
        }
        return stringBuilder.toString();
    }

    public static String replaceEach(String string2, String[] stringArray, String[] stringArray2) {
        return StringUtils.replaceEach(string2, stringArray, stringArray2, false, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String replaceEach(String string2, String[] stringArray, String[] stringArray2, boolean bl2, int n2) {
        int n3;
        int n4;
        boolean[] blArray;
        int n5;
        block20: {
            block19: {
                if (string2 == null || string2.isEmpty() || stringArray == null || stringArray.length == 0 || stringArray2 == null || stringArray2.length == 0) break block19;
                if (n2 < 0) {
                    throw new IllegalStateException("Aborting to protect against StackOverflowError - output of one loop is the input of another");
                }
                n5 = stringArray.length;
                int n6 = stringArray2.length;
                if (n5 != n6) {
                    throw new IllegalArgumentException("Search and Replace array lengths don't match: " + n5 + " vs " + n6);
                }
                blArray = new boolean[n5];
                n4 = -1;
                n3 = -1;
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (blArray[i2] || stringArray[i2] == null || stringArray[i2].isEmpty() || stringArray2[i2] == null) continue;
                    int n7 = string2.indexOf(stringArray[i2]);
                    if (n7 == -1) {
                        blArray[i2] = true;
                        continue;
                    }
                    if (n4 != -1 && n7 >= n4) continue;
                    n4 = n7;
                    n3 = i2;
                }
                if (n4 != -1) break block20;
            }
            return string2;
        }
        int n8 = 0;
        int n9 = 0;
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            int n10;
            if (stringArray[i3] == null || stringArray2[i3] == null || (n10 = stringArray2[i3].length() - stringArray[i3].length()) <= 0) continue;
            n9 += n10 * 3;
        }
        StringBuilder stringBuilder = new StringBuilder(Math.min(n9, string2.length() / 5) + string2.length());
        block2: while (true) {
            if (n4 != -1) {
                for (int i4 = n8; i4 < n4; ++i4) {
                    stringBuilder.append(string2.charAt(i4));
                }
            } else {
                int n11 = string2.length();
                for (int i5 = n8; i5 < n11; ++i5) {
                    stringBuilder.append(string2.charAt(i5));
                }
                String string3 = stringBuilder.toString();
                if (!bl2) {
                    return string3;
                }
                return StringUtils.replaceEach(string3, stringArray, stringArray2, bl2, n2 - 1);
            }
            stringBuilder.append(stringArray2[n3]);
            n8 = n4 + stringArray[n3].length();
            n4 = -1;
            n3 = -1;
            int n12 = 0;
            while (true) {
                if (n12 >= n5) continue block2;
                if (!blArray[n12] && stringArray[n12] != null && !stringArray[n12].isEmpty() && stringArray2[n12] != null) {
                    int n13 = string2.indexOf(stringArray[n12], n8);
                    if (n13 == -1) {
                        blArray[n12] = true;
                    } else if (n4 == -1 || n13 < n4) {
                        n4 = n13;
                        n3 = n12;
                    }
                }
                ++n12;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String replaceEachRepeatedly(String string2, String[] stringArray, String[] stringArray2) {
        int n2;
        if (stringArray == null) {
            n2 = 0;
            return StringUtils.replaceEach(string2, stringArray, stringArray2, true, n2);
        }
        n2 = stringArray.length;
        return StringUtils.replaceEach(string2, stringArray, stringArray2, true, n2);
    }

    public static String replaceOnce(String string2, String string3, String string4) {
        return StringUtils.replace(string2, string3, string4, 1);
    }

    public static String replacePattern(String string2, String string3, String string4) {
        return Pattern.compile(string3, 32).matcher(string2).replaceAll(string4);
    }

    public static String reverse(String string2) {
        if (string2 == null) {
            return null;
        }
        return new StringBuilder(string2).reverse().toString();
    }

    public static String reverseDelimited(String string2, char c2) {
        if (string2 == null) {
            return null;
        }
        Object[] objectArray = StringUtils.split(string2, c2);
        ArrayUtils.reverse(objectArray);
        return StringUtils.join(objectArray, c2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String right(String string2, int n2) {
        if (string2 == null) {
            return null;
        }
        if (n2 < 0) {
            return EMPTY;
        }
        if (string2.length() <= n2) return string2;
        return string2.substring(string2.length() - n2);
    }

    public static String rightPad(String string2, int n2) {
        return StringUtils.rightPad(string2, n2, ' ');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String rightPad(String string2, int n2, char c2) {
        if (string2 == null) {
            return null;
        }
        int n3 = n2 - string2.length();
        if (n3 <= 0) return string2;
        if (n3 <= 8192) return string2.concat(StringUtils.repeat(c2, n3));
        return StringUtils.rightPad(string2, n2, String.valueOf(c2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String rightPad(String string2, int n2, String string3) {
        if (string2 == null) {
            return null;
        }
        if (StringUtils.isEmpty(string3)) {
            string3 = SPACE;
        }
        int n3 = string3.length();
        int n4 = n2 - string2.length();
        if (n4 <= 0) return string2;
        if (n3 == 1 && n4 <= 8192) {
            return StringUtils.rightPad(string2, n2, string3.charAt(0));
        }
        if (n4 == n3) {
            return string2.concat(string3);
        }
        if (n4 < n3) {
            return string2.concat(string3.substring(0, n4));
        }
        char[] cArray = new char[n4];
        char[] cArray2 = string3.toCharArray();
        int n5 = 0;
        while (n5 < n4) {
            cArray[n5] = cArray2[n5 % n3];
            ++n5;
        }
        return string2.concat(new String(cArray));
    }

    public static String[] split(String string2) {
        return StringUtils.split(string2, null, -1);
    }

    public static String[] split(String string2, char c2) {
        return StringUtils.splitWorker(string2, c2, false);
    }

    public static String[] split(String string2, String string3) {
        return StringUtils.splitWorker(string2, string3, -1, false);
    }

    public static String[] split(String string2, String string3, int n2) {
        return StringUtils.splitWorker(string2, string3, n2, false);
    }

    public static String[] splitByCharacterType(String string2) {
        return StringUtils.splitByCharacterType(string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] splitByCharacterType(String string2, boolean bl2) {
        if (string2 == null) {
            return null;
        }
        if (string2.isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        char[] cArray = string2.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = Character.getType(cArray[0]);
        int n4 = 0 + 1;
        while (true) {
            if (n4 >= cArray.length) {
                arrayList.add(new String(cArray, n2, cArray.length - n2));
                return arrayList.toArray(new String[arrayList.size()]);
            }
            int n5 = Character.getType(cArray[n4]);
            if (n5 != n3) {
                if (bl2 && n5 == 2 && n3 == 1) {
                    int n6 = n4 - 1;
                    if (n6 != n2) {
                        arrayList.add(new String(cArray, n2, n6 - n2));
                        n2 = n6;
                    }
                } else {
                    arrayList.add(new String(cArray, n2, n4 - n2));
                    n2 = n4;
                }
                n3 = n5;
            }
            ++n4;
        }
    }

    public static String[] splitByCharacterTypeCamelCase(String string2) {
        return StringUtils.splitByCharacterType(string2, true);
    }

    public static String[] splitByWholeSeparator(String string2, String string3) {
        return StringUtils.splitByWholeSeparatorWorker(string2, string3, -1, false);
    }

    public static String[] splitByWholeSeparator(String string2, String string3, int n2) {
        return StringUtils.splitByWholeSeparatorWorker(string2, string3, n2, false);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String string2, String string3) {
        return StringUtils.splitByWholeSeparatorWorker(string2, string3, -1, true);
    }

    public static String[] splitByWholeSeparatorPreserveAllTokens(String string2, String string3, int n2) {
        return StringUtils.splitByWholeSeparatorWorker(string2, string3, n2, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String[] splitByWholeSeparatorWorker(String string2, String string3, int n2, boolean bl2) {
        if (string2 == null) {
            return null;
        }
        int n3 = string2.length();
        if (n3 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (string3 == null || EMPTY.equals(string3)) {
            return StringUtils.splitWorker(string2, null, n2, bl2);
        }
        int n4 = string3.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            n7 = string2.indexOf(string3, n6);
            if (n7 > -1) {
                if (n7 > n6) {
                    if (++n5 == n2) {
                        n7 = n3;
                        arrayList.add(string2.substring(n6));
                        continue;
                    }
                    arrayList.add(string2.substring(n6, n7));
                    n6 = n7 + n4;
                    continue;
                }
                if (bl2) {
                    if (++n5 == n2) {
                        n7 = n3;
                        arrayList.add(string2.substring(n6));
                    } else {
                        arrayList.add(EMPTY);
                    }
                }
                n6 = n7 + n4;
                continue;
            }
            arrayList.add(string2.substring(n6));
            n7 = n3;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] splitPreserveAllTokens(String string2) {
        return StringUtils.splitWorker(string2, null, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string2, char c2) {
        return StringUtils.splitWorker(string2, c2, true);
    }

    public static String[] splitPreserveAllTokens(String string2, String string3) {
        return StringUtils.splitWorker(string2, string3, -1, true);
    }

    public static String[] splitPreserveAllTokens(String string2, String string3, int n2) {
        return StringUtils.splitWorker(string2, string3, n2, true);
    }

    private static String[] splitWorker(String string2, char c2, boolean bl2) {
        if (string2 == null) {
            return null;
        }
        int n2 = string2.length();
        if (n2 == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        while (n3 < n2) {
            if (string2.charAt(n3) == c2) {
                if (bl3 || bl2) {
                    arrayList.add(string2.substring(n4, n3));
                    bl3 = false;
                    bl4 = true;
                }
                n4 = ++n3;
                continue;
            }
            bl3 = true;
            ++n3;
            bl4 = false;
        }
        if (bl3 || bl2 && bl4) {
            arrayList.add(string2.substring(n4, n3));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private static String[] splitWorker(String var0, String var1_1, int var2_2, boolean var3_3) {
        block21: {
            block25: {
                block22: {
                    block24: {
                        block23: {
                            if (var0 == null) {
                                return null;
                            }
                            var4_4 = var0.length();
                            if (var4_4 == 0) {
                                return ArrayUtils.EMPTY_STRING_ARRAY;
                            }
                            var5_5 = new ArrayList<String>();
                            var6_6 = 0;
                            var7_7 = 0;
                            var8_8 = false;
                            var9_9 = false;
                            if (var1_1 != null) break block23;
                            var10_10 = 1;
                            block0: while (var6_6 < var4_4) {
                                if (Character.isWhitespace(var0.charAt(var6_6))) {
                                    if (var8_8 || var3_3) {
                                        var9_9 = true;
                                        var20_11 = var10_10 + 1;
                                        if (var10_10 == var2_2) {
                                            var6_6 = var4_4;
                                            var9_9 = false;
                                        }
                                        var5_5.add(var0.substring(var7_7, var6_6));
                                        var8_8 = false;
lbl24:
                                        // 2 sources

                                        while (true) {
                                            var7_7 = ++var6_6;
                                            var10_10 = var20_11;
                                            continue block0;
                                            break;
                                        }
                                    }
                                    break block21;
                                }
                                var8_8 = true;
                                ++var6_6;
                                var9_9 = false;
                            }
                            break block24;
                        }
                        if (var1_1.length() == 1) {
                            var15_12 = var1_1.charAt(0);
                            var16_13 = 1;
                            block2: while (var6_6 < var4_4) {
                                if (var0.charAt(var6_6) == var15_12) {
                                    if (var8_8 || var3_3) {
                                        var9_9 = true;
                                        var18_14 = var16_13 + 1;
                                        if (var16_13 == var2_2) {
                                            var6_6 = var4_4;
                                            var9_9 = false;
                                        }
                                        var5_5.add(var0.substring(var7_7, var6_6));
                                        var8_8 = false;
lbl49:
                                        // 2 sources

                                        while (true) {
                                            var7_7 = ++var6_6;
                                            var16_13 = var18_14;
                                            continue block2;
                                            break;
                                        }
                                    }
                                    break block22;
                                }
                                var8_8 = true;
                                ++var6_6;
                                var9_9 = false;
                            }
lbl59:
                            // 2 sources

                            while (true) {
                                if (var8_8 || var3_3 && var9_9) {
                                    var5_5.add(var0.substring(var7_7, var6_6));
                                }
                                return var5_5.toArray(new String[var5_5.size()]);
                            }
lbl64:
                            // 1 sources

                            block5: while (true) {
                                if (var6_6 >= var4_4) ** break;
                                if (var1_1.indexOf(var0.charAt(var6_6)) >= 0) {
                                    if (var8_8 || var3_3) {
                                        var9_9 = true;
                                        var13_15 = var10_10 + 1;
                                        if (var10_10 == var2_2) {
                                            var6_6 = var4_4;
                                            var9_9 = false;
                                        }
                                        var5_5.add(var0.substring(var7_7, var6_6));
                                        var8_8 = false;
lbl76:
                                        // 2 sources

                                        while (true) {
                                            var7_7 = ++var6_6;
                                            var10_10 = var13_15;
                                            continue block5;
                                            break;
                                        }
                                    }
                                } else {
                                    var8_8 = true;
                                    ++var6_6;
                                    var9_9 = false;
                                    continue;
                                }
                                var13_15 = var10_10;
                                ** continue;
                                break;
                            }
                        }
                        break block25;
                    }
                    ** while (true)
                }
                var18_14 = var16_13;
                ** while (true)
            }
            var10_10 = 1;
            var6_6 = 0;
            var9_9 = false;
            var8_8 = false;
            var7_7 = 0;
            ** while (true)
        }
        var20_11 = var10_10;
        ** while (true)
    }

    public static boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.startsWith(charSequence, charSequence2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean startsWith(CharSequence charSequence, CharSequence charSequence2, boolean bl2) {
        boolean bl3;
        if (charSequence == null || charSequence2 == null) {
            bl3 = false;
            if (charSequence != null) return bl3;
            bl3 = false;
            if (charSequence2 != null) return bl3;
            return true;
        }
        int n2 = charSequence2.length();
        int n3 = charSequence.length();
        bl3 = false;
        if (n2 > n3) return bl3;
        return CharSequenceUtils.regionMatches(charSequence, bl2, 0, charSequence2, 0, charSequence2.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean startsWithAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (!StringUtils.isEmpty(charSequence) && !ArrayUtils.isEmpty(charSequenceArray)) {
            int n2 = charSequenceArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!StringUtils.startsWith(charSequence, charSequenceArray[i2])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StringUtils.startsWith(charSequence, charSequence2, true);
    }

    public static String strip(String string2) {
        return StringUtils.strip(string2, null);
    }

    public static String strip(String string2, String string3) {
        if (StringUtils.isEmpty(string2)) {
            return string2;
        }
        return StringUtils.stripEnd(StringUtils.stripStart(string2, string3), string3);
    }

    public static String stripAccents(String string2) {
        if (string2 == null) {
            return null;
        }
        return Pattern.compile("\\p{InCombiningDiacriticalMarks}+").matcher(Normalizer.normalize(string2, Normalizer.Form.NFD)).replaceAll(EMPTY);
    }

    public static String[] stripAll(String ... stringArray) {
        return StringUtils.stripAll(stringArray, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] stripAll(String[] stringArray, String string2) {
        if (stringArray == null) return stringArray;
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray2[n3] = StringUtils.strip(stringArray[n3], string2);
            ++n3;
        }
        return stringArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String stripEnd(String string2, String string3) {
        int n2;
        if (string2 == null || (n2 = string2.length()) == 0) return string2;
        if (string3 == null) {
            while (n2 != 0 && Character.isWhitespace(string2.charAt(n2 - 1))) {
                --n2;
            }
            return string2.substring(0, n2);
        }
        if (string3.isEmpty()) {
            return string2;
        }
        while (n2 != 0 && string3.indexOf(string2.charAt(n2 - 1)) != -1) {
            --n2;
        }
        return string2.substring(0, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stripStart(String string2, String string3) {
        int n2;
        int n3;
        if (string2 == null || (n3 = string2.length()) == 0) {
            return string2;
        }
        if (string3 == null) {
            for (n2 = 0; n2 != n3 && Character.isWhitespace(string2.charAt(n2)); ++n2) {
            }
            return string2.substring(n2);
        } else {
            boolean bl2 = string3.isEmpty();
            if (bl2) return string2;
            for (n2 = 0; n2 != n3 && string3.indexOf(string2.charAt(n2)) != -1; ++n2) {
            }
        }
        return string2.substring(n2);
    }

    public static String stripToEmpty(String string2) {
        if (string2 == null) {
            return EMPTY;
        }
        return StringUtils.strip(string2, null);
    }

    public static String stripToNull(String string2) {
        if (string2 == null) {
            return null;
        }
        String string3 = StringUtils.strip(string2, null);
        if (string3.isEmpty()) {
            string3 = null;
        }
        return string3;
    }

    public static String substring(String string2, int n2) {
        if (string2 == null) {
            return null;
        }
        if (n2 < 0) {
            n2 += string2.length();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > string2.length()) {
            return EMPTY;
        }
        return string2.substring(n2);
    }

    public static String substring(String string2, int n2, int n3) {
        if (string2 == null) {
            return null;
        }
        if (n3 < 0) {
            n3 += string2.length();
        }
        if (n2 < 0) {
            n2 += string2.length();
        }
        if (n3 > string2.length()) {
            n3 = string2.length();
        }
        if (n2 > n3) {
            return EMPTY;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return string2.substring(n2, n3);
    }

    public static String substringAfter(String string2, String string3) {
        if (StringUtils.isEmpty(string2)) {
            return string2;
        }
        if (string3 == null) {
            return EMPTY;
        }
        int n2 = string2.indexOf(string3);
        if (n2 == -1) {
            return EMPTY;
        }
        return string2.substring(n2 + string3.length());
    }

    public static String substringAfterLast(String string2, String string3) {
        if (StringUtils.isEmpty(string2)) {
            return string2;
        }
        if (StringUtils.isEmpty(string3)) {
            return EMPTY;
        }
        int n2 = string2.lastIndexOf(string3);
        if (n2 == -1 || n2 == string2.length() - string3.length()) {
            return EMPTY;
        }
        return string2.substring(n2 + string3.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String substringBefore(String string2, String string3) {
        int n2;
        block5: {
            block4: {
                if (StringUtils.isEmpty(string2) || string3 == null) break block4;
                if (string3.isEmpty()) {
                    return EMPTY;
                }
                n2 = string2.indexOf(string3);
                if (n2 != -1) break block5;
            }
            return string2;
        }
        return string2.substring(0, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String substringBeforeLast(String string2, String string3) {
        int n2;
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string3) || (n2 = string2.lastIndexOf(string3)) == -1) {
            return string2;
        }
        return string2.substring(0, n2);
    }

    public static String substringBetween(String string2, String string3) {
        return StringUtils.substringBetween(string2, string3, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String substringBetween(String string2, String string3, String string4) {
        int n2;
        int n3;
        if (string2 == null || string3 == null || string4 == null || (n3 = string2.indexOf(string3)) == -1 || (n2 = string2.indexOf(string4, n3 + string3.length())) == -1) {
            return null;
        }
        return string2.substring(n3 + string3.length(), n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] substringsBetween(String string2, String string3, String string4) {
        ArrayList<String> arrayList;
        block6: {
            block5: {
                int n2;
                int n3;
                int n4;
                if (string2 == null || StringUtils.isEmpty(string3) || StringUtils.isEmpty(string4)) break block5;
                int n5 = string2.length();
                if (n5 == 0) {
                    return ArrayUtils.EMPTY_STRING_ARRAY;
                }
                int n6 = string4.length();
                int n7 = string3.length();
                arrayList = new ArrayList<String>();
                int n8 = 0;
                while (n8 < n5 - n6 && (n4 = string2.indexOf(string3, n8)) >= 0 && (n3 = string2.indexOf(string4, n2 = n4 + n7)) >= 0) {
                    arrayList.add(string2.substring(n2, n3));
                    n8 = n3 + n6;
                }
                if (!arrayList.isEmpty()) break block6;
            }
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String swapCase(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return string2;
        }
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            char c2 = cArray[n2];
            if (Character.isUpperCase(c2)) {
                cArray[n2] = Character.toLowerCase(c2);
            } else if (Character.isTitleCase(c2)) {
                cArray[n2] = Character.toLowerCase(c2);
            } else if (Character.isLowerCase(c2)) {
                cArray[n2] = Character.toUpperCase(c2);
            }
            ++n2;
        }
        return new String(cArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toEncodedString(byte[] byArray, Charset charset) throws UnsupportedEncodingException {
        if (charset != null) {
            return new String(byArray, charset);
        }
        charset = Charset.defaultCharset();
        return new String(byArray, charset);
    }

    @Deprecated
    public static String toString(byte[] byArray, String string2) throws UnsupportedEncodingException {
        if (string2 != null) {
            return new String(byArray, string2);
        }
        return new String(byArray, Charset.defaultCharset());
    }

    public static String trim(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.trim();
    }

    public static String trimToEmpty(String string2) {
        if (string2 == null) {
            return EMPTY;
        }
        return string2.trim();
    }

    public static String trimToNull(String string2) {
        String string3 = StringUtils.trim(string2);
        if (StringUtils.isEmpty(string3)) {
            string3 = null;
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String uncapitalize(String string2) {
        char c2;
        int n2;
        if (string2 == null || (n2 = string2.length()) == 0 || Character.isLowerCase(c2 = string2.charAt(0))) {
            return string2;
        }
        return new StringBuilder(n2).append(Character.toLowerCase(c2)).append(string2.substring(1)).toString();
    }

    public static String upperCase(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.toUpperCase();
    }

    public static String upperCase(String string2, Locale locale) {
        if (string2 == null) {
            return null;
        }
        return string2.toUpperCase(locale);
    }
}

