/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.commons.lang3.text.translate.NumericEntityUnescaper;
import org.apache.commons.lang3.text.translate.OctalUnescaper;
import org.apache.commons.lang3.text.translate.UnicodeUnescaper;

public class StringEscapeUtils {
    public static final CharSequenceTranslator ESCAPE_CSV;
    public static final CharSequenceTranslator ESCAPE_ECMASCRIPT;
    public static final CharSequenceTranslator ESCAPE_HTML3;
    public static final CharSequenceTranslator ESCAPE_HTML4;
    public static final CharSequenceTranslator ESCAPE_JAVA;
    public static final CharSequenceTranslator ESCAPE_JSON;
    public static final CharSequenceTranslator ESCAPE_XML;
    public static final CharSequenceTranslator UNESCAPE_CSV;
    public static final CharSequenceTranslator UNESCAPE_ECMASCRIPT;
    public static final CharSequenceTranslator UNESCAPE_HTML3;
    public static final CharSequenceTranslator UNESCAPE_HTML4;
    public static final CharSequenceTranslator UNESCAPE_JAVA;
    public static final CharSequenceTranslator UNESCAPE_JSON;
    public static final CharSequenceTranslator UNESCAPE_XML;

    static {
        LookupTranslator lookupTranslator = new LookupTranslator({"\"", "\\\""}, {"\\", "\\\\"});
        CharSequenceTranslator[] charSequenceTranslatorArray = new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE())};
        CharSequenceTranslator charSequenceTranslator = lookupTranslator.with(charSequenceTranslatorArray);
        CharSequenceTranslator[] charSequenceTranslatorArray2 = new CharSequenceTranslator[]{JavaUnicodeEscaper.outsideOf(32, 127)};
        ESCAPE_JAVA = charSequenceTranslator.with(charSequenceTranslatorArray2);
        CharSequenceTranslator[] charSequenceTranslatorArray3 = new CharSequenceTranslator[]{new LookupTranslator({"'", "\\'"}, {"\"", "\\\""}, {"\\", "\\\\"}, {"/", "\\/"}), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()), JavaUnicodeEscaper.outsideOf(32, 127)};
        ESCAPE_ECMASCRIPT = new AggregateTranslator(charSequenceTranslatorArray3);
        CharSequenceTranslator[] charSequenceTranslatorArray4 = new CharSequenceTranslator[]{new LookupTranslator({"\"", "\\\""}, {"\\", "\\\\"}, {"/", "\\/"}), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()), JavaUnicodeEscaper.outsideOf(32, 127)};
        ESCAPE_JSON = new AggregateTranslator(charSequenceTranslatorArray4);
        CharSequenceTranslator[] charSequenceTranslatorArray5 = new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.APOS_ESCAPE())};
        ESCAPE_XML = new AggregateTranslator(charSequenceTranslatorArray5);
        CharSequenceTranslator[] charSequenceTranslatorArray6 = new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE())};
        ESCAPE_HTML3 = new AggregateTranslator(charSequenceTranslatorArray6);
        CharSequenceTranslator[] charSequenceTranslatorArray7 = new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE()), new LookupTranslator(EntityArrays.HTML40_EXTENDED_ESCAPE())};
        ESCAPE_HTML4 = new AggregateTranslator(charSequenceTranslatorArray7);
        ESCAPE_CSV = new CsvEscaper();
        CharSequenceTranslator[] charSequenceTranslatorArray8 = new CharSequenceTranslator[]{new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE()), new LookupTranslator({"\\\\", "\\"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\", ""})};
        UNESCAPE_ECMASCRIPT = UNESCAPE_JAVA = new AggregateTranslator(charSequenceTranslatorArray8);
        UNESCAPE_JSON = UNESCAPE_JAVA;
        CharSequenceTranslator[] charSequenceTranslatorArray9 = new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0])};
        UNESCAPE_HTML3 = new AggregateTranslator(charSequenceTranslatorArray9);
        CharSequenceTranslator[] charSequenceTranslatorArray10 = new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE()), new LookupTranslator(EntityArrays.HTML40_EXTENDED_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0])};
        UNESCAPE_HTML4 = new AggregateTranslator(charSequenceTranslatorArray10);
        CharSequenceTranslator[] charSequenceTranslatorArray11 = new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.APOS_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0])};
        UNESCAPE_XML = new AggregateTranslator(charSequenceTranslatorArray11);
        UNESCAPE_CSV = new CsvUnescaper();
    }

    public static final String escapeCsv(String string2) {
        return ESCAPE_CSV.translate(string2);
    }

    public static final String escapeEcmaScript(String string2) {
        return ESCAPE_ECMASCRIPT.translate(string2);
    }

    public static final String escapeHtml3(String string2) {
        return ESCAPE_HTML3.translate(string2);
    }

    public static final String escapeHtml4(String string2) {
        return ESCAPE_HTML4.translate(string2);
    }

    public static final String escapeJava(String string2) {
        return ESCAPE_JAVA.translate(string2);
    }

    public static final String escapeJson(String string2) {
        return ESCAPE_JSON.translate(string2);
    }

    public static final String escapeXml(String string2) {
        return ESCAPE_XML.translate(string2);
    }

    public static final String unescapeCsv(String string2) {
        return UNESCAPE_CSV.translate(string2);
    }

    public static final String unescapeEcmaScript(String string2) {
        return UNESCAPE_ECMASCRIPT.translate(string2);
    }

    public static final String unescapeHtml3(String string2) {
        return UNESCAPE_HTML3.translate(string2);
    }

    public static final String unescapeHtml4(String string2) {
        return UNESCAPE_HTML4.translate(string2);
    }

    public static final String unescapeJava(String string2) {
        return UNESCAPE_JAVA.translate(string2);
    }

    public static final String unescapeJson(String string2) {
        return UNESCAPE_JSON.translate(string2);
    }

    public static final String unescapeXml(String string2) {
        return UNESCAPE_XML.translate(string2);
    }

    static class CsvEscaper
    extends CharSequenceTranslator {
        private static final char CSV_DELIMITER = ',';
        private static final char CSV_QUOTE = '\"';
        private static final String CSV_QUOTE_STR = String.valueOf('\"');
        private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

        CsvEscaper() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int translate(CharSequence charSequence, int n2, Writer writer) throws IOException {
            if (n2 != 0) {
                throw new IllegalStateException("CsvEscaper should never reach the [1] index");
            }
            if (StringUtils.containsNone((CharSequence)charSequence.toString(), CSV_SEARCH_CHARS)) {
                writer.write(charSequence.toString());
                return charSequence.length();
            }
            writer.write(34);
            writer.write(StringUtils.replace(charSequence.toString(), CSV_QUOTE_STR, CSV_QUOTE_STR + CSV_QUOTE_STR));
            writer.write(34);
            return charSequence.length();
        }
    }

    static class CsvUnescaper
    extends CharSequenceTranslator {
        private static final char CSV_DELIMITER = ',';
        private static final char CSV_QUOTE = '\"';
        private static final String CSV_QUOTE_STR = String.valueOf('\"');
        private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

        CsvUnescaper() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int translate(CharSequence charSequence, int n2, Writer writer) throws IOException {
            if (n2 != 0) {
                throw new IllegalStateException("CsvUnescaper should never reach the [1] index");
            }
            if (charSequence.charAt(0) != '\"' || charSequence.charAt(-1 + charSequence.length()) != '\"') {
                writer.write(charSequence.toString());
                return charSequence.length();
            }
            String string2 = charSequence.subSequence(1, -1 + charSequence.length()).toString();
            if (StringUtils.containsAny((CharSequence)string2, CSV_SEARCH_CHARS)) {
                writer.write(StringUtils.replace(string2, CSV_QUOTE_STR + CSV_QUOTE_STR, CSV_QUOTE_STR));
                return charSequence.length();
            }
            writer.write(charSequence.toString());
            return charSequence.length();
        }
    }
}

